/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.integrate.optlog.service;

import com.hs.atic.syslog.entity.SyslogServerEntity;
import com.hs.lego.cbb.i18n.sdk.I18nMrg;
import com.hs.lego.cbb.task.sdk.model.Task;
import com.hs.lego.cbb.task.sdk.model.TaskResult;
import com.hs.lego.cbb.task.sdk.service.ITaskService;
import com.hs.lego.cbb.task.sdk.service.TaskResultState;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.notify.sdk.model.SyslogBean;
import com.hs.lego.core.system.notify.sdk.service.ISyslogSendService;
import com.hs.lego.core.system.syslog.dao.IOptLogDao;
import com.hs.lego.core.system.syslog.sdk.model.OptLogMo;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.service.TranslateObject;
import com.hs.lego.integrate.optlog.sdk.service.IOptLogIntegrateService;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class OptLogIntegrateService
implements IOptLogIntegrateService {
    public static final int OPTLOG_RESULT_SUCCESS = 1;
    protected final transient Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private int optLogThreshold = 100000;
    private ReentrantLock lock = new ReentrantLock();
    private IOptLogDao optLogDao;
    private ISysOptLog sysOpLog = null;
    private ISyslogSendService syslogSendService;
    private I18nMrg i18nMgr;
    private ITaskService taskService;

    public ITaskService getTaskService() {
        return this.taskService;
    }

    public void setTaskService(ITaskService taskService) {
        this.taskService = taskService;
    }

    public void setOptLogDao(IOptLogDao optLogDao) {
        this.optLogDao = optLogDao;
    }

    public IOptLogDao getOptLogDao() {
        return this.optLogDao;
    }

    public ISyslogSendService getSyslogSendService() {
        return this.syslogSendService;
    }

    public void setSyslogSendService(ISyslogSendService syslogSendService) {
        this.syslogSendService = syslogSendService;
    }

    public I18nMrg getI18nMgr() {
        return this.i18nMgr;
    }

    public void setI18nMgr(I18nMrg i18nMgr) {
        this.i18nMgr = i18nMgr;
    }

    private boolean isNull(String str) {
        return str == null || "".equals(str.trim()) || "null".equals(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeOptLog(SysOptLog oOptLog, byte[] logDetail) {
        this.log.info((Object)"write lego opt log");
        OptLogMo oOptLogMo = TranslateObject.translateSysOptLogBo(oOptLog);
        oOptLogMo.setHasDetail(0);
        if (this.optLogDao.getCurrentOptLogTotal() >= (long)this.optLogThreshold) {
            this.log.info((Object)("current opt log total:" + this.optLogDao.getCurrentOptLogTotal()));
            Date startTime = new Date();
            this.log.info((Object)("start time:" + startTime));
            TaskResultState state = null;
            String resultLink = "";
            this.lock.lock();
            try {
                try {
                    StringBuffer filePath = new StringBuffer("datastorage" + File.separator + "sysoptlog");
                    resultLink = this.sysOpLog.transferLog("csv", this.optLogDao.getTenThousandTime(), "en", filePath.toString());
                    this.log.info((Object)"resultLink fileType is csv");
                    state = resultLink.equals("") ? TaskResultState.fail : TaskResultState.sucess;
                }
                catch (RuntimeException e) {
                    this.log.error((Object)"writeOptLog error");
                    state = TaskResultState.fail;
                }
                Date endTime = new Date();
                this.log.info((Object)("end time:" + endTime));
                TaskResult result = new TaskResult();
                Task task = this.taskService.readTask(1L);
                this.log.info((Object)("task id:" + task.getTaskId() + ";task name:" + task.getTaskName()));
                result.setTaskId(task);
                result.setStartTime(startTime);
                result.setEndTime(endTime);
                result.setResult(state.getValue());
                result.setResultLink(resultLink);
                result.setResultInfo("Task execute ok.");
                this.taskService.addTaskResult(result);
            }
            finally {
                this.lock.unlock();
            }
        }
        this.optLogDao.writeOptLog(oOptLogMo);
        this.syslogSendService = (ISyslogSendService)ServiceContext.getInstance().getService("syslogSendService", ISyslogSendService.class);
        Map keysAndValuesMap = this.syslogSendService.getSyslogServerMapKeysAndValues();
        List keys = (List)keysAndValuesMap.get("keys");
        List values = (List)keysAndValuesMap.get("values");
        if (null == keys || keys.size() == 0) {
            return;
        }
        HashMap syslogServerMap = new HashMap();
        for (int i = 0; i < keys.size(); ++i) {
            syslogServerMap.put(keys.get(i), values.get(i));
        }
        if (!syslogServerMap.isEmpty()) {
            for (Map.Entry serverMap : syslogServerMap.entrySet()) {
                SyslogServerEntity server = (SyslogServerEntity)serverMap.getValue();
                if (server.getAticOptlog() != 1) continue;
                String hostName = System.getProperty("nms.server.host");
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String time = dateFormat.format(new Date(oOptLogMo.getOpTime()));
                ArrayList<String> conentList = new ArrayList<String>();
                conentList.add("log_type=sysOperateLog");
                conentList.add("log_time=\"" + time + "\"");
                conentList.add("severity=" + oOptLogMo.getRiskLevel());
                conentList.add("user=" + oOptLogMo.getOpUser());
                String opName = this.i18nMgr.getString(oOptLogMo.getOpName());
                conentList.add("operate=\"" + opName + "\"");
                if (1 == oOptLogMo.getOpResult()) {
                    conentList.add("result=success");
                } else {
                    conentList.add("result=failed");
                }
                String opTarget = oOptLogMo.getOpTarget();
                if (this.isNull(opTarget)) {
                    opTarget = "null";
                }
                conentList.add("object=" + opTarget);
                String opDetail = null;
                if (!this.isNull(oOptLogMo.getOpDetail()) && !this.isNull(oOptLogMo.getOpDetailPama())) {
                    opDetail = this.i18nMgr.getString(oOptLogMo.getOpDetail(), oOptLogMo.getOpDetailPama().split("\n"));
                } else if (!this.isNull(oOptLogMo.getOpDetail()) && this.isNull(oOptLogMo.getOpDetailPama())) {
                    opDetail = this.i18nMgr.getString(oOptLogMo.getOpDetail());
                }
                conentList.add("detail=\"" + opDetail + "\"");
                SyslogBean syslogBean = new SyslogBean(hostName, "OPLOG", conentList);
                String serverIpPort = server.getServerIp() + "," + server.getServerPort();
                this.syslogSendService.sendSyslog(serverIpPort, syslogBean);
            }
        }
    }

    public ISysOptLog getSysOpLog() {
        return this.sysOpLog;
    }

    public void setSysOpLog(ISysOptLog sysOpLog) {
        this.sysOpLog = sysOpLog;
    }
}

