/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.constants;

import com.hs.atic.util.FileUtils;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.EncryptData;
import com.hs.lego.core.sdk.util.StringConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class Constants {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    public static final String USER_SESSION_KEY = "session.user";
    public static final String USER_SESSION_LANGKEY = "session.language";
    public static final String OPERATE_BATH_CATCH = "session.oper.catch";
    public static final String ERR_PREV = "lego.err.";
    public static final String FLASHPLAY = "10.3";
    public static final String SECO_PASSWORD_STAR = "********";
    public static final String SECO_PASSWORD_NO_STAR = "";
    public static final String SECO_PASSWORD_MODE_MODIFY = "modify";
    public static final String SECO_PASSWORD_MODE_CANCEL = "cancel";
    public static final String DEVICE_TYPE_FIREWALL_KEY = "0";
    public static final String DEVICE_TYPE_SWITCHER_KEY = "1";
    public static final String DEVICE_TYPE_ROUTER_KEY = "2";
    public static final int DOMAIN_LENGTH = 255;
    public static final int STRING_LENGTH = 250;
    public static int PACKET_VERSION_FLAG = 7;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void loadPacketVersion() {
        ByteArrayInputStream barrayInput;
        ByteArrayOutputStream barrayOut;
        InputStream input;
        block10: {
            Properties propPacketVersion = new Properties();
            input = null;
            barrayOut = null;
            barrayInput = null;
            try {
                input = Constants.class.getClassLoader().getResourceAsStream("env.properties");
                if (null == input) {
                    throw new IOException("env.properties is not exist");
                }
                barrayOut = new ByteArrayOutputStream();
                byte[] bufRead = new byte[1024];
                int len = 0;
                while ((len = input.read(bufRead)) != -1) {
                    barrayOut.write(bufRead, 0, len);
                }
                byte[] fileBytesAry4Encoded = barrayOut.toByteArray();
                String fileEncryptHex = StringConverter.getInstanse().parseByte2HexStr(fileBytesAry4Encoded);
                String hexText4Decrypt = EncryptData.getInstanse().decryptInitdata(fileEncryptHex);
                if (null == hexText4Decrypt || hexText4Decrypt.trim().equals(SECO_PASSWORD_NO_STAR)) {
                    throw new IOException("env.properties decryptInitdata error");
                }
                byte[] actualText4Decrypt = StringConverter.getInstanse().parseHexStr2Byte(hexText4Decrypt);
                barrayInput = new ByteArrayInputStream(actualText4Decrypt);
                propPacketVersion.load(barrayInput);
                Object propFlag = propPacketVersion.get("PACKET_VERSION_FLAG");
                if (null != propFlag) {
                    PACKET_VERSION_FLAG = Integer.parseInt(propFlag.toString());
                    break block10;
                }
                logger.error((Object)"read env.properties props[PACKET_VERSION_FLAG] is null ");
            }
            catch (IOException e) {
                logger.error((Object)("load env.properties error " + e.getMessage()));
                FileUtils.close(input, barrayOut, barrayInput);
            }
            catch (NumberFormatException e2) {
                logger.error((Object)("explain env.properties props[PACKET_VERSION_FLAG] error " + e2.getMessage()));
                {
                    catch (Throwable throwable) {
                        FileUtils.close(input, barrayOut, barrayInput);
                        throw throwable;
                    }
                }
                FileUtils.close(input, barrayOut, barrayInput);
            }
        }
        FileUtils.close(input, barrayOut, barrayInput);
    }

    static {
        Constants.loadPacketVersion();
    }
}

