/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.filter.csrf;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.AESUtil;
import com.hs.lego.ui.plat.common.filter.csrf.CsrfGuargXmlHelper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.text.Normalizer;
import java.util.Locale;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public final class CsrfGuard {
    public static final int MAX_COUNT = 102400;
    public static final int MAX_LINE_COUNT = 500;
    public static final String SESSION_KEY_NAME = "CFNMAE_S";
    public static final String CHECK_KEY_NAME = "cfNameHF";
    public static final String CHECK_KEY_NAME_FLAG = "needCfNameCheck";
    private static final CsrfGuard INSTANCE = new CsrfGuard();
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    public static CsrfGuard getInstance() {
        return INSTANCE;
    }

    public String getNewValue() {
        byte[] bytes = new byte[32];
        SecureRandom random = new SecureRandom();
        random.nextBytes(bytes);
        return AESUtil.parseByte2HexStr(bytes);
    }

    public boolean isValidRequest(HttpServletRequest request, HttpServletResponse response) {
        String uri = request.getRequestURI();
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)("csrf check error, xhrToken : " + e.getMessage()));
            return false;
        }
        uri = Normalizer.normalize(uri, Normalizer.Form.NFKC);
        boolean validRequest = false;
        boolean isWeakWhiteURL = CsrfGuargXmlHelper.getInstance().isWeakWhiteURL(uri);
        boolean isPostQeqURL = CsrfGuargXmlHelper.getInstance().isWeakBlackURL(uri);
        if (isWeakWhiteURL && !isPostQeqURL) {
            validRequest = true;
        } else {
            String method = request.getMethod();
            if (method.equalsIgnoreCase("get") && !isPostQeqURL) {
                validRequest = true;
            } else {
                boolean approval = this.validCsrfToken(request);
                if (approval) {
                    validRequest = true;
                }
            }
        }
        return validRequest;
    }

    private boolean validCsrfToken(HttpServletRequest request) {
        boolean valid = false;
        HttpSession session = request.getSession(false);
        if (null == session) {
            return valid;
        }
        String sToken = (String)session.getAttribute(SESSION_KEY_NAME);
        if (sToken != null && !sToken.isEmpty()) {
            String paramToken;
            String xhrToken = request.getHeader(CHECK_KEY_NAME);
            if (null == xhrToken || xhrToken.isEmpty()) {
                boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
                xhrToken = isMultipart ? this.multipartContentToken(request) : request.getParameter(CHECK_KEY_NAME);
            }
            if (null != (paramToken = request.getParameter(CHECK_KEY_NAME)) && !paramToken.isEmpty()) {
                paramToken = Normalizer.normalize(paramToken, Normalizer.Form.NFKC);
            }
            if (null != paramToken && paramToken.contains(",")) {
                String[] argsTokens = paramToken.split(",");
                int length = argsTokens.length;
                for (int i = 0; i < length; ++i) {
                    if (null == argsTokens[i] || "".equals(argsTokens[i].trim())) continue;
                    paramToken = argsTokens[i];
                    break;
                }
            }
            valid = this.check(valid, sToken, xhrToken, paramToken);
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String multipartContentToken(HttpServletRequest request) {
        String formDataToken = null;
        ServletInputStream servletInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            servletInputStream = request.getInputStream();
            inputStreamReader = new InputStreamReader((InputStream)servletInputStream, "UTF-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            boolean isTokenLine = false;
            char[] buf = new char[1];
            StringBuilder sb = new StringBuilder();
            int lineCount = 0;
            String currentLine = null;
            while (bufferedReader.read(buf) != -1) {
                if (lineCount > 500) {
                } else {
                    sb.append(buf);
                    if (buf[0] == '\n') {
                        currentLine = sb.toString();
                        sb = new StringBuilder();
                        ++lineCount;
                    }
                    if (sb.length() >= 102400) {
                        currentLine = sb.toString();
                        sb = new StringBuilder();
                        ++lineCount;
                    }
                    if (null == currentLine || "".equals(currentLine.trim())) continue;
                    if (currentLine.contains("Content-Disposition: form-data; name=\"cfNameHF\"")) {
                        isTokenLine = true;
                        continue;
                    }
                    if (!isTokenLine) continue;
                    formDataToken = currentLine.trim();
                }
                break;
            }
        }
        catch (IOException e) {
            LOG.error((Object)"ServletInputStream getInputStream error");
        }
        finally {
            try {
                if (null != bufferedReader) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"bufferedReader close error");
            }
            try {
                if (null != inputStreamReader) {
                    inputStreamReader.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"inputStreamReader close error");
            }
            try {
                if (null != servletInputStream) {
                    servletInputStream.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"inputStreamReader close error");
            }
        }
        return formDataToken;
    }

    private boolean check(boolean valid, String sToken, String xhrToken, String paramToken) {
        if (xhrToken != null && sToken.equals(xhrToken)) {
            if (this.validTokenFormat(xhrToken)) {
                valid = true;
            } else {
                LOG.error((Object)"csrf check error, xhrToken : ***");
            }
        } else if (paramToken != null && sToken.equals(paramToken)) {
            if (this.validTokenFormat(paramToken)) {
                valid = true;
            } else {
                LOG.error((Object)"csrf check error, paramToken : ***");
            }
        } else {
            LOG.error((Object)"csrf check error, default null : ");
        }
        return valid;
    }

    private boolean validTokenFormat(String token) {
        if (null == token) {
            return false;
        }
        String uuid = token.toUpperCase(Locale.US);
        uuid = Normalizer.normalize(uuid, Normalizer.Form.NFKC);
        boolean retVal = false;
        if (uuid.length() == 64) {
            retVal = true;
        }
        return retVal;
    }

    static class MutilServletInputStream
    extends ServletInputStream {
        private ByteArrayInputStream bais;

        public MutilServletInputStream(byte[] body) {
            this.bais = new ByteArrayInputStream((byte[])body.clone());
        }

        public int read() throws IOException {
            return this.bais.read();
        }
    }

    static class MutilHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private byte[] body;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MutilHttpServletRequestWrapper(HttpServletRequest request) {
            super(request);
            ByteArrayOutputStream byteArrayOutputStream = null;
            ServletInputStream servletInputStream = null;
            try {
                servletInputStream = request.getInputStream();
                byteArrayOutputStream = new ByteArrayOutputStream();
                int len = 0;
                byte[] buffer = new byte[1024];
                while ((len = servletInputStream.read(buffer)) != -1) {
                    byteArrayOutputStream.write(buffer, 0, len);
                }
                byte[] cloneBuffer = byteArrayOutputStream.toByteArray();
                this.body = new byte[cloneBuffer.length];
                System.arraycopy(cloneBuffer, 0, this.body, 0, cloneBuffer.length);
                byteArrayOutputStream.flush();
            }
            catch (IOException e) {
                LOG.error((Object)"MutilHttpServletRequestWrapper read inputstream error!");
            }
            finally {
                try {
                    if (null != byteArrayOutputStream) {
                        byteArrayOutputStream.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"MutilHttpServletRequestWrapper byteArrayOutputStream.close error!");
                }
                try {
                    if (null != servletInputStream) {
                        servletInputStream.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"MutilHttpServletRequestWrapper servletInputStream.close() error!");
                }
            }
        }

        public BufferedReader getReader() throws IOException {
            return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), "UTF-8"));
        }

        public ServletInputStream getInputStream() throws IOException {
            return new MutilServletInputStream(this.body);
        }
    }
}

