/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.filter.csrf;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.filter.csrf.CsrfGuard;
import com.hs.lego.ui.plat.user.util.LoginMgrUtil;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.Normalizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class CsrfGuardFilter
implements Filter {
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String uri = httpRequest.getRequestURI();
        uri = URLDecoder.decode(uri, "UTF-8");
        uri = Normalizer.normalize(uri, Normalizer.Form.NFKC);
        CsrfGuard csrfGuard = CsrfGuard.getInstance();
        HttpSession session = httpRequest.getSession(false);
        if (null != session && uri.contains(".do")) {
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)httpRequest);
            CsrfGuard.MutilHttpServletRequestWrapper mutilHttpServlet = null;
            boolean isValidRequest = false;
            if (isMultipart) {
                mutilHttpServlet = new CsrfGuard.MutilHttpServletRequestWrapper(httpRequest);
                isValidRequest = csrfGuard.isValidRequest((HttpServletRequest)mutilHttpServlet, httpResponse);
            } else {
                isValidRequest = csrfGuard.isValidRequest(httpRequest, httpResponse);
            }
            if (isMultipart && isValidRequest) {
                filterChain.doFilter((ServletRequest)mutilHttpServlet, (ServletResponse)httpResponse);
            } else if (!isMultipart && isValidRequest) {
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            } else {
                this.log.error((Object)("Check CSRF error url=" + uri));
                LoginMgrUtil.redirectLogin(httpRequest, httpResponse);
            }
        } else {
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

