/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.filter.urlf;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public final class UrlWhiteListHelper {
    public static final String SESSION_KEY_NAME = "CFNMAE_S";
    public static final String CHECK_KEY_NAME = "cfNameHF";
    public static final String CHECK_KEY_NAME_FLAG = "needCfNameCheck";
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private static final String WHITE_URL_FPATH = "urlWhiteList.xml";
    private static Map<String, String> cSCheckMap;
    private static Set<String> whiteUrlList;

    private UrlWhiteListHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initWhiteUrlList() {
        InputStream fin = null;
        Document doc = null;
        whiteUrlList = new HashSet<String>();
        cSCheckMap = new HashMap<String, String>();
        ClassLoader cl = UrlWhiteListHelper.class.getClassLoader();
        if (null == cl) {
            log.info((Object)"ClassLoader not found");
            return;
        }
        fin = cl.getResourceAsStream(WHITE_URL_FPATH);
        try {
            SAXReader reader = new SAXReader();
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            doc = reader.read(fin);
            Element root = doc.getRootElement();
            for (Element el : root.elements("entry")) {
                Attribute csAttr;
                Attribute urlAttr = el.attribute("url");
                if (urlAttr == null) continue;
                String key = urlAttr.getText().trim();
                if (!key.isEmpty()) {
                    whiteUrlList.add(key);
                }
                if ((csAttr = el.attribute("cs")) == null) continue;
                String csCheck = csAttr.getText().trim();
                cSCheckMap.put(key, csCheck);
            }
        }
        catch (DocumentException e) {
            log.error((Object)"urlWhiteList.xml read error");
        }
        catch (SAXException e) {
            log.error((Object)"urlWhiteList.xml SAXException error");
        }
        finally {
            if (null != fin) {
                try {
                    fin.close();
                }
                catch (IOException ex) {
                    log.error((Object)"Close file error");
                }
            }
        }
    }

    public static boolean validateInWhiteUrl(HttpServletRequest httpRequest, String url) {
        return whiteUrlList.contains(url);
    }

    public static Set<String> getUrlWhiteList() {
        return whiteUrlList;
    }

    static {
        UrlWhiteListHelper.initWhiteUrlList();
    }
}

