/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.log;

import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import java.text.Normalizer;
import java.util.List;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.remoting.RemoteConnectFailureException;

public class LogInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 6685011530357579416L;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private transient ISysOptLog sysLogService = null;

    public String intercept(ActionInvocation invocation) {
        ActionContext ctx = invocation.getInvocationContext();
        String errStr = "";
        String[] detailPara = new String[]{};
        int bOprSucc = 1;
        try {
            String string = invocation.invoke();
            return string;
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)ex.getMessage().replace("\r", "").replace("\n", ""));
            bOprSucc = 0;
            errStr = "lego.err." + ex.getErrorCode();
            detailPara = ex.getParameters();
            throw ex;
        }
        catch (LegoUncheckedException e) {
            LOGGER.error((Object)e.getMessage().replace("\r", "").replace("\n", ""));
            bOprSucc = 0;
            errStr = "lego.err." + e.getMessage();
            throw e;
        }
        catch (RemoteConnectFailureException e) {
            LOGGER.error((Object)e.getMessage().replace("\r", "").replace("\n", ""));
            bOprSucc = 0;
            errStr = "lego.err." + String.valueOf(105L);
            throw new LegoCheckedException(105L, (Throwable)e);
        }
        catch (DataAccessResourceFailureException e) {
            LOGGER.error((Object)e.getMessage().replace("\r", "").replace("\n", ""));
            throw new LegoCheckedException(104L, (Throwable)e);
        }
        catch (Exception ex) {
            errStr = ex.getMessage();
            if (ex instanceof IllegalStateException && errStr.contains("setAttribute: Session")) {
                int index1 = errStr.indexOf(String.valueOf('['));
                int index2 = errStr.indexOf(String.valueOf(']'), index1 + 1);
                String sessionId = errStr.substring(index1 + 1, index2);
                errStr = errStr.replace(sessionId, "******");
            }
            LOGGER.error((Object)("error info : " + this.getcleanedMessage(errStr)));
            bOprSucc = 0;
            throw new LegoUncheckedException((Throwable)ex);
        }
        finally {
            this.writlog(invocation, ctx, errStr, detailPara, bOprSucc);
        }
    }

    private void writlog(ActionInvocation invocation, ActionContext ctx, String errStr, String[] detailPara, int bOprSucc) {
        User currentUser = (User)ctx.getSession().get("currentUser");
        if (!(invocation.getAction() instanceof BaseAction)) {
            return;
        }
        BaseAction baseAction = (BaseAction)((Object)invocation.getAction());
        if (baseAction.getOperateLog() == null || baseAction.getOperateLog().getSysLog() == null) {
            return;
        }
        SysOptLog sysLog = baseAction.getOperateLog().getSysLog();
        try {
            sysLog.setTerminalIp(currentUser.getIpAdr());
            sysLog.setOperator(currentUser.getUserName());
            if (baseAction.getBatchOperationResult() != null) {
                this.bathWriteLog(baseAction, sysLog, this.sysLogService);
            } else {
                sysLog.setResult(bOprSucc);
                if (bOprSucc == 0) {
                    sysLog.setDetail(errStr);
                    if (errStr == null) {
                        sysLog.setDetailPara(null);
                    } else if (null != detailPara) {
                        sysLog.setDetailPara(detailPara);
                    }
                }
                if (null != sysLog.getTarget() && sysLog.getTarget().indexOf("alert") != -1) {
                    sysLog.setTarget(sysLog.getModule());
                    sysLog.setTargetLocal(true);
                }
                if (null == sysLog.getTarget() || sysLog.getTarget().equals("") || sysLog.getTarget().equals("--")) {
                    sysLog.setTarget(sysLog.getModule());
                    sysLog.setTargetLocal(true);
                }
                if (null == sysLog.getDetail() || sysLog.getDetail().trim().equals("") || sysLog.getDetail().indexOf("For input string:") != -1 || sysLog.getDetail().indexOf("lego.err.expecting") != -1 || sysLog.getDetail().indexOf("com.hs.lego.core.system.syslog") != -1) {
                    sysLog.setDetail(null);
                } else if (sysLog.getDetail().indexOf("lego.err.unexpected end of subtree") != -1 || sysLog.getDetail().indexOf("lego.err.unexpected char:") != -1 || sysLog.getDetail().indexOf("String index out of range:") != -1 || sysLog.getDetail().indexOf("lego.err.unexpected") != -1) {
                    sysLog.setDetail(null);
                } else if (sysLog.getDetail().indexOf("null") != -1 || sysLog.getDetail().indexOf("alert") != -1 || sysLog.getDetail().indexOf("lego.err.null") != -1 || sysLog.getDetail().indexOf("com.hs.lego.cbb.nms") != -1 || sysLog.getDetail().indexOf("Could not execute JDBC batch update") != -1) {
                    sysLog.setDetail(null);
                }
                this.sysLogService.writeOptLog(sysLog);
            }
        }
        catch (RuntimeException re) {
            LOGGER.error((Object)("write syslog:" + sysLog.getOperation()));
        }
        catch (Exception ex) {
            LOGGER.error((Object)("write syslog:" + sysLog.getOperation()));
        }
    }

    private void bathWriteLog(BaseAction baseAction, SysOptLog sylOpt, ISysOptLog sysOptLog) {
        List<BatchOperation> lst = baseAction.getBatchOperationResult().getResult();
        for (BatchOperation batOpe : lst) {
            batOpe.setDetailParam(LogInterceptor.getcleanedMessage(batOpe.getDetailParam()));
            batOpe.setTargetNameParam(LogInterceptor.getcleanedMessage(batOpe.getTargetNameParam()));
            SysOptLog sysLog = this.getSysOptLog(sylOpt);
            String normalizeTargetName = Normalizer.normalize(batOpe.getTargetName(), Normalizer.Form.NFKC);
            if (normalizeTargetName.endsWith(".alarm.name")) {
                sysLog.setTargetLocal(true);
            }
            if (batOpe.getTargetName() == null || batOpe.getTargetName().equals("") || batOpe.getTargetName().equals("--")) {
                sysLog.setTargetLocal(true);
                sysLog.setTarget("lego.lab.com.batch.operation");
            } else {
                sysLog.setTarget(batOpe.getTargetName());
            }
            String[] targetNameParam = batOpe.getTargetNameParam();
            if (null != targetNameParam && targetNameParam.length > 0) {
                sysLog.setTargetPara(batOpe.getTargetNameParam());
            }
            if (batOpe.getErrorCode() == 0L) {
                sysLog.setResult(1);
                String optDetail = batOpe.getOptDetail();
                if (optDetail != null && !optDetail.trim().equals("")) {
                    sysLog.setDetail(optDetail);
                    String[] optDetailParam = batOpe.getDetailParam();
                    if (null != optDetailParam && optDetailParam.length > 0) {
                        sysLog.setDetailPara(optDetailParam);
                    }
                }
            } else {
                sysLog.setResult(0);
                sysLog.setDetail("lego.err." + batOpe.getErrorCode());
                String[] optDetailParam = batOpe.getDetailParam();
                if (null != optDetailParam && optDetailParam.length > 0) {
                    sysLog.setDetailPara(optDetailParam);
                }
            }
            if (null == sysLog.getDetail() || sysLog.getDetail().trim().equals("") || sysLog.getDetail().indexOf("For input string:") != -1 || sysLog.getDetail().indexOf("lego.err.expecting") != -1 || sysLog.getDetail().indexOf("com.hs.lego.core.system.syslog") != -1) {
                sysLog.setDetail(null);
            } else if (sysLog.getDetail().indexOf("lego.err.unexpected end of subtree") != -1 || sysLog.getDetail().indexOf("lego.err.unexpected char:") != -1 || sysLog.getDetail().indexOf("String index out of range:") != -1 || sysLog.getDetail().indexOf("lego.err.unexpected") != -1) {
                sysLog.setDetail(null);
            } else if (sysLog.getDetail().indexOf("null") != -1 || sysLog.getDetail().indexOf("alert") != -1 || sysLog.getDetail().indexOf("lego.err.null") != -1 || sysLog.getDetail().indexOf("com.hs.lego.cbb.nms") != -1 || sysLog.getDetail().indexOf("Could not execute JDBC batch update") != -1) {
                sysLog.setDetail(null);
            }
            sysOptLog.writeOptLog(sysLog);
        }
    }

    private SysOptLog getSysOptLog(SysOptLog sylOpt) {
        SysOptLog sysLog = new SysOptLog();
        sysLog.setDate(sylOpt.getDate());
        sysLog.setTargetLocal(sylOpt.getTargetLocal());
        sysLog.setLevel(sylOpt.getLevel());
        sysLog.setModule(sylOpt.getModule());
        sysLog.setOperation(sylOpt.getOperation());
        sysLog.setOperator(sylOpt.getOperator());
        sysLog.setResult(sylOpt.getResult());
        sysLog.setTerminalIp(sylOpt.getTerminalIp());
        return sysLog;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private static String[] getcleanedMessage(String[] message) {
        if (message != null) {
            for (int i = 0; i < message.length; ++i) {
                message[i] = message[i].replace('\n', ' ').replace('\r', ' ');
            }
        }
        return message;
    }

    public void setSysLogService(ISysOptLog sysLogService) {
        this.sysLogService = sysLogService;
    }
}

