/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.proxy;

import com.hs.atic.util.XmlUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.constants.CustomSysConstant;
import com.hs.lego.ui.plat.common.proxy.StaticResourceUtil;
import com.huawei.atic.util.AticInstallUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.text.Normalizer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class ProxyFilter
implements Filter {
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private static final int FIVE = 5;
    private String customModName = "";
    private Map<String, ServletModel> servletMap = new HashMap<String, ServletModel>();
    private ServletContext servletContext;
    private ServletConfig servletConfig = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        String location = "webJSP.xml";
        this.readCustom();
        String config = filterConfig.getInitParameter("config");
        if (config != null) {
            location = config;
        }
        try {
            Enumeration<URL> url = Thread.currentThread().getContextClassLoader().getResources(location);
            while (url.hasMoreElements()) {
                URL next = url.nextElement();
                this.readConfig(next);
            }
        }
        catch (IOException e) {
            log.error((Object)"ProxyFilter init");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCustom() {
        String custConf = AticInstallUtil.getInstance().getAticInstallPath() + File.separator + "Tomcat6" + File.separator + "Lego-UI-Plat" + File.separator + "WEB-INF" + File.separator + "custom.conf";
        File file = null;
        InputStream inpStr = null;
        try {
            file = FileUtils.getFile((String[])new String[]{URLDecoder.decode(custConf, "utf-8")});
            if (file.exists()) {
                String styTemp;
                Properties prop = new Properties();
                inpStr = new FileInputStream(FileUtils.getFile((String[])new String[]{URLDecoder.decode(custConf, "utf-8")}));
                prop.load(inpStr);
                if (prop.containsKey("modulename")) {
                    this.customModName = prop.getProperty("modulename");
                }
                if (prop.containsKey("style") && (styTemp = prop.getProperty("style")).equals("red")) {
                    CustomSysConstant.setCustomStyle("red");
                    CustomSysConstant.setCustomResImgLogin("/resources/skins/default-red/images/header/logo.png");
                    CustomSysConstant.setCustomResImgIndex("/resources/skins/default-red/images/header/indlogo.png");
                    CustomSysConstant.setCustomResImgAbout("/resources/skins/default-red/images/header/aboutlogo.png");
                }
                if (prop.containsKey("theme") && prop.getProperty("theme").equals("classic")) {
                    CustomSysConstant.setCustomTheme("classic");
                }
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)"custom.conf FileNotFoundException");
        }
        catch (IOException e) {
            log.error((Object)"custom.conf IOException");
        }
        finally {
            try {
                if (null != inpStr) {
                    inpStr.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Close InputStream IOException");
            }
        }
        if ("red".equals(CustomSysConstant.getCustomStyle())) {
            CustomSysConstant.setCustomResCharacCopyright("lego.lab.com.footViewInfoHw");
        } else {
            CustomSysConstant.setCustomResCharacCopyright("lego.lab.com.footViewInfo");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.servletConfig == null) {
            this.servletConfig = (ServletConfig)this.servletContext.getAttribute("com.hs.lego.ServletConfig");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String uri = httpRequest.getRequestURI();
        uri = URLDecoder.decode(uri, "UTF-8");
        String contextPath = httpRequest.getContextPath();
        if (contextPath.length() > 0) {
            uri = uri.substring(contextPath.length());
        }
        if ((uri = Normalizer.normalize(uri, Normalizer.Form.NFKC)).endsWith(".jsp")) {
            HttpServlet targetSevlet;
            ServletModel sm = this.servletMap.get(uri);
            if (sm != null && (targetSevlet = this.getServletInstance(sm)) != null) {
                httpRequest.setAttribute("com.hs.lego.moduleName", (Object)sm.modulename);
                targetSevlet.service(request, response);
                return;
            }
        } else {
            try {
                if (response instanceof HttpServletResponse) {
                    boolean staticResours;
                    HttpServletResponse httpResponse = (HttpServletResponse)response;
                    boolean bl = staticResours = StaticResourceUtil.getInstance().findStaticResource(uri, "com/hs/jspPages", (HttpServletRequest)request, httpResponse) || StaticResourceUtil.getInstance().findStaticResource(uri, "com/huawei/jspPages", (HttpServletRequest)request, (HttpServletResponse)response);
                    if (staticResours) {
                        return;
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)(" ProxyFilter do Filter! " + e.getMessage()));
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        for (ServletModel sm : this.servletMap.values()) {
            if (sm.instance == null) continue;
            sm.instance.destroy();
        }
    }

    private HttpServlet getServletInstance(ServletModel sm) {
        HttpServlet targetServlet = null;
        try {
            if (sm.instance == null) {
                targetServlet = (HttpServlet)Class.forName(sm.servletname).newInstance();
                targetServlet.init(this.servletConfig);
                sm.instance = targetServlet;
            } else {
                targetServlet = sm.instance;
            }
        }
        catch (InstantiationException e) {
            log.error((Object)("ProxyFilter getServletInstance!" + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            log.error((Object)("ProxyFilter getServletInstance!" + e.getMessage()));
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("ProxyFilter getServletInstance!" + e.getMessage()));
        }
        catch (ServletException e) {
            log.error((Object)("ProxyFilter getServletInstance!" + e.getMessage()));
        }
        return targetServlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readConfig(URL url) throws IOException {
        String modulename = null;
        if ("jar".equals(url.getProtocol())) {
            String path = url.getPath();
            if (path == null) {
                return;
            }
            if (path.indexOf("!") > 5) {
                path = path.substring(5, path.indexOf("!"));
            }
            log.debug((Object)("protocol is" + url.getProtocol()));
            JarFile jf = new JarFile(URLDecoder.decode(path, "utf-8"));
            InputStream iPut = null;
            Manifest mf = null;
            try {
                mf = jf.getManifest();
                if (mf == null) {
                    jf.close();
                    return;
                }
                modulename = mf.getMainAttributes().getValue("Module-Name");
                if (!"".equals(this.customModName) && this.customModName.equals(modulename)) {
                    JarEntry entry = jf.getJarEntry("productcustom.conf");
                    Properties prop = new Properties();
                    if (null == entry) {
                        jf.close();
                        try {
                            if (iPut != null) {
                                this.destroy(iPut);
                            }
                            jf.close();
                            return;
                        }
                        catch (IOException e) {
                            log.error((Object)"IOException error");
                        }
                        return;
                    }
                    iPut = jf.getInputStream(entry);
                    prop.load(iPut);
                    if ("red".equals(CustomSysConstant.getCustomStyle())) {
                        CustomSysConstant.setCustomResCharacCopyright(prop.getProperty("copyrightRES_RED", CustomSysConstant.getCustomResCharacCopyright()));
                        CustomSysConstant.setCustomResCharacSysname(prop.getProperty("sysnameRES_RED", CustomSysConstant.getCustomResCharacSysname()));
                        CustomSysConstant.setCustomResImgIndex(prop.getProperty("indexSysIMG_RED", "/resources/skins/default-red/images/header/indlogo.png"));
                        CustomSysConstant.setCustomResImgLogin(prop.getProperty("loginSysIMG_RED", "/resources/skins/default-red/images/header/logo.png"));
                        CustomSysConstant.setCustomResImgAbout(prop.getProperty("aboutSysimg_RED", "/resources/skins/default-red/images/header/aboutlogo.png"));
                    } else {
                        CustomSysConstant.setCustomResCharacCopyright(prop.getProperty("copyrightRES", CustomSysConstant.getCustomResCharacCopyright()));
                        CustomSysConstant.setCustomResCharacSysname(prop.getProperty("sysnameRES", CustomSysConstant.getCustomResCharacSysname()));
                        CustomSysConstant.setCustomResImgIndex(prop.getProperty("indexSysIMG", CustomSysConstant.getCustomResImgIndex()));
                        CustomSysConstant.setCustomResImgLogin(prop.getProperty("loginSysIMG", CustomSysConstant.getCustomResImgLogin()));
                        CustomSysConstant.setCustomResImgAbout(prop.getProperty("aboutSysimg", CustomSysConstant.getCustomResImgAbout()));
                    }
                    CustomSysConstant.setCustomResLocation(prop.getProperty("location", CustomSysConstant.getCustomResLocation()));
                    CustomSysConstant.setAlarmLocation(prop.getProperty("alarmLocation", CustomSysConstant.getAlarmLocation()));
                    CustomSysConstant.setCustomUrlAbout(prop.getProperty("aboutURL", CustomSysConstant.getCustomUrlAbout()));
                    CustomSysConstant.setCustomProperties(prop);
                    log.debug((Object)"about img: aboutlogo.png ");
                    log.debug((Object)"index img: indlogo.png ");
                    log.debug((Object)"login img: logo.png ");
                }
            }
            catch (RuntimeException ex) {
                log.error((Object)"RuntimeException");
            }
            catch (Exception ex) {
                log.error((Object)"custom readConfig");
            }
            finally {
                try {
                    if (iPut != null) {
                        this.destroy(iPut);
                    }
                    jf.close();
                }
                catch (IOException e) {
                    log.error((Object)"IOException error");
                }
            }
        }
        this.config(modulename, url);
    }

    private void destroy(InputStream iPut) {
        try {
            if (null != iPut) {
                iPut.close();
            }
        }
        catch (IOException e) {
            log.error((Object)"iPut close error ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void config(String modulename, URL url) throws IOException {
        InputStream in = null;
        SAXReader reader = new SAXReader();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            List webappEles;
            String name;
            XmlUtil.setSecureFeatureForSaxReader(reader);
            in = url.openStream();
            Document xmlDoc = reader.read(in);
            List elementList = xmlDoc.selectNodes("//servlet");
            for (Element servlet : elementList) {
                name = servlet.element("servlet-name").getText().trim();
                String clazz = servlet.element("servlet-class").getText().trim();
                map.put(name, clazz);
            }
            elementList = xmlDoc.selectNodes("//servlet-mapping");
            for (Element mapping : elementList) {
                name = mapping.element("servlet-name").getText().trim();
                String pattern = mapping.element("url-pattern").getText().trim();
                String clazz = (String)map.get(name);
                if (clazz == null) continue;
                this.servletMap.put(pattern, new ServletModel(modulename, clazz));
            }
            if (elementList.size() == 0 && (webappEles = xmlDoc.selectNodes("//web-app")).size() == 1) {
                String name2;
                Element webappEle = (Element)webappEles.get(0);
                List listServlet = webappEle.elements("servlet");
                List listServletMapping = webappEle.elements("servlet-mapping");
                for (Element element : listServlet) {
                    name2 = element.element("servlet-name").getText().trim();
                    String clazz = element.element("servlet-class").getText().trim();
                    map.put(name2, clazz);
                }
                for (Element element : listServletMapping) {
                    name2 = element.element("servlet-name").getText().trim();
                    String pattern = element.element("url-pattern").getText().trim();
                    String clazz = (String)map.get(name2);
                    if (clazz == null) continue;
                    this.servletMap.put(pattern, new ServletModel(modulename, clazz));
                }
            }
        }
        catch (DocumentException e) {
            log.error((Object)"ProxyFilter readConfig");
        }
        catch (SAXException e) {
            log.error((Object)"ProxyFilter readConfig");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error((Object)"ProxyFilter readConfig");
                }
            }
        }
    }

    static class ServletModel {
        private String modulename;
        private String servletname;
        private HttpServlet instance;

        public ServletModel(String modulename, String servletname) {
            this.modulename = modulename;
            this.servletname = servletname;
        }
    }
}

