/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.proxy;

import com.hs.atic.util.LocalizedTextUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

public class ProxyServlet
extends HttpServlet {
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private static final long serialVersionUID = -824664812484515694L;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        config.getServletContext().setAttribute("com.hs.lego.ServletConfig", (Object)config);
        this.readConfig();
    }

    private void readConfig() {
        String location = "module.conf";
        try {
            Enumeration<URL> url = Thread.currentThread().getContextClassLoader().getResources(location);
            while (url.hasMoreElements()) {
                String[] res;
                URL path = url.nextElement();
                Properties prop = new Properties();
                prop.load(path.openStream());
                log.debug((Object)("i18n config,protocol is" + path.getProtocol()));
                String i18n = prop.getProperty("i18n");
                if (i18n == null) continue;
                for (String re : res = i18n.split(",")) {
                    log.debug((Object)("load Resources:" + re));
                    LocalizedTextUtil.addDefaultResourceBundle(re);
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"ProxyServlet readConfig");
        }
    }
}

