/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.proxy;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.text.Normalizer;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

final class StaticResourceUtil {
    private static final int NUM_4096 = 4096;
    private static final Object LOCK = new Object();
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private static StaticResourceUtil instance = null;
    private static String encoding = "UTF-8";
    private final Calendar lastModifiedCal = Calendar.getInstance();

    private StaticResourceUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StaticResourceUtil getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new StaticResourceUtil();
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean findStaticResource(String name, String pathPrefix, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String normalizeName = Normalizer.normalize(name, Normalizer.Form.NFKC);
        if (!normalizeName.endsWith(".class") && !"/".equals(normalizeName)) {
            InputStream is = null;
            is = this.findInputStream(normalizeName, pathPrefix);
            if (is != null) {
                Calendar cal = Calendar.getInstance();
                long ifModifiedSince = 0L;
                try {
                    ifModifiedSince = request.getDateHeader("If-Modified-Since");
                }
                catch (Exception e) {
                    log.error((Object)("Invalid If-Modified-Since header value ignoring!" + e.getMessage()));
                }
                long lastModifiedMillis = this.lastModifiedCal.getTimeInMillis();
                long now = cal.getTimeInMillis();
                cal.add(5, 1);
                long expires = cal.getTimeInMillis();
                if (ifModifiedSince > 0L && ifModifiedSince <= lastModifiedMillis) {
                    response.setDateHeader("Expires", expires);
                    response.setStatus(304);
                    is.close();
                    return true;
                }
                String contentType = this.getContentType(normalizeName);
                boolean needCache = false;
                if (contentType != null) {
                    response.setContentType(contentType);
                    needCache = true;
                }
                if (needCache) {
                    response.setDateHeader("Date", now);
                    response.setDateHeader("Expires", expires);
                    response.setDateHeader("Retry-After", expires);
                    response.setHeader("Cache-Control", "public");
                    response.setDateHeader("Last-Modified", lastModifiedMillis);
                } else {
                    response.setHeader("Cache-Control", "no-store");
                    response.setHeader("Pragma", "no-cache");
                    response.setHeader("Expires", "-1");
                }
                try {
                    this.copy(is, (OutputStream)response.getOutputStream());
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"IOException");
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected InputStream findInputStream(String name, String packagePrefix) throws IOException {
        String normalizeName = Normalizer.normalize(name, Normalizer.Form.NFKC);
        String normalizePackagePrefix = Normalizer.normalize(packagePrefix, Normalizer.Form.NFKC);
        String resourcePath = normalizePackagePrefix.endsWith("/") && normalizeName.startsWith("/") ? normalizePackagePrefix + normalizeName.substring(1) : normalizePackagePrefix + normalizeName;
        resourcePath = URLDecoder.decode(resourcePath, encoding);
        return ClassLoaderUtil.getResourceAsStream((String)resourcePath, this.getClass());
    }

    protected String getContentType(String name) {
        String normalizeName = Normalizer.normalize(name, Normalizer.Form.NFKC);
        if (normalizeName.endsWith(".js")) {
            return "text/javascript";
        }
        if (normalizeName.endsWith(".css")) {
            return "text/css";
        }
        if (normalizeName.endsWith(".html")) {
            return "text/html";
        }
        if (normalizeName.endsWith(".txt")) {
            return "text/plain";
        }
        if (normalizeName.endsWith(".gif")) {
            return "image/gif";
        }
        return this.getOtherContentType(normalizeName);
    }

    private String getOtherContentType(String name) {
        if (name.endsWith(".jpg") || name.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (name.endsWith(".png")) {
            return "image/png";
        }
        if (name.endsWith(".ico")) {
            return "image/ico";
        }
        if (name.endsWith(".swf")) {
            return "application/x-shockwave-flash";
        }
        if (name.endsWith(".exe")) {
            return "application/x-msdownload";
        }
        if (name.endsWith(".csv")) {
            return "application/vnd.ms-excel";
        }
        return null;
    }

    protected void copy(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        output.flush();
    }
}

