/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.util;

import com.hs.lego.ui.plat.common.util.OperateLockEnum;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;

public final class OperateLocker {
    private static OperateLocker instance = new OperateLocker();
    private Map<OperateLockEnum, Semaphore> lockMap = new HashMap<OperateLockEnum, Semaphore>();

    private OperateLocker() {
        for (OperateLockEnum lockEnum : OperateLockEnum.values()) {
            this.lockMap.put(lockEnum, new Semaphore(lockEnum.getMaxCount()));
        }
    }

    public static OperateLocker getInstance() {
        return instance;
    }

    public boolean addOneExecutingOperate(OperateLockEnum operate) {
        Semaphore semaphore = this.lockMap.get((Object)operate);
        return semaphore.tryAcquire();
    }

    public void removeOneExecutingOperate(OperateLockEnum operate) {
        Semaphore semaphore = this.lockMap.get((Object)operate);
        semaphore.release();
    }
}

