/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.common.webapp.action;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.hs.atic.analysis.util.SysOptLogAnalysisUtil;
import com.hs.lego.cbb.fault.sdk.model.PageSizeConfig;
import com.hs.lego.cbb.fault.sdk.service.PageSizeConfigService;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.constants.LangPair;
import com.hs.lego.ui.plat.common.exception.LegoSecurityException;
import com.hs.lego.ui.plat.common.log.OperateLog;
import com.hs.lego.ui.tag.tools.IAuthHandler;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.restful.util.JacksonNullProviderUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts2.ServletActionContext;
import org.springframework.remoting.RemoteConnectFailureException;

public class BaseAction
extends ActionSupport {
    public static final String CANCEL = "cancel";
    private static final long serialVersionUID = 3525445612504421307L;
    protected final transient Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    protected int pageSize = 10;
    protected int start = 0;
    protected int total;
    protected BatchOperationResult batchOperationResult = null;
    private List<LangPair> batchOpeList;
    private OperateLog operateLog = new OperateLog();
    private IAuthHandler authHandler;

    public BaseAction() {
        try {
            PageSizeConfigService service = (PageSizeConfigService)ServiceContext.getInstance().getService("pageSizeConfigService", PageSizeConfigService.class);
            List<PageSizeConfig> list = service.findPageSizeNum("pageSize");
            if (list != null && !list.isEmpty()) {
                for (PageSizeConfig pageSizeConfig : list) {
                    this.pageSize = Integer.parseInt(pageSizeConfig.getSysValue());
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("log getPageSize error!" + e.getMessage()));
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean isAuthority(String authId) {
        if (this.authHandler == null) {
            this.authHandler = (IAuthHandler)ServletActionContext.getRequest().getSession().getAttribute("auth_handler");
            if (this.authHandler == null) {
                return false;
            }
            return this.authHandler.isAuthority(authId);
        }
        return this.authHandler.isAuthority(authId);
    }

    public void setPageSize(int pageSize) {
        if (pageSize != 10 && pageSize != 20 && pageSize != 30 && pageSize != 50 && pageSize != 100) {
            return;
        }
        this.pageSize = pageSize;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        if (start <= 0) {
            return;
        }
        this.start = start;
    }

    protected HttpSession getSession() {
        return this.fetchRequest().getSession();
    }

    protected HttpServletRequest fetchRequest() {
        return ServletActionContext.getRequest();
    }

    protected HttpServletResponse getResponse() {
        return ServletActionContext.getResponse();
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void responseResult(String string) {
        PrintWriter writer = null;
        try {
            this.getResponse().setCharacterEncoding("UTF-8");
            this.getResponse().setHeader("Pragma", "no-cache");
            this.getResponse().setHeader("Cache-Control", "no-store");
            this.getResponse().setDateHeader("Expires", 0L);
            this.getResponse().setContentType("text/html;charset=UTF-8");
            writer = this.getResponse().getWriter();
            writer.write(string);
            writer.flush();
        }
        catch (Exception e) {
            this.log.error((Object)("write response:" + string + ". " + e.getMessage()));
        }
        finally {
            if (null != writer) {
                writer.close();
            }
        }
    }

    public void validate() {
        Map fieldErrors = this.getFieldErrors();
        if (fieldErrors == null || fieldErrors.isEmpty()) {
            return;
        }
        User user = (User)this.getSession().getAttribute("currentUser");
        for (String key : fieldErrors.keySet()) {
            this.log.error((Object)("**************parameters validate error, id:-->" + key));
        }
        if (user == null) {
            throw new LegoSecurityException(206L);
        }
        SysOptLog optLog = new SysOptLog();
        optLog.setOperation("lego.err.error");
        optLog.setModule("lego.dic.module.user");
        optLog.setLevel(SysoplogLevel.warning.getValue());
        optLog.setOperator(user.getUserName().trim());
        optLog.setTargetLocal(true);
        optLog.setTarget("lego.dic.module.user");
        optLog.setTerminalIp(((User)this.getSession().getAttribute("currentUser")).getIpAdr());
        optLog.setResult(0);
        optLog.setDetail("lego.err.dataerror");
        ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        sysOptLog.writeOptLog(optLog);
        SysOptLog logOutLog = new SysOptLog();
        logOutLog.setLevel(SysoplogLevel.info.getValue());
        logOutLog.setResult(1);
        logOutLog.setModule("lego.dic.module.user");
        logOutLog.setOperation("lego.lab.com.loginout");
        logOutLog.setOperator(user.getUserName());
        logOutLog.setTerminalIp(user.getIpAdr());
        logOutLog.setTarget(user.getUserName());
        logOutLog.setDetail("lego.err.dataerror");
        sysOptLog.writeOptLog(logOutLog);
        this.fetchRequest().getSession().invalidate();
        Iterator iterator = fieldErrors.keySet().iterator();
        if (iterator.hasNext()) {
            String key = (String)iterator.next();
            throw new LegoSecurityException(206L, key);
        }
        throw new LegoSecurityException(206L);
    }

    public String batchOper() {
        HttpSession session = this.getSession();
        this.batchOpeList = new ArrayList<LangPair>();
        if (session.getAttribute("session.oper.catch") != null) {
            this.batchOperationResult = (BatchOperationResult)session.getAttribute("session.oper.catch");
            List<BatchOperation> batchTemLst = this.batchOperationResult.getResult();
            for (BatchOperation batchOp : batchTemLst) {
                this.processOper(batchOp);
            }
        } else {
            this.batchOperationResult = new BatchOperationResult();
        }
        return "success";
    }

    private void processOper(BatchOperation batchOp) {
        if (batchOp.getErrorCode() != 0L) {
            String targetName = "";
            String[] targetNameParam = batchOp.getTargetNameParam();
            if (null != targetNameParam && targetNameParam.length > 0) {
                int targetNameParamLen = targetNameParam.length;
                for (int i = 0; i < targetNameParamLen; ++i) {
                    targetNameParam[i] = this.getIntelizeText(targetNameParam[i]);
                }
                targetName = this.getText(batchOp.getTargetName(), targetNameParam);
            } else {
                targetName = this.getIntelizeText(batchOp.getTargetName());
            }
            String detail = "";
            String[] param = batchOp.getDetailParam();
            if (null != param && param.length > 0) {
                for (int i = 0; i < param.length; ++i) {
                    param[i] = this.getIntelizeText(this.htmlEncodeCore(param[i]));
                }
                detail = this.getText("lego.err." + batchOp.getErrorCode(), param);
            } else {
                detail = this.getText("lego.err." + batchOp.getErrorCode());
            }
            LangPair langPair = new LangPair(targetName, detail);
            this.batchOpeList.add(langPair);
        }
    }

    private String getIntelizeText(String strText) {
        String temp = "";
        if (null == strText) {
            return "";
        }
        if (-1 == strText.indexOf("[") && -1 == strText.indexOf("]")) {
            try {
                temp = this.getText(strText);
                return temp;
            }
            catch (Exception ex) {
                this.log.error((Object)("log getText error!" + ex.getMessage()));
            }
        } else {
            return strText;
        }
        return strText;
    }

    protected void bathResult(BatchOperationResult operationResult) {
        this.batchOperationResult = operationResult;
        if (operationResult.getFailCount() == 0) {
            this.responseResult("success");
        } else {
            HttpSession session = this.getSession();
            if (session.getAttribute("session.oper.catch") != null) {
                session.removeAttribute("session.oper.catch");
            }
            session.setAttribute("session.oper.catch", (Object)operationResult);
            this.responseResult("failure");
        }
    }

    public boolean validateURLParameters(String whiteStr) {
        String str = whiteStr.replaceAll("\\s", "");
        String[] whiteList = str.split(",");
        if (null == this.fetchRequest().getParameterMap()) {
            return true;
        }
        Set ss = this.fetchRequest().getParameterMap().keySet();
        if (null == ss) {
            return true;
        }
        HashSet<String> whiteParaSet = new HashSet<String>();
        whiteParaSet.addAll(Arrays.asList("cfNameHF", "_dc", "start", "pageSize"));
        whiteParaSet.addAll(Arrays.asList(whiteList));
        Boolean checkParaResult = whiteParaSet.containsAll(ss);
        if (!checkParaResult.booleanValue()) {
            StringBuffer buf = new StringBuffer();
            for (String ssKey : ss) {
                buf.append(ssKey + ";");
            }
            this.log.error((Object)("Parameters in URL:" + buf.toString()));
            this.log.error((Object)("white URL Para:" + whiteStr + ",cfNameHF,_dc,start,pageSize"));
        }
        return checkParaResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void responseResult(Object obj) {
        PrintWriter writer = null;
        try {
            this.getResponse().setCharacterEncoding("UTF-8");
            this.getResponse().setHeader("Pragma", "no-cache");
            this.getResponse().setHeader("Cache-Control", "no-store");
            this.getResponse().setDateHeader("Expires", 0L);
            this.getResponse().setContentType("text/html;charset=UTF-8");
            writer = this.getResponse().getWriter();
            String s = null;
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializerProvider((DefaultSerializerProvider)new JacksonNullProviderUtil());
            s = mapper.writeValueAsString(obj);
            writer.write(s);
            writer.flush();
        }
        catch (IOException e) {
            this.log.error((Object)("write response:" + obj.toString() + e.getMessage()));
        }
        finally {
            if (null != writer) {
                writer.close();
            }
        }
    }

    public String htmlEncodeCore(String text) {
        if (null != text && !text.isEmpty()) {
            text = text.replace("&", "&amp;");
            text = text.replace("<", "&lt;");
            text = text.replace(">", "&gt;");
            text = text.replace("\"", "&quot;");
            text = text.replace("'", "&#x27;");
            text = text.replace("(", "&#x28;");
            text = text.replace(")", "&#x29;");
            text = text.replace("\\", "&#x5c;");
            text = text.replace("/", "&#x2f;");
        }
        return text;
    }

    public void systemOpeLog(String operation, String module, boolean targetLocal, String[] detailPara, String detail, String target, int level, boolean isSuccess, Exception ex) {
        SysOptLog sysOptLogLego = new SysOptLog();
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        String terminalIp = "127.0.0.1";
        String operator = "";
        if (null != request) {
            terminalIp = request.getRemoteAddr();
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            operator = currentUser.getUserName();
        }
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
        if (level >= SysoplogLevel.info.getValue() && level <= SysoplogLevel.risk.getValue()) {
            sysOptLogLego.setLevel(level);
        }
        sysOptLogLego.setModule(module);
        sysOptLogLego.setOperation(operation);
        sysOptLogLego.setOperator(operator);
        sysOptLogLego.setTarget(target);
        if (!targetLocal && target != null && target.length() > 255) {
            sysOptLogLego.setTarget(target.substring(0, 250) + "...");
        }
        sysOptLogLego.setTargetLocal(targetLocal);
        sysOptLogLego.setResult(isSuccess ? 1 : 0);
        if (ex == null) {
            if (detail == null) {
                detailPara = null;
            }
        } else if (ex instanceof LegoCheckedException) {
            LegoCheckedException legoException = (LegoCheckedException)((Object)ex);
            detail = "lego.err." + legoException.getErrorCode();
            detailPara = legoException.getParameters();
        } else if (ex instanceof LegoUncheckedException) {
            detail = "lego.err.102";
        } else if (ex instanceof RemoteConnectFailureException) {
            detail = "lego.err." + String.valueOf(105L);
        } else {
            detail = "lego.err.102";
            if (ex instanceof IllegalStateException && detail.contains("setAttribute: Session")) {
                int index1 = detail.indexOf(String.valueOf('['));
                int index2 = detail.indexOf(String.valueOf(']'), index1 + 1);
                String sessionId = detail.substring(index1 + 1, index2);
                detail = detail.replace(sessionId, "******");
            }
        }
        sysOptLogLego.setDetail(detail);
        sysOptLogLego.setDetailPara(detailPara);
        sysOptLogLego.setTerminalIp(terminalIp);
        if (null != sysOptLogLego.getTarget() && sysOptLogLego.getTarget().indexOf("alert") != -1) {
            sysOptLogLego.setTarget(sysOptLogLego.getModule());
            sysOptLogLego.setTargetLocal(true);
        }
        if (null == sysOptLogLego.getTarget() || sysOptLogLego.getTarget().equals("") || sysOptLogLego.getTarget().equals("--")) {
            sysOptLogLego.setTarget(sysOptLogLego.getModule());
            sysOptLogLego.setTargetLocal(true);
        }
        if (null == sysOptLogLego.getDetail() || sysOptLogLego.getDetail().trim().equals("") || sysOptLogLego.getDetail().indexOf("For input string:") != -1 || sysOptLogLego.getDetail().indexOf("lego.err.expecting") != -1 || sysOptLogLego.getDetail().indexOf("com.hs.lego.core.system.syslog") != -1) {
            sysOptLogLego.setDetail(null);
        } else if (sysOptLogLego.getDetail().indexOf("lego.err.unexpected end of subtree") != -1 || sysOptLogLego.getDetail().indexOf("lego.err.unexpected char:") != -1 || sysOptLogLego.getDetail().indexOf("String index out of range:") != -1 || sysOptLogLego.getDetail().indexOf("lego.err.unexpected") != -1) {
            sysOptLogLego.setDetail(null);
        } else if (sysOptLogLego.getDetail().indexOf("null") != -1 || sysOptLogLego.getDetail().indexOf("alert") != -1 || sysOptLogLego.getDetail().indexOf("lego.err.null") != -1 || sysOptLogLego.getDetail().indexOf("com.hs.lego.cbb.nms") != -1 || sysOptLogLego.getDetail().indexOf("Could not execute JDBC batch update") != -1) {
            sysOptLogLego.setDetail(null);
        }
        SysOptLogAnalysisUtil.getSysOptLog().writeOptLog(sysOptLogLego);
    }

    public void systemOpeLogBatch(String operation, String module, boolean targetLocal, int level, List<BatchOperation> batchOperationList) {
        if (batchOperationList == null || batchOperationList.isEmpty()) {
            this.log.warn((Object)"no operate result to write!");
            return;
        }
        SysOptLog sysOptLogLego = new SysOptLog();
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        String terminalIp = "127.0.0.1";
        String operator = "";
        if (null != request) {
            terminalIp = request.getRemoteAddr();
            User currentUser = (User)request.getSession().getAttribute("currentUser");
            operator = currentUser.getUserName();
        }
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
        if (level >= SysoplogLevel.info.getValue() && level <= SysoplogLevel.risk.getValue()) {
            sysOptLogLego.setLevel(level);
        }
        sysOptLogLego.setModule(module);
        sysOptLogLego.setOperation(operation);
        sysOptLogLego.setOperator(operator);
        sysOptLogLego.setTerminalIp(terminalIp);
        for (BatchOperation batOpe : batchOperationList) {
            batOpe.setDetailParam(BaseAction.getcleanedMessage(batOpe.getDetailParam()));
            batOpe.setTargetNameParam(BaseAction.getcleanedMessage(batOpe.getTargetNameParam()));
            String normalizeTargetName = Normalizer.normalize(batOpe.getTargetName(), Normalizer.Form.NFKC);
            sysOptLogLego.setTargetLocal(targetLocal);
            if (normalizeTargetName.endsWith(".alarm.name")) {
                sysOptLogLego.setTargetLocal(true);
            }
            if (batOpe.getTargetName() == null || batOpe.getTargetName().equals("") || sysOptLogLego.getTarget().equals("--")) {
                sysOptLogLego.setTargetLocal(true);
                sysOptLogLego.setTarget("lego.lab.com.batch.operation");
            } else {
                sysOptLogLego.setTarget(batOpe.getTargetName());
            }
            String[] targetNameParam = batOpe.getTargetNameParam();
            if (null != targetNameParam && targetNameParam.length > 0) {
                sysOptLogLego.setTargetPara(batOpe.getTargetNameParam());
            }
            if (batOpe.getErrorCode() == 0L) {
                sysOptLogLego.setResult(1);
                String optDetail = batOpe.getOptDetail();
                if (optDetail != null && !optDetail.trim().equals("")) {
                    sysOptLogLego.setDetail(optDetail);
                    String[] optDetailParam = batOpe.getDetailParam();
                    if (null != optDetailParam && optDetailParam.length > 0) {
                        sysOptLogLego.setDetailPara(optDetailParam);
                    }
                }
            } else {
                sysOptLogLego.setResult(0);
                sysOptLogLego.setDetail("lego.err." + batOpe.getErrorCode());
                String[] optDetailParam = batOpe.getDetailParam();
                if (null != optDetailParam && optDetailParam.length > 0) {
                    sysOptLogLego.setDetailPara(optDetailParam);
                }
            }
            if (null == sysOptLogLego.getDetail() || sysOptLogLego.getDetail().trim().equals("") || sysOptLogLego.getDetail().indexOf("For input string:") != -1 || sysOptLogLego.getDetail().indexOf("lego.err.expecting") != -1 || sysOptLogLego.getDetail().indexOf("com.hs.lego.core.system.syslog") != -1) {
                sysOptLogLego.setDetail(null);
            } else if (sysOptLogLego.getDetail().indexOf("lego.err.unexpected end of subtree") != -1 || sysOptLogLego.getDetail().indexOf("lego.err.unexpected char:") != -1 || sysOptLogLego.getDetail().indexOf("String index out of range:") != -1 || sysOptLogLego.getDetail().indexOf("lego.err.unexpected") != -1) {
                sysOptLogLego.setDetail(null);
            } else if (sysOptLogLego.getDetail().indexOf("null") != -1 || sysOptLogLego.getDetail().indexOf("alert") != -1 || sysOptLogLego.getDetail().indexOf("lego.err.null") != -1 || sysOptLogLego.getDetail().indexOf("com.hs.lego.cbb.nms") != -1 || sysOptLogLego.getDetail().indexOf("Could not execute JDBC batch update") != -1) {
                sysOptLogLego.setDetail(null);
            }
            SysOptLogAnalysisUtil.getSysOptLog().writeOptLog(sysOptLogLego);
        }
    }

    private static String[] getcleanedMessage(String[] message) {
        if (message != null) {
            for (int i = 0; i < message.length; ++i) {
                message[i] = message[i].replace('\n', ' ').replace('\r', ' ');
            }
        }
        return message;
    }

    public OperateLog getOperateLog() {
        return this.operateLog;
    }

    public BatchOperationResult getBatchOperationResult() {
        return this.batchOperationResult;
    }

    public void setBatchOperationResult(BatchOperationResult batchOperationResult) {
        this.batchOperationResult = batchOperationResult;
    }

    public List<LangPair> getBatchOpeList() {
        return this.batchOpeList;
    }

    public void setBatchOpeList(List<LangPair> batchOpeList) {
        this.batchOpeList = batchOpeList;
    }

    public void addListElementInSession(String attrName, String elementData) {
        List<String> strDataList = null;
        Object attrObj = this.getSession().getAttribute(attrName);
        strDataList = attrObj != null && attrObj instanceof List ? (List)attrObj : new ArrayList<String>();
        strDataList.add(elementData);
        this.getSession().setAttribute(attrName, strDataList);
    }

    public boolean existListElementInSession(String attrName, String elementData) {
        Object attrObj = this.getSession().getAttribute(attrName);
        if (attrObj == null) {
            return false;
        }
        if (attrObj instanceof List) {
            List strDataList = (List)attrObj;
            return strDataList.contains(elementData);
        }
        return false;
    }

    public void removeListElementInSession(String attrName, String elementData) {
        Object attrObj = this.getSession().getAttribute(attrName);
        if (attrObj == null) {
            return;
        }
        if (attrObj instanceof List) {
            List strDataList = (List)attrObj;
            strDataList.remove(elementData);
        }
    }
}

