/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.custom.help.util;

import com.hs.atic.util.XmlUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.custom.help.vo.HelpInfo;
import com.hs.lego.ui.plat.custom.help.vo.ParamInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public final class HelpConfig {
    private static final transient Log LOG = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private static Map<String, HelpInfo> menuConfig = new HashMap<String, HelpInfo>();
    private static Map<String, HelpInfo> pageConfig = new HashMap<String, HelpInfo>();
    private static boolean nonInit = true;

    private HelpConfig() {
    }

    private static void init() {
        HelpConfig.readCfg("/../../help/menuConfig.xml", menuConfig);
        HelpConfig.readCfg("/../../help/pageConfig.xml", pageConfig);
        nonInit = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void readCfg(String path, Map<String, HelpInfo> map) {
        block14: {
            SAXReader reader;
            InputStream in;
            block13: {
                in = null;
                reader = new SAXReader();
                XmlUtil.setSecureFeatureForSaxReader(reader);
                in = HelpConfig.class.getResourceAsStream(path);
                if (in != null) break block13;
                HelpConfig.destroy(in);
                return;
            }
            try {
                Document xmlDoc = reader.read(in);
                List configElementList = xmlDoc.selectNodes("//config");
                for (Element configElement : configElementList) {
                    Element urlElement;
                    Element keyElement = configElement.element("key");
                    if (keyElement == null) {
                        LOG.error((Object)"Help Config readConfig : no Key");
                        continue;
                    }
                    String textId = keyElement.getTextTrim();
                    HelpInfo helpInfo = new HelpInfo();
                    List paramsElementList = configElement.elements("params");
                    if (null != paramsElementList && !paramsElementList.isEmpty()) {
                        ParamInfo[] paramsArray = new ParamInfo[paramsElementList.size()];
                        int j = paramsElementList.size();
                        for (int i = 0; i < j; ++i) {
                            paramsArray[i] = HelpConfig.createParamInfo((Element)paramsElementList.get(i));
                        }
                        helpInfo.setParams(paramsArray);
                    }
                    if ((urlElement = configElement.element("url")) != null) {
                        String url = urlElement.getTextTrim();
                        helpInfo.setHelpUrl(url);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"url set up");
                        }
                    }
                    map.put(textId, helpInfo);
                }
            }
            catch (DocumentException e) {
                LOG.error((Object)"HelpConfig readConfig");
                HelpConfig.destroy(in);
                break block14;
            }
            catch (SAXException e2) {
                LOG.error((Object)"HelpConfig readConfig");
                {
                    catch (Throwable throwable) {
                        HelpConfig.destroy(in);
                        throw throwable;
                    }
                }
                HelpConfig.destroy(in);
            }
            HelpConfig.destroy(in);
        }
    }

    private static void destroy(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                LOG.error((Object)"HelpConfig readConfig");
            }
        }
    }

    private static ParamInfo createParamInfo(Element paramsElement) {
        List paramElementList = paramsElement.elements("param");
        String[] paramArray = new String[paramElementList.size()];
        int j = paramElementList.size();
        for (int i = 0; i < j; ++i) {
            paramArray[i] = "&" + ((Element)paramElementList.get(i)).getTextTrim() + "&";
        }
        String url = paramsElement.element("url").getTextTrim();
        if (LOG.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("param: ");
            for (String param : paramArray) {
                sb.append(param).append(' ');
            }
            LOG.debug((Object)sb);
            sb.append(" url:");
            sb.append(url);
        }
        return new ParamInfo(paramArray, url);
    }

    public static String getHelpCfg(String url, String menu, String topMenu) {
        int split;
        if (nonInit) {
            HelpConfig.init();
        }
        String paramString = null;
        if (null != url && (split = url.indexOf("?")) >= 0) {
            paramString = url.substring(split + 1);
            url = url.substring(0, split);
        }
        HelpInfo cfg = null;
        if (url != null && !"".equals(url)) {
            cfg = pageConfig.get(url);
        }
        if (cfg == null && null != menu && (cfg = menuConfig.get(HelpConfig.filterCfName(menu))) == null) {
            cfg = menuConfig.get(topMenu);
        }
        if (cfg == null) {
            return null;
        }
        return cfg.getHelpUrl(paramString);
    }

    private static String filterCfName(String strMenu) {
        int cfnameBeginIndex = strMenu.indexOf("?cfNameHF=");
        if (-1 == cfnameBeginIndex && -1 == (cfnameBeginIndex = strMenu.indexOf("&cfNameHF="))) {
            return strMenu;
        }
        return strMenu.substring(0, cfnameBeginIndex);
    }
}

