/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.user.util;

import com.hs.lego.cbb.user.cache.IUserLoginLocalCache;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.opensymphony.xwork2.ActionContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class LoginMgrUtil {
    private static Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);
    private static final Object LOCK = new Object();
    private static int maxFailNumber = 3;
    private static int maxAuthFailNumber = 3;
    private static LoginMgrUtil instance;
    private static Map<String, Integer> loginFailData;
    private static Map<String, Integer> authFailData;
    private static IUserLoginLocalCache userCacheService;
    public static final String ONLINE_SESSIONIDLIST_KEY = "onlineSessionIdList";

    private LoginMgrUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoginMgrUtil getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new LoginMgrUtil();
                loginFailData = new HashMap<String, Integer>();
                authFailData = new HashMap<String, Integer>();
            }
            return instance;
        }
    }

    public void loginFail(String ip, String userName) {
        Integer number = loginFailData.get(ip);
        if (number == null) {
            loginFailData.put(ip, 1);
        } else {
            loginFailData.put(ip, number + 1);
        }
    }

    public void loginSuccess(String ip, String userName) {
        Integer number = loginFailData.get(ip);
        if (number != null) {
            loginFailData.remove(ip);
        }
        if ((number = authFailData.get(userName)) != null) {
            authFailData.remove(userName);
        }
    }

    public boolean needVerifyCode(String ip, String userName) {
        Integer number = loginFailData.get(ip);
        if (number == null) {
            return false;
        }
        return number >= maxFailNumber;
    }

    public void authFail(String userName) {
        Integer number = authFailData.get(userName);
        if (number == null) {
            authFailData.put(userName, 1);
        } else {
            authFailData.put(userName, number + 1);
        }
    }

    public void authSuccess(String userName) {
        Integer number = authFailData.get(userName);
        if (number != null) {
            authFailData.remove(userName);
        }
    }

    public boolean needLogout(String userName) {
        Integer number = authFailData.get(userName);
        if (number == null) {
            return false;
        }
        return number >= maxAuthFailNumber;
    }

    public static void redirectLogin(HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession(false);
            ISysOptLog sysLogService = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
            if (null == session) {
                log.error((Object)"Session is empty.");
            } else {
                try {
                    User user = (User)session.getAttribute("currentUser");
                    session.invalidate();
                    LoginMgrUtil.clearSessionFromCache(user.getSession());
                    SysOptLog logout = new SysOptLog();
                    logout.setLevel(SysoplogLevel.info.getValue());
                    logout.setResult(1);
                    logout.setModule("lego.dic.module.user");
                    logout.setOperation("lego.lab.com.loginout");
                    logout.setOperator(user.getUserName());
                    logout.setTerminalIp(user.getIpAdr());
                    logout.setTarget(user.getUserName());
                    logout.setDetail("lego.err.dataerror");
                    logout.setTargetLocal(false);
                    if (null != ActionContext.getContext() && Locale.ENGLISH == ActionContext.getContext().getLocale()) {
                        logout.setTargetLocal(true);
                    }
                    sysLogService.writeOptLog(logout);
                }
                catch (RuntimeException e) {
                    log.error((Object)("Redirect to login page error : " + e.getMessage()));
                }
                catch (Exception e) {
                    log.error((Object)"error: write system log");
                }
            }
            response.sendRedirect(request.getContextPath() + "/pages/common/exception.jsp?timeout=true");
        }
        catch (IOException e) {
            log.error((Object)"redirectLogin sendRedirect fail");
        }
    }

    public static void clearSessionFromCache(String sessionId) {
        try {
            ConcurrentSkipListSet set;
            if (null == userCacheService) {
                log.info((Object)"userCacheService is null.");
                return;
            }
            if (userCacheService.containsKey(sessionId, true)) {
                userCacheService.remove(sessionId);
                log.info((Object)"Success to remove session from cacheService.");
            }
            if (userCacheService.containsKey(ONLINE_SESSIONIDLIST_KEY) && (set = (ConcurrentSkipListSet)userCacheService.get(ONLINE_SESSIONIDLIST_KEY)).contains(sessionId)) {
                set.remove(sessionId);
                log.info((Object)"Success to remove session from onlineSessionList.");
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to remove session: " + e.getMessage()));
            throw new LegoCheckedException(412L);
        }
    }

    static {
        userCacheService = (IUserLoginLocalCache)ServiceContext.getInstance().getService("cacheService", IUserLoginLocalCache.class);
    }
}

