/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.user.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.imageio.ImageIO;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public final class VerifyCode {
    private static final long serialVersionUID = 1L;
    private static SecureRandom gORandom = new SecureRandom();
    private static String bVariableFont = "false";
    private static int iMinFontSize = 30;
    private static int iMaxFontSize = 40;
    private static String bVariableFontSize = "true";
    private static String bIsContainLowercase = "true";
    private static String bIsContainUppercase = "true";
    private static String bIsRotate = "true";
    private static int iDistance = 5;
    private static String bIsSetBackground = "true";
    private static String bIsSetInterferon = "true";
    private static int iDistort = 3;
    private static final double ZPS = 0.6;
    private static final double ZPE = 0.8;
    private static final double ZPT = 0.2;
    private static final double MZPT = -0.2;
    private static final double FFD = 15.0;
    private static final double TTD = 20.0;
    private static final double PI = Math.PI;
    private static final long DATEEXP = 6256548150790586368L;
    private static final float TWOF = 2.0f;
    private static double[] scaleRange = new double[]{0.6, 0.8};
    private static double[] rotateRange = new double[]{-0.2, 0.2};

    public void init(ServletConfig config) throws ServletException {
        this.setbVariableFont(config.getInitParameter("bVariableFont"));
        this.setbVariableFontSize(config.getInitParameter("bVariableFontSize"));
        this.setbIsContainLowercase(config.getInitParameter("bIsContainLowercase"));
        this.setbIsContainUppercase(config.getInitParameter("bIsContainUppercase"));
        this.setbIsRotate(config.getInitParameter("bIsRotate"));
        this.setiDistance(Integer.parseInt(config.getInitParameter("iDistance")));
        this.setbIsSetBackground(config.getInitParameter("bIsSetBackground"));
        this.setbIsSetInterferon(config.getInitParameter("bIsSetInterferon"));
        this.setiDistort(Integer.parseInt(config.getInitParameter("iDistort")));
    }

    public static String getbVariableFont() {
        return bVariableFont;
    }

    public static void setbVariableFontCp(String bVariableFontCp) {
        bVariableFont = bVariableFontCp;
    }

    public void setbVariableFont(String bVariableFontCp) {
        VerifyCode.setbVariableFontCp(bVariableFontCp);
    }

    public static String getbVariableFontSize() {
        return bVariableFontSize;
    }

    public static void setbVariableFontSizeCp(String bVariableFontSizeCp) {
        bVariableFontSize = bVariableFontSizeCp;
    }

    public void setbVariableFontSize(String bVariableFontSizeCp) {
        VerifyCode.setbVariableFontSizeCp(bVariableFontSizeCp);
    }

    public static String getbIsContainLowercase() {
        return bIsContainLowercase;
    }

    public static void setbIsContainLowercaseCp(String oneBIsContainLowercase) {
        bIsContainLowercase = oneBIsContainLowercase;
    }

    public void setbIsContainLowercase(String onrBIsContainLowercase) {
        VerifyCode.setbIsContainLowercaseCp(onrBIsContainLowercase);
    }

    public static String getbIsContainUppercase() {
        return bIsContainUppercase;
    }

    public static void setbIsContainUppercaseCp(String oneBIsContainUppercase) {
        bIsContainUppercase = oneBIsContainUppercase;
    }

    public void setbIsContainUppercase(String oneBIsContainUppercase) {
        VerifyCode.setbIsContainUppercaseCp(oneBIsContainUppercase);
    }

    public static String getbIsRotate() {
        return bIsRotate;
    }

    public static void setbIsRotateCp(String oneBIsRotate) {
        bIsRotate = oneBIsRotate;
    }

    public void setbIsRotate(String oneBIsRotate) {
        VerifyCode.setbIsRotateCp(oneBIsRotate);
    }

    public static int getiDistance() {
        return iDistance;
    }

    public static void setiDistanceCp(int onrIDistance) {
        iDistance = onrIDistance;
    }

    public void setiDistance(int oneIDistance) {
        VerifyCode.setiDistanceCp(oneIDistance);
    }

    public static String getbIsSetBackground() {
        return bIsSetBackground;
    }

    public static void setbIsSetBackgroundCp(String oneBIsSetBackground) {
        bIsSetBackground = oneBIsSetBackground;
    }

    public void setbIsSetBackground(String oneBIsSetBackground) {
        VerifyCode.setbIsSetBackgroundCp(oneBIsSetBackground);
    }

    public static String getbIsSetInterferon() {
        return bIsSetInterferon;
    }

    public static void setbIsSetInterferonCp(String onrBIsSetInterferon) {
        bIsSetInterferon = onrBIsSetInterferon;
    }

    public void setbIsSetInterferon(String onrBIsSetInterferon) {
        VerifyCode.setbIsSetInterferonCp(onrBIsSetInterferon);
    }

    public static int getiDistort() {
        return iDistort;
    }

    public static void setiDistortCp(int oneIDistort) {
        iDistort = oneIDistort;
    }

    public void setiDistort(int oneIDistort) {
        VerifyCode.setiDistortCp(oneIDistort);
    }

    private static Color getColor(int[] colorRange) {
        int r = VerifyCode.getRandomInRange(colorRange);
        int g = VerifyCode.getRandomInRange(colorRange);
        int b = VerifyCode.getRandomInRange(colorRange);
        return new Color(r, g, b);
    }

    private static int getRandomInRange(int[] range) {
        if (range == null || range.length != 2) {
            return 0;
        }
        return (int)(gORandom.nextDouble() * (double)(range[1] - range[0]) + (double)range[0]);
    }

    private static double getRandomInRange(double[] range) {
        if (range == null || range.length != 2) {
            return 0.0;
        }
        return gORandom.nextDouble() * (range[1] - range[0]) + range[0];
    }

    private static String generateCodeString(String dictionary) {
        char[] dictionaryChars = dictionary.toCharArray();
        SecureRandom r = new SecureRandom();
        int index1 = r.nextInt(dictionaryChars.length);
        int index2 = r.nextInt(dictionaryChars.length);
        int index3 = r.nextInt(dictionaryChars.length);
        int index4 = r.nextInt(dictionaryChars.length);
        char[] codeChars = new char[]{dictionaryChars[index1], dictionaryChars[index2], dictionaryChars[index3], dictionaryChars[index4]};
        return String.valueOf(codeChars, 0, codeChars.length);
    }

    private static BufferedImage generateCheckCodeImage(String code) {
        char[] codeChars = code.toCharArray();
        BufferedImage[] images = new BufferedImage[codeChars.length];
        SecureRandom random = new SecureRandom();
        Color fgColor = VerifyCode.getRandColor(10, 100);
        for (int i = 0; i < codeChars.length; ++i) {
            int height = 25;
            images[i] = new BufferedImage(height, height, 1);
            Graphics2D g2d = images[i].createGraphics();
            images[i] = g2d.getDeviceConfiguration().createCompatibleImage(height, height, 3);
            g2d.dispose();
            g2d = images[i].createGraphics();
            String sFont = "Courier";
            if (bVariableFont.equalsIgnoreCase("true")) {
                String[] lstFONTs = new String[]{"Arial", "Courier", "Courier New", "Times New Roman"};
                int index = random.nextInt(3) % 4;
                sFont = lstFONTs[index];
            }
            int iFontSize = 35;
            if (bVariableFontSize.equalsIgnoreCase("true")) {
                iFontSize = random.nextInt(iMaxFontSize) % (iMaxFontSize - iMinFontSize + 1) + iMinFontSize;
            }
            Font font = new Font(sFont, 0, iFontSize);
            g2d.setFont(font);
            g2d.setColor(fgColor);
            AffineTransform affineTransform = new AffineTransform();
            double scaleX = VerifyCode.getRandomInRange(scaleRange);
            double scaleY = VerifyCode.getRandomInRange(scaleRange);
            affineTransform.scale(scaleX, scaleY);
            double rotateX = 0.0;
            if (bIsRotate.equalsIgnoreCase("true")) {
                rotateX = VerifyCode.getRandomInRange(rotateRange);
            }
            affineTransform.rotate(rotateX, 15.0, 15.0);
            g2d.setTransform(affineTransform);
            FontRenderContext fontRenderContext = g2d.getFontRenderContext();
            int px = (height - g2d.getFontMetrics().charWidth(codeChars[i])) / 2;
            int py = (int)(Float.valueOf(String.valueOf(height / 2)).floatValue() + font.getLineMetrics(Character.toString(codeChars[i]), fontRenderContext).getAscent() / 2.0f);
            g2d.drawString(Character.toString(codeChars[i]), px, py);
            g2d.dispose();
        }
        return VerifyCode.assembleImages(images);
    }

    private static BufferedImage assembleImages(BufferedImage[] images) {
        int width = 75 + 3 * iDistance;
        int height = 25;
        int liTmp0 = 0;
        int liTmp1 = 0;
        int liWidth = 100;
        int liHeight = 25;
        BufferedImage bgImage = new BufferedImage(width, height, 4);
        Graphics2D g2d = bgImage.createGraphics();
        g2d.fillRect(0, 0, width, height);
        g2d.setColor(Color.white);
        g2d.drawRect(0, 0, width, height);
        if (bIsSetBackground.equalsIgnoreCase("true")) {
            SecureRandom random = new SecureRandom();
            int[] disturbColor = new int[]{150, 255};
            for (int i = 0; i < 150; ++i) {
                int xs = random.nextInt(width);
                int ys = random.nextInt(height);
                int xe = xs;
                int ye = ys;
                Color fgColor = VerifyCode.getColor(disturbColor);
                g2d.setColor(fgColor);
                g2d.drawLine(xs, ys, xe, ye);
            }
        }
        int index = 0;
        int drawX = 5;
        int distance = 0;
        if (images != null && images.length != 0) {
            g2d.drawImage(images[index], drawX, 2, images[index].getWidth(), images[0].getHeight(), null);
            distance = VerifyCode.calculateDistanceBetweenChar2(images[0], images[1]);
            drawX = drawX + images[index].getWidth() - distance + iDistance;
            ++index;
            while (index < images.length) {
                g2d.drawImage(images[index], drawX, 2, images[index].getWidth(), images[0].getHeight(), null);
                distance = VerifyCode.calculateDistanceBetweenChar2(images[index - 1], images[index]);
                drawX = drawX + images[index].getWidth() - distance + iDistance;
                ++index;
            }
        }
        if (bIsSetInterferon.equalsIgnoreCase("true")) {
            int ii;
            liTmp0 = liWidth + 1;
            liTmp1 = liHeight + 1;
            for (ii = 0; ii < 2; ++ii) {
                g2d.setStroke(new BasicStroke((float)((double)(VerifyCode.createRandom(30) + 1) / 20.0)));
                g2d.setColor(VerifyCode.getRandColor(100, 150));
                g2d.drawLine(0, VerifyCode.createRandom(liTmp1), liWidth, VerifyCode.createRandom(liTmp1));
            }
            for (ii = 0; ii < 2; ++ii) {
                g2d.setStroke(new BasicStroke((float)((double)(VerifyCode.createRandom(30) + 1) / 20.0)));
                g2d.setColor(VerifyCode.getRandColor(100, 150));
                g2d.drawLine(VerifyCode.createRandom(liTmp0), 0, VerifyCode.createRandom(liTmp0), liHeight);
            }
        }
        g2d.dispose();
        return bgImage;
    }

    private static int min(int[] array) {
        int result = Integer.MAX_VALUE;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] >= result) continue;
            result = array[i];
        }
        return result;
    }

    private static int[][] calculateBlankNum(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] result = new int[height][2];
        for (int i = 0; i < result.length; ++i) {
            result[i][0] = 0;
            result[i][1] = width;
        }
        int[] colorArray = new int[4];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                colorArray = image.getRaster().getPixel(j, i, colorArray);
                if (VerifyCode.checkArray(colorArray, new int[4])) continue;
                if (result[i][0] == 0) {
                    result[i][0] = j;
                }
                result[i][1] = width - j - 1;
            }
        }
        return result;
    }

    private static int calculateDistanceBetweenChar2(BufferedImage leftImage, BufferedImage rightImage) {
        int[][] left = VerifyCode.calculateBlankNum(leftImage);
        int[][] right = VerifyCode.calculateBlankNum(rightImage);
        int[] tempArray = new int[leftImage.getHeight()];
        for (int i = 0; i < left.length; ++i) {
            tempArray[i] = right[i][0] == 0 ? left[i][1] + leftImage.getWidth() : left[i][1] + right[i][0];
        }
        return VerifyCode.min(tempArray);
    }

    private static boolean checkArray(int[] arrayA, int[] arrayB) {
        if (arrayA == null || arrayB == null) {
            return false;
        }
        if (arrayA.length != arrayB.length) {
            return false;
        }
        for (int i = 0; i < arrayA.length; ++i) {
            if (arrayA[i] == arrayB[i]) continue;
            return false;
        }
        return true;
    }

    private static int createRandom(int iSeed) {
        int liValue = 0;
        byte[] lpbtRand = new byte[4];
        gORandom.nextBytes(lpbtRand);
        for (int ii = 0; ii < 4; ++ii) {
            byte lbtTmp = lpbtRand[ii];
            liValue += (lbtTmp & 0xFF) << 8 * ii;
        }
        return Math.abs(liValue % iSeed);
    }

    private static Color getRandColor(int iFC, int iBC) {
        int liMax = Math.max(iFC, iBC);
        int liMin = Math.min(iFC, iBC);
        if (liMin == liMax) {
            return new Color(liMin, liMin, liMin);
        }
        return new Color(liMin + VerifyCode.createRandom(liMax -= liMin - 1), liMin + VerifyCode.createRandom(liMax), liMin + VerifyCode.createRandom(liMax));
    }

    private static BufferedImage distortImage(BufferedImage oldImage, int iMargin, double dPhase) {
        BufferedImage newImage = new BufferedImage(oldImage.getWidth(), oldImage.getHeight(), 1);
        Graphics graphics = newImage.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, newImage.getWidth(), newImage.getHeight());
        graphics.dispose();
        SecureRandom random = new SecureRandom();
        if (iMargin > 4) {
            iMargin = random.nextInt(iMargin) % (iMargin - 4) + 5;
        }
        double dLen = newImage.getHeight();
        for (int i = 0; i < newImage.getWidth(); ++i) {
            for (int j = 0; j < newImage.getHeight(); ++j) {
                double x = Math.PI * (double)j / dLen;
                double dy = Math.sin(x += dPhase);
                int oX = 0;
                int oY = 0;
                oX = i + (int)(dy * (double)iMargin);
                oY = j;
                int rgb = oldImage.getRGB(i, j);
                if (oX < 0 || oX >= newImage.getWidth() || oY < 0 || oY >= newImage.getHeight()) continue;
                newImage.setRGB(oX, oY, rgb);
            }
        }
        return newImage;
    }

    public static void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("image/jpeg");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-store");
        response.setDateHeader("Expires", 6256548150790586368L);
        String dictionary = "012345689";
        if (bIsContainLowercase.equalsIgnoreCase("true")) {
            dictionary = bIsContainUppercase.equalsIgnoreCase("true") ? "12345689ABCDEFGHJKMNPQRSUVXYWZacdefhjkmnpqrsuvxywz" : "12345689acdefhjkmnpqrsuvxywz";
        } else if (bIsContainUppercase.equalsIgnoreCase("true")) {
            dictionary = "12345689ABCDEFGHJKMNPQRSUVXYWZ";
        }
        String sRand = "";
        sRand = VerifyCode.generateCodeString(dictionary);
        BufferedImage image = VerifyCode.generateCheckCodeImage(sRand);
        image = VerifyCode.distortImage(image, iDistort, 0.0);
        HttpSession session = request.getSession();
        session.setAttribute("HWVerifyCode", (Object)sRand);
        ServletOutputStream responseOutputStream = response.getOutputStream();
        ImageIO.setUseCache(false);
        ImageIO.write((RenderedImage)image, "JPEG", (OutputStream)responseOutputStream);
        responseOutputStream.flush();
        responseOutputStream.close();
    }
}

