/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.secservice.sdk.common.dao;

import com.hs.lego.core.sdk.comm.Paging;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.Transformers;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class BaseDao<T, PK extends Serializable>
extends HibernateDaoSupport {
    protected Class<T> persistentClass;

    public BaseDao() {
    }

    public BaseDao(Class<T> persistentClass) {
        this.persistentClass = persistentClass;
    }

    public List<T> queryPageByHql(final String hql, final int start, final int pageSize, final Map<Integer, String> condition) {
        return (List)new HibernateTemplate(this.getSessionFactory()).execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.createQuery(hql);
                Set entrys = condition.entrySet();
                for (Map.Entry entry : entrys) {
                    query.setString(((Integer)entry.getKey()).intValue(), (String)entry.getValue());
                }
                query.setFirstResult(start);
                if (pageSize != 0) {
                    query.setMaxResults(pageSize);
                }
                return query.getResultList();
            }
        });
    }

    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        HashMap<Integer, String> condition = new HashMap<Integer, String>();
        String hql = this.initQuery(queryMap, new StringBuffer(), condition);
        List<T> list = this.queryPageByHql(hql, start, pageSize, condition);
        Paging page = new Paging();
        page.setData(list);
        page.setCount(this.getRowCountByHsql(this.generateRowCountSqlByHsql(hql), condition));
        return page;
    }

    public void delete(PK id) {
        T t = this.query(id);
        if (t == null) {
            return;
        }
        this.getHibernateTemplate().delete(t);
    }

    public T deleteByQuery(PK id) {
        T t = this.query(id);
        if (t == null) {
            return null;
        }
        this.getHibernateTemplate().delete(t);
        return t;
    }

    public void delete(T t) {
        this.getHibernateTemplate().delete(t);
    }

    public T query(PK id) {
        return (T)this.getHibernateTemplate().get(this.persistentClass, id);
    }

    public List<T> queryAll() {
        return this.queryByHql(this.basicHql(), new HashMap<Integer, Object>());
    }

    public List<T> queryAllByOrder(Map<String, String> queryMap) {
        StringBuffer hql = new StringBuffer();
        hql.append(this.basicHql());
        this.sortHql(queryMap, hql);
        List<T> list = this.queryByHql(hql.toString(), new HashMap<Integer, Object>());
        return list;
    }

    protected String generateRowCountSqlByHsql(String hsql) {
        String hsqlLowerCase = hsql.toLowerCase(Locale.getDefault());
        int sqlFrom = hsqlLowerCase.indexOf("from ");
        int sqlOrderby = hsqlLowerCase.lastIndexOf("order by");
        int sqlGroupby = hsqlLowerCase.lastIndexOf("group by");
        String rowCountSql = "";
        rowCountSql = sqlOrderby > 0 ? "select count(*) AS rowCount " + hsql.substring(sqlFrom, sqlOrderby) : (sqlGroupby > 0 ? "select count(*) from (select count(*) AS rowCount " + hsql.substring(sqlFrom) + ") as tab" : "select count(*) AS rowCount " + hsql.substring(sqlFrom));
        return rowCountSql;
    }

    public int getRowCountByHsql(final String hsql, final Map<Integer, String> condition) {
        return (Integer)new HibernateTemplate(this.getSessionFactory()).execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.createQuery(BaseDao.this.generateRowCountSqlByHsql(hsql));
                Set entrys = condition.entrySet();
                for (Map.Entry entry : entrys) {
                    query.setString(((Integer)entry.getKey()).intValue(), (String)entry.getValue());
                }
                return Integer.valueOf(query.list().get(0).toString());
            }
        });
    }

    public int getRowCountByHsql(String hsql, Object[] objects) {
        return Integer.parseInt(super.getHibernateTemplate().find(this.generateRowCountSqlByHsql(hsql), objects).get(0).toString());
    }

    public List<T> queryByHql(final String hql, final Map<Integer, Object> condition) {
        return (List)new HibernateTemplate(this.getSessionFactory()).execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.createQuery(hql);
                Set entrys = condition.entrySet();
                for (Map.Entry entry : entrys) {
                    query.setParameter(((Integer)entry.getKey()).intValue(), entry.getValue());
                }
                return query.list();
            }
        });
    }

    protected String initQuery(Map<String, String> queryMap, StringBuffer hql, Map<Integer, String> conditon) {
        this.basicHql(hql);
        this.conditionHql(queryMap, hql, conditon);
        this.sortHql(queryMap, hql);
        return hql.toString();
    }

    protected void conditionHql(Map<String, String> queryMap, StringBuffer hql, Map<Integer, String> condition) {
        if (!queryMap.isEmpty()) {
            int index = 0;
            boolean isFirstCondition = true;
            hql.append(" where ");
            for (Map.Entry<String, String> entry : queryMap.entrySet()) {
                if (isFirstCondition) {
                    isFirstCondition = false;
                } else {
                    hql.append(" and ");
                }
                String key = entry.getKey();
                String value = entry.getValue();
                hql.append(key + "= ?" + index);
                condition.put(index++, value);
            }
        }
    }

    protected String basicHql() {
        StringBuffer hql = new StringBuffer();
        this.basicHql(hql);
        return hql.toString();
    }

    private void basicHql(StringBuffer hql) {
        hql.append("from ").append(this.persistentClass.getSimpleName());
    }

    protected void sortHql(Map<String, String> queryMap, StringBuffer hql) {
        String regular;
        String sortType = queryMap.get("sortType");
        String sortName = queryMap.get("sortName");
        if (null != sortType && null != sortName && Pattern.matches(regular = "^[A-Za-z0-9|_]+$", sortName) && (sortType.trim().equalsIgnoreCase("desc") || sortType.trim().equalsIgnoreCase("asc"))) {
            hql.append(" order by ").append(sortName).append("  ").append(sortType);
        }
    }

    public T save(T object) {
        return (T)this.getHibernateTemplate().merge(object);
    }

    public void update(T object) {
        this.getHibernateTemplate().update(object);
    }

    public Serializable create(T object) {
        return this.getHibernateTemplate().save(object);
    }

    public void deleteList(Collection<T> list) {
        for (T t : list) {
            this.getHibernateTemplate().delete(t);
        }
    }

    public void deleteListByPkId(Collection<PK> list) {
        for (Serializable pk : list) {
            this.getHibernateTemplate().delete((Object)pk);
        }
    }

    public void createOrUpdate(T object) {
        super.getHibernateTemplate().flush();
        super.getHibernateTemplate().clear();
        this.getHibernateTemplate().saveOrUpdate(object);
    }

    public int executeHql(final String hql, final Map<Integer, Object> condition) {
        return (Integer)new HibernateTemplate(this.getSessionFactory()).execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query q = session.createQuery(hql);
                Set entrys = condition.entrySet();
                for (Map.Entry entry : entrys) {
                    q.setParameter(((Integer)entry.getKey()).intValue(), entry.getValue());
                }
                return q.executeUpdate();
            }
        });
    }

    protected void setQueryParameter(Query query, Map<String, Object> params) {
        if (params != null) {
            Map.Entry<String, Object> param2 = null;
            for (Map.Entry<String, Object> param2 : params.entrySet()) {
                if (param2.getValue() instanceof Collection) {
                    query.setParameterList(param2.getKey(), (Collection)param2.getValue());
                    continue;
                }
                if (param2.getValue() instanceof Object[]) {
                    query.setParameterList(param2.getKey(), (Object[])param2.getValue());
                    continue;
                }
                query.setParameter(param2.getKey(), param2.getValue());
            }
        }
    }

    public List<?> findByNamedQuery(final String queryName, final Map<String, Object> params) {
        return (List)new HibernateTemplate(this.getSessionFactory()).execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.getNamedQuery(queryName);
                BaseDao.this.setQueryParameter(query, params);
                return query.list();
            }
        });
    }

    public List<?> findBySQLQuery(final String queryName, final Map<String, Object> parameters, final Class<?> clazz) {
        return (List)new HibernateTemplate(this.getSessionFactory()).execute(new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.getNamedQuery(queryName);
                BaseDao.this.setQueryParameter(query, parameters);
                if (null != clazz) {
                    query.setResultTransformer(Transformers.aliasToBean((Class)clazz));
                }
                return query.list();
            }
        });
    }

    public List<T> findByHql(String hql) {
        return super.getHibernateTemplate().find(hql, new Object[0]);
    }

    public List<T> findByHql(String hql, Object object) {
        return super.getHibernateTemplate().find(hql, new Object[]{object});
    }

    public List<T> findByHql(String hql, Object[] object) {
        return super.getHibernateTemplate().find(hql, object);
    }

    public void remove(PK id) {
        T t = this.get(id);
        if (t == null) {
            return;
        }
        this.getHibernateTemplate().delete(t);
    }

    public T get(PK id) {
        return (T)this.getHibernateTemplate().get(this.persistentClass, id);
    }

    public List<T> getAll() {
        return this.findByHql(this.basicHql());
    }
}

