/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.monitortempdir;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.File;
import java.net.URL;
import java.util.Optional;

public class TempFileMonitor {
    private static final Long MAX_EXPIRATION_TIME = 0x6DDD00L;
    private static final Long SLEEP_TIME = 60000L;
    private Log log = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);

    public void initTask() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                TempFileMonitor.this.loopMonitor();
            }
        };
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                TempFileMonitor.this.log.error((Object)"loopMonitor uncaughtException");
            }
        });
        thread.start();
    }

    private void loopMonitor() {
        String basePath = this.getWebRootPath().get();
        while (true) {
            try {
                while (true) {
                    this.readFilesAndDelExperience(new File(basePath + "export"));
                    this.readFilesAndDelExperience(new File(basePath + "import"));
                    this.readFilesAndDelExperience(new File(basePath + "iReport" + File.separator + "temp"));
                    Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread t, Throwable e) {
                            TempFileMonitor.this.log.error((Object)"loopMonitor uncaughtException");
                        }
                    });
                    Thread.currentThread();
                    Thread.sleep(SLEEP_TIME);
                }
            }
            catch (InterruptedException e) {
                this.log.error((Object)"loopMonitor InterruptedException");
                continue;
            }
            break;
        }
    }

    private void readFilesAndDelExperience(File dir) {
        if (null == dir || !dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        if (null != files) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.readFilesAndDelExperience(file);
                    continue;
                }
                this.checkAndDelFile(file);
            }
        }
        if (!(dir.getAbsolutePath().endsWith("temp") || dir.getAbsolutePath().endsWith("import") || dir.getAbsolutePath().endsWith("export"))) {
            this.checkAndDelFile(dir);
        }
    }

    private void checkAndDelFile(File file) {
        Long currrentTime = System.currentTimeMillis();
        if (currrentTime - file.lastModified() > MAX_EXPIRATION_TIME && !file.delete()) {
            this.log.warn((Object)("the file delete failed: " + file.getName()));
        }
    }

    private Optional<String> getWebRootPath() {
        URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        if (url == null) {
            return Optional.empty();
        }
        String strUrl = url.getPath().endsWith("jar") ? url.getPath().substring(0, url.getPath().indexOf("lib")) : url.getPath().substring(0, url.getPath().indexOf("classes"));
        strUrl = url.getPath().substring(1, url.getPath().indexOf("WEB-INF"));
        return Optional.of(strUrl);
    }
}

