/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalInt;
import org.apache.commons.collections.CollectionUtils;

public final class DeviceCmdMessageManager {
    private static final Map<String, Integer> CMD_MESSAGE_MAP = new LinkedHashMap<String, Integer>(16);
    private static final Map<Integer, List<String>> CMD_MESSAGE_AND_MAP = new LinkedHashMap<Integer, List<String>>(4);
    private static final Map<String, Integer> CMD_MESSAGE_LAST_MAP = new LinkedHashMap<String, Integer>(2);
    private static final int DEFAULT_ERROR_CODE = Integer.MAX_VALUE;

    public static Integer getErrorCode(String errorMessage) {
        if (null == errorMessage) {
            return 571806;
        }
        String cmdResultLowcase = errorMessage.toLowerCase(Locale.ENGLISH);
        return DeviceCmdMessageManager.getErrorCodeFromMap(cmdResultLowcase, 1);
    }

    public static Integer getErrorCode(List<String> cmdResult) {
        if (CollectionUtils.isEmpty(cmdResult)) {
            return 571806;
        }
        for (String errorMessage : cmdResult) {
            String cmdResultLowcase = errorMessage.toLowerCase(Locale.ENGLISH);
            Integer errorCode = DeviceCmdMessageManager.getErrorCodeFromMap(cmdResultLowcase, Integer.MAX_VALUE);
            if (Integer.MAX_VALUE == errorCode) continue;
            return errorCode;
        }
        return 1;
    }

    private DeviceCmdMessageManager() {
    }

    private static void put2Map(Integer errorCode, String message, Map<Integer, List<String>> messageMap) {
        if (CollectionUtils.isEmpty((Collection)messageMap.get(errorCode))) {
            ArrayList<String> messageList = new ArrayList<String>();
            messageList.add(message);
            messageMap.put(errorCode, messageList);
        } else {
            messageMap.get(errorCode).add(message);
        }
    }

    private static Integer getErrorCodeFromMap(String cmdResultLowcase, Integer defaultErrorCode) {
        Integer errorCode = DeviceCmdMessageManager.getErrorcodeFromMapByErrorMessage(cmdResultLowcase, CMD_MESSAGE_MAP).orElse(DeviceCmdMessageManager.getErrorcodeFromAndMapByErrorMessage(cmdResultLowcase, CMD_MESSAGE_AND_MAP).orElse(DeviceCmdMessageManager.getErrorcodeFromMapByErrorMessage(cmdResultLowcase, CMD_MESSAGE_LAST_MAP).orElse(defaultErrorCode)));
        return errorCode;
    }

    private static OptionalInt getErrorcodeFromMapByErrorMessage(String errorMessage, Map<String, Integer> messageOrMap) {
        for (Map.Entry<String, Integer> entry : messageOrMap.entrySet()) {
            String message = entry.getKey();
            if (!errorMessage.contains(message.toLowerCase(Locale.ENGLISH))) continue;
            return OptionalInt.of(entry.getValue());
        }
        return OptionalInt.empty();
    }

    private static OptionalInt getErrorcodeFromAndMapByErrorMessage(String errorMessage, Map<Integer, List<String>> messageAndMap) {
        for (Map.Entry<Integer, List<String>> entry : messageAndMap.entrySet()) {
            List<String> messages = entry.getValue();
            boolean flag = DeviceCmdMessageManager.isFlag(errorMessage, messages);
            if (!flag) continue;
            return OptionalInt.of(entry.getKey());
        }
        return OptionalInt.empty();
    }

    private static boolean isFlag(String errorMessage, List<String> messages) {
        boolean flag = false;
        for (String message : messages) {
            if (errorMessage.contains(message.toLowerCase(Locale.ENGLISH))) {
                flag = true;
                continue;
            }
            flag = false;
            break;
        }
        return flag;
    }

    static {
        CMD_MESSAGE_MAP.put("Error: Invalid IP address", 571208);
        CMD_MESSAGE_MAP.put("Error: The number of IP addresses of traffic diversion reaches limit already, no more IP addresses can be added to the device", 571209);
        CMD_MESSAGE_MAP.put("Error: Please specify IP address of next hop first", 571210);
        CMD_MESSAGE_MAP.put("Error: Traffic IP addresses conflict", 571211);
        CMD_MESSAGE_MAP.put("The route already exists.", 571801);
        CMD_MESSAGE_MAP.put("The specified route does not exist.", 571802);
        CMD_MESSAGE_MAP.put("Error: The route does not exist.", 571802);
        CMD_MESSAGE_MAP.put("Error: The IP address does not exist", 1);
        CMD_MESSAGE_MAP.put("Error: This specified item does not exist", 572219);
        CMD_MESSAGE_MAP.put("Error: The specified item has already existed.", 572220);
        CMD_MESSAGE_MAP.put("Error: The number of configured items has reached the upper limit.", 572221);
        CMD_MESSAGE_MAP.put("The destination address is invalid.", 571814);
        CMD_MESSAGE_MAP.put("The destination address cannot be a multicast address.", 571814);
        CMD_MESSAGE_MAP.put("The dynamic NP rule number has reached the upper limit", 571818);
        CMD_MESSAGE_MAP.put("Error: The number of NP dynamic rule exceeds the maximum.", 571818);
        CMD_MESSAGE_MAP.put("Info: The system is busy in collecting the current configuration. Please wait...", 571217);
        CMD_MESSAGE_MAP.put("The system is busy in saving or comparing the current configuration. Please wait...", 571217);
        CMD_MESSAGE_MAP.put("Info: The configuration is being recovering, please wait.", 600001);
        DeviceCmdMessageManager.put2Map(571817, "anti-ddos np-rule defend destination-ip", CMD_MESSAGE_AND_MAP);
        DeviceCmdMessageManager.put2Map(571817, "Error: Unrecognized command found at", CMD_MESSAGE_AND_MAP);
        CMD_MESSAGE_LAST_MAP.put("Error:", 571813);
    }
}

