/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import twaver.Utils;

public final class AlarmSeverity {
    public static final Comparator<Object> ASCENDING_FUNCTION = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            AlarmSeverity severity1 = (AlarmSeverity)o1;
            AlarmSeverity severity2 = (AlarmSeverity)o2;
            if (severity1 != null && severity2 != null) {
                return severity1.getValue() - severity2.getValue();
            }
            if (severity1 != null && severity2 == null) {
                return 1;
            }
            if (severity1 == null && severity2 != null) {
                return -1;
            }
            return 0;
        }
    };
    public static final Comparator<Object> DESCENDING_FUNCTION = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            AlarmSeverity severity1 = (AlarmSeverity)o1;
            AlarmSeverity severity2 = (AlarmSeverity)o2;
            if (severity1 != null && severity2 != null) {
                return severity2.getValue() - severity1.getValue();
            }
            if (severity1 != null && severity2 == null) {
                return 1;
            }
            if (severity1 == null && severity2 != null) {
                return -1;
            }
            return 0;
        }
    };
    public static final AlarmSeverity CRITICAL = AlarmSeverity.register(500, "Critical", "C", new Color(255, 0, 0), null);
    public static final AlarmSeverity MAJOR = AlarmSeverity.register(400, "Major", "M", new Color(255, 160, 0), null);
    public static final AlarmSeverity MINOR = AlarmSeverity.register(300, "Minor", "m", new Color(255, 255, 0), null);
    public static final AlarmSeverity WARNING = AlarmSeverity.register(200, "Warning", "W", new Color(0, 255, 255), null);
    public static final AlarmSeverity INDETERMINATE = AlarmSeverity.register(100, "Indeterminate", "N", new Color(200, 0, 255), null);
    public static final AlarmSeverity CLEARED;
    private static AlarmSeverity clearedAlarmSeverity;
    private static Map<String, AlarmSeverity> nameMap;
    private static Map<Integer, AlarmSeverity> valueMap;
    private static List<AlarmSeverity> severities;
    private static Comparator<Object> compareFunction;
    private final int value;
    private final String name;
    private Color color;
    private String nickName;
    private String displayName;

    private AlarmSeverity(int value, String name, String nickName, Color color, String displayName) {
        if (name == null) {
            throw new NullPointerException("Name");
        }
        if (nickName == null) {
            throw new NullPointerException("NickName");
        }
        this.value = value;
        this.name = name;
        this.nickName = nickName;
        this.color = color;
        this.displayName = displayName;
    }

    public static AlarmSeverity register(int value, String name, String nickName, Color color, String displayName) {
        if (valueMap.containsKey(Utils.valueOf(value))) {
            throw new IllegalArgumentException("AlarmSeverity with value '" + value + "' already exist");
        }
        if (nameMap.containsKey(name)) {
            throw new IllegalArgumentException("AlarmSeverity with name '" + name + "' already exist");
        }
        AlarmSeverity severity = new AlarmSeverity(value, name, nickName, color, displayName);
        valueMap.put(Utils.valueOf(value), severity);
        nameMap.put(name, severity);
        severities.add(severity);
        Collections.sort(severities, compareFunction);
        return severity;
    }

    public static AlarmSeverity unregister(String name) {
        if (!nameMap.containsKey(name)) {
            throw new IllegalArgumentException("AlarmSeverity with name '" + name + "' doesen't exist");
        }
        AlarmSeverity severity = nameMap.get(name);
        nameMap.remove(name);
        valueMap.remove(Utils.valueOf(severity.getValue()));
        severities.remove(severity);
        return severity;
    }

    public static boolean isClearedAlarmSeverity(AlarmSeverity severity) {
        if (severity == null || clearedAlarmSeverity == null) {
            return false;
        }
        return clearedAlarmSeverity.getValue() == severity.getValue();
    }

    public static AlarmSeverity getClearedAlarmSeverity() {
        return clearedAlarmSeverity;
    }

    public static void setClearedAlarmSeverity(AlarmSeverity newValue) {
        clearedAlarmSeverity = newValue;
    }

    public static Comparator<Object> getCompareFunction() {
        return compareFunction;
    }

    public static void setCompareFunction(Comparator<Object> newValue) {
        if (newValue == null) {
            throw new NullPointerException("compareFunction");
        }
        compareFunction = newValue;
        Collections.sort(severities, compareFunction);
    }

    public static int compare(AlarmSeverity severity1, AlarmSeverity severity2) {
        return compareFunction.compare(severity1, severity2);
    }

    public static List<AlarmSeverity> getSeverities() {
        return severities;
    }

    public static AlarmSeverity getByName(String name) {
        return nameMap.get(name);
    }

    public static AlarmSeverity getByValue(int value) {
        return valueMap.get(Utils.valueOf(value));
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String toString() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.nickName;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof AlarmSeverity) {
            return ((AlarmSeverity)object).getValue() == this.value;
        }
        return false;
    }

    public static void clear() {
        nameMap.clear();
        valueMap.clear();
        severities.clear();
    }

    public static int count() {
        return severities.size();
    }

    static {
        clearedAlarmSeverity = CLEARED = AlarmSeverity.register(0, "Cleared", "R", new Color(0, 255, 0), null);
        nameMap = new HashMap<String, AlarmSeverity>();
        valueMap = new HashMap<Integer, AlarmSeverity>();
        severities = new ArrayList<AlarmSeverity>();
        compareFunction = ASCENDING_FUNCTION;
    }
}

