/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import twaver.IData;
import twaver.Utils;
import twaver.XMLSerializer;

public class Data
implements IData {
    private Object id;
    private String name;
    private String icon = "node_icon";
    private String toolTip;
    private IData parent;
    private Map<String, Object> clientMap;
    private List<IData> childrenList = new ArrayList<IData>();
    private Map<Object, IData> childrenMap = new HashMap<Object, IData>();
    private boolean isAdjustingParent = false;

    public Data() {
        this(null);
    }

    public Data(Object id) {
        this.id = id == null ? Utils.getIdentifier(this) : id;
    }

    @Override
    public Object getID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.dispatchPropertyChangeEvent("name", oldValue, name);
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(String icon) {
        String oldValue = this.icon;
        this.icon = icon;
        this.dispatchPropertyChangeEvent("icon", oldValue, icon);
    }

    @Override
    public String getToolTip() {
        return this.toolTip;
    }

    @Override
    public void setToolTip(String toolTip) {
        String oldValue = this.toolTip;
        this.toolTip = toolTip;
        this.dispatchPropertyChangeEvent("toolTip", oldValue, toolTip);
    }

    @Override
    public IData getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IData newParent) {
        if (this.isAdjustingParent || this.parent == newParent || this == newParent) {
            return;
        }
        if (newParent != null && newParent.isDescendantOf(this)) {
            return;
        }
        IData oldValue = this.parent;
        this.parent = newParent;
        this.isAdjustingParent = true;
        if (oldValue != null) {
            oldValue.removeChild(this);
        }
        if (newParent != null) {
            newParent.addChild(this);
        }
        this.isAdjustingParent = false;
        this.dispatchPropertyChangeEvent("parent", oldValue, newParent);
    }

    @Override
    public boolean addChild(IData child) {
        return this.addChild(child, this.childrenList.size());
    }

    @Override
    public boolean addChild(IData child, int index) {
        if (child == null || child == this) {
            return false;
        }
        if (this.childrenMap.containsKey(child.getID())) {
            return false;
        }
        if (this.isDescendantOf(child)) {
            return false;
        }
        if (child.getParent() != null) {
            child.getParent().removeChild(child);
        }
        if (index < 0 || index > this.childrenList.size()) {
            index = this.childrenList.size();
        }
        this.childrenList.add(index, child);
        this.childrenMap.put(child.getID(), child);
        child.setParent(this);
        this.dispatchPropertyChangeEvent("children", null, child);
        this.onChildAdded(child, index);
        return true;
    }

    protected void onChildAdded(IData child, int index) {
    }

    @Override
    public boolean removeChild(IData child) {
        if (child == null) {
            return false;
        }
        if (!this.childrenMap.containsKey(child.getID())) {
            return false;
        }
        int index = this.childrenList.indexOf(child);
        this.childrenList.remove(child);
        this.childrenMap.remove(child.getID());
        child.setParent(null);
        this.dispatchPropertyChangeEvent("children", child, null);
        this.onChildRemoved(child, index);
        return true;
    }

    protected void onChildRemoved(IData child, int index) {
    }

    @Override
    public boolean clearChildren() {
        if (this.childrenList.isEmpty()) {
            return false;
        }
        List<IData> list = this.toChildren();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            this.removeChild(list.get(i));
        }
        return true;
    }

    @Override
    public IData getChildAt(int index) {
        return this.childrenList.get(index);
    }

    @Override
    public List<IData> getChildren() {
        return this.childrenList;
    }

    @Override
    public List<IData> toChildren() {
        return new ArrayList<IData>(this.childrenList);
    }

    @Override
    public int getChildrenCount() {
        return this.childrenList.size();
    }

    @Override
    public boolean hasChildren() {
        return this.childrenList.size() > 0;
    }

    @Override
    public boolean isDescendantOf(IData data) {
        if (data == null) {
            return false;
        }
        if (!data.hasChildren()) {
            return false;
        }
        for (IData tempParent = this.parent; tempParent != null; tempParent = tempParent.getParent()) {
            if (data != tempParent) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isParentOf(IData data) {
        if (data == null) {
            return false;
        }
        return this == data.getParent();
    }

    @Override
    public boolean isRelatedTo(IData data) {
        if (data == null) {
            return false;
        }
        return this.isDescendantOf(data) || data.isDescendantOf(this);
    }

    public void setClient(String clientProp, int newValue) {
        this.setClient(clientProp, (Object)newValue);
    }

    public void setClient(String clientProp, double newValue) {
        this.setClient(clientProp, (Object)newValue);
    }

    public void setClient(String clientProp, boolean newValue) {
        this.setClient(clientProp, (Object)newValue);
    }

    @Override
    public void setClient(String clientProp, Object newValue) {
        if (clientProp == null) {
            throw new NullPointerException("clientProp");
        }
        if (this.clientMap == null) {
            this.clientMap = new HashMap<String, Object>();
        }
        Object oldValue = this.clientMap.get(clientProp);
        if (newValue == null) {
            this.clientMap.remove(clientProp);
        } else {
            this.clientMap.put(clientProp, newValue);
        }
        this.dispatchPropertyChangeEvent("C:" + clientProp, oldValue, newValue);
    }

    @Override
    public Object getClient(String clientProp) {
        if (this.clientMap == null) {
            return null;
        }
        return this.clientMap.get(clientProp);
    }

    public Map<String, Object> getClientProperties() {
        return this.clientMap;
    }

    protected void onPropertyChanged(String property, Object oldValue, Object newValue) {
    }

    @Override
    public boolean dispatchPropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (null == oldValue && null == newValue) {
            return false;
        }
        if (oldValue == newValue) {
            return false;
        }
        this.onPropertyChanged(propertyName, oldValue, newValue);
        return true;
    }

    public boolean dispatchPropertyChangeEvent(String propertyName, boolean oldValue, boolean newValue) {
        return this.dispatchPropertyChangeEvent(propertyName, (Object)oldValue, (Object)newValue);
    }

    public boolean dispatchPropertyChangeEvent(String propertyName, double oldValue, double newValue) {
        return this.dispatchPropertyChangeEvent(propertyName, (Object)oldValue, (Object)newValue);
    }

    @Override
    public void serializeXML(XMLSerializer serializer, IData newInstance) {
        if (this.clientMap != null) {
            for (Map.Entry<String, Object> entry : this.clientMap.entrySet()) {
                this.serializeClient(serializer, entry.getKey().toString(), newInstance);
            }
        }
        this.serializeProperty(serializer, "name", newInstance);
        this.serializeProperty(serializer, "icon", newInstance);
        this.serializeProperty(serializer, "toolTip", newInstance);
        this.serializeProperty(serializer, "parent", newInstance);
    }

    protected void serializeProperty(XMLSerializer serializer, String property, IData newInstance) {
        serializer.serializeProperty(this, property, newInstance);
    }

    protected void serializeClient(XMLSerializer serializer, String clientPrope, IData newInstance) {
        serializer.serializeClient(this, clientPrope, newInstance);
    }

    @Override
    public void deserializeXML(XMLSerializer serializer, String prefix, String prop, Node pNode) {
        if (prefix.equals("p")) {
            this.deserializeProperty(serializer, prop, pNode);
        } else {
            if (!prefix.equals("c")) {
                return;
            }
            this.deserializeClient(serializer, prop, pNode);
        }
    }

    protected void deserializeClient(XMLSerializer serializer, String prop, Node pNode) {
        serializer.deserializeClient(this, prop, pNode);
    }

    protected void deserializeProperty(XMLSerializer serializer, String prop, Node pNode) {
        serializer.deserializeProperty(this, prop, pNode);
    }
}

