/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.geom.Rectangle2D;
import java.util.List;
import twaver.Follower;
import twaver.Utils;

public class Grid
extends Follower {
    public Grid() {
        this(null);
    }

    public Grid(Object id) {
        super(id);
        this.setIcon("grid_icon");
        this.setImage(null);
        this.setStyle("image.stretch", "fill");
    }

    public Rectangle2D getCellRect(int rowIndex, int columnIndex) {
        int rowCount = (int)Double.parseDouble("" + this.getStyle("grid.row.count"));
        int columnCount = (int)Double.parseDouble("" + this.getStyle("grid.column.count"));
        if (rowCount <= 0 || columnCount <= 0) {
            return null;
        }
        if (rowIndex < 0 || rowIndex >= rowCount) {
            return null;
        }
        if (columnIndex < 0 || columnIndex >= columnCount) {
            return null;
        }
        Rectangle2D rect = this.getRect();
        Utils.addPadding(rect, this, "grid.border");
        int index = 0;
        List rows = (List)this.getStyle("grid.row.percents");
        List columns = (List)this.getStyle("grid.column.percents");
        if (rows != null && rows.size() == rowCount) {
            double h = 0.0;
            for (index = 0; index < rowIndex; ++index) {
                h += rect.getHeight() * Double.parseDouble("" + rows.get(index));
            }
            rect.setRect(rect.getX(), rect.getY() + h, rect.getWidth(), rect.getHeight() * Double.parseDouble("" + rows.get(rowIndex)));
        } else {
            double nh = rect.getHeight() / (double)rowCount;
            double ny = rect.getY() + nh * (double)rowIndex;
            rect.setRect(rect.getX(), ny, rect.getWidth(), nh);
        }
        if (columns != null && columns.size() == columnCount) {
            double w = 0.0;
            for (index = 0; index < columnIndex; ++index) {
                w += rect.getWidth() * Double.parseDouble("" + columns.get(index));
            }
            rect.setRect(rect.getX() + w, rect.getY(), rect.getWidth() * Double.parseDouble("" + columns.get(columnIndex)), rect.getHeight());
        } else {
            double nw = rect.getWidth() / (double)columnCount;
            double nx = rect.getX() + nw * (double)columnIndex;
            rect.setRect(nx, rect.getY(), nw, rect.getHeight());
        }
        Utils.addPadding(rect, this, "grid.padding");
        return rect;
    }
}

