/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.util.List;
import twaver.DataBox;
import twaver.Defaults;
import twaver.ElementBox;
import twaver.IData;
import twaver.IElement;
import twaver.ILayer;
import twaver.Layer;

public class LayerBox
extends DataBox {
    private final ElementBox elementBox;
    private final ILayer defaultLayer;

    LayerBox(ElementBox elementBox) {
        this.elementBox = elementBox;
        this.defaultLayer = new Layer(Defaults.LAYER_DEFAULT_ID, "default");
        this.add(this.defaultLayer);
    }

    public ElementBox getElementBox() {
        return this.elementBox;
    }

    public ILayer getDefaultLayer() {
        return this.defaultLayer;
    }

    @Override
    public void add(IData data, int index) {
        if (!(data instanceof ILayer)) {
            throw new IllegalArgumentException("Only ILayer can be added into LayerBox");
        }
        super.add(data, index);
    }

    @Override
    public void removeByID(Object id) {
        if (id == this.defaultLayer.getID()) {
            throw new IllegalArgumentException("Can not remove default layer");
        }
        super.removeByID(id);
    }

    public ILayer getLayerByID(Object layerID) {
        IData obj = this.getDataByID(layerID);
        if (obj != null && obj instanceof ILayer) {
            return (ILayer)obj;
        }
        return null;
    }

    public ILayer getLayerByElement(IElement element) {
        if (element == null) {
            return null;
        }
        ILayer layer = (ILayer)this.getDataByID(element.getLayerID());
        if (layer == null) {
            return this.defaultLayer;
        }
        return layer;
    }

    @Override
    public void clear() {
        List<IData> layers = this.toDatas();
        int size = layers.size();
        for (int i = 0; i < size; ++i) {
            ILayer layer = (ILayer)layers.get(i);
            if (layer == this.defaultLayer) continue;
            this.removeByID(layer.getID());
        }
    }
}

