/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import twaver.Follower;
import twaver.IData;
import twaver.Utils;
import twaver.XMLSerializer;

public class ShapeNode
extends Follower {
    protected List<Point2D> points = new ArrayList<Point2D>();
    private boolean isAdjusting = false;
    private List<?> segments = null;

    public ShapeNode() {
        this(null);
    }

    public ShapeNode(Object id) {
        super(id);
        this.setIcon("shapenode_icon");
        this.setStyle("vector.fill", Boolean.FALSE);
        this.setStyle("vector.outline.width", 5);
    }

    public List<Point2D> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point2D> shapeValue) {
        if (this.points == shapeValue) {
            return;
        }
        if (shapeValue == null) {
            shapeValue = new ArrayList<Point2D>();
        }
        this.points = shapeValue;
        this.dispatchPointsChangeEvent();
    }

    public void addPoint(Point2D shapePoint) {
        this.points.add(shapePoint);
        this.dispatchPointsChangeEvent();
    }

    public void addPointAt(Point2D point2d, int index) {
        this.points.add(index, point2d);
        this.dispatchPointsChangeEvent();
    }

    public void setPointAt(Point2D point2d, int index) {
        this.points.set(index, point2d);
        this.dispatchPointsChangeEvent();
    }

    public void removePoint(Point2D point2d) {
        if (this.points.remove(point2d)) {
            this.dispatchPointsChangeEvent();
        }
    }

    public void removePointAt(int pointIndex) {
        this.points.remove(pointIndex);
        this.dispatchPointsChangeEvent();
    }

    @Override
    public void setWidth(double value) {
        if (value < 0.0) {
            return;
        }
        if (!this.isAdjusting && !Utils.isDeserializingXML() && this.getWidth() != 0.0) {
            this.isAdjusting = true;
            int size = this.points.size();
            for (int i = 0; i < size; ++i) {
                Point2D point = this.points.get(i);
                double x = (point.getX() - this.getX()) * value / this.getWidth() + this.getX();
                point.setLocation(x, point.getY());
            }
            this.dispatchPointsChangeEvent();
            this.isAdjusting = false;
        }
        super.setWidth(value);
    }

    @Override
    public void setHeight(double value) {
        if (value < 0.0) {
            return;
        }
        if (!this.isAdjusting && !Utils.isDeserializingXML() && this.getHeight() != 0.0) {
            this.isAdjusting = true;
            int size = this.points.size();
            for (int i = 0; i < size; ++i) {
                Point2D point = this.points.get(i);
                double y = (point.getY() - this.getY()) * value / this.getHeight() + this.getY();
                point.setLocation(point.getX(), y);
            }
            this.dispatchPointsChangeEvent();
            this.isAdjusting = false;
        }
        super.setHeight(value);
    }

    @Override
    public void setLocation(Point2D value) {
        if (!this.isAdjusting && !Utils.isDeserializingXML()) {
            double xoffset = value.getX() - this.getX();
            double yoffset = value.getY() - this.getY();
            if (xoffset == 0.0 && yoffset == 0.0) {
                return;
            }
            this.isAdjusting = true;
            int size = this.points.size();
            for (int i = 0; i < size; ++i) {
                Point2D point = this.points.get(i);
                point.setLocation(point.getX() + xoffset, point.getY() + yoffset);
            }
            this.dispatchPointsChangeEvent();
            this.isAdjusting = false;
        }
        super.setLocation(value);
    }

    public void dispatchPointsChangeEvent() {
        Rectangle2D rect;
        if (!this.isAdjusting && !Utils.isDeserializingXML() && (rect = Utils.getRect(this.points)) != null) {
            this.isAdjusting = true;
            this.setLocation(rect.getX(), rect.getY());
            this.setWidth(rect.getWidth());
            this.setHeight(rect.getHeight());
            this.isAdjusting = false;
        }
        this.dispatchPropertyChangeEvent("points", null, this.points);
    }

    public List<?> getSegments() {
        return this.segments;
    }

    public void setSegments(List<?> value) {
        List<?> oldValue = this.segments;
        this.segments = value;
        this.dispatchPropertyChangeEvent("segments", oldValue, value);
    }

    @Override
    public void serializeXML(XMLSerializer serializer, IData newInstance) {
        super.serializeXML(serializer, newInstance);
        this.serializeProperty(serializer, "points", newInstance);
        this.serializeProperty(serializer, "segments", newInstance);
    }
}

