/*
 * Decompiled with CFR 0.152.
 */
package twaver;

import com.hs.atic.util.XmlUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import twaver.ClassGenerator;
import twaver.Data;
import twaver.DataBox;
import twaver.IClient;
import twaver.IData;
import twaver.IStyle;
import twaver.ReflectUtils;
import twaver.SerializationSettings;
import twaver.Utils;

public class XMLSerializer {
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private DataBox dataBox;
    private SerializationSettings settings;
    private Map refMap = Collections.synchronizedMap(new HashMap());
    private StringBuffer xmlString = new StringBuffer();
    private ClassGenerator classGenerator = Utils.CLASSGENERATOR;
    private boolean isCommon = false;
    private int ref = 0;
    private Map domMap = Collections.synchronizedMap(new HashMap());
    private Log log = LogFactory.getInstance((Module)Module.ATIC_CORE_BASE);

    public XMLSerializer(DataBox dataBox) {
        this(dataBox, null);
    }

    public XMLSerializer(DataBox dataBox, SerializationSettings settings) {
        this.dataBox = dataBox;
        this.settings = new SerializationSettings();
    }

    public ClassGenerator getClassGenerator() {
        return this.classGenerator;
    }

    public void setClassGenerator(ClassGenerator generator) {
        this.classGenerator = generator;
    }

    public SerializationSettings getSettings() {
        return this.settings;
    }

    public String serialize() {
        this.xmlString = new StringBuffer();
        this.xmlString.append("<twaver v='" + Utils.getVersion() + "' p='flex'>\n");
        this.serializeBody();
        this.xmlString.append("</twaver>\n");
        return this.xmlString.toString();
    }

    public String serializeCommon() {
        this.isCommon = true;
        this.xmlString = new StringBuffer();
        this.xmlString.append("<topodata v='" + Utils.getVersion() + "' p='flex'>\n");
        this.serializeCommonBody();
        this.xmlString.append("</topodata>\n");
        this.isCommon = false;
        return this.xmlString.toString();
    }

    protected void serializeBody() {
        this.ref = 0;
        List<IData> roots = this.dataBox.getRoots();
        int size = roots.size();
        for (int i = 0; i < size; ++i) {
            this.initRefs(roots.get(i));
        }
        String className = this.getClassGenerator().generate(this.dataBox.getClass());
        this.xmlString.append("<dataBox type='" + className + "'>\n");
        DataBox newBox = null;
        try {
            newBox = (DataBox)this.dataBox.getClass().newInstance();
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        this.dataBox.serializeXML(this, newBox);
        this.xmlString.append("</dataBox>\n");
        int count = roots.size();
        for (int i = 0; i < count; ++i) {
            IData data = roots.get(i);
            if (!this.isSerialize(data)) continue;
            this.serializeData(data);
        }
    }

    protected void serializeCommonBody() {
        this.ref = 0;
        List<IData> roots = this.dataBox.getRoots();
        int size = roots.size();
        for (int i = 0; i < size; ++i) {
            this.initRefs(roots.get(i));
        }
        DataBox newBox = null;
        try {
            newBox = (DataBox)this.dataBox.getClass().newInstance();
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        this.dataBox.serializeCommonXML(this, newBox);
        int count = roots.size();
        for (int i = 0; i < count; ++i) {
            IData data = roots.get(i);
            if (!this.isSerialize(data)) continue;
            this.serializeCommonData(data);
        }
    }

    private void initRefs(IData data) {
        if (!this.isSerialize(data)) {
            return;
        }
        this.refMap.put(data, this.ref++);
        int size = data.getChildrenCount();
        for (int i = 0; i < size; ++i) {
            this.initRefs(data.getChildAt(i));
        }
    }

    protected boolean isSerialize(IData data) {
        return this.dataBox.contains(data);
    }

    protected void serializeData(IData data) {
        IData newInstance = null;
        try {
            newInstance = (IData)data.getClass().newInstance();
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        String ref0 = String.valueOf(this.refMap.get(data));
        String className = this.classGenerator.generate(data.getClass());
        this.xmlString.append("<data type='" + className + "' ref='" + ref0 + "'");
        if (this.settings.getPropertyType("id") != null) {
            this.xmlString.append(" id='" + data.getID() + "'");
        }
        this.xmlString.append(">\n");
        data.serializeXML(this, newInstance);
        this.xmlString.append("</data>\n");
        int size = data.getChildrenCount();
        for (int i = 0; i < size; ++i) {
            IData child = data.getChildAt(i);
            this.serializeData(child);
        }
    }

    protected void serializeCommonData(IData commonData) {
        IData newInstance = null;
        try {
            newInstance = (IData)commonData.getClass().newInstance();
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
        String ref0 = String.valueOf(this.refMap.get(commonData));
        String className = commonData.getClass().getSimpleName();
        this.xmlString.append("<data type='" + className + "' ref='" + ref0 + "'");
        if (this.settings.getPropertyType("id") != null) {
            this.xmlString.append(" id='" + commonData.getID() + "'");
        }
        this.xmlString.append(">\n");
        commonData.serializeXML(this, newInstance);
        this.xmlString.append("</data>\n");
        int size = commonData.getChildrenCount();
        for (int i = 0; i < size; ++i) {
            IData child = commonData.getChildAt(i);
            this.serializeCommonData(child);
        }
    }

    public void serializeProperty(Object instance, String property, Object newInstance) {
        Object newInstanceValue;
        Object value;
        String type = this.settings.getPropertyType(property);
        if (type != null && (value = ReflectUtils.getObject(instance, property)) != (newInstanceValue = ReflectUtils.getObject(newInstance, property))) {
            this.serializeValue("p", property, value, newInstanceValue, type, this.settings.isPropertyCdata(property));
        }
    }

    public void serializeStyle(IStyle instance, String style, IStyle newInstance) {
        Object newInstanceValue;
        Object value;
        String type = this.settings.getStyleType(style);
        if (type != null && (value = instance.getStyle(style)) != (newInstanceValue = newInstance.getStyle(style))) {
            this.serializeValue("s", style, value, newInstanceValue, type, this.settings.isStyleCdata(style));
        }
    }

    public void serializeClient(IClient instance, String client, IClient newInstance) {
        Object newInstanceValue;
        Object value;
        String type = this.settings.getClientType(client);
        if (type != null && (value = instance.getClient(client)) != (newInstanceValue = newInstance.getClient(client))) {
            this.serializeValue("c", client, value, newInstanceValue, type, this.settings.isClientCdata(client));
        }
    }

    public void serializeValue(String c, String property, Object value, Object newInstanceValue, String type, boolean cdata) {
        if (value == null) {
            this.xmlString.append("\t<" + c + " n='" + property + "' none=''/>\n");
        } else if (cdata) {
            this.xmlString.append("\t<" + c + " n='" + property + "'><![CDATA[" + value + "]]></" + c + ">\n");
        } else if ("data".equals(type)) {
            Object dataRef = this.refMap.get(value);
            if (dataRef != null) {
                this.xmlString.append("\t<" + c + " n='" + property + "' ref='" + dataRef + "'/>\n");
            }
        } else if ("point".equals(type)) {
            Point2D valueP = (Point2D)value;
            Point2D newInstanceValueP = (Point2D)newInstanceValue;
            if (!(newInstanceValue instanceof Point) || valueP.equals(newInstanceValueP)) {
                this.xmlString.append("\t<" + c + " n='" + property + "' x='" + valueP.getX() + "' y='" + valueP.getY() + "'/>\n");
            }
        } else if ("collection.point".equals(type)) {
            List points = (List)value;
            this.xmlString.append("\t<" + c + " n='" + property + "'>\n");
            for (int i = 0; i < points.size(); ++i) {
                Point2D point = (Point2D)points.get(i);
                this.xmlString.append("\t\t<p x='" + point.getX() + "' y='" + point.getY() + "'/>\n");
            }
            this.xmlString.append("\t</" + c + ">\n");
        } else if ("collection.string".equals(type)) {
            List ss = (List)value;
            this.xmlString.append("\t<" + c + " n='" + property + "'>\n");
            for (int i = 0; i < ss.size(); ++i) {
                this.xmlString.append("\t\t<s>" + ss.get(i) + "</s>\n");
            }
            this.xmlString.append("\t</" + c + ">\n");
        } else if ("rectangle".equals(type)) {
            Rectangle rect = (Rectangle)value;
            this.xmlString.append("\t<" + c + " n='" + property + "' x='" + rect.x + "' y='" + rect.y + "' w='" + rect.width + "' h='" + rect.height + "'/>\n");
        } else {
            StringBuffer text = new StringBuffer();
            if (value instanceof String[]) {
                if (this.isCommon) {
                    String[] t = (String[])value;
                    int len = t.length;
                    for (int i = 0; i < len; ++i) {
                        text.append("\t<i>" + t[i] + "</i>\n");
                    }
                    this.xmlString.append("\t<" + c + " n='" + property + "'>\n" + text + "</" + c + ">\n");
                } else {
                    String[] t = (String[])value;
                    int len = t.length;
                    for (int i = 0; i < len; ++i) {
                        if (i > 0) {
                            text.append("," + t[i]);
                            continue;
                        }
                        text.append(t[i]);
                    }
                    this.xmlString.append("\t<" + c + " n='" + property + "'>" + text + "</" + c + ">\n");
                }
            } else if (value instanceof int[]) {
                if (this.isCommon) {
                    int[] t = (int[])value;
                    int len = t.length;
                    for (int i = 0; i < len; ++i) {
                        text.append("\t<i>" + t[i] + "</i>\n");
                    }
                    this.xmlString.append("\t<" + c + " n='" + property + "'>\n" + text + "</" + c + ">\n");
                } else {
                    int[] t = (int[])value;
                    int len = t.length;
                    for (int i = 0; i < len; ++i) {
                        if (i > 0) {
                            text.append("," + t[i]);
                            continue;
                        }
                        text.append(t[i]);
                    }
                    this.xmlString.append("\t<" + c + " n='" + property + "'>" + text + "</" + c + ">\n");
                }
            } else if (value instanceof double[]) {
                if (this.isCommon) {
                    double[] t = (double[])value;
                    int len = t.length;
                    for (int i = 0; i < len; ++i) {
                        if (property.endsWith(".colors")) {
                            text.append("\t<i>" + this.getColor((int)t[i]) + "</i>\n");
                            continue;
                        }
                        text.append("\t<i>" + t[i] + "</i>\n");
                    }
                    this.xmlString.append("\t<" + c + " n='" + property + "'>\n" + text + "</" + c + ">\n");
                } else {
                    double[] t = (double[])value;
                    int len = t.length;
                    for (int i = 0; i < len; ++i) {
                        if (i > 0) {
                            text.append("," + t[i]);
                            continue;
                        }
                        text.append(t[i]);
                    }
                    this.xmlString.append("\t<" + c + " n='" + property + "'>" + text + "</" + c + ">\n");
                }
            } else if (this.isCommon && property.endsWith(".color")) {
                this.xmlString.append("\t<" + c + " n='" + property + "'>" + this.getColor(Integer.parseInt(value.toString())) + "</" + c + ">\n");
            } else if (value instanceof Color) {
                this.xmlString.append("\t<" + c + " n='" + property + "'>" + Utils.getColorHexString((Color)value, true) + "</" + c + ">\n");
            } else {
                this.xmlString.append("\t<" + c + " n='" + property + "'>" + value + "</" + c + ">\n");
            }
        }
    }

    public String getColor(int c) {
        String rgb = Integer.toHexString(c & 0xFFFFFF);
        String result = "#ff000000".substring(0, 9 - rgb.length()).concat(rgb);
        return result;
    }

    public void deserializeXML(String xml) {
        this.deserializeXML(xml, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserializeXML(String xml, IData rootParent) {
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            this.deserialize(inputStream, rootParent);
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)e.getMessage());
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"IOException error");
                }
            }
        }
    }

    public void deserialize(InputStream inputStream) {
        if (null != inputStream) {
            try {
                this.deserialize(inputStream, null);
                inputStream.close();
            }
            catch (IOException e) {
                this.log.error((Object)"IOException error");
            }
        }
    }

    public void deserialize(InputStream inputStream, IData rootParent) {
        Utils.setDeserializingXML(true);
        this.refMap.clear();
        this.domMap.clear();
        try {
            DocumentBuilder builder = XmlUtil.configureSecureInfoForDocumentBuilder(this.factory);
            Document doc = builder.parse(inputStream);
            this.deserializeDocument(doc, rootParent);
        }
        catch (SAXException e) {
            this.log.error((Object)e.getMessage());
        }
        catch (IOException e) {
            this.log.error((Object)"IOException error");
        }
        catch (ParserConfigurationException e) {
            this.log.error((Object)e.getMessage());
        }
        Utils.setDeserializingXML(false);
        if (null != inputStream) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                this.log.error((Object)"IOException error");
            }
        }
    }

    public void deserialize(String xmlUri) {
        this.deserialize(xmlUri, null);
    }

    public void deserialize(String xmlUri, IData rootParent) {
        Utils.setDeserializingXML(true);
        this.refMap.clear();
        this.domMap.clear();
        try {
            DocumentBuilder builder = XmlUtil.configureSecureInfoForDocumentBuilder(this.factory);
            Document doc = builder.parse(xmlUri);
            this.deserializeDocument(doc, rootParent);
        }
        catch (SAXException e) {
            this.log.error((Object)e.getMessage());
        }
        catch (IOException e) {
            this.log.error((Object)"IOException error");
        }
        catch (ParserConfigurationException e) {
            this.log.error((Object)e.getMessage());
        }
        Utils.setDeserializingXML(false);
    }

    private void deserializeDocument(Document doc, IData rootParent) {
        ArrayList dataList = new ArrayList();
        NodeList list = doc.getElementsByTagName("data");
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Node dataNode = list.item(i);
            if (dataNode.getNodeType() != 1) continue;
            this.deserializeDataToList(dataList, dataNode);
        }
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            Data data = (Data)dataList.get(i);
            Node domNode = (Node)this.domMap.get(data);
            this.deserializeData(data, domNode);
            this.dataBox.add(data);
        }
        list = doc.getElementsByTagName("dataBox");
        if (list.getLength() > 0) {
            Node boxNode = list.item(0);
            this.deserializeBox(boxNode);
        }
    }

    private void deserializeData(Data data, Node domNode) {
        NodeList list = domNode.getChildNodes();
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Node pNode = list.item(i);
            if (pNode.getNodeType() != 1) continue;
            String nodeName = pNode.getNodeName();
            NamedNodeMap pattributes = pNode.getAttributes();
            String pName = pattributes.getNamedItem("n").getNodeValue();
            data.deserializeXML(this, nodeName, pName, pNode);
        }
    }

    private void deserializeBox(Node domNode) {
        NodeList list = domNode.getChildNodes();
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Node pNode = list.item(i);
            if (pNode.getNodeType() != 1) continue;
            String nodeName = pNode.getNodeName();
            NamedNodeMap pattributes = pNode.getAttributes();
            Node namedItem = pattributes.getNamedItem("n");
            String pName = null;
            if (namedItem != null && namedItem.getNodeValue() != null) {
                pName = namedItem.getNodeValue();
            }
            this.dataBox.deserializeXML(this, nodeName, pName, pNode);
        }
    }

    private void deserializeDataToList(List list, Node domNode) {
        NamedNodeMap attributes = domNode.getAttributes();
        String clazz = attributes.getNamedItem("type").getNodeValue();
        Node refItem = attributes.getNamedItem("ref");
        String ref1 = null;
        if (refItem != null) {
            ref1 = refItem.getNodeValue();
        }
        Node actionItem = attributes.getNamedItem("action");
        String action = null;
        if (actionItem != null) {
            action = actionItem.getNodeValue();
        }
        Node idItem = attributes.getNamedItem("id");
        String idStr = null;
        if (idItem != null) {
            idStr = idItem.getNodeValue();
        }
        Data data = null;
        Class<?> newoneClass = this.classGenerator.generate(clazz);
        try {
            String idType = this.settings.getPropertyType("id");
            if (idType != null && idStr != null) {
                Object id = null;
                if ("string".equals(idType)) {
                    id = idStr;
                } else if ("number".equals(idType)) {
                    id = Double.valueOf(idStr);
                } else if ("int".equals(idType) || "uint".equals(idType)) {
                    id = Integer.valueOf(idStr);
                } else {
                    this.log.error((Object)("Unsupported id type '" + idType + "'"));
                }
                if (actionItem != null && "remove".equals(action)) {
                    this.dataBox.removeByID(idStr);
                }
                Class[] argsClass = new Class[]{Object.class};
                Constructor<?> cons = newoneClass.getConstructor(argsClass);
                data = (Data)cons.newInstance(id);
            } else {
                data = (Data)newoneClass.newInstance();
            }
            list.add(data);
            if (ref1 != null) {
                this.refMap.put(ref1, data);
            }
            this.domMap.put(data, domNode);
        }
        catch (InstantiationException e) {
            this.log.error((Object)e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)e.getMessage());
        }
        catch (NoSuchMethodException e) {
            this.log.error((Object)e.getMessage());
        }
        catch (InvocationTargetException e) {
            this.log.error((Object)e.getMessage());
        }
    }

    public void deserializeProperty(Object instance, String prop, Node pNode) {
        NamedNodeMap attributes = pNode.getAttributes();
        String pName = attributes.getNamedItem("n").getNodeValue();
        String propType = null;
        propType = this.settings.getPropertyType(pName);
        String text = null;
        NodeList childNodeList = pNode.getChildNodes();
        int len = 0;
        if (null != childNodeList) {
            len = childNodeList.getLength();
        }
        if (childNodeList != null && len > 0) {
            text = childNodeList.item(0).getNodeValue();
        }
        if (propType != null) {
            if (propType.equals("string")) {
                Method method = ReflectUtils.getWriteMethod(instance.getClass(), prop, String.class);
                ReflectUtils.writeValue(instance, method, prop, text);
            } else if (propType.equals("point")) {
                double x = Double.parseDouble(attributes.getNamedItem("x").getNodeValue());
                double y = Double.parseDouble(attributes.getNamedItem("y").getNodeValue());
                Point2D.Double point = new Point2D.Double(x, y);
                Method method = ReflectUtils.getWriteMethod(instance.getClass(), prop, Point2D.class);
                ReflectUtils.writeValue(instance, method, prop, point);
            } else if (propType.equals("boolean")) {
                Method method = ReflectUtils.getWriteMethod(instance.getClass(), prop, Boolean.TYPE);
                ReflectUtils.writeValue(instance, method, prop, Boolean.valueOf(text));
            } else if (propType.equals("number")) {
                Method method = ReflectUtils.getWriteMethod(instance.getClass(), prop, Double.TYPE);
                ReflectUtils.writeValue(instance, method, prop, Double.valueOf(text));
            } else if (propType.equals("int")) {
                Method method = ReflectUtils.getWriteMethod(instance.getClass(), prop, Integer.TYPE);
                ReflectUtils.writeValue(instance, method, prop, Integer.valueOf(text));
            } else if (propType.equals("uint")) {
                Method method = ReflectUtils.getWriteMethod(instance.getClass(), prop, Integer.TYPE);
                ReflectUtils.writeValue(instance, method, prop, Integer.valueOf(text));
            } else if (propType.equals("data")) {
                Node refItem = attributes.getNamedItem("ref");
                if (refItem != null) {
                    text = refItem.getNodeValue();
                }
                Method method = ReflectUtils.getWriteMethod(instance.getClass(), prop, this.refMap.get(text).getClass());
                ReflectUtils.writeValue(instance, method, prop, this.refMap.get(text));
            } else if (propType.equals("rectangle")) {
                double x = Double.parseDouble(attributes.getNamedItem("x").getNodeValue());
                double y = Double.parseDouble(attributes.getNamedItem("y").getNodeValue());
                double w = Double.parseDouble(attributes.getNamedItem("w").getNodeValue());
                double h = Double.parseDouble(attributes.getNamedItem("h").getNodeValue());
                Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h);
                Method method = ReflectUtils.getWriteMethod(instance.getClass(), prop, Rectangle2D.class);
                ReflectUtils.writeValue(instance, method, prop, rect);
            } else if (childNodeList != null && propType.equals("collection.point")) {
                ArrayList<Point2D.Double> list = new ArrayList<Point2D.Double>();
                for (int i = 0; i < len; ++i) {
                    Node pointNode = childNodeList.item(i);
                    if (pointNode.getNodeType() != 1) continue;
                    NamedNodeMap pointAtt = pointNode.getAttributes();
                    double x = Double.parseDouble(pointAtt.getNamedItem("x").getNodeValue());
                    double y = Double.parseDouble(pointAtt.getNamedItem("y").getNodeValue());
                    Point2D.Double point = new Point2D.Double(x, y);
                    list.add(point);
                }
                Method method = ReflectUtils.getWriteMethod(instance.getClass(), prop, List.class);
                ReflectUtils.writeValue(instance, method, prop, list);
            } else if (childNodeList != null && propType.equals("collection.string")) {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < len; ++i) {
                    Node pointNode = childNodeList.item(i);
                    if (pointNode.getNodeType() != 1) continue;
                    list.add(pointNode.getFirstChild().getNodeValue());
                }
                Method method = ReflectUtils.getWriteMethod(instance.getClass(), prop, List.class);
                ReflectUtils.writeValue(instance, method, prop, list);
            }
        } else {
            Method method = ReflectUtils.getWriteMethod(instance.getClass(), prop, String.class);
            ReflectUtils.writeValue(instance, method, prop, text);
        }
    }

    public void deserializeClient(IClient instance, String prop, Node pNode) {
        NamedNodeMap attributes = pNode.getAttributes();
        String pName = attributes.getNamedItem("n").getNodeValue();
        String propertyType = null;
        propertyType = this.settings.getPropertyType(pName);
        String text = null;
        NodeList nodeList = pNode.getChildNodes();
        int len = 0;
        if (null != nodeList) {
            len = nodeList.getLength();
        }
        if (nodeList != null && len > 0) {
            text = nodeList.item(0).getNodeValue();
        }
        if (propertyType != null) {
            if (propertyType.equals("string")) {
                instance.setClient(prop, text);
            } else if (propertyType.equals("point")) {
                double x = Double.parseDouble(attributes.getNamedItem("x").getNodeValue());
                double y = Double.parseDouble(attributes.getNamedItem("y").getNodeValue());
                Point2D.Double point = new Point2D.Double(x, y);
                instance.setClient(prop, point);
            } else if (propertyType.equals("boolean")) {
                instance.setClient(prop, Boolean.valueOf(text));
            } else if (propertyType.equals("number")) {
                instance.setClient(prop, Double.valueOf(text));
            } else if (propertyType.equals("int")) {
                instance.setClient(prop, Integer.valueOf(text));
            } else if (propertyType.equals("uint")) {
                instance.setClient(prop, Integer.valueOf(text));
            } else if (propertyType.equals("data")) {
                instance.setClient(prop, this.refMap.get(text));
            } else if (propertyType.equals("rectangle")) {
                double x2 = Double.parseDouble(attributes.getNamedItem("x").getNodeValue());
                double y2 = Double.parseDouble(attributes.getNamedItem("y").getNodeValue());
                double w2 = Double.parseDouble(attributes.getNamedItem("w").getNodeValue());
                double h2 = Double.parseDouble(attributes.getNamedItem("h").getNodeValue());
                Rectangle2D.Double rect = new Rectangle2D.Double(x2, y2, w2, h2);
                instance.setClient(prop, rect);
            } else if (nodeList != null && propertyType.equals("collection.point")) {
                ArrayList<Point2D.Double> pList = new ArrayList<Point2D.Double>();
                for (int i = 0; i < len; ++i) {
                    Node pointNode = nodeList.item(i);
                    if (pointNode.getNodeType() != 1) continue;
                    NamedNodeMap pointAtttibute = pointNode.getAttributes();
                    double x = Double.parseDouble(pointAtttibute.getNamedItem("x").getNodeValue());
                    double y = Double.parseDouble(pointAtttibute.getNamedItem("y").getNodeValue());
                    Point2D.Double point = new Point2D.Double(x, y);
                    pList.add(point);
                }
                instance.setClient(prop, pList);
            } else if (nodeList != null && propertyType.equals("collection.string")) {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < len; ++i) {
                    Node pointNode = nodeList.item(i);
                    if (pointNode.getNodeType() != 1) continue;
                    list.add(pointNode.getFirstChild().getNodeValue());
                }
                instance.setClient(prop, list);
            } else {
                instance.setClient(prop, text);
            }
        }
    }

    public void deserializeStyle(IStyle instance, String prop, Node pNode) {
        NamedNodeMap attributes = pNode.getAttributes();
        String pName = attributes.getNamedItem("n").getNodeValue();
        String type = null;
        type = this.settings.getPropertyType(pName);
        String text = null;
        NodeList childNodes = pNode.getChildNodes();
        int len = 0;
        if (null != childNodes) {
            len = childNodes.getLength();
        }
        if (childNodes != null && len > 0) {
            text = childNodes.item(0).getNodeValue();
        }
        if (type != null) {
            if (type.equals("string")) {
                instance.setStyle(prop, text);
            } else if (type.equals("point")) {
                double x = Double.parseDouble(attributes.getNamedItem("x").getNodeValue());
                double y = Double.parseDouble(attributes.getNamedItem("y").getNodeValue());
                Point2D.Double point = new Point2D.Double(x, y);
                instance.setStyle(prop, point);
            } else if (type.equals("boolean")) {
                instance.setStyle(prop, Boolean.valueOf(text));
            } else if (type.equals("number")) {
                instance.setStyle(prop, Double.valueOf(text));
            } else if (type.equals("int")) {
                instance.setStyle(prop, Integer.valueOf(text));
            } else if (type.equals("uint")) {
                instance.setStyle(prop, Integer.valueOf(text));
            } else if (type.equals("data")) {
                instance.setStyle(prop, this.refMap.get(text));
            } else if (type.equals("rectangle")) {
                double x1 = Double.parseDouble(attributes.getNamedItem("x").getNodeValue());
                double y1 = Double.parseDouble(attributes.getNamedItem("y").getNodeValue());
                double w1 = Double.parseDouble(attributes.getNamedItem("w").getNodeValue());
                double h1 = Double.parseDouble(attributes.getNamedItem("h").getNodeValue());
                Rectangle2D.Double rect = new Rectangle2D.Double(x1, y1, w1, h1);
                instance.setStyle(prop, rect);
            } else if (childNodes != null && type.equals("collection.point")) {
                ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
                for (int i = 0; i < len; ++i) {
                    Node pointNode = childNodes.item(i);
                    if (pointNode.getNodeType() != 1) continue;
                    NamedNodeMap pointAttr = pointNode.getAttributes();
                    double x = Double.parseDouble(pointAttr.getNamedItem("x").getNodeValue());
                    double y = Double.parseDouble(pointAttr.getNamedItem("y").getNodeValue());
                    Point2D.Double point = new Point2D.Double(x, y);
                    pointList.add(point);
                }
                instance.setStyle(prop, pointList);
            } else if (childNodes != null && type.equals("collection.string")) {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < len; ++i) {
                    Node pointNode = childNodes.item(i);
                    if (pointNode.getNodeType() != 1) continue;
                    list.add(pointNode.getFirstChild().getNodeValue());
                }
                instance.setStyle(prop, list);
            } else {
                instance.setStyle(prop, text);
            }
        }
    }

    public StringBuffer getXmlString() {
        return this.xmlString;
    }

    public void setXmlString(StringBuffer xmlString) {
        this.xmlString = xmlString;
    }

    public void setSettings(SerializationSettings settings) {
        this.settings = settings;
    }
}

