/*
 * Decompiled with CFR 0.152.
 */
package com.ha.atic.alarm.service;

import com.hs.atic.sdk.bis.model.AticAlarmObject;
import com.hs.atic.sdk.bis.service.IAlarmService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.atic.device.model.AticDevice;
import java.util.Map;

public class HaAlarmHandler {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private IAlarmService alarmService;

    public void haSwitchAlarm(String preActiveIp, String currentActiveIp) {
        logger.info((Object)("enter HASwitchAlarm. preActiveIp=" + AticUtil.getcleanedMessage((String)preActiveIp) + ", currentActiveIp=" + AticUtil.getcleanedMessage((String)currentActiveIp)));
        AticAlarmObject alarmObject = new AticAlarmObject();
        String[] alarm = new String[]{currentActiveIp, preActiveIp};
        alarmObject.setAlarmId("0x0000000803240807");
        alarmObject.setAlarmParam(alarm);
        alarmObject.setIsAlarm(Boolean.valueOf(true));
        alarmObject.setAlertTime(System.currentTimeMillis());
        alarmObject.setMoName("System");
        alarmObject.setMoIp("127.0.0.1");
        alarmObject.setMoId(Long.valueOf(1L));
        try {
            this.alarmService.callAlarmQueue(alarmObject);
        }
        catch (RuntimeException e) {
            logger.error((Object)("generate alarm error, AlarmId:" + alarmObject.getAlarmId() + ", currentActiveIp:" + currentActiveIp + ", preActiveIp:" + preActiveIp + ". Exception:" + e.getMessage()));
        }
    }

    public void haDeployAlarm(Map<AticDevice, String> param) {
        logger.info((Object)("enter haDeployAlarm . param : " + param));
        AticAlarmObject alarmObject = null;
        for (Map.Entry<AticDevice, String> entry : param.entrySet()) {
            AticDevice device = entry.getKey();
            String collectorIp = entry.getValue();
            alarmObject = new AticAlarmObject();
            String[] alarm = new String[]{device.getName(), device.getIpAddress(), collectorIp};
            alarmObject.setAlarmId("0x0000000803240808");
            alarmObject.setAlarmParam(alarm);
            alarmObject.setIsAlarm(Boolean.valueOf(true));
            alarmObject.setAlertTime(System.currentTimeMillis());
            alarmObject.setMoName("System");
            alarmObject.setMoIp("127.0.0.1");
            alarmObject.setMoId(Long.valueOf(1L));
            try {
                this.alarmService.callAlarmQueue(alarmObject);
            }
            catch (RuntimeException e) {
                logger.error((Object)("haDeployAlarm error. device : " + device + " collectorIp : " + collectorIp + ". " + e.getMessage()));
            }
        }
    }

    public void haDatabaseHaAlarm(Map<String, String> map) {
        logger.info((Object)("enter haDatabaseHaAlarm. param : " + map));
        AticAlarmObject alarmObject = new AticAlarmObject();
        alarmObject.setAlertLevel(FaultEnum.AlarmSeverity.CRITICAL);
        String[] alarmPara = new String[]{map.get("ip")};
        alarmObject.setAlarmParam(alarmPara);
        alarmObject.setAlertTime(System.currentTimeMillis());
        alarmObject.setAlarmId(String.valueOf(map.get("alarmId")));
        alarmObject.setIsAlarm(Boolean.valueOf(Boolean.parseBoolean(map.get("isAlarm"))));
        alarmObject.setMoIp(map.get("ip"));
        alarmObject.setMoName("System");
        alarmObject.setMoId(Long.valueOf(1L));
        try {
            this.alarmService.callAlarmQueue(alarmObject);
        }
        catch (RuntimeException e) {
            logger.error((Object)"haDatabaseHaAlarm error.");
        }
    }

    public IAlarmService getAlarmService() {
        return this.alarmService;
    }

    public void setAlarmService(IAlarmService alarmService) {
        this.alarmService = alarmService;
    }
}

