/*
 * Decompiled with CFR 0.152.
 */
package com.ha.atic.ha.util;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CollectorIpThread
extends Thread {
    private static volatile int sleepTime = 60000;
    private static final String CONFIGFILE = "/collector.conf";
    private static CollectorIpThread thread = null;
    private List<String> cmds;
    private List<Long> nowProcessing = Collections.synchronizedList(new ArrayList());
    private IAticDeviceService aticDeviceService;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private Boolean isActive = true;

    public CollectorIpThread(List<String> cmd) {
        this.cmds = cmd;
    }

    private CollectorIpThread(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public static synchronized CollectorIpThread getInstance(IAticDeviceService aticDeviceService) {
        if (null == thread) {
            thread = new CollectorIpThread(aticDeviceService);
            InputStream inputStream = AticUtil.class.getResourceAsStream(CONFIGFILE);
            String propertyTime = AticUtil.getPropertyValue((InputStream)inputStream, (String)"DualHostSwitchSleepTime");
            if (null != propertyTime) {
                try {
                    sleepTime = Integer.parseInt(propertyTime);
                }
                catch (Exception e) {
                    sleepTime = 60000;
                }
            }
        }
        return thread;
    }

    @Override
    public void run() {
        while (this.isActive.booleanValue()) {
            try {
                this.reDeployLogServerIp();
            }
            catch (RuntimeException e) {
                this.logger.error((Object)(this.getClass().getSimpleName() + "'s run method failed:" + e.getMessage()));
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("sleep failed:" + e.getMessage()));
            }
        }
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void reDeployLogServerIp() {
        if (this.nowProcessing.isEmpty()) {
            return;
        }
        Iterator<Long> iterator = this.nowProcessing.iterator();
        while (iterator.hasNext()) {
            Long devId = iterator.next();
            List results = null;
            try {
                results = this.aticDeviceService.execCmd(this.cmds, devId.longValue());
            }
            catch (RuntimeException e) {
                this.logger.error((Object)("execCmd failed! cmds :" + (this.cmds == null ? "" : this.getcleanedMessage(this.cmds.toString())) + " Exception:" + e.getMessage()));
                continue;
            }
            if (!AticUtil.isCmdSucess((List)results)) {
                this.logger.error((Object)"execCmd failed!");
                continue;
            }
            iterator.remove();
        }
        if (this.nowProcessing.isEmpty()) {
            this.setIsActive(false);
        }
    }

    public void addNeedDeployDev(Long devId) {
        this.logger.info((Object)("add redeploy device in queue! device id is " + devId));
        if (!this.nowProcessing.contains(devId)) {
            this.nowProcessing.add(devId);
        }
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }
}

