/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.cert.action;

import com.hs.atic.cert.model.CertManagementForm;
import com.hs.atic.cert.service.ICertManagementService;
import com.hs.atic.util.CertManagementUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CertManagementAction
extends BaseAction {
    private static final long serialVersionUID = -6228234772459082609L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private File cert;
    private CertManagementForm certManagementForm;
    private String result;
    @Autowired
    private ICertManagementService certManagementService;
    private List<CertManagementForm> certList;
    private List<Map<String, String>> classifications;

    public String queryCertPage() {
        this.logger.info((Object)"queryCertPage start");
        if (null == this.certList) {
            this.certList = new ArrayList<CertManagementForm>();
        }
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        Paging page = this.certManagementService.queryByPage(conditionMap, this.start, this.pageSize);
        this.certList = page.getData();
        this.total = page.getCount();
        this.logger.info((Object)"queryCertPage end");
        return "success";
    }

    public String preAddCert() {
        if (null == this.classifications) {
            this.classifications = new ArrayList<Map<String, String>>();
        }
        HashMap<String, String> lineModeMap = new HashMap<String, String>();
        lineModeMap.put("name", this.getText("atic.Certificate.Management.cert.type.cloudclean"));
        lineModeMap.put("id", "cloudclean");
        this.classifications.add(lineModeMap);
        HashMap<String, String> lineModeMap1 = new HashMap<String, String>();
        lineModeMap1.put("name", this.getText("atic.Certificate.Management.cert.type.CTCC"));
        lineModeMap1.put("id", "CTCC");
        this.classifications.add(lineModeMap1);
        HashMap<String, String> lineModeMap2 = new HashMap<String, String>();
        lineModeMap2.put("name", this.getText("atic.Certificate.Management.cert.type.BlackholeIp"));
        lineModeMap2.put("id", "BlackholeIp");
        this.classifications.add(lineModeMap2);
        HashMap<String, String> lineModeMap3 = new HashMap<String, String>();
        lineModeMap3.put("name", this.getText("atic.Certificate.Management.cert.type.huaweicloud"));
        lineModeMap3.put("id", "huaweicloud");
        this.classifications.add(lineModeMap3);
        HashMap<String, String> lineModeMap4 = new HashMap<String, String>();
        lineModeMap4.put("name", this.getText("atic.Certificate.Management.cert.type.highdefense"));
        lineModeMap4.put("id", "highdefense");
        this.classifications.add(lineModeMap4);
        HashMap<String, String> lineModeMap5 = new HashMap<String, String>();
        lineModeMap5.put("name", this.getText("atic.Certificate.Management.cert.type.Unicom.soc"));
        lineModeMap5.put("id", "Unicomsoc");
        this.classifications.add(lineModeMap5);
        return "success";
    }

    /*
     * Exception decompiling
     */
    public String saveCert() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void closeStream(InputStream inputStream, BufferedInputStream bufferedInputStream, ByteArrayOutputStream byteArrayOutputStream) {
        try {
            if (null != byteArrayOutputStream) {
                byteArrayOutputStream.close();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"byteArrayOutputStream.close() failed");
        }
        try {
            if (null != bufferedInputStream) {
                bufferedInputStream.close();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"bufferedInputStream.close() failed");
        }
        try {
            if (null != inputStream) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"inputStream.close() failed");
        }
    }

    public String deleteCert() {
        this.logger.info((Object)"deleteCert start");
        if (null == this.certManagementForm) {
            this.logger.error((Object)"certManagementForm is null of deleteCert action");
            this.result = "failed";
            return "error";
        }
        List<CertManagementForm> list = this.certManagementService.queryByPkids(this.certManagementForm.getPkids());
        StringBuilder detailPara = new StringBuilder();
        for (CertManagementForm form : list) {
            boolean deleteCert;
            boolean isExist = CertManagementUtil.getInstance().isExistByAlias(form.getAlias());
            if (isExist && !(deleteCert = CertManagementUtil.getInstance().deleteCert(form.getAlias()))) {
                this.logger.error((Object)"CertificateException delete third_truststore is failed");
                this.result = "failed";
                this.log4Options(false, "atic.Certificate.Management", "atic.Certificate.Management.cert.log.delete.target", "atic.Certificate.Management.delete", "atic.Certificate.Management.cert.log.delete.detail.failed", new String[0]);
                return "error";
            }
            detailPara.append(form.getAlias()).append("; ");
            this.certManagementService.deleteCertById(form.getPkid());
        }
        try {
            this.certManagementService.resetAliasName(list);
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"reset cert alias name error.");
            this.result = "failed";
            long errorCode = e.getErrorCode();
            this.log4Options(false, "atic.Certificate.Management", "atic.Certificate.Management.cert.log.delete.target", "atic.Certificate.Management.delete", "lego.err." + errorCode, new String[0]);
            return "error";
        }
        this.logger.info((Object)"deleteCert end");
        this.log4Options(true, "atic.Certificate.Management", "atic.Certificate.Management.cert.log.delete.target", "atic.Certificate.Management.delete", "atic.Certificate.Management.cert.log.delete.detail.success", new String[]{detailPara.toString()});
        return "success";
    }

    public boolean validateCertFile(File certFile) {
        if (null == certFile) {
            this.logger.error((Object)"certFile is null validateCertFile failed");
            return false;
        }
        if (certFile.length() <= 0L || certFile.length() > 0x100000L) {
            this.logger.error((Object)("certFile size validateCertFile failed" + certFile.length()));
            return false;
        }
        return true;
    }

    public boolean validateAlias(String alias) {
        if (null == alias) {
            return true;
        }
        Pattern pattern = Pattern.compile("^(?!_)(?![0-9])[a-zA-Z_0-9]+$");
        Matcher matcher = pattern.matcher(alias);
        if (!matcher.matches()) {
            return false;
        }
        return alias.length() > 0 && alias.length() <= 128;
    }

    public boolean validatePkids(String pkids) {
        if (null == pkids) {
            return true;
        }
        String[] pkidArry = pkids.split(",");
        if (pkidArry.length > 100) {
            return false;
        }
        for (String pkid : pkidArry) {
            if (null == pkid) continue;
            return Pattern.matches("^[0-9]*$", pkid);
        }
        return true;
    }

    private void log4Options(boolean isSuccess, String module, String target, String operation, String detail, String[] detailPara) {
        User currentUser = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        SysOptLog syncSysLog = new SysOptLog();
        syncSysLog.setOperation(operation);
        syncSysLog.setModule(module);
        syncSysLog.setOperator(currentUser.getUserName().trim());
        syncSysLog.setTerminalIp(currentUser.getIpAdr());
        ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        syncSysLog.setTargetLocal(Boolean.valueOf(true));
        if (isSuccess) {
            syncSysLog.setResult(1);
            syncSysLog.setLevel(SysoplogLevel.info.getValue());
            syncSysLog.setTarget(target);
            syncSysLog.setDetail(detail);
            syncSysLog.setDetailPara(detailPara);
            sysOptLog.writeOptLog(syncSysLog);
        } else {
            syncSysLog.setResult(0);
            syncSysLog.setLevel(SysoplogLevel.normal.getValue());
            syncSysLog.setTarget(target);
            syncSysLog.setDetail(detail);
            syncSysLog.setDetailPara(detailPara);
            sysOptLog.writeOptLog(syncSysLog);
        }
    }

    public File getCert() {
        return this.cert;
    }

    public void setCert(File cert) {
        this.cert = cert;
    }

    public CertManagementForm getCertManagementForm() {
        return this.certManagementForm;
    }

    public void setCertManagementForm(CertManagementForm certManagementForm) {
        this.certManagementForm = certManagementForm;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public List<CertManagementForm> getCertList() {
        return this.certList;
    }

    public List<Map<String, String>> getClassifications() {
        return this.classifications;
    }

    public void setClassifications(List<Map<String, String>> classifications) {
        this.classifications = classifications;
    }
}

