/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.cert.dao;

import com.hs.atic.cert.model.CertManagement;
import com.hs.atic.cert.model.CertManagementForm;
import com.hs.atic.system.model.SysConfig;
import com.hs.lego.core.base.persistance.dao.CommonDaoImpl;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.atic.util.JSONUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Repository;

@Repository(value="certManagementDAO")
public class CertManagementDAOImpl
extends CommonDaoImpl {
    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        Paging page = new Paging();
        HashMap queryMap = new HashMap();
        StringBuffer hql = new StringBuffer();
        hql.append("from CertManagement f where (1=1) ");
        String hql4Count = "select count(*) as rowCount ";
        hql4Count = hql4Count + hql;
        Long count = this.getTotalCount(hql4Count, queryMap);
        List result = this.findPage(hql.toString(), start, pageSize, queryMap);
        page.setCount(count.intValue());
        page.setData(result);
        return page;
    }

    public List<CertManagement> queryByAlias(String alias) {
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        StringBuffer hql = new StringBuffer();
        hql.append("FROM CertManagement where (1=1) ");
        hql.append(" AND alias = ?0");
        queryMap.put(0, alias);
        List list = this.findByHql(hql.toString(), queryMap);
        return list;
    }

    public List<CertManagement> queryByPkids(String pkids) {
        String[] pkidAry = pkids.split(",");
        HashMap<Integer, String> queryMap = new HashMap<Integer, String>();
        StringBuffer hql = new StringBuffer();
        hql.append("FROM CertManagement where (1=1) AND ");
        int index = 0;
        for (String pkid : pkidAry) {
            if (null == pkid || pkid.length() == 0) continue;
            if (0 == index) {
                hql.append(" ( ");
            }
            if (0 != index) {
                hql.append(" OR ");
            }
            hql.append(" pkid = ?" + index);
            queryMap.put(index++, pkid.trim());
            if (pkidAry.length != index) continue;
            hql.append(" ) ");
        }
        List list = this.findByHql(hql.toString(), queryMap);
        return list;
    }

    public List<CertManagement> queryAllCerts() {
        StringBuffer hql = new StringBuffer();
        hql.append("FROM CertManagement");
        List list = this.findByHql(hql.toString());
        return list;
    }

    public void deleteCertById(long pkid) {
        String hql = "delete from CertManagement where pkid = ?0 ";
        this.getHibernateTemplate().bulkUpdate(hql, new Object[]{pkid});
    }

    public void resetAliasName(List<CertManagementForm> list) {
        try {
            StringBuilder cbSb = new StringBuilder();
            cbSb.append("UPDATE ConfigBlackholeApi SET certAlias = '' WHERE certAlias in (");
            int index = 0;
            Object[] paras = new String[list.size()];
            for (CertManagementForm f : list) {
                paras[index] = f.getAlias();
                cbSb.append("?" + index++);
                if (index >= list.size()) continue;
                cbSb.append(",");
            }
            cbSb.append(")");
            this.getHibernateTemplate().bulkUpdate(cbSb.toString(), paras);
            StringBuilder deviceSb = new StringBuilder();
            deviceSb.append("UPDATE AticDevice SET restfulCertAlias = '' WHERE restfulCertAlias in (");
            int devIndex = 0;
            Object[] devParas = new String[list.size()];
            for (CertManagementForm f : list) {
                devParas[devIndex] = f.getAlias();
                deviceSb.append("?" + devIndex++);
                if (devIndex >= list.size()) continue;
                deviceSb.append(",");
            }
            deviceSb.append(")");
            this.getHibernateTemplate().bulkUpdate(deviceSb.toString(), devParas);
            StringBuilder ccSb = new StringBuilder();
            ccSb.append("UPDATE CloudCleanConfig SET certAlias = '' WHERE certAlias in (");
            int ccIndex = 0;
            Object[] ccParas = new String[list.size()];
            for (CertManagementForm f : list) {
                ccParas[ccIndex] = f.getAlias();
                ccSb.append("?" + ccIndex++);
                if (ccIndex >= list.size()) continue;
                ccSb.append(",");
            }
            ccSb.append(")");
            this.getHibernateTemplate().bulkUpdate(ccSb.toString(), ccParas);
            String systemVar = "huaweiCloudConfig";
            String hcHql = "FROM SysConfig WHERE sysVar = ?0";
            List hcList = this.getHibernateTemplate().find(hcHql, new Object[]{systemVar});
            if (null != hcList && hcList.size() > 0) {
                Map jsonMap = (Map)JSONUtil.getInstance().fromJSON(((SysConfig)hcList.get(0)).getSysValue(), Map.class);
                String defenceAuthCertAlias = (String)jsonMap.get("defenceAuthCertAlias");
                String defenceAuthAdvancedCertAlias = (String)jsonMap.get("defenceAuthAdvancedCertAlias");
                for (CertManagementForm f : list) {
                    if (StringUtils.isNotEmpty((CharSequence)defenceAuthCertAlias) && defenceAuthCertAlias.equals(f.getAlias())) {
                        jsonMap.put("defenceAuthCertAlias", "");
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)defenceAuthAdvancedCertAlias) || !defenceAuthAdvancedCertAlias.equals(f.getAlias())) continue;
                    jsonMap.put("defenceAuthAdvancedCertAlias", "");
                }
                String sysValue = JSONUtil.getInstance().toJSON((Object)jsonMap);
                String hcuphql = "update SysConfig set sysValue=?0 where sysVar=?1";
                this.getHibernateTemplate().bulkUpdate(hcuphql, new Object[]{sysValue, systemVar});
            }
            StringBuilder recSb = new StringBuilder();
            recSb.append("UPDATE RestfulConfigForm SET cloudCertAlias = CASE WHEN cloudCertAlias IN (");
            int recIndex = 0;
            Object[] recParas = new String[list.size()];
            StringBuilder subSb = new StringBuilder();
            for (CertManagementForm f : list) {
                recParas[recIndex] = f.getAlias();
                subSb.append("?" + recIndex++);
                if (recIndex >= list.size()) continue;
                subSb.append(",");
            }
            subSb.append(") ");
            recSb.append((CharSequence)subSb).append("THEN '' ELSE cloudCertAlias END,");
            recSb.append("blackCertAlias = CASE WHEN blackCertAlias IN (").append((CharSequence)subSb).append("THEN '' ELSE blackCertAlias END");
            this.getHibernateTemplate().bulkUpdate(recSb.toString(), recParas);
            StringBuilder socSb = new StringBuilder();
            socSb.append("UPDATE UnicomConfigInfo SET certAlias = '' WHERE certAlias in (");
            int socIndex = 0;
            Object[] socParas = new String[list.size()];
            for (CertManagementForm f : list) {
                socParas[socIndex] = f.getAlias();
                socSb.append("?" + socIndex++);
                if (socIndex >= list.size()) continue;
                socSb.append(",");
            }
            socSb.append(")");
            this.getHibernateTemplate().bulkUpdate(socSb.toString(), socParas);
        }
        catch (DataAccessException e) {
            throw new LegoCheckedException(570507L);
        }
    }
}

