/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.cert.service.impl;

import com.hs.atic.cert.dao.CertManagementDAOImpl;
import com.hs.atic.cert.model.CertManagement;
import com.hs.atic.cert.model.CertManagementForm;
import com.hs.atic.cert.service.ICertManagementService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.constants.LangPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="certManagementService")
public class CertManagementServiceImpl
implements ICertManagementService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    @Autowired
    private CertManagementDAOImpl certManagementDAO;

    @Override
    public Paging queryByPage(Map<String, String> conditionMap, int start, int pageSize) {
        this.logger.info((Object)"CertManagementServiceImpl queryByPage ");
        Paging page = this.certManagementDAO.queryByPage(conditionMap, start, pageSize);
        List infoList = page.getData();
        ArrayList<CertManagementForm> formList = new ArrayList<CertManagementForm>();
        if (null != infoList) {
            for (CertManagement certManagement : infoList) {
                CertManagementForm certManagementForm = new CertManagementForm();
                AticUtil.copyProperties((Object)certManagement, (Object)certManagementForm);
                certManagementForm.setDname(this.unicodeToString(certManagement.getDname()));
                formList.add(certManagementForm);
            }
        }
        page.setData(formList);
        return page;
    }

    private String unicodeToString(String str) {
        Pattern pattern = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            char ch = (char)Integer.parseInt(matcher.group(2), 16);
            str = str.replace(matcher.group(1), ch + "");
        }
        return str;
    }

    @Override
    public void saveCert(CertManagementForm certManagementForm) {
        CertManagement certManagement = new CertManagement();
        List<CertManagement> certManagementList = this.certManagementDAO.queryByAlias(certManagementForm.getAlias());
        if (CollectionUtils.isNotEmpty(certManagementList)) {
            certManagement = certManagementList.get(0);
            certManagementForm.setPkid(certManagement.getPkid());
        }
        BeanUtils.copyProperties((Object)certManagementForm, (Object)certManagement);
        this.certManagementDAO.save(certManagement);
    }

    @Override
    public void deleteCert(CertManagementForm certManagementForm) {
        String[] pkidAry;
        String pkids = certManagementForm.getPkids();
        for (String pkid : pkidAry = pkids.split(",")) {
            CertManagement certManagement = new CertManagement();
            certManagement.setPkid(Long.parseLong(pkid.trim()));
            this.certManagementDAO.delete(certManagement);
        }
    }

    @Override
    public void deleteCertById(long pkid) {
        this.certManagementDAO.deleteCertById(pkid);
    }

    @Override
    public boolean queryByAlias(String alias) {
        return this.certManagementDAO.queryByAlias(alias).size() > 0;
    }

    @Override
    public List<CertManagementForm> queryByPkids(String pkids) {
        List<CertManagement> list = this.certManagementDAO.queryByPkids(pkids);
        ArrayList<CertManagementForm> result = new ArrayList<CertManagementForm>();
        for (CertManagement cert : list) {
            CertManagementForm form = new CertManagementForm();
            BeanUtils.copyProperties((Object)cert, (Object)form);
            result.add(form);
        }
        return result;
    }

    @Override
    public List<CertManagementForm> queryAllCerts() {
        List<CertManagement> list = this.certManagementDAO.queryAllCerts();
        ArrayList<CertManagementForm> result = new ArrayList<CertManagementForm>();
        for (CertManagement cert : list) {
            CertManagementForm form = new CertManagementForm();
            BeanUtils.copyProperties((Object)cert, (Object)form);
            result.add(form);
        }
        return result;
    }

    public List<LangPair> queryAllCertName() {
        List<CertManagement> list = this.certManagementDAO.queryAllCerts();
        ArrayList<LangPair> certPair = new ArrayList<LangPair>();
        for (CertManagement cert : list) {
            certPair.add(new LangPair(cert.getAlias(), String.valueOf(cert.getPkid())));
        }
        return certPair;
    }

    public String queryCertByAlias(String alias) {
        List<CertManagement> list = this.certManagementDAO.queryByAlias(alias);
        CertManagement certManagement = null;
        if (list.size() > 0) {
            certManagement = list.get(0);
        }
        return null == certManagement ? "" : certManagement.getCertFile();
    }

    @Override
    public void resetAliasName(List<CertManagementForm> list) {
        this.certManagementDAO.resetAliasName(list);
    }
}

