/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi.impl;

import com.ha.atic.alarm.service.HaAlarmHandler;
import com.ha.atic.ha.util.CollectorIpThread;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.DualHostSwitchService;
import com.hs.atic.rmi.SecneCollectorRMIProxy;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.atic.rmi.SysManagerService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.CrashThreadHandler;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.service.ICollectorDeviceService;
import com.huawei.atic.collector.service.dao.CollectorDao;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.device.model.Collector;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.huawei.atic.secservice.policyengine.command.CommandAPI;
import com.huawei.atic.secservice.policyengine.commandutil.CmdParam;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DualHostSwitchServiceImpl
extends UnicastRemoteObject
implements DualHostSwitchService {
    private static String status = "normal";
    private static final long serialVersionUID = 5427310856723391728L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private CollectorDao collectorDao;
    private ICollectorDeviceService cdService;
    private HaAlarmHandler alarmHandler;
    private IAticDeviceService aticDeviceService;
    private SecneCollectorRMIProxy collectorRMIProxy;

    public DualHostSwitchServiceImpl() throws RemoteException {
    }

    public DualHostSwitchServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, (RMIClientSocketFactory)csf, (RMIServerSocketFactory)ssf);
        this.collectorDao = (CollectorDao)ServiceContext.getInstance().getService("collectorDao", CollectorDao.class);
        this.cdService = (ICollectorDeviceService)ServiceContext.getInstance().getService("collectorDeviceService", ICollectorDeviceService.class);
        this.alarmHandler = (HaAlarmHandler)ServiceContext.getInstance().getService("haAlarmHandler", HaAlarmHandler.class);
        this.aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        this.collectorRMIProxy = (SecneCollectorRMIProxy)ServiceContext.getInstance().getService("secneCollectorRMIProxy", SecneCollectorRMIProxy.class);
    }

    public static String getStatus() {
        return status;
    }

    public static void setStatus(String status) {
        DualHostSwitchServiceImpl.status = status;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public void modifyOnPassive(String preActiveIp, String currentActiveIp) throws RemoteException {
        CollectorIpThread thread;
        DualHostSwitchServiceImpl.setStatus("danger");
        this.logger.info((Object)("enter modifyOnPassive().the input param is preActiveIp:" + AticUtil.getcleanedMessage((String)preActiveIp) + " currentActiveIp:" + AticUtil.getcleanedMessage((String)currentActiveIp)));
        if (currentActiveIp.equals(preActiveIp)) {
            this.logger.info((Object)"preActiveIp is same with currentActiveIp,return success");
            DualHostSwitchServiceImpl.setStatus("normal");
            return;
        }
        List listCollector = this.collectorDao.getAll();
        Collector preActive = this.modifyCollectorInfo(preActiveIp, currentActiveIp, listCollector, thread = CollectorIpThread.getInstance(this.aticDeviceService));
        if (null == preActive) {
            this.logger.error((Object)"modifyCollectorInfo return null and execute modifyOnPassive break");
            DualHostSwitchServiceImpl.setStatus("normal");
            return;
        }
        HashMap<AticDevice, String> faultParam = new HashMap<AticDevice, String>();
        List<Long> listDevId = this.dealCollector(currentActiveIp, preActive);
        if (null == listDevId) {
            this.waitingForAlarmFinish(preActiveIp, currentActiveIp);
            return;
        }
        boolean success = true;
        List<String> cmds = this.getCommands(preActiveIp, currentActiveIp);
        this.logger.info((Object)("after getCommands the collector ipaddress is " + this.getcleanedMessage(((Collector)this.collectorDao.getAll().get(0)).getIpAddress())));
        for (Long devId : listDevId) {
            AticDevice device = this.aticDeviceService.getDeviceByMoid(devId.longValue());
            if (device.getDeviceType() == 1 || device.getDeviceType() == 8) {
                boolean execCmd = this.execCmd(cmds, devId);
                if (execCmd) continue;
                success = false;
                faultParam.put(device, currentActiveIp);
                continue;
            }
            IClusterService clusterService = (IClusterService)ServiceContext.getInstance().getService("clusterService", IClusterService.class);
            List bindNfaDevice = clusterService.getBindNfaDevice(devId);
            for (AticDeviceNfaCluster aticDeviceNfaCluster : bindNfaDevice) {
                boolean execCmd = this.execCmd(cmds, aticDeviceNfaCluster.getDeviceId());
                if (execCmd) continue;
                success = false;
                faultParam.put(device, currentActiveIp);
            }
        }
        this.logger.info((Object)("after all execCmds the collector ipaddress is " + this.getcleanedMessage(((Collector)this.collectorDao.getAll().get(0)).getIpAddress())));
        this.waitingForAlarmFinish(preActiveIp, currentActiveIp);
        this.deployAlarm(faultParam);
        if (success) {
            thread.setIsActive(false);
        }
        DualHostSwitchServiceImpl.setStatus("normal");
        this.logger.info((Object)"leave modifyOnPassive()");
        this.logger.info((Object)("the last collector ipaddress is " + this.getcleanedMessage(((Collector)this.collectorDao.getAll().get(0)).getIpAddress())));
    }

    private boolean execCmd(List<String> cmds, Long devId) {
        CollectorIpThread thread = CollectorIpThread.getInstance(this.aticDeviceService);
        List results = null;
        try {
            results = this.aticDeviceService.execCmd(cmds, devId.longValue());
        }
        catch (RuntimeException e) {
            this.logger.error((Object)("execCmd failed! cmds :" + (cmds == null ? "" : this.getcleanedMessage(cmds.toString())) + " Exception:" + e.getMessage()));
            thread.addNeedDeployDev(devId);
            thread.setIsActive(true);
            return false;
        }
        if (!AticUtil.isCmdSucess((List)results)) {
            this.logger.error((Object)("execCmd failed! cmds :" + (cmds == null ? "" : this.getcleanedMessage(cmds.toString())) + " results:" + (results == null ? "" : this.getcleanedMessage(results.toString()))));
            thread.addNeedDeployDev(devId);
            thread.setIsActive(true);
            return false;
        }
        this.logger.info((Object)("after execCmd the collector ipaddress is " + this.getcleanedMessage(((Collector)this.collectorDao.getAll().get(0)).getIpAddress())));
        return true;
    }

    private List<Long> dealCollector(String currentActiveIp, Collector preActive) throws RemoteException {
        List listCollector = this.collectorDao.getAll();
        if (listCollector.isEmpty()) {
            this.logger.error((Object)"after the modify the listCollector is null or empty.");
            DualHostSwitchServiceImpl.setStatus("normal");
            return null;
        }
        List listDevId = null;
        boolean needDeployCmd = false;
        for (Collector collector : listCollector) {
            SysManagerService sysManagerService;
            if (currentActiveIp.equals(collector.getIpAddress()) && (listDevId = this.cdService.getDeviceAccess(collector.getMoId())) != null && !listDevId.isEmpty()) {
                needDeployCmd = true;
            }
            if ((sysManagerService = this.collectorRMIProxy.getSysManagerService(collector.getIpAddress())) != null) {
                sysManagerService.updateSysVal("server_ip", currentActiveIp);
                continue;
            }
            this.logger.error((Object)("modify collector's server_ip failed! collector ip is :" + this.getcleanedMessage(collector.getIpAddress())));
        }
        this.logger.info((Object)("preActive.getMoId():" + preActive.getMoId()));
        this.logger.info((Object)("after updateSysVal the collector ipaddress is " + this.getcleanedMessage(((Collector)this.collectorDao.getAll().get(0)).getIpAddress())));
        if (!needDeployCmd) {
            DualHostSwitchServiceImpl.setStatus("normal");
            this.logger.error((Object)"needDeployCmd is false. Don't need to deploy the cmd to device");
            return null;
        }
        return listDevId;
    }

    private void waitingForAlarmFinish(String preActiveIp, String currentActiveIp) {
        this.alarmHandler.haSwitchAlarm(preActiveIp, currentActiveIp);
        this.logger.info((Object)"send switch alarm success.");
    }

    private Collector modifyCollectorInfo(String preActiveIp, String currentActiveIp, List<Collector> listCollector, CollectorIpThread thread) {
        this.logger.info((Object)("enter modifyCollectorInfo().preActiveIp is " + AticUtil.getcleanedMessage((String)preActiveIp) + " and currentActiveIp is " + AticUtil.getcleanedMessage((String)currentActiveIp)));
        if (null == preActiveIp) {
            this.logger.error((Object)"preActiveIp is null!");
            return null;
        }
        if (preActiveIp.equals(currentActiveIp)) {
            this.logger.error((Object)"preActiveIp equals currentActiveIp!");
            return null;
        }
        thread.setIsActive(true);
        thread.setName("dualhostswitch");
        if (!thread.isAlive()) {
            thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
            thread.start();
        }
        this.logger.info((Object)"The thread has already started.");
        if (null == listCollector || listCollector.isEmpty()) {
            this.logger.error((Object)"listCollector is null or empty");
            return null;
        }
        Collector preCollector = null;
        Collector curCollector = null;
        int curDeviceNumber = 0;
        int preDeviceNumber = 0;
        for (Collector collector : listCollector) {
            if (currentActiveIp.equals(collector.getIpAddress())) {
                curCollector = collector;
                List curDevices = this.cdService.getDeviceAccess(collector.getMoId());
                if (curDevices == null) continue;
                curDeviceNumber = curDevices.size();
                continue;
            }
            if (!preActiveIp.equals(collector.getIpAddress())) continue;
            preCollector = collector;
            List preDevices = this.cdService.getDeviceAccess(collector.getMoId());
            if (preDevices == null) continue;
            preDeviceNumber = preDevices.size();
        }
        if (preCollector != null && curCollector != null) {
            if (preDeviceNumber == 0) {
                this.collectorDao.delById(preCollector.getMoId());
                this.logger.info((Object)("delete collector id: " + preCollector.getMoId() + " and name :" + preCollector.getCollectorName() + " and ip:" + this.getcleanedMessage(preCollector.getIpAddress())));
            }
            if (curDeviceNumber == 0 && preDeviceNumber > 0) {
                this.collectorDao.delById(curCollector.getMoId());
                this.logger.info((Object)("delete collector id: " + curCollector.getMoId() + " and name :" + curCollector.getCollectorName() + " and ip:" + this.getcleanedMessage(curCollector.getIpAddress())));
            }
            listCollector = this.collectorDao.getAll();
        }
        Collector modifyCollector = null;
        for (Collector collector : listCollector) {
            if (preActiveIp.equals(collector.getIpAddress())) {
                this.logger.error((Object)("find preActiveIp:" + preActiveIp + ":" + currentActiveIp + ":" + collector.getIpAddress()));
                modifyCollector = collector;
                break;
            }
            if (currentActiveIp.equals(collector.getIpAddress())) {
                this.logger.error((Object)("find currentActiveIp:" + preActiveIp + ":" + currentActiveIp + ":" + collector.getIpAddress()));
                modifyCollector = collector;
                break;
            }
            this.modifyCollectorManagerIP(collector, currentActiveIp);
        }
        if (null == modifyCollector) {
            this.logger.info((Object)"modifyCollector is null.");
            return null;
        }
        this.logger.info((Object)("before set the ip is :" + this.getcleanedMessage(modifyCollector.getIpAddress())));
        modifyCollector.setIpAddress(currentActiveIp);
        this.logger.info((Object)("after set the ip is :" + this.getcleanedMessage(modifyCollector.getIpAddress())));
        this.collectorDao.saveOrUpdate((Object)modifyCollector);
        return modifyCollector;
    }

    private void modifyCollectorManagerIP(Collector collector, String managerIp) {
        SysManagerService sysManagerService = this.collectorRMIProxy.getSysManagerService(collector.getIpAddress());
        if (sysManagerService != null) {
            try {
                sysManagerService.updateSysVal("server_ip", managerIp);
            }
            catch (RemoteException e) {
                this.logger.error((Object)(" modifyCollectorManagerIP error " + e.getMessage()));
            }
        }
    }

    private List<String> getCommands(String undoIp, String deployIp) {
        ArrayList<CmdParam> paramList = new ArrayList<CmdParam>();
        CmdParam tmpCmdParam = new CmdParam();
        tmpCmdParam.setCmdID("SYS");
        paramList.add(tmpCmdParam);
        CmdParam cmdParam1 = new CmdParam();
        cmdParam1.setCmdID("UNDO_SERVER_IP");
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("serverIp", undoIp);
        cmdParam1.setParams(params1);
        paramList.add(cmdParam1);
        CmdParam cmdParam2 = new CmdParam();
        cmdParam2.setCmdID("DEPLOY_SERVER_IP");
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("serverIp", deployIp);
        cmdParam2.setParams(params2);
        paramList.add(cmdParam2);
        String xmlPath = "conf/aticCommands.xml";
        CommandAPI cAPI = new CommandAPI();
        List list = cAPI.doTranslate(xmlPath, "collector", paramList);
        this.logger.info((Object)("list:" + list));
        return list;
    }

    private void deployAlarm(Map<AticDevice, String> alarmParam) {
        this.alarmHandler.haDeployAlarm(alarmParam);
        this.logger.info((Object)"send ha deploy alarm success");
    }

    @Override
    public void sendAlarm(Map<String, String> param) throws RemoteException {
        this.alarmHandler.haDatabaseHaAlarm(param);
        this.logger.info((Object)"send Database HaAlarm success");
    }
}

