/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.system;

import com.hs.atic.sdk.system.form.LogHoldTimeForm;
import com.hs.atic.system.util.SystemUtil;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.fault.sdk.model.PageSizeConfig;
import com.hs.lego.cbb.fault.sdk.service.PageSizeConfigService;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.huawei.atic.parents.servcice.ILogHoldTimeService;
import java.util.List;

public class LogHoldTimeAction
extends BaseAction {
    private static final long serialVersionUID = 4959943250704244457L;
    private LogHoldTimeForm logHoldTime;
    private Boolean isNeedSave = false;
    private int notifyTime;
    private int blackHoleDelayTime;
    private int packetFileDelayTime;
    private int blackHoleWhiteTime;
    private PageSizeConfigService pageSizeConfigService;
    private ILogHoldTimeService logHoldTimeService;

    public String antiDdosData() {
        this.logHoldTime = SystemUtil.getLogHoldTime();
        this.findNotifyTime();
        this.findBlackHoleTime();
        this.findPacketTaskTime();
        this.findBlackHoleWhiteTime();
        return "success";
    }

    private void findNotifyTime() {
        List pageSizeConfigs = this.pageSizeConfigService.findPageSizeNum("notifyTime");
        this.notifyTime = null != pageSizeConfigs && !pageSizeConfigs.isEmpty() ? Integer.parseInt(((PageSizeConfig)pageSizeConfigs.get(0)).getSysValue()) : 600;
    }

    private void findBlackHoleTime() {
        List sysConfigs = this.pageSizeConfigService.findPageSizeNum("unblockTime");
        this.blackHoleDelayTime = null != sysConfigs && !sysConfigs.isEmpty() ? Integer.parseInt(((PageSizeConfig)sysConfigs.get(0)).getSysValue()) : 30;
    }

    private void findBlackHoleWhiteTime() {
        List sysConfigs = this.pageSizeConfigService.findPageSizeNum("whiteTime");
        this.blackHoleWhiteTime = null != sysConfigs && !sysConfigs.isEmpty() ? Integer.parseInt(((PageSizeConfig)sysConfigs.get(0)).getSysValue()) : 30;
    }

    private void findPacketTaskTime() {
        List sysConfigs = this.pageSizeConfigService.findPageSizeNum("packetFile");
        this.packetFileDelayTime = null != sysConfigs && !sysConfigs.isEmpty() ? Integer.parseInt(((PageSizeConfig)sysConfigs.get(0)).getSysValue()) : 90;
    }

    public void saveLogHoldTime() {
        if (this.logHoldTime != null) {
            this.systemOpeLog("report.operation.sysLog.modifyData.oper", "lego.dic.module.logHoldTimeApp", true, new String[]{String.valueOf(this.logHoldTime.getHoldOriginal()), String.valueOf(this.logHoldTime.getHoldHour()), String.valueOf(this.logHoldTime.getHoldDay()), String.valueOf(this.logHoldTime.getTacticsLogTime()), String.valueOf(this.logHoldTime.getDevSyslogTime()), String.valueOf(this.packetFileDelayTime), String.valueOf(this.logHoldTime.getDayReportTime()), String.valueOf(this.logHoldTime.getWeekReportTime()), String.valueOf(this.logHoldTime.getMonthReportTime()), String.valueOf(this.logHoldTime.getYearReportTime()), String.valueOf(this.logHoldTime.getDivertDelayTime()), String.valueOf(this.blackHoleDelayTime), String.valueOf(this.blackHoleWhiteTime), String.valueOf(this.notifyTime), String.valueOf(this.logHoldTime.getPageSizeNum())}, "report.operation.sysLog.modifyData.success", "lego.dic.module.logHoldTimeApp", SysoplogLevel.normal.getValue(), true, null);
            this.isNeedSave = this.logHoldTimeService.saveLogHoldTime(this.logHoldTime);
            this.pageSizeConfigService.saveSysValue("pageSize", String.valueOf(this.logHoldTime.getPageSizeNum()));
            this.pageSizeConfigService.saveSysValue("notifyTime", String.valueOf(this.notifyTime));
            this.pageSizeConfigService.saveSysValue("unblockTime", String.valueOf(this.blackHoleDelayTime));
            this.pageSizeConfigService.saveSysValue("whiteTime", String.valueOf(this.blackHoleWhiteTime));
            this.pageSizeConfigService.saveSysValue("packetFile", String.valueOf(this.packetFileDelayTime));
        }
        this.responseResult(String.valueOf(this.isNeedSave));
    }

    public boolean checkParameters() {
        if (!this.checkParams()) {
            return false;
        }
        if (!this.isInBetween(1, 500, this.logHoldTime.getDayReportTime())) {
            return false;
        }
        if (!this.isInBetween(1, 24, this.logHoldTime.getWeekReportTime())) {
            return false;
        }
        if (!this.isInBetween(1, 3, this.logHoldTime.getMonthReportTime())) {
            return false;
        }
        if (!this.isInBetween(1, 10, this.logHoldTime.getYearReportTime())) {
            return false;
        }
        if (!this.isInBetween(0, 7200, this.logHoldTime.getDivertDelayTime())) {
            return false;
        }
        if (!this.isInBetween(1, 100, this.logHoldTime.getPageSizeNum())) {
            return false;
        }
        if (!this.isInBetween(2, 600, this.blackHoleDelayTime)) {
            return false;
        }
        if (!this.isInBetween(0, 600, this.blackHoleWhiteTime)) {
            return false;
        }
        String packetTaskTime = String.valueOf(this.packetFileDelayTime);
        try {
            Integer.parseInt(packetTaskTime);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (!this.isInBetween(1, 365, Integer.parseInt(packetTaskTime)) || AticUtil.isNull((String)packetTaskTime)) {
            return false;
        }
        return this.isInBetween(10, 600, this.notifyTime);
    }

    private boolean checkParams() {
        if (!this.isInBetween(1, 500, this.logHoldTime.getHoldOriginal())) {
            return false;
        }
        if (!this.isInBetween(1, 36, this.logHoldTime.getHoldHour())) {
            return false;
        }
        if (!this.isInBetween(1, 5, this.logHoldTime.getHoldDay())) {
            return false;
        }
        if (!this.isInBetween(1, 500, this.logHoldTime.getTacticsLogTime())) {
            return false;
        }
        if (!this.isInBetween(1, 500, this.logHoldTime.getDevSyslogTime())) {
            return false;
        }
        return !AticUtil.isNullForVpn((String)String.valueOf(this.logHoldTime.getDivertDelayTime())) && !AticUtil.isNullForVpn((String)String.valueOf(this.blackHoleDelayTime)) && !AticUtil.isNullForVpn((String)String.valueOf(this.blackHoleWhiteTime));
    }

    private boolean isInBetween(int smaller, int bigger, int operation) {
        return operation >= smaller && operation <= bigger;
    }

    public LogHoldTimeForm getLogHoldTime() {
        return this.logHoldTime;
    }

    public void setLogHoldTime(LogHoldTimeForm logHoldTime) {
        this.logHoldTime = logHoldTime;
    }

    public Boolean getIsNeedSave() {
        return this.isNeedSave;
    }

    public void setIsNeedSave(Boolean isNeedSave) {
        this.isNeedSave = isNeedSave;
    }

    public int getNotifyTime() {
        return this.notifyTime;
    }

    public void setNotifyTime(int notifyTime) {
        this.notifyTime = notifyTime;
    }

    public int getBlackHoleDelayTime() {
        return this.blackHoleDelayTime;
    }

    public void setBlackHoleDelayTime(int blackHoleDelayTime) {
        this.blackHoleDelayTime = blackHoleDelayTime;
    }

    public int getPacketFileDelayTime() {
        return this.packetFileDelayTime;
    }

    public void setPacketFileDelayTime(int packetFileDelayTime) {
        this.packetFileDelayTime = packetFileDelayTime;
    }

    public int getBlackHoleWhiteTime() {
        return this.blackHoleWhiteTime;
    }

    public void setBlackHoleWhiteTime(int blackHoleWhiteTime) {
        this.blackHoleWhiteTime = blackHoleWhiteTime;
    }

    public PageSizeConfigService getPageSizeConfigService() {
        return this.pageSizeConfigService;
    }

    public void setPageSizeConfigService(PageSizeConfigService pageSizeConfigService) {
        this.pageSizeConfigService = pageSizeConfigService;
    }

    public ILogHoldTimeService getLogHoldTimeService() {
        return this.logHoldTimeService;
    }

    public void setLogHoldTimeService(ILogHoldTimeService logHoldTimeService) {
        this.logHoldTimeService = logHoldTimeService;
    }
}

