/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.system.service;

import com.hs.atic.rmi.SecneCollectorRMIProxy;
import com.hs.atic.rmi.SysManagerService;
import com.hs.atic.sdk.system.form.LogHoldTimeForm;
import com.hs.atic.system.dao.LogHoldTimeDAO;
import com.hs.atic.system.model.LogHoldTime;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.service.dao.CollectorDao;
import com.huawei.atic.device.model.Collector;
import com.huawei.atic.parents.servcice.ILogHoldTimeService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class LogHoldTimeServiceImpl
implements ILogHoldTimeService {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private LogHoldTimeDAO logHoldTimeDAO;
    private CollectorDao collectorDao;
    private SecneCollectorRMIProxy collectorRMIProxy;

    public CollectorDao getCollectorDao() {
        return this.collectorDao;
    }

    public void setCollectorDao(CollectorDao collectorDao) {
        this.collectorDao = collectorDao;
    }

    public LogHoldTimeDAO getLogHoldTimeDAO() {
        return this.logHoldTimeDAO;
    }

    public void setLogHoldTimeDAO(LogHoldTimeDAO logHoldTimeDAO) {
        this.logHoldTimeDAO = logHoldTimeDAO;
    }

    public SecneCollectorRMIProxy getCollectorRMIProxy() {
        return this.collectorRMIProxy;
    }

    public void setCollectorRMIProxy(SecneCollectorRMIProxy collectorRMIProxy) {
        this.collectorRMIProxy = collectorRMIProxy;
    }

    public List<LogHoldTimeForm> findLogHoldTime() {
        List<LogHoldTime> list = this.logHoldTimeDAO.findLogHoldTime();
        ArrayList<LogHoldTimeForm> listForm = new ArrayList<LogHoldTimeForm>();
        if (list != null && !list.isEmpty()) {
            listForm.add((LogHoldTimeForm)AticUtil.copyProperties((Object)list.get(0), (Object)new LogHoldTimeForm()));
        }
        return listForm;
    }

    public boolean saveLogHoldTime(LogHoldTimeForm logHoldTime) {
        List aticList = this.collectorDao.getAll();
        if (null != logHoldTime && !aticList.isEmpty()) {
            try {
                for (Collector collectorinfo : aticList) {
                    SysManagerService sysManagerService;
                    if (collectorinfo.getDdosCollectorStatus() != 1 || (sysManagerService = this.collectorRMIProxy.getSysManagerService(collectorinfo.getIpAddress())) == null) continue;
                    sysManagerService.setPartitionParameter(logHoldTime.getHoldOriginal(), logHoldTime.getHoldHour(), logHoldTime.getHoldDay());
                    sysManagerService.setMonitorHoldTime(logHoldTime.getHoldTime());
                    sysManagerService.updateSysVal("divert_delay_time", String.valueOf(logHoldTime.getDivertDelayTime()));
                }
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)"Get SysManagerService interface failed!");
                throw e;
            }
            catch (RemoteException e) {
                this.logger.error((Object)("Save logHoldTime data failed!" + e.getMessage()));
            }
        }
        if (logHoldTime != null) {
            this.logHoldTimeDAO.saveLogHoldTime((LogHoldTime)AticUtil.copyProperties((Object)logHoldTime, (Object)new LogHoldTime()));
        }
        return true;
    }
}

