/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.sysmonitor.service.db.mysql;

import com.hs.lego.core.system.sysmonitor.sdk.model.DataBaseInfo;
import com.hs.lego.core.system.sysmonitor.sdk.model.DiskResouceUse;
import com.hs.lego.core.system.sysmonitor.service.db.Monitor;
import com.hs.lego.core.system.sysmonitor.service.db.mysql.IMysqlMonitorDao;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class MysqlMonitor
implements Monitor {
    private static final int VERSION_MAIN = 5;
    private static final int VERSION_SUB_MAIN = 1;
    private static final int VERSION_SUB = 28;
    private static String dbVersion = "";
    private boolean noCheckDBVersion = true;
    private boolean supportFreeSpace = false;
    private IMysqlMonitorDao monitorDao;
    private boolean remoteDB = false;

    @Override
    public String getDBType() {
        return "MySQL";
    }

    @Override
    public List<DataBaseInfo> getDbInfo() {
        this.remoteDB = true;
        return this.getDbInfo(null);
    }

    @Override
    public List<DataBaseInfo> getDbInfo(List<DiskResouceUse> diskList) {
        List<Object[]> dblist;
        if (null == this.monitorDao) {
            return Collections.EMPTY_LIST;
        }
        long diskFreeSpace = 0L;
        if (diskList != null && this.queryFreeSpace()) {
            String path = this.monitorDao.getDBFilePath();
            if (null == path) {
                return Collections.EMPTY_LIST;
            }
            path = path.toUpperCase(Locale.US);
            boolean isLinux = path.startsWith("/");
            long rootSize = 0L;
            boolean noFind = true;
            String realDisk = "/";
            for (DiskResouceUse disk : diskList) {
                if (isLinux && "/".equals(disk.getDiskName())) {
                    rootSize = this.diskCorventB(disk.getAvail());
                    continue;
                }
                if (isLinux && path.startsWith(disk.getDiskName().toUpperCase(Locale.US))) {
                    if ("/".equals(realDisk)) {
                        realDisk = disk.getDiskName().toUpperCase(Locale.US);
                        diskFreeSpace = this.diskCorventB(disk.getAvail());
                        noFind = false;
                        continue;
                    }
                    if (null != disk.getDiskName().toUpperCase(Locale.US) && !"".equals(disk.getDiskName().toUpperCase(Locale.US)) && realDisk.split("/").length < disk.getDiskName().toUpperCase(Locale.US).split("/").length) {
                        realDisk = disk.getDiskName().toUpperCase(Locale.US);
                        diskFreeSpace = this.diskCorventB(disk.getAvail());
                        noFind = false;
                        continue;
                    }
                }
                if (isLinux || !path.startsWith(disk.getDiskName().toUpperCase(Locale.US))) continue;
                diskFreeSpace = this.diskCorventB(disk.getAvail());
                noFind = false;
                break;
            }
            if (isLinux && noFind) {
                diskFreeSpace = rootSize;
            }
        }
        if (null == (dblist = this.monitorDao.getDbSize())) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DataBaseInfo> databaseList = new ArrayList<DataBaseInfo>();
        for (Object[] db : dblist) {
            double dbSize = Long.parseLong(db[1].toString()) + Long.parseLong(db[2].toString());
            double maxSize = dbSize + (double)diskFreeSpace;
            double maxDbSize = Long.parseLong(db[4].toString());
            if (maxDbSize > 0.0 && maxDbSize < maxSize) {
                maxSize = maxDbSize;
            }
            double remain = maxSize - dbSize;
            double usedCapacity = dbSize / maxSize * 100.0;
            usedCapacity = new BigDecimal(usedCapacity).setScale(2, 4).doubleValue();
            DataBaseInfo dataBaseInfo = new DataBaseInfo();
            dataBaseInfo.setDataBaseName(db[0].toString());
            dataBaseInfo.setTotal(this.corventReadable(maxSize));
            dataBaseInfo.setUsed(this.corventReadable(dbSize));
            if (this.queryFreeSpace()) {
                dataBaseInfo.setRemain(this.corventReadable(remain));
                dataBaseInfo.setPercent(usedCapacity + "%");
            } else {
                dataBaseInfo.setRemainCapacity("N/A");
                dataBaseInfo.setRemain("N/A");
                dataBaseInfo.setPercent("N/A");
            }
            dataBaseInfo.setVersion(this.getDBType() + " " + this.getDBVersion());
            dataBaseInfo.setAutoIncrease(true);
            if (this.remoteDB) {
                dataBaseInfo.setPercent("N/A");
            }
            databaseList.add(dataBaseInfo);
        }
        return databaseList;
    }

    private String getDBVersion() {
        if (dbVersion == null || dbVersion.isEmpty() && null != this.monitorDao) {
            dbVersion = this.monitorDao.getDBVersion();
        }
        return dbVersion;
    }

    private boolean queryFreeSpace() {
        if (this.noCheckDBVersion) {
            boolean enable = false;
            String mysqlVersion = this.getDBVersion();
            this.noCheckDBVersion = false;
            if (null == mysqlVersion || mysqlVersion.equals("")) {
                return enable;
            }
            String[] version = mysqlVersion.split("-");
            String[] vers = version[0].split("\\.");
            int version1 = 0;
            int version2 = 0;
            int version3 = 0;
            if (vers.length > 0) {
                version1 = Integer.parseInt(vers[0]);
            }
            if (vers.length > 1) {
                version2 = Integer.parseInt(vers[1]);
            }
            if (vers.length > 2) {
                version3 = Integer.parseInt(vers[2]);
            }
            if (version1 > 5) {
                enable = true;
            } else if (version1 == 5) {
                if (version2 > 1) {
                    enable = true;
                } else if (version2 == 1 && version3 >= 28) {
                    enable = true;
                }
            }
            this.supportFreeSpace = enable;
        }
        return this.supportFreeSpace;
    }

    private String corventReadable(double space) {
        return new BigDecimal(space / 1048576.0).setScale(2, 4).doubleValue() + " MB";
    }

    private long diskCorventB(String disk) {
        double size = 0.0;
        if (disk.contains("K")) {
            size = Double.parseDouble(disk.replace("K", "").trim());
            size *= 1024.0;
        } else if (disk.contains("M")) {
            size = Double.parseDouble(disk.replace("M", "").trim());
            size = size * 1024.0 * 1024.0;
        } else if (disk.contains("G")) {
            size = Double.parseDouble(disk.replace("G", "").trim());
            size = size * 1024.0 * 1024.0 * 1024.0;
        } else if (disk.contains("T")) {
            size = Double.parseDouble(disk.replace("T", "").trim());
            size = size * 1024.0 * 1024.0 * 1024.0 * 1024.0;
        } else {
            if (!disk.matches("[0-9]*(\\.[0-9]*){0,1}")) {
                disk = disk.trim().substring(0, disk.length() - 1);
            }
            size = Double.parseDouble(disk.trim());
        }
        return Math.round(size);
    }

    public void setMonitorDao(IMysqlMonitorDao monitorDao) {
        this.monitorDao = monitorDao;
    }
}

