/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.sysmonitor.service.db.sqlserver;

import com.hs.lego.core.system.sysmonitor.sdk.model.DataBaseInfo;
import com.hs.lego.core.system.sysmonitor.sdk.model.DiskResouceUse;
import com.hs.lego.core.system.sysmonitor.service.db.Monitor;
import com.hs.lego.core.system.sysmonitor.service.db.sqlserver.ISqlServerMonitorDao;
import com.hs.lego.core.system.sysmonitor.service.db.sqlserver.SingleDBFile;
import com.hs.lego.core.system.sysmonitor.service.db.sqlserver.SingleDiskDBFile;
import com.hs.lego.core.system.sysmonitor.service.db.sqlserver.SqlServerDBFile;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class SqlServerMonitor
implements Monitor {
    private ISqlServerMonitorDao monitorDao;
    private boolean remoteDB = false;

    @Override
    public String getDBType() {
        return "Microsoft SQL Server";
    }

    @Override
    public List<DataBaseInfo> getDbInfo() {
        this.remoteDB = true;
        return this.getDbInfo(null);
    }

    @Override
    public List<DataBaseInfo> getDbInfo(List<DiskResouceUse> diskList) {
        ArrayList<DataBaseInfo> databaseList = new ArrayList<DataBaseInfo>();
        if (null == this.monitorDao) {
            return databaseList;
        }
        List<Object[]> dblist = this.monitorDao.getDbList();
        if (null == dblist) {
            return databaseList;
        }
        for (Object[] db : dblist) {
            Map<String, List<SingleDBFile>> fileMap = this.getDBFile(db);
            Set<Map.Entry<String, List<SingleDBFile>>> entries = fileMap.entrySet();
            long maxSize = 0L;
            long dataSize = 0L;
            long logSize = 0L;
            boolean autoIncreaseAndNoLimit = false;
            SqlServerDBFile dbfile = null;
            for (Map.Entry<String, List<SingleDBFile>> entry : entries) {
                String disk = entry.getKey();
                List<SingleDBFile> files = entry.getValue();
                dbfile = diskList == null ? this.countDiskFileSize(files) : this.countDiskFileSize(disk, files, diskList);
                maxSize += dbfile.getMaxSize();
                dataSize += dbfile.getDataSize();
                logSize += dbfile.getLogSize();
                if (!dbfile.isCountDiskSpace()) continue;
                autoIncreaseAndNoLimit = true;
            }
            String dbName = db[0].toString();
            double dataUnallocatedSize = this.getDataUnallocatedSize(dbName);
            double allUsed = (double)dataSize - dataUnallocatedSize + (double)logSize;
            double remain = (double)maxSize - allUsed;
            double usedCapacity = allUsed / (double)maxSize * 100.0;
            usedCapacity = new BigDecimal(usedCapacity).setScale(2, 4).doubleValue();
            DataBaseInfo dataBaseInfo = new DataBaseInfo();
            dataBaseInfo.setDataBaseName(dbName);
            dataBaseInfo.setTotal(this.corventReadable(maxSize));
            dataBaseInfo.setRemain(this.corventReadable(remain));
            dataBaseInfo.setUsed(this.corventReadable(allUsed));
            dataBaseInfo.setPercent(usedCapacity + "%");
            dataBaseInfo.setVersion(this.getDBType());
            dataBaseInfo.setAutoIncrease(autoIncreaseAndNoLimit);
            if (this.remoteDB && autoIncreaseAndNoLimit) {
                dataBaseInfo.setPercent("N/A");
            }
            databaseList.add(dataBaseInfo);
        }
        return databaseList;
    }

    private SqlServerDBFile countDiskFileSize(String disk, List<SingleDBFile> files, List<DiskResouceUse> diskList) {
        long diskFreeSpace = 0L;
        for (DiskResouceUse diskUse : diskList) {
            if (!disk.equals(diskUse.getDiskName().toUpperCase(Locale.US))) continue;
            diskFreeSpace = this.diskCorventKB(diskUse.getAvail());
            break;
        }
        SingleDiskDBFile sDiskFile = this.countSingleDiskDBFile(files);
        long maxSize = 0L;
        maxSize = sDiskFile.isDataIncrease() || sDiskFile.isLogIncrease() ? (sDiskFile.isDataLimit() && sDiskFile.isLogLimit() ? sDiskFile.getDataMaxSize() + sDiskFile.getLogMaxSize() : sDiskFile.getDataSize() + sDiskFile.getLogSize() + diskFreeSpace) : sDiskFile.getDataSize() + sDiskFile.getLogSize();
        boolean autoIncreaseAndNoLimit = sDiskFile.isDataIncrease() && !sDiskFile.isDataLimit() || sDiskFile.isLogIncrease() && !sDiskFile.isLogLimit();
        return new SqlServerDBFile(maxSize, sDiskFile.getDataSize(), sDiskFile.getLogSize(), autoIncreaseAndNoLimit);
    }

    private SqlServerDBFile countDiskFileSize(List<SingleDBFile> files) {
        SingleDiskDBFile sDiskFile = this.countSingleDiskDBFile(files);
        long maxSize = 0L;
        if (sDiskFile.isDataIncrease() || sDiskFile.isLogIncrease()) {
            maxSize = sDiskFile.isDataIncrease() && sDiskFile.isDataLimit() ? (maxSize += sDiskFile.getDataMaxSize()) : (maxSize += sDiskFile.getDataSize());
            maxSize = sDiskFile.isLogIncrease() && sDiskFile.isLogLimit() ? (maxSize += sDiskFile.getLogMaxSize()) : (maxSize += sDiskFile.getLogSize());
        } else {
            maxSize = sDiskFile.getDataSize() + sDiskFile.getLogSize();
        }
        boolean autoIncreaseAndNoLimit = sDiskFile.isDataIncrease() && !sDiskFile.isDataLimit() || sDiskFile.isLogIncrease() && !sDiskFile.isLogLimit();
        return new SqlServerDBFile(maxSize, sDiskFile.getDataSize(), sDiskFile.getLogSize(), autoIncreaseAndNoLimit);
    }

    private SingleDiskDBFile countSingleDiskDBFile(List<SingleDBFile> files) {
        long dataSize = 0L;
        long logSize = 0L;
        long dataMaxSize = 0L;
        long logMaxSize = 0L;
        boolean dataIncrease = false;
        boolean logIncrease = false;
        boolean dataLimit = true;
        boolean logLimit = true;
        for (SingleDBFile file : files) {
            if (file.isDataFile()) {
                dataSize += file.getSize();
                if (file.isLimit()) {
                    dataMaxSize += file.getMaxDBsize();
                } else {
                    dataMaxSize += file.getSize();
                    dataLimit = false;
                }
                if (!file.isGrowth()) continue;
                dataIncrease = true;
                continue;
            }
            logSize += file.getSize();
            if (file.isLimit()) {
                logMaxSize += file.getMaxDBsize();
            } else {
                logMaxSize += file.getSize();
                logLimit = false;
            }
            if (!file.isGrowth()) continue;
            logIncrease = true;
        }
        SingleDiskDBFile singleDiskDBFile = new SingleDiskDBFile();
        singleDiskDBFile.setDataIncrease(dataIncrease);
        singleDiskDBFile.setDataLimit(dataLimit);
        singleDiskDBFile.setDataMaxSize(dataMaxSize);
        singleDiskDBFile.setDataSize(dataSize);
        singleDiskDBFile.setLogIncrease(logIncrease);
        singleDiskDBFile.setLogLimit(logLimit);
        singleDiskDBFile.setLogMaxSize(logMaxSize);
        singleDiskDBFile.setLogSize(logSize);
        return singleDiskDBFile;
    }

    private Map<String, List<SingleDBFile>> getDBFile(Object[] dbs) {
        HashMap<String, List<SingleDBFile>> fileMap = new HashMap<String, List<SingleDBFile>>();
        String dbName = dbs[0].toString();
        if (null == this.monitorDao) {
            return fileMap;
        }
        List<Object[]> dbFileList = this.monitorDao.getDbFileInfo(dbName);
        if (null == dbFileList) {
            return fileMap;
        }
        for (Object[] obj : dbFileList) {
            SingleDBFile file = new SingleDBFile();
            this.setLimit(obj, file);
            if ("0".equals(obj[3].toString())) {
                file.setGrowth(false);
            } else {
                file.setGrowth(true);
            }
            file.setSize(Long.parseLong(obj[1].toString()) * 8L);
            if (file.isLimit()) {
                file.setMaxDBsize(Long.parseLong(obj[2].toString()) * 8L);
            } else {
                file.setMaxDBsize(0L);
            }
            file.setDisk(this.getDisk(obj[4].toString()));
            if (fileMap.containsKey(file.getDisk())) {
                ((List)fileMap.get(file.getDisk())).add(file);
                continue;
            }
            ArrayList<SingleDBFile> fileList = new ArrayList<SingleDBFile>();
            fileList.add(file);
            fileMap.put(file.getDisk(), fileList);
        }
        return fileMap;
    }

    private void setLimit(Object[] obj, SingleDBFile file) {
        if ("0".equals(obj[0].toString())) {
            file.setDataFile(false);
            if ("268435456".equals(obj[2].toString())) {
                file.setLimit(false);
            } else {
                file.setLimit(true);
            }
        } else {
            file.setDataFile(true);
            if ("-1".equals(obj[2].toString())) {
                file.setLimit(false);
            } else {
                file.setLimit(true);
            }
        }
    }

    private String getDisk(String path) {
        return path.substring(0, path.indexOf("\\") + 1).toUpperCase(Locale.US);
    }

    private double getDataUnallocatedSize(String dbName) {
        List<Object[]> dbUsedList;
        double dataUnallocatedSize = 0.0;
        if (null != this.monitorDao && null != (dbUsedList = this.monitorDao.getDbUsedInfo(dbName))) {
            for (Object[] obj : dbUsedList) {
                dataUnallocatedSize += this.corventKB(obj[2].toString());
            }
        }
        return dataUnallocatedSize;
    }

    private String corventReadable(double space) {
        return new BigDecimal(space / 1024.0).setScale(2, 4).doubleValue() + " MB";
    }

    private double corventKB(String space) {
        double size = 0.0;
        if (space.contains("MB")) {
            size = Double.parseDouble(space.replace("MB", "").trim());
            size *= 1024.0;
        } else {
            size = Double.parseDouble(space.trim());
        }
        return size;
    }

    private long diskCorventKB(String disk) {
        double size = 0.0;
        if (disk.contains("K")) {
            size = Double.parseDouble(disk.replace("K", "").trim());
            size *= 1024.0;
        } else if (disk.contains("M")) {
            size = Double.parseDouble(disk.replace("M", "").trim());
            size = size * 1024.0 * 1024.0;
        } else if (disk.contains("G")) {
            size = Double.parseDouble(disk.replace("G", "").trim());
            size = size * 1024.0 * 1024.0 * 1024.0;
        } else if (disk.contains("T")) {
            size = Double.parseDouble(disk.replace("T", "").trim());
            size = size * 1024.0 * 1024.0 * 1024.0 * 1024.0;
        } else {
            size = Double.parseDouble(disk.trim().substring(0, disk.length() - 1));
        }
        return Math.round(size);
    }

    public void setMonitorDao(ISqlServerMonitorDao monitorDao) {
        this.monitorDao = monitorDao;
    }
}

