/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.sysmonitor.service.db.sqlserver;

import com.hs.lego.core.system.sysmonitor.service.db.sqlserver.ISqlServerMonitorDao;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class SqlServerMonitorDao
extends HibernateDaoSupport
implements ISqlServerMonitorDao {
    public static final String LIST_DB_SQL = "sp_helpdb";
    public static final String LIST_FILE_SQL1 = "select groupid,size,maxsize,growth,filename from";
    public static final String LIST_FILE_SQL2 = ".dbo.sysfiles";
    public static final String DB_USED_SQL = ".dbo.sp_spaceused";
    public static final String DBMS_MASTER = "master";
    public static final String DBMS_TEMPDB = "tempdb";
    public static final String DBMS_MODEL = "model";
    public static final String DBMS_MSDB = "msdb";
    public static final String REPORT_MSDB = "ReportServer";
    public static final String REPORT_TEMP_MSDB = "public static final String REPORT_MSDB";
    public static final String REPORT_TEMP_MSDB_EXT = "ReportServerTempDB";

    @Override
    public List<Object[]> getDbList() {
        ArrayList<Object[]> dbList = null;
        List<?> rs = this.findBySql(LIST_DB_SQL);
        if (null == rs) {
            return dbList;
        }
        dbList = new ArrayList<Object[]>();
        for (Object obj : rs) {
            Object[] objs = (Object[])obj;
            String dbName = objs[0].toString();
            if (!(!dbName.isEmpty() && !DBMS_MASTER.equals(dbName) && !DBMS_TEMPDB.equals(dbName) && !DBMS_MODEL.equals(dbName) || !DBMS_MSDB.equals(dbName) && !REPORT_TEMP_MSDB.equals(dbName) && !REPORT_MSDB.equals(dbName) && !REPORT_TEMP_MSDB_EXT.equals(dbName))) continue;
            dbList.add(objs);
        }
        return dbList;
    }

    @Override
    public List<Object[]> getDbFileInfo(String dbName) {
        ArrayList<Object[]> fileList = null;
        List<?> rs = this.findBySql(LIST_FILE_SQL1 + dbName + LIST_FILE_SQL2);
        if (null == rs) {
            return fileList;
        }
        fileList = new ArrayList<Object[]>();
        for (Object obj : rs) {
            fileList.add((Object[])obj);
        }
        return fileList;
    }

    @Override
    public List<Object[]> getDbUsedInfo(String dbName) {
        ArrayList<Object[]> dbUsedList = null;
        List<?> rs = this.findBySql(dbName + DB_USED_SQL);
        if (null == rs) {
            return dbUsedList;
        }
        dbUsedList = new ArrayList<Object[]>();
        for (Object obj : rs) {
            dbUsedList.add((Object[])obj);
        }
        return dbUsedList;
    }

    private List<?> findBySql(String sql) {
        FindBySqlCallBack callback = new FindBySqlCallBack(sql);
        return (List)super.getHibernateTemplate().execute((HibernateCallback)callback);
    }

    private static final class FindBySqlCallBack
    implements HibernateCallback {
        private String sql;

        public FindBySqlCallBack(String sql) {
            this.sql = sql;
        }

        public Object doInHibernate(Session session) {
            List list = session.createNativeQuery(this.sql).getResultList();
            return list;
        }
    }
}

