/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.system.sysmonitor.service.hostserver;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.MathUtil;
import com.hs.lego.core.system.sysmonitor.model.ResourceResult;
import com.hs.lego.core.system.sysmonitor.sdk.model.DiskResouceUse;
import com.hs.lego.core.system.sysmonitor.service.hostserver.ISystemTool;
import com.hs.lego.core.system.sysmonitor.service.util.ResourceCbb;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class WindowsSystemTool
implements ISystemTool {
    public static final int MAX_BUFFER_LEN = 20;
    private static final String CPU_USE_PERCENT = "CPU";
    private static final String MEM_TOTALMEM = "TOTALMEM";
    private static final String MEM_AVAILMEM = "AVAILMEM";
    private static final long GB = 0x40000000L;
    private static final double DBHUNDRED = 100.0;
    private static final double LHUNDRED = 100.0;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_SYSTEM_COMMON);
    private final Object lock = new Object();

    @Override
    public double getCpuInfo() {
        long percent = 0L;
        try {
            percent = this.getCPUAndMenInfo(CPU_USE_PERCENT);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
        }
        return percent;
    }

    @Override
    public long getPercentMemInfo() {
        long total = this.getTotalMemInfo();
        long avail = this.getAvailMemInfo();
        long use = total - avail;
        double percent = (double)use * 100.0 / 100.0;
        return (long)percent;
    }

    @Override
    public long getAvailMemInfo() {
        return this.getCPUAndMenInfo(MEM_AVAILMEM);
    }

    @Override
    public long getTotalMemInfo() {
        return this.getCPUAndMenInfo(MEM_TOTALMEM);
    }

    public static String byteToString(byte[] buffer) {
        try {
            int length = 0;
            for (int i = 0; i < buffer.length && 0 != buffer[i]; ++i) {
                length = i + 1;
            }
            return new String(buffer, 0, length, "UTF-8");
        }
        catch (Exception e) {
            LOGGER.error((Object)("UnsupportedEncodingException: " + e.getMessage()));
            return null;
        }
    }

    private long getCPUAndMenInfo(String para) {
        long returnVaule = 1L;
        ResourceCbb resourceCbb = null;
        try {
            byte[] bytes = new byte[20];
            resourceCbb = ResourceCbb.SYNC_INSTANCE;
            ResourceResult.ByReference result = new ResourceResult.ByReference();
            resourceCbb.getWindowsResource(para, result);
            System.arraycopy(result.getRetStr(), 0, bytes, 0, 20);
            returnVaule = Long.parseLong(WindowsSystemTool.byteToString(bytes));
        }
        catch (Exception e) {
            LOGGER.error((Object)("getCPUAndMenInfo error! " + e.getMessage()));
        }
        return returnVaule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DiskResouceUse> getDisk() {
        Object object = this.lock;
        synchronized (object) {
            File[] roots = File.listRoots();
            ArrayList<DiskResouceUse> list = new ArrayList<DiskResouceUse>();
            if (roots == null) {
                return list;
            }
            for (File file : roots) {
                DiskResouceUse disktemp = new DiskResouceUse();
                disktemp.setDiskName(file.getPath());
                double totalSpace = file.getTotalSpace();
                double usableSpace = file.getUsableSpace();
                if (!(totalSpace > 0.0) || !file.canWrite() || !(usableSpace > 0.0)) continue;
                double total = MathUtil.getDoubleValue((double)(totalSpace / 1.073741824E9));
                disktemp.setTotal(total + " G");
                double useableGB = MathUtil.getDoubleValue((double)(usableSpace / 1.073741824E9));
                double used = MathUtil.getDoubleValue((double)(total - useableGB));
                disktemp.setUsed(used + " G");
                disktemp.setUnit("GB");
                disktemp.setAvail(useableGB + " G");
                double percent = MathUtil.getDoubleValue((double)((totalSpace - usableSpace) / totalSpace)) * 100.0;
                disktemp.setPercent(percent + "%");
                list.add(disktemp);
            }
            return list;
        }
    }
}

