/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.ui.plat.monitor.webapp.action;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.core.system.sysmonitor.sdk.model.DataBaseInfo;
import com.hs.lego.core.system.sysmonitor.sdk.model.DiskResouceUse;
import com.hs.lego.core.system.sysmonitor.sdk.model.HostServerMonitorInfo;
import com.hs.lego.core.system.sysmonitor.sdk.model.ResourceUse;
import com.hs.lego.core.system.sysmonitor.sdk.model.SysmTreshold;
import com.hs.lego.core.system.sysmonitor.sdk.model.SysmTresholdType;
import com.hs.lego.core.system.sysmonitor.sdk.service.ISysMonitor;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.lego.ui.plat.monitor.model.SysMonitorView;
import com.hs.lego.ui.plat.monitor.model.chartmodel.AxisLabel;
import com.hs.lego.ui.plat.monitor.model.chartmodel.Grid;
import com.hs.lego.ui.plat.monitor.model.chartmodel.Legend;
import com.hs.lego.ui.plat.monitor.model.chartmodel.Option;
import com.hs.lego.ui.plat.monitor.model.chartmodel.Series;
import com.hs.lego.ui.plat.monitor.model.chartmodel.Tooltip;
import com.hs.lego.ui.plat.monitor.model.chartmodel.Xaxis;
import com.hs.lego.ui.plat.monitor.model.chartmodel.Yaxis;
import com.restful.util.JacksonNullProviderUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SysMonitorAction
extends BaseAction {
    private static final long PERCENT = 90L;
    private static final long serialVersionUID = -648803035177796028L;
    private static final double MIN_VALUE = 0.01;
    private List<DiskResouceUse> listDisk;
    private List<ResourceUse> listCpu;
    private List<ResourceUse> listMemo;
    private List<DataBaseInfo> listDataBase;
    private long cpuPercent = 90L;
    private long memPercent = 90L;
    private long diskPercent = 90L;
    private long installDiskPercent = 90L;
    private long dbPercent = 90L;
    private String dbSupportHold = "true";
    private String displayDB = "true";
    private String optionResultCpu;
    private String optionResultMemo;
    private String optionResultDisk;
    private String optionResultDataBase;
    private ISysMonitor sysMonitorService;

    public String perforView() {
        this.listDataBase = new ArrayList<DataBaseInfo>();
        this.listCpu = new ArrayList<ResourceUse>();
        this.listMemo = new ArrayList<ResourceUse>();
        List<SysmTreshold> list = this.sysMonitorService.getSysmTreshold();
        this.setPercentValue(list);
        ResourceUse dataBaseInfo = null;
        Map<?, List<DataBaseInfo>> tempMap1 = this.sysMonitorService.getDataBaseInfo();
        if (tempMap1 != null) {
            Collection<List<DataBaseInfo>> setKey1 = tempMap1.values();
            for (List<DataBaseInfo> obj : setKey1) {
                this.listDataBase = obj;
                if (null == this.listDataBase || this.listDataBase.isEmpty()) continue;
                dataBaseInfo = this.listDataBase.get(0);
                break;
            }
        }
        if (dataBaseInfo != null) {
            this.displayDB = "true";
            this.dbSupportHold = "true";
            if ("N/A".equals(dataBaseInfo.getPercent())) {
                this.dbSupportHold = "false";
            }
        } else {
            this.dbSupportHold = "false";
            this.displayDB = "false";
        }
        this.optionResultCpu = this.getCpuJson();
        this.optionResultMemo = this.getMemoJson();
        this.optionResultDisk = this.getDiskJson();
        this.optionResultDataBase = this.getDataBaseJson();
        return "success";
    }

    public String preSysMonitorRuleSet() {
        this.listDataBase = new ArrayList<DataBaseInfo>();
        this.listCpu = new ArrayList<ResourceUse>();
        this.listMemo = new ArrayList<ResourceUse>();
        List<SysmTreshold> list = this.sysMonitorService.getSysmTreshold();
        this.setPercentValue(list);
        ResourceUse dataBaseInfo = null;
        Map<?, List<DataBaseInfo>> tempMap1 = this.sysMonitorService.getDataBaseInfo();
        if (tempMap1 != null) {
            Collection<List<DataBaseInfo>> setKey1 = tempMap1.values();
            for (List<DataBaseInfo> obj : setKey1) {
                this.listDataBase = obj;
                if (null == this.listDataBase || this.listDataBase.isEmpty()) continue;
                dataBaseInfo = this.listDataBase.get(0);
                break;
            }
        }
        if (dataBaseInfo != null) {
            if ("N/A".equals(dataBaseInfo.getPercent())) {
                this.dbSupportHold = "false";
            }
        } else {
            this.dbSupportHold = "false";
            this.displayDB = "false";
        }
        this.optionResultCpu = this.getCpuJson();
        this.optionResultMemo = this.getMemoJson();
        this.optionResultDisk = this.getDiskJson();
        this.optionResultDataBase = this.getDataBaseJson();
        return "success";
    }

    private void setPercentValue(List<SysmTreshold> list) {
        if (null != list && !list.isEmpty()) {
            for (SysmTreshold sysmTreshold : list) {
                if (sysmTreshold.getId().longValue() == SysmTresholdType.cpu.getValue()) {
                    this.cpuPercent = sysmTreshold.getPercent();
                    continue;
                }
                if (sysmTreshold.getId().longValue() == SysmTresholdType.db.getValue()) {
                    this.dbPercent = sysmTreshold.getPercent();
                    continue;
                }
                if (sysmTreshold.getId().longValue() == SysmTresholdType.mem.getValue()) {
                    this.memPercent = sysmTreshold.getPercent();
                    continue;
                }
                if (sysmTreshold.getId().longValue() == SysmTresholdType.disk.getValue()) {
                    this.diskPercent = sysmTreshold.getPercent();
                    continue;
                }
                if (sysmTreshold.getId().longValue() != SysmTresholdType.installdisk.getValue()) continue;
                this.installDiskPercent = sysmTreshold.getPercent();
            }
        }
        if (!(this.checkLongParam(this.cpuPercent) && this.checkLongParam(this.dbPercent) && this.checkLongParam(this.diskPercent) && this.checkLongParam(this.memPercent) && this.checkLongParam(this.installDiskPercent))) {
            throw new LegoCheckedException(303L);
        }
    }

    private String getDiskJson() {
        Map<?, HostServerMonitorInfo> tempMap = this.sysMonitorService.getCurrentHostServerInfo();
        ArrayList<SysMonitorView> allData = new ArrayList<SysMonitorView>();
        if (tempMap != null) {
            Collection<HostServerMonitorInfo> setKey = tempMap.values();
            SysMonitorView useDisk = null;
            SysMonitorView unUsedDisk = null;
            Iterator<HostServerMonitorInfo> iterator = setKey.iterator();
            while (iterator.hasNext()) {
                HostServerMonitorInfo obj;
                HostServerMonitorInfo tempHsInf = obj = iterator.next();
                for (DiskResouceUse temp : tempHsInf.getDiskInfo()) {
                    useDisk = new SysMonitorView();
                    unUsedDisk = new SysMonitorView();
                    useDisk.setSeries(this.getText("lego.lab.monitor.capacitytitle").split(",")[0]);
                    unUsedDisk.setSeries(this.getText("lego.lab.monitor.capacitytitle").split(",")[1]);
                    useDisk.setHostDisk(Double.parseDouble(temp.getUsed().trim().replace("G", "")));
                    unUsedDisk.setHostDisk(Double.parseDouble(temp.getAvail().trim().replace("G", "")));
                    String userDiskName = temp.getDiskName().trim().replace(":", "").replace("\\", "");
                    useDisk.setxLable(userDiskName);
                    unUsedDisk.setxLable(userDiskName);
                    allData.add(useDisk);
                    allData.add(unUsedDisk);
                }
            }
        }
        return this.prceossBarJson(allData, true);
    }

    private String getDataBaseJson() {
        DecimalFormat df = new DecimalFormat("##0.0 ");
        Map<?, List<DataBaseInfo>> tempMap = this.sysMonitorService.getDataBaseInfo();
        ArrayList<SysMonitorView> allData = new ArrayList<SysMonitorView>();
        if (tempMap != null) {
            Collection<List<DataBaseInfo>> setKey = tempMap.values();
            for (List<DataBaseInfo> obj : setKey) {
                this.listDataBase = obj;
            }
            SysMonitorView useDisk = null;
            SysMonitorView unUsedDisk = null;
            if (null != this.listDataBase) {
                for (DataBaseInfo temp : this.listDataBase) {
                    useDisk = new SysMonitorView();
                    unUsedDisk = new SysMonitorView();
                    useDisk.setSeries(this.getText("lego.lab.monitor.capacitytitle").split(",")[0]);
                    unUsedDisk.setSeries(this.getText("lego.lab.monitor.capacitytitle").split(",")[1]);
                    String userStr = temp.getUsed().trim().replace("MB", "");
                    String totalStr = temp.getTotal().trim().replace("MB", "");
                    useDisk.setDataBase(Double.parseDouble(df.format(Double.parseDouble(userStr))));
                    unUsedDisk.setDataBase(Double.parseDouble(df.format(Double.parseDouble(totalStr) - Double.parseDouble(userStr))));
                    useDisk.setxLable(temp.getDataBaseName());
                    unUsedDisk.setxLable(temp.getDataBaseName());
                    allData.add(useDisk);
                    allData.add(unUsedDisk);
                }
            }
        }
        return this.prceossBarJson(allData, false);
    }

    private String prceossBarJson(List<SysMonitorView> allData, boolean isDisk) {
        Option option = new Option();
        Tooltip tooltip = new Tooltip();
        Legend legend = new Legend();
        ArrayList<Xaxis> xAxisList = new ArrayList<Xaxis>();
        ArrayList<Yaxis> yAxisList = new ArrayList<Yaxis>();
        ArrayList<Series> seriesList = new ArrayList<Series>();
        Xaxis xAxis = new Xaxis();
        Yaxis yAxis = new Yaxis();
        Grid grid = new Grid();
        legend.setX("center");
        legend.setY("230");
        grid.setX("50");
        grid.setY("30");
        grid.setX2("50");
        int y2 = 40;
        grid.setY2(String.valueOf(y2));
        AxisLabel axisLabel = new AxisLabel();
        axisLabel.setFormatter("{value}");
        ArrayList<String> dateList = new ArrayList<String>();
        ArrayList<String> legendList = new ArrayList<String>();
        String currenXLable = "";
        boolean dbUnitG = false;
        if (!isDisk) {
            for (SysMonitorView diskItem : allData) {
                if (!(diskItem.getDataBase() > 99999.0)) continue;
                dbUnitG = true;
                break;
            }
        }
        for (SysMonitorView diskItem : allData) {
            BigDecimal bg;
            double seriesValue;
            if (!currenXLable.equals(diskItem.getxLable())) {
                currenXLable = diskItem.getxLable();
                dateList.add(currenXLable);
            }
            String hostName = diskItem.getSeries();
            boolean hasSeries = false;
            for (Series series : seriesList) {
                if (!hostName.equals(series.getName())) continue;
                seriesValue = 0.0;
                if (isDisk) {
                    seriesValue = diskItem.getHostDisk();
                } else {
                    seriesValue = diskItem.getDataBase();
                    if (dbUnitG) {
                        if (seriesValue / 1024.0 > 0.0 && seriesValue / 1024.0 < 0.01) {
                            seriesValue = 0.01;
                        } else {
                            bg = new BigDecimal(seriesValue / 1024.0);
                            seriesValue = bg.setScale(2, 4).doubleValue();
                        }
                    }
                }
                series.getData().add(seriesValue);
                hasSeries = true;
                break;
            }
            if (hasSeries) continue;
            Series series = new Series();
            ArrayList<Double> dataList = new ArrayList<Double>();
            legendList.add("'" + hostName + "'");
            series.setName(hostName);
            seriesValue = 0.0;
            if (isDisk) {
                seriesValue = diskItem.getHostDisk();
            } else {
                seriesValue = diskItem.getDataBase();
                if (dbUnitG) {
                    if (seriesValue / 1024.0 > 0.0 && seriesValue / 1024.0 < 0.01) {
                        seriesValue = 0.01;
                    } else {
                        bg = new BigDecimal(seriesValue / 1024.0);
                        seriesValue = bg.setScale(2, 4).doubleValue();
                    }
                }
            }
            dataList.add(seriesValue);
            series.setType("bar");
            series.setStack(diskItem.getxLable());
            series.setData(dataList);
            series.setBarWidth(40);
            seriesList.add(series);
        }
        tooltip.setTrigger("axis");
        legend.setData(legendList);
        xAxis.setType("category");
        xAxis.setData(dateList);
        xAxis.setBoundaryGap(Boolean.valueOf(true));
        yAxis.setType("value");
        String unit = "(MB)";
        if (isDisk || dbUnitG) {
            unit = "(GB)";
        }
        yAxis.setName(this.getText("lego.lab.monitor.capacity") + unit);
        yAxis.setAxisLabel(axisLabel);
        xAxisList.add(xAxis);
        yAxisList.add(yAxis);
        option.setTooltip(tooltip);
        option.setLegend(legend);
        option.setxAxis(xAxisList);
        option.setyAxis(yAxisList);
        option.setSeries(seriesList);
        option.setGrid(grid);
        String optionResultDBJson = "";
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializerProvider((DefaultSerializerProvider)new JacksonNullProviderUtil());
        try {
            optionResultDBJson = mapper.writeValueAsString((Object)option);
        }
        catch (JsonProcessingException e) {
            this.log.error((Object)("JsonProcessingException-->" + e.getMessage()));
        }
        optionResultDBJson = optionResultDBJson.replaceAll("-1,", ",");
        optionResultDBJson = optionResultDBJson.replaceAll(",-1", ",");
        return optionResultDBJson;
    }

    public void refreshCPU() {
        this.responseResult(this.getCpuJson());
    }

    public void refreshMemo() {
        this.responseResult(this.getMemoJson());
    }

    private String getMemoJson() {
        List<Map<Long, HostServerMonitorInfo>> list = this.sysMonitorService.getHistoryhostInfo();
        List<SysmTreshold> treshold = this.sysMonitorService.getSysmTreshold();
        String maxMemo = String.valueOf(treshold.get(1).getPercent());
        ArrayList<SysMonitorView> allData = new ArrayList<SysMonitorView>();
        if (null != list && !list.isEmpty()) {
            SysMonitorView memoItem = null;
            SysMonitorView maxMemoItem = null;
            for (Map<Long, HostServerMonitorInfo> map : list) {
                Set<Map.Entry<Long, HostServerMonitorInfo>> set = map.entrySet();
                for (Map.Entry<Long, HostServerMonitorInfo> entry : set) {
                    memoItem = new SysMonitorView();
                    maxMemoItem = new SysMonitorView();
                    memoItem.setSeries(this.getText("lego.lab.monitor.memo"));
                    maxMemoItem.setSeries(this.getText("lego.lab.sysmonitor.threshold"));
                    Long time = entry.getKey();
                    memoItem.setTime(time);
                    maxMemoItem.setTime(time);
                    HostServerMonitorInfo temp = entry.getValue();
                    String memoPer = temp.getMemoryInfo().getPercent().trim().replace("%", "");
                    memoItem.setHostCpu(Double.parseDouble(memoPer));
                    maxMemoItem.setHostCpu(Double.parseDouble(maxMemo));
                    allData.add(memoItem);
                    allData.add(maxMemoItem);
                }
            }
        }
        return this.processLineJson(allData);
    }

    private String processLineJson(List<SysMonitorView> allData) {
        Collections.sort(allData);
        Option option = new Option();
        Tooltip tooltip = new Tooltip();
        Legend legend = new Legend();
        ArrayList<Xaxis> xAxisList = new ArrayList<Xaxis>();
        ArrayList<Yaxis> yAxisList = new ArrayList<Yaxis>();
        ArrayList<Series> seriesList = new ArrayList<Series>();
        Xaxis xAxis = new Xaxis();
        Yaxis yAxis = new Yaxis();
        Grid grid = new Grid();
        legend.setX("center");
        legend.setY("230");
        grid.setX("50");
        grid.setY("30");
        grid.setX2("50");
        int y2 = 40;
        grid.setY2(String.valueOf(y2));
        AxisLabel axisLabel = new AxisLabel();
        axisLabel.setFormatter("{value}");
        ArrayList<String> dateList = new ArrayList<String>();
        ArrayList<String> legendList = new ArrayList<String>();
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        long currentTime = 0L;
        for (SysMonitorView cpuItem : allData) {
            if (currentTime != cpuItem.getTime()) {
                currentTime = cpuItem.getTime();
                dateList.add("'" + formatter.format(currentTime) + "'");
            }
            String hostName = cpuItem.getSeries();
            boolean hasSeries = false;
            for (Series series : seriesList) {
                if (!hostName.equals(series.getName())) continue;
                series.getData().add(cpuItem.getHostCpu());
                hasSeries = true;
                break;
            }
            if (hasSeries) continue;
            Series series = new Series();
            ArrayList<Double> useageList = new ArrayList<Double>();
            legendList.add("'" + hostName + "'");
            series.setName(hostName);
            useageList.add(cpuItem.getHostCpu());
            series.setType("line");
            series.setData(useageList);
            seriesList.add(series);
        }
        tooltip.setTrigger("axis");
        legend.setData(legendList);
        xAxis.setType("category");
        xAxis.setData(dateList);
        yAxis.setType("value");
        yAxis.setName(this.getText("lego.lab.monitor.usedpercent"));
        yAxis.setAxisLabel(axisLabel);
        xAxisList.add(xAxis);
        yAxisList.add(yAxis);
        option.setTooltip(tooltip);
        option.setLegend(legend);
        option.setxAxis(xAxisList);
        option.setyAxis(yAxisList);
        option.setSeries(seriesList);
        option.setGrid(grid);
        String optionResultCpuJson = "";
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializerProvider((DefaultSerializerProvider)new JacksonNullProviderUtil());
        try {
            optionResultCpuJson = mapper.writeValueAsString((Object)option);
        }
        catch (JsonProcessingException e) {
            this.log.error((Object)("JsonProcessingException-->" + e.getMessage()));
        }
        optionResultCpuJson = optionResultCpuJson.replaceAll("-1,", ",");
        optionResultCpuJson = optionResultCpuJson.replaceAll(",-1", ",");
        return optionResultCpuJson;
    }

    private String getCpuJson() {
        List<Map<Long, HostServerMonitorInfo>> list = this.sysMonitorService.getHistoryhostInfo();
        List<SysmTreshold> treshold = this.sysMonitorService.getSysmTreshold();
        String maxCpu = String.valueOf(treshold.get(0).getPercent());
        ArrayList<SysMonitorView> allData = new ArrayList<SysMonitorView>();
        if (null != list && !list.isEmpty()) {
            SysMonitorView cpuItem = null;
            SysMonitorView maxCpuItem = null;
            for (Map<Long, HostServerMonitorInfo> map : list) {
                Set<Map.Entry<Long, HostServerMonitorInfo>> set = map.entrySet();
                for (Map.Entry<Long, HostServerMonitorInfo> entry : set) {
                    cpuItem = new SysMonitorView();
                    maxCpuItem = new SysMonitorView();
                    cpuItem.setSeries("CPU");
                    maxCpuItem.setSeries(this.getText("lego.lab.sysmonitor.threshold"));
                    Long time = entry.getKey();
                    cpuItem.setTime(time);
                    maxCpuItem.setTime(time);
                    HostServerMonitorInfo temp = entry.getValue();
                    String cpuPer = temp.getCpuInfo().getPercent().trim().replace("%", "");
                    cpuItem.setHostCpu(Double.parseDouble(cpuPer));
                    maxCpuItem.setHostCpu(Double.parseDouble(maxCpu));
                    allData.add(cpuItem);
                    allData.add(maxCpuItem);
                }
            }
        }
        return this.processLineJson(allData);
    }

    public String updateSysmTreshold() {
        List<SysmTreshold> list = this.sysMonitorService.getSysmTreshold();
        this.systemOpeLog("lego.dic.module.system.modify.Treshold", "lego.dic.module.system", true, null, "", "lego.lab.sysmonitor.thresholdset", SysoplogLevel.normal.getValue(), true, null);
        if (!(this.checkLongParam(this.cpuPercent) && this.checkLongParam(this.dbPercent) && this.checkLongParam(this.diskPercent) && this.checkLongParam(this.memPercent))) {
            throw new LegoCheckedException(303L);
        }
        if (null != list && !list.isEmpty()) {
            for (SysmTreshold sysmTreshold : list) {
                if (sysmTreshold.getId().longValue() == SysmTresholdType.cpu.getValue()) {
                    sysmTreshold.setPercent(this.cpuPercent);
                    continue;
                }
                if (sysmTreshold.getId().longValue() == SysmTresholdType.db.getValue()) {
                    sysmTreshold.setPercent(this.dbPercent);
                    continue;
                }
                if (sysmTreshold.getId().longValue() == SysmTresholdType.disk.getValue()) {
                    sysmTreshold.setPercent(this.diskPercent);
                    continue;
                }
                if (sysmTreshold.getId().longValue() != SysmTresholdType.mem.getValue()) continue;
                sysmTreshold.setPercent(this.memPercent);
            }
        }
        this.sysMonitorService.updateSysmTreshold(list);
        return "success";
    }

    private boolean checkLongParam(long l) {
        return l >= 1L && l <= 99L;
    }

    public String getMonitorChartPage() {
        return "success";
    }

    public String getMonitorPage() {
        return "success";
    }

    public List<DiskResouceUse> getListDisk() {
        return this.listDisk;
    }

    public void setListDisk(List<DiskResouceUse> listDisk) {
        this.listDisk = listDisk;
    }

    public List<ResourceUse> getListCpu() {
        return this.listCpu;
    }

    public void setListCpu(List<ResourceUse> listCpu) {
        this.listCpu = listCpu;
    }

    public List<ResourceUse> getListMemo() {
        return this.listMemo;
    }

    public void setListMemo(List<ResourceUse> listMemo) {
        this.listMemo = listMemo;
    }

    public List<DataBaseInfo> getListDataBase() {
        return this.listDataBase;
    }

    public void setListDataBase(List<DataBaseInfo> listDataBase) {
        this.listDataBase = listDataBase;
    }

    public long getCpuPercent() {
        return this.cpuPercent;
    }

    public void setCpuPercent(long cpuPercent) {
        this.cpuPercent = cpuPercent;
    }

    public long getMemPercent() {
        return this.memPercent;
    }

    public void setMemPercent(long memPercent) {
        this.memPercent = memPercent;
    }

    public long getDbPercent() {
        return this.dbPercent;
    }

    public void setDbPercent(long dbPercent) {
        this.dbPercent = dbPercent;
    }

    public String getDbSupportHold() {
        return this.dbSupportHold;
    }

    public void setDbSupportHold(String dbSupportHold) {
        this.dbSupportHold = dbSupportHold;
    }

    public String getDisplayDB() {
        return this.displayDB;
    }

    public void setDisplayDB(String displayDB) {
        this.displayDB = displayDB;
    }

    public long getInstallDiskPercent() {
        return this.installDiskPercent;
    }

    public void setInstallDiskPercent(long installDiskPercent) {
        this.installDiskPercent = installDiskPercent;
    }

    public long getDiskPercent() {
        return this.diskPercent;
    }

    public void setDiskPercent(long diskPercent) {
        this.diskPercent = diskPercent;
    }

    public String getOptionResultCpu() {
        return this.optionResultCpu;
    }

    public void setOptionResultCpu(String optionResultCpu) {
        this.optionResultCpu = optionResultCpu;
    }

    public String getOptionResultMemo() {
        return this.optionResultMemo;
    }

    public void setOptionResultMemo(String optionResultMemo) {
        this.optionResultMemo = optionResultMemo;
    }

    public String getOptionResultDisk() {
        return this.optionResultDisk;
    }

    public void setOptionResultDisk(String optionResultDisk) {
        this.optionResultDisk = optionResultDisk;
    }

    public String getOptionResultDataBase() {
        return this.optionResultDataBase;
    }

    public void setOptionResultDataBase(String optionResultDataBase) {
        this.optionResultDataBase = optionResultDataBase;
    }

    public ISysMonitor getSysMonitorService() {
        return this.sysMonitorService;
    }

    public void setSysMonitorService(ISysMonitor sysMonitorService) {
        this.sysMonitorService = sysMonitorService;
    }
}

