/*
 * Decompiled with CFR 0.152.
 */
package com.hs.vsm.ireportadapter.sendemail;

import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AnonymousContentUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectServiceConst;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.nem.fault.sdk.model.RemoteNotifyServer;
import com.hs.lego.nem.fault.sdk.service.IRemoteNotifyServerService;
import com.hs.vsm.common.sdk.ireport.form.ReportEmailInfoForm;
import com.hs.vsm.common.sdk.ireport.service.IReportEmailInfoService;
import com.hs.vsm.ireportadapter.model.SendEmailForm;
import com.hs.vsm.ireportadapter.sendemail.SendEmailQueue;
import com.hs.vsm.ireportadapter.util.AdapterUtil;
import com.security.ireport.util.IReportMgrUtil;
import java.io.File;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class SendEmailThread
extends Thread {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private static final int SLEEP_TIME = 10000;
    private static final int SLEEP_TIME_SENDEMAIL = 3000;
    private final ExecutorService emailSendPool = Executors.newCachedThreadPool();
    private boolean isAlive = true;

    @Override
    public void run() {
        LOGGER.info((Object)"mailSender Thread run!");
        while (this.isAlive) {
            try {
                this.process();
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)("SendEmailThread InterruptedException error: " + e.getMessage()));
            }
            catch (Exception e) {
                LOGGER.error((Object)("SendEmailThread error: " + e.getMessage()));
            }
        }
        LOGGER.info((Object)"mailSender Thread stop!");
    }

    private void process() {
        if (!SendEmailQueue.isEmpty()) {
            int j = SendEmailQueue.size();
            for (int i = 0; i < j; ++i) {
                ZoneInfoForm zone;
                IZoneService zoneService;
                SendEmailForm sendEmailForm = SendEmailQueue.poll();
                if (null == sendEmailForm) continue;
                LOGGER.info((Object)("task run-> taskId:" + sendEmailForm.getTaskId()));
                ReportEmailInfoForm reportEmailInfoForm = new ReportEmailInfoForm();
                reportEmailInfoForm.setTaskId(sendEmailForm.getTaskId());
                reportEmailInfoForm.setConditionId(sendEmailForm.getConditionId());
                reportEmailInfoForm.setAuthId(sendEmailForm.getAuthId());
                IReportEmailInfoService reportEmailInfoService = AdapterUtil.getReportEmailInfoService();
                if (null == reportEmailInfoService || null == (reportEmailInfoForm = reportEmailInfoService.findByCondition(reportEmailInfoForm))) continue;
                String emailAddress = reportEmailInfoForm.getEmailInfo();
                if (reportEmailInfoForm.getZoneId() > 0L && null != (zoneService = AdapterUtil.getZoneService()) && null != (zone = zoneService.getById(reportEmailInfoForm.getZoneId())) && !"".equals(zone.getEmail())) {
                    emailAddress = zone.getEmail() + ";" + emailAddress;
                }
                if ("".equals(emailAddress)) continue;
                LOGGER.info((Object)("EmailSender start,taskId:" + sendEmailForm.getTaskId()));
                EmailSender mailSender = new EmailSender(emailAddress, sendEmailForm);
                this.emailSendPool.execute(mailSender);
            }
        }
    }

    private String getEmailSignature(String emailSignature) {
        if (AdapterUtil.isNull(emailSignature)) {
            String[] emailSignatureTeam = emailSignature.split("\n");
            StringBuilder temp = new StringBuilder("<span style=\"font-size:12\">");
            for (int i = 0; i < emailSignatureTeam.length; ++i) {
                if (i == emailSignatureTeam.length - 1) {
                    temp.append(emailSignatureTeam[i] + "</span>");
                    return temp.toString();
                }
                temp.append(emailSignatureTeam[i] + "</span><br><span style=\"font-size:12\">");
            }
            return temp.toString();
        }
        return "";
    }

    private void addOperaLog(Boolean sendResult, String emailAddress) {
        ISysOptLog sysOptLogMgr = AdapterUtil.getSysOptLog();
        SysOptLog sysOptLogLego = new SysOptLog();
        sysOptLogLego.setDate(new Date());
        sysOptLogLego.setModule("lego.dic.module.AticAnalysis");
        sysOptLogLego.setOperation("report.commom.sysLog");
        sysOptLogLego.setOperator("system");
        sysOptLogLego.setLevel(SysoplogLevel.info.getValue());
        if (sendResult.booleanValue()) {
            sysOptLogLego.setResult(1);
            sysOptLogLego.setDetail("report.commom.sysLog.success");
            sysOptLogLego.setDetailPara(new String[]{emailAddress});
        } else {
            sysOptLogLego.setResult(0);
            sysOptLogLego.setDetail("report.commom.sysLog.failure");
            sysOptLogLego.setDetailPara(new String[]{emailAddress});
        }
        sysOptLogLego.setTarget(emailAddress);
        sysOptLogLego.setTargetLocal(Boolean.valueOf(false));
        String terminalIp = "127.0.0.1";
        sysOptLogLego.setTerminalIp(terminalIp);
        if (null != sysOptLogMgr) {
            sysOptLogMgr.writeOptLog(sysOptLogLego);
        }
    }

    public void setAlive(boolean isAliv) {
        LOGGER.info((Object)("mailSender isAlive: " + isAliv));
        this.isAlive = isAliv;
    }

    private class EmailSender
    implements Runnable {
        private static final long serialVersionUID = 1L;
        private String emailAddresss;
        private SendEmailForm sendEmailForm;

        public EmailSender(String emailAddresss, SendEmailForm sendEmailForm) {
            this.emailAddresss = emailAddresss;
            this.sendEmailForm = sendEmailForm;
        }

        private String getEmailText(String emailText) {
            String returnText = "";
            returnText = emailText.endsWith(".zip") || emailText.endsWith(".ZIP") ? emailText.substring(0, emailText.length() - ".zip".length()) : emailText;
            return returnText;
        }

        @Override
        public void run() {
            String[] mails;
            Boolean sendResult = false;
            StringBuffer target = new StringBuffer();
            for (String str : mails = this.emailAddresss.split(";")) {
                target.append(AnonymousContentUtil.getAnonymousMailContent((String)str)).append(";");
            }
            try {
                System.setProperty("mail.mime.splitlongparameters", "false");
                JavaMailSenderImpl javaMail = new JavaMailSenderImpl();
                MimeMessage mailMessage = javaMail.createMimeMessage();
                MimeMessageHelper messageHelper = new MimeMessageHelper(mailMessage, true, "GBK");
                IRemoteNotifyServerService remoteNotifyServerService = AdapterUtil.getRemoteNotifyServerService();
                if (null == remoteNotifyServerService) {
                    LOGGER.error((Object)"MessagingException:remoteNotifyServerService is null");
                    SendEmailThread.this.addOperaLog(sendResult, target.substring(0, target.lastIndexOf(";")));
                    return;
                }
                RemoteNotifyServer remoteNotifyServer = remoteNotifyServerService.getRemoteNotifyServer();
                if (null != remoteNotifyServer) {
                    LOGGER.info((Object)("email config host:" + remoteNotifyServer.getServer() + " port:" + remoteNotifyServer.getPort()));
                    javaMail.setHost(remoteNotifyServer.getServer());
                    javaMail.setPort(Integer.parseInt(remoteNotifyServer.getPort()));
                    Properties prop = new Properties();
                    prop.setProperty("mail.smtp.timeout", "60000");
                    if (remoteNotifyServer.isIsValidateEnable()) {
                        prop.setProperty("mail.smtp.auth", "true");
                        javaMail.setUsername(remoteNotifyServer.getUserName());
                        javaMail.setPassword(DataProtectServiceConst.sdpDecryptLocal((String)remoteNotifyServer.getPassword()));
                    }
                    javaMail.setJavaMailProperties(prop);
                    messageHelper.setFrom(remoteNotifyServer.getEmailFrom());
                    String aticMailText = this.getEmailText(null == this.sendEmailForm.getReportName() ? this.sendEmailForm.getReportInfo() : this.sendEmailForm.getReportName());
                    String commonMailText = '[' + AdapterUtil.getText("report.commom.mail.subject") + " " + aticMailText + ']';
                    if ("VSM_ATIC".equalsIgnoreCase(this.sendEmailForm.getAuthId())) {
                        commonMailText = AdapterUtil.getText("report.commom.mail.atic.subject") + aticMailText;
                    }
                    messageHelper.setSubject(commonMailText);
                    messageHelper.setText("<html><head></head><body><h3>" + aticMailText + "</h3>" + SendEmailThread.this.getEmailSignature(remoteNotifyServer.getEmailSignature()) + "</body></html>", true);
                    FileSystemResource file = new FileSystemResource(new File(IReportMgrUtil.getExportPath() + File.separator + this.sendEmailForm.getReportInfo()));
                    String fName = file.getFilename();
                    if (null != this.sendEmailForm.getReportName() && this.sendEmailForm.getReportName().length() > 0) {
                        fName = this.sendEmailForm.getReportName();
                    }
                    String filename = MimeUtility.decodeText((String)fName);
                    filename = filename.replaceAll("\r", "").replaceAll("\n", "");
                    messageHelper.addAttachment(filename, (InputStreamSource)file);
                    String[] emailAdd = this.emailAddresss.split(";");
                    block8: for (int i = 0; i < emailAdd.length; ++i) {
                        String anonyMail = AnonymousContentUtil.getAnonymousContent((String)emailAdd[i]);
                        for (int j = 0; j < 3; ++j) {
                            try {
                                messageHelper.setTo(emailAdd[i]);
                                javaMail.send(mailMessage);
                                sendResult = true;
                                SendEmailThread.this.addOperaLog(sendResult, anonyMail);
                                if (!sendResult.booleanValue()) continue;
                                continue block8;
                            }
                            catch (RuntimeException e) {
                                sendResult = false;
                                int sendEmailTime = j + 1;
                                LOGGER.error((Object)("sendMail email Exception for " + sendEmailTime + " times. " + e.getMessage()));
                                SendEmailThread.this.addOperaLog(sendResult, anonyMail);
                                Thread.sleep(3000L);
                            }
                        }
                    }
                }
            }
            catch (MessagingException e) {
                LOGGER.error((Object)("MessagingException error:" + e.getMessage()));
                SendEmailThread.this.addOperaLog(sendResult, target.substring(0, target.lastIndexOf(";")));
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)("InterruptedException:" + e.getMessage()));
                SendEmailThread.this.addOperaLog(sendResult, target.substring(0, target.lastIndexOf(";")));
            }
            catch (RuntimeException e) {
                LOGGER.error((Object)("unknow Exception:" + e.getMessage()));
                SendEmailThread.this.addOperaLog(sendResult, target.substring(0, target.lastIndexOf(";")));
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exception:" + e.getMessage()));
                SendEmailThread.this.addOperaLog(sendResult, target.substring(0, target.lastIndexOf(";")));
            }
        }
    }
}

