/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.base.dataprotect.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.dataprotect.DataProtector;
import com.hs.lego.core.sdk.base.dataprotect.KmcFiles;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectConfigHelper;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.UnsupportedEncodingException;

public abstract class LegoDataProtector {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_AUTH_ENCRYPT);
    private static final Object LOCK = new Object();
    private static DataProtector dataProtector = null;
    private static DataProtector dataProtectorInit = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetInstanceAndInitInstance() {
        Object object = LOCK;
        synchronized (object) {
            dataProtector = null;
            dataProtectorInit = null;
            LOGGER.info((Object)"reset instance and initInstance");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataProtector getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (null == dataProtector) {
                String libFolderPath = DataProtectConfigHelper.getKmclibPath();
                String sdpConfigRootPath = DataProtectConfigHelper.getKmcConfigRootPath();
                String kmcLogConfigFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue((String)"kmcLogConfigFile");
                String dhP = DataProtectConfigHelper.getConfigValue((String)"dh_p");
                byte[] dhPBytes = new byte[]{};
                try {
                    dhPBytes = dhP.getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e1) {
                    LOGGER.error((Object)("DataProtector: " + e1.getMessage()));
                }
                LOGGER.info((Object)("dhP=" + dhP));
                String dhG = DataProtectConfigHelper.getConfigValue((String)"dh_g");
                byte[] dhGBytes = new byte[]{};
                try {
                    dhGBytes = dhG.getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error((Object)("DataProtector: " + e.getMessage()));
                }
                LOGGER.info((Object)("dhG=" + dhG));
                String keyStoreFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue((String)"keyStoreFile");
                LOGGER.info((Object)"get keyStoreFile success");
                String keyStoreBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue((String)"keyStoreBakFile");
                String kmcCfgFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue((String)"kmcCfgFile");
                String kmcCfgBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue((String)"kmcCfgBakFile");
                KmcFiles kf = new KmcFiles();
                kf.setKeyStoreFile(keyStoreFile);
                kf.setKeyStoreBakFile(keyStoreBakFile);
                kf.setKmcCfgFile(kmcCfgFile);
                kf.setKmcCfgBakFile(kmcCfgBakFile);
                kf.setLogConfigFile(kmcLogConfigFile);
                dataProtector = new DataProtector(libFolderPath, kf, dhPBytes, dhGBytes);
                LOGGER.info((Object)"dataProtector init end");
            }
            return dataProtector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataProtector getInitInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (null == dataProtectorInit) {
                String libFolderPath = DataProtectConfigHelper.getKmclibPath();
                LOGGER.info((Object)"getKmclibPath success");
                String sdpConfigRootPath = DataProtectConfigHelper.getKmcConfigRootPath();
                LOGGER.info((Object)"getKmcConfigRootPath success");
                String kmcLogConfigFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue((String)"kmcLogConfigFile");
                LOGGER.info((Object)"kmcLogConfigFile success");
                String dhP = DataProtectConfigHelper.getConfigValue((String)"dh_p");
                byte[] dhPBytes = new byte[]{};
                try {
                    dhPBytes = dhP.getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error((Object)("DataProtector: " + e.getMessage()));
                }
                LOGGER.info((Object)("dhP=" + dhP));
                String dhG = DataProtectConfigHelper.getConfigValue((String)"dh_g");
                byte[] dhGBytes = new byte[]{};
                try {
                    dhGBytes = dhG.getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error((Object)("DataProtector:" + e.getMessage()));
                }
                LOGGER.info((Object)("dhG=" + dhG));
                String initkeyStoreFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue((String)"init-keyStoreFile");
                String initkeyStoreBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue((String)"init-keyStoreBakFile");
                LOGGER.info((Object)"initkeyStoreFile success");
                String initkmcCfgFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue((String)"init-kmcCfgFile");
                LOGGER.info((Object)"initkeyStoreBakFile success");
                String initkmcCfgBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue((String)"init-kmcCfgBakFile");
                LOGGER.info((Object)"initkmcCfgFile success");
                KmcFiles kfInit = new KmcFiles();
                kfInit.setKeyStoreFile(initkeyStoreFile);
                kfInit.setKeyStoreBakFile(initkeyStoreBakFile);
                kfInit.setKmcCfgFile(initkmcCfgFile);
                kfInit.setKmcCfgBakFile(initkmcCfgBakFile);
                kfInit.setLogConfigFile(kmcLogConfigFile);
                dataProtectorInit = new DataProtector(libFolderPath, kfInit, dhPBytes, dhGBytes);
            }
            return dataProtectorInit;
        }
    }

    public static String sdpEncrypt(long domainId, String pucPlainText) {
        return LegoDataProtector.getInstance().sdpEncrypt(domainId, pucPlainText);
    }

    public static String sdpEncryptLocal(String pucPlainText) {
        return LegoDataProtector.getInstance().sdpEncrypt(0L, pucPlainText);
    }

    public static String sdpEncryptInitData(String pucPlainText) {
        return LegoDataProtector.getInitInstance().sdpEncrypt(0L, pucPlainText);
    }

    public static String sdpDecrypt(long domainId, String pucCipherText) {
        String plainText = LegoDataProtector.getInstance().sdpDecrypt(domainId, pucCipherText);
        if (null == plainText) {
            LOGGER.info((Object)"sdpDecrypt fail,try sdpDecryptInitData.");
            plainText = LegoDataProtector.sdpDecryptInitData(pucCipherText);
            if (null == plainText) {
                LOGGER.error((Object)"sdpDecrypt try decrypt init data fail.");
                LegoDataProtector.resetInstanceAndInitInstance();
            }
        }
        return plainText;
    }

    public static String sdpDecryptLocal(String pucCipherText) {
        return LegoDataProtector.sdpDecrypt(0L, pucCipherText);
    }

    public static String sdpDecryptInitData(String pucCipherText) {
        String plainText = LegoDataProtector.getInitInstance().sdpDecrypt(0L, pucCipherText);
        if (null == plainText) {
            LOGGER.error((Object)"sdpDecryptInitData fail.");
        }
        return plainText;
    }

    public static String sdpProtectPwd(String pucPlainText) {
        return LegoDataProtector.getInstance().sdpProtectPwd(pucPlainText);
    }

    public static String sdpProtectPwdInitData(String pucPlainText) {
        return LegoDataProtector.getInitInstance().sdpProtectPwd(pucPlainText);
    }

    public static boolean sdpVerifyPwd(String pucPlainText, String pucCipherText) {
        boolean result = LegoDataProtector.getInstance().sdpVerifyPwd(pucPlainText, pucCipherText);
        if (!result && !(result = LegoDataProtector.getInitInstance().sdpVerifyPwd(pucPlainText, pucCipherText))) {
            LOGGER.error((Object)"LegoDataProtector sdpVerifyPwd error");
            LegoDataProtector.resetInstanceAndInitInstance();
        }
        return result;
    }

    public static String sdpHmac(String pucPlainText) {
        return LegoDataProtector.getInstance().sdpHmac(pucPlainText);
    }

    public static String sdpEncrypt(long domainId, byte[] pucPlainText) {
        return LegoDataProtector.getInstance().sdpEncrypt(domainId, pucPlainText);
    }

    public static String sdpEncryptLocal(byte[] pucPlainText) {
        return LegoDataProtector.getInstance().sdpEncrypt(0L, pucPlainText);
    }

    public static String sdpEncryptInitData(byte[] pucPlainText) {
        return LegoDataProtector.getInitInstance().sdpEncrypt(0L, pucPlainText);
    }

    public static byte[] sdpDecrypt(String pucCipherText, long domainId) {
        byte[] plainText = LegoDataProtector.getInstance().sdpDecrypt(pucCipherText, domainId);
        if (0 == plainText.length) {
            LOGGER.info((Object)"sdpDecrypt fail,try sdpDecryptInitData.");
            plainText = LegoDataProtector.sdpDecryptInitDataByte(pucCipherText);
            if (0 == plainText.length) {
                LOGGER.error((Object)"LegoDataProtector sdpDecrypt error");
                LegoDataProtector.resetInstanceAndInitInstance();
            }
        }
        return plainText;
    }

    public static byte[] sdpDecryptLocalByte(String pucCipherText) {
        return LegoDataProtector.sdpDecrypt(pucCipherText, 0L);
    }

    public static byte[] sdpDecryptInitDataByte(String pucCipherText) {
        byte[] plainText = LegoDataProtector.getInitInstance().sdpDecrypt(pucCipherText, 0L);
        return plainText;
    }

    public static String sdpProtectPwd(byte[] pucPlainText) {
        return LegoDataProtector.getInstance().sdpProtectPwd(pucPlainText);
    }

    public static String sdpProtectPwdInitData(byte[] pucPlainText) {
        return LegoDataProtector.getInitInstance().sdpProtectPwd(pucPlainText);
    }

    public static boolean sdpVerifyPwd(byte[] pucPlainText, String pucCipherText) {
        boolean result = LegoDataProtector.getInstance().sdpVerifyPwd(pucPlainText, pucCipherText);
        if (!result && !(result = LegoDataProtector.getInitInstance().sdpVerifyPwd(pucPlainText, pucCipherText))) {
            LOGGER.error((Object)"LegoDataProtector sdpVerifyPwd error");
            LegoDataProtector.resetInstanceAndInitInstance();
        }
        return result;
    }

    public static String sdpHmac(byte[] pucPlainText) {
        return LegoDataProtector.getInstance().sdpHmac(pucPlainText);
    }
}

