/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.action;

import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.DataSourceStub;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.sdk.res.service.ILicenseOutboundService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.ui.plat.common.exception.LegoSecurityException;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IZoneMgrNorthSerice;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.CommonUtil;
import com.opensymphony.xwork2.ActionContext;
import com.security.logserver.module.condition.common.BaseAction;
import com.security.logserver.module.condition.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class AnalysisAction
extends BaseAction {
    private static final long serialVersionUID = 7498278516139199774L;
    private transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private String reportType;
    private boolean allDisplay;
    private String deviceId;
    private String zoneId;
    private Long startTime = 0L;
    private Long endTime = 0L;
    private String type;
    private String bisId;
    private String abnormalTime;
    private String endTimeLong;
    private String displayZoneIp;
    private String switchOption;
    private String reportSessionId;
    private Boolean isV1;
    private Boolean isV1Protocl;
    private String bizId;
    private Boolean needNfa;
    private int direction;
    private boolean isSupportOutbound;
    private int attackTypeId;

    public String getReportZoneList() {
        ArrayList<Pair> listZone = new ArrayList<Pair>();
        Pair pairAll = new Pair();
        pairAll.setKey((Object)"0");
        pairAll.setValue((Object)this.getText("atic.analysis.common.all"));
        listZone.add(pairAll);
        List lstZone = null;
        ActionContext ctx = ActionContext.getContext();
        if (null == ctx) {
            this.getOperateResult().setData(listZone);
            return "jsonResult";
        }
        HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        User currentUser = (User)request.getSession().getAttribute("currentUser");
        Boolean isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
        if (this.deviceId.contains("_")) {
            String[] dev = this.deviceId.split("_");
            this.deviceId = dev[0];
        }
        if (null == (lstZone = ReportAnalysisUtil.processStr2Long(this.deviceId) == -1L ? ReportBisUtil.getZoneService().getDeployZoneInfoByDeviceType(Long.valueOf(currentUser.getUserID()), isAdmin, 0) : (ReportAnalysisUtil.processStr2Long(this.deviceId) == -2L ? ReportBisUtil.getZoneService().getDeployZoneInfoByDeviceType(Long.valueOf(currentUser.getUserID()), isAdmin, 1) : ReportBisUtil.getZoneService().getDeployZoneInfoByDeviceId(Long.valueOf(currentUser.getUserID()), isAdmin, ReportAnalysisUtil.processStr2Long(this.deviceId)))) || lstZone.isEmpty()) {
            return "jsonResult";
        }
        for (int i = 0; i < lstZone.size(); ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)((ZoneInfoForm)lstZone.get(i)).getZoneId().toString());
            pair.setValue((Object)((ZoneInfoForm)lstZone.get(i)).getZoneDesc());
            listZone.add(pair);
        }
        this.getOperateResult().setData(listZone);
        return "jsonResult";
    }

    public String getReportTypeList() {
        this.validateGetReportTypeListWithoutXml();
        this.checkDeviceId();
        int deviceType = 0;
        if (this.deviceId.contains("_")) {
            String[] dev = this.deviceId.split("_");
            this.deviceId = dev[0];
            deviceType = ReportAnalysisUtil.processStr2Integer(dev[1]);
        } else if (-1 == ReportAnalysisUtil.processStr2Integer(this.deviceId)) {
            deviceType = 0;
        } else if (-2 == ReportAnalysisUtil.processStr2Integer(this.deviceId)) {
            deviceType = 1;
        } else {
            AticDevice firewall = ReportBisUtil.getIFirewallService().getDeviceByMoid(ReportAnalysisUtil.processStr2Long(this.deviceId).longValue());
            deviceType = ReportAnalysisUtil.getDeviceDdos(firewall);
        }
        ArrayList<Pair> listFluxType = new ArrayList<Pair>();
        String[] arg = null;
        String[] key = null;
        if (0 == deviceType) {
            arg = new String[]{this.getText("atic.analysis.common.flux.in"), this.getText("atic.analysis.common.flux.attack")};
            key = new String[]{"1", "2"};
        } else if (1 == deviceType) {
            arg = new String[]{this.getText("atic.analysis.common.flux.in")};
            key = new String[]{"1"};
        }
        if (null == arg) {
            return "jsonResult";
        }
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listFluxType.add(pair);
        }
        this.getOperateResult().setData(listFluxType);
        return "jsonResult";
    }

    public String getFlowTopnType() {
        this.validateGetReportTypeListWithoutXml();
        this.checkDeviceId();
        int deviceType = 0;
        AticDevice firewall = null;
        if (this.deviceId.contains("_")) {
            String[] dev = this.deviceId.split("_");
            this.deviceId = dev[0];
            deviceType = ReportAnalysisUtil.processStr2Integer(dev[1]);
        } else {
            firewall = ReportBisUtil.getIFirewallService().getDeviceByMoid(ReportAnalysisUtil.processStr2Long(this.deviceId).longValue());
            deviceType = ReportAnalysisUtil.getDeviceDdos(firewall);
        }
        ArrayList<Pair> listFluxType = new ArrayList<Pair>();
        String[] arg = null;
        String[] key = null;
        if (1 == deviceType) {
            arg = new String[]{this.getText("atic.analysis.common.flux.in")};
            key = new String[]{"1"};
        } else if (0 == deviceType) {
            arg = new String[3];
            key = new String[3];
            arg[0] = this.getText("atic.analysis.common.flux.in");
            arg[1] = this.getText("atic.analysis.common.flux.attack");
            arg[2] = this.getText("atic.analysis.common.flux.out");
            key[0] = "1";
            key[1] = "2";
            key[2] = "3";
        }
        if (null == arg) {
            return "jsonResult";
        }
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listFluxType.add(pair);
        }
        this.getOperateResult().setData(listFluxType);
        return "jsonResult";
    }

    public void validateGetReportTypeListWithoutXml() {
        String[] whiteList = new String[]{"deviceId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    public String getUnit2FlowCompare() {
        String regex = "^true|false$";
        if (!String.valueOf(this.isV1Protocl).matches(regex)) {
            this.validateWithoutXml();
        }
        DataSourceStub ds = new DataSourceStub();
        List<Pair<String, String>> unit = ds.getUnit();
        if (this.isV1Protocl.booleanValue()) {
            unit.remove(1);
        }
        this.getOperateResult().setData(unit);
        return "jsonResult";
    }

    public String getUnit2AppFlowCompare() {
        List<Pair<String, String>> unit;
        this.validateGetUnit2AppFlowCompareWithoutXml();
        this.checkBizId();
        DataSourceStub ds = new DataSourceStub();
        this.logger.info((Object)("getUnit2AppFlowCompare bizId = " + this.bizId));
        if (!"key".equalsIgnoreCase(this.bizId) && Long.parseLong(this.bizId) > 0L) {
            ZoneServiceForm zoneServiceForm = ReportBisUtil.getZoneMgrNorthSerice().getBizTypeById(Long.valueOf(this.bizId));
            if ("HTTP".equalsIgnoreCase(zoneServiceForm.getProtocol())) {
                unit = ds.getUnit4AppFlow();
            } else if ("UDP_DNS".equalsIgnoreCase(zoneServiceForm.getProtocol())) {
                unit = ds.getUnit4AppFlow();
                unit.remove(2);
                unit.remove(1);
            } else {
                unit = ds.getUnit4AppFlow();
                unit.remove(2);
            }
        } else if (!"key".equalsIgnoreCase(this.bizId) && -2L == Long.parseLong(this.bizId)) {
            unit = ds.getUnit4AppFlow();
            unit.remove(0);
        } else if (!"key".equalsIgnoreCase(this.bizId) && -3L == Long.parseLong(this.bizId)) {
            unit = ds.getUnit4AppFlow();
            unit.remove(2);
        } else if (!"key".equalsIgnoreCase(this.bizId) && -4L == Long.parseLong(this.bizId)) {
            unit = ds.getUnit4AppFlow();
        } else if (!"key".equalsIgnoreCase(this.bizId) && -5L == Long.parseLong(this.bizId)) {
            unit = ds.getUnit4AppFlow();
        } else {
            unit = ds.getUnit4AppFlow();
            unit.remove(2);
        }
        this.getOperateResult().setData(unit);
        return "jsonResult";
    }

    public String getUnitByAttackType() {
        DataSourceStub ds = new DataSourceStub();
        List<Pair<String, String>> unit = ds.getUnit4AppFlow();
        if (27 == this.attackTypeId) {
            unit.remove(0);
        } else {
            unit.remove(2);
        }
        this.getOperateResult().setData(unit);
        return "jsonResult";
    }

    public void validateGetUnit2AppFlowCompareWithoutXml() {
        String[] whiteList = new String[]{"bizId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    public String getReportTypeCombList() {
        this.validateGetReportTypeCombListWithoutXml();
        this.checkDeviceId();
        ArrayList<Pair> listMaxOrAvgFlux = new ArrayList<Pair>();
        String[] arg = new String[1];
        String[] key = new String[1];
        if (this.deviceId.contains("_")) {
            String[] dev = this.deviceId.split("_");
            this.deviceId = dev[0];
        }
        key[0] = "1";
        arg[0] = this.getText("atic.analysis.common.flux.max");
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listMaxOrAvgFlux.add(pair);
        }
        this.getOperateResult().setData(listMaxOrAvgFlux);
        return "jsonResult";
    }

    public void validateGetReportTypeCombListWithoutXml() {
        String[] whiteList = new String[]{"deviceId", "zoneId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    public String getCountTypeList() {
        this.validateGetCountTypeListWithoutXml();
        this.checkDeviceId();
        DataSourceStub dataSourceStub = new DataSourceStub();
        List<Pair<String, String>> listType = null;
        List<Object> deviceList = new ArrayList();
        if (!AticUtil.isNull((String)this.deviceId)) {
            if (this.deviceId.equals("-1")) {
                deviceList = dataSourceStub.getCleanDeviceList();
            } else {
                AticDevice device = null;
                if (this.deviceId.contains("_")) {
                    String[] deviceIds = this.deviceId.split("_");
                    device = ReportBisUtil.getIFirewallService().getDeviceByMoid(Long.parseLong(deviceIds[0]));
                } else {
                    device = ReportBisUtil.getIFirewallService().getDeviceByMoid(Long.parseLong(this.deviceId));
                }
                if (null != device) {
                    deviceList.add(device);
                }
            }
        }
        listType = CommonUtil.includesV1R1(deviceList) ? dataSourceStub.getCountTypeListOfV1R1() : dataSourceStub.getCountTypeList();
        this.getOperateResult().setData(listType);
        return "jsonResult";
    }

    public void validateGetCountTypeListWithoutXml() {
        String[] whiteList = new String[]{"deviceId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    public String getAttackLogTypeList() {
        this.validateGetAttackLogTypeListWithoutXml();
        this.checkDeviceId();
        DataSourceStub dataSourceStub = new DataSourceStub();
        List<Object> listType = new ArrayList();
        if (!AticUtil.isNull((String)this.deviceId)) {
            boolean isClean = false;
            if (this.deviceId.contains("_") && this.deviceId.split("_")[1].equals("0")) {
                isClean = true;
            }
            if (isClean) {
                listType = dataSourceStub.getAttackLogType();
            } else {
                String[] arg = new String[1];
                String[] key = new String[]{"1"};
                arg[0] = this.getText("atic.analysis.report.log.type.abnormal");
                Pair pair = new Pair();
                pair.setKey((Object)key[0]);
                pair.setValue((Object)arg[0]);
                listType.add(pair);
            }
        }
        this.getOperateResult().setData(listType);
        return "jsonResult";
    }

    public String getAttackLogTypeDistributeList() {
        this.validateGetAttackLogTypeListWithoutXml();
        this.checkDeviceId();
        DataSourceStub dataSourceStub = new DataSourceStub();
        List<Object> listType = new ArrayList();
        if (!AticUtil.isNull((String)this.deviceId)) {
            boolean isClean = false;
            if (this.deviceId.contains("_") && this.deviceId.split("_")[1].equals("0")) {
                isClean = true;
            }
            if (isClean) {
                listType = dataSourceStub.getAttackTypeDistribute();
            } else {
                String[] arg = new String[1];
                String[] key = new String[]{"1"};
                arg[0] = this.getText("atic.analysis.report.log.type.abnormal");
                Pair pair = new Pair();
                pair.setKey((Object)key[0]);
                pair.setValue((Object)arg[0]);
                listType.add(pair);
            }
        }
        this.getOperateResult().setData(listType);
        return "jsonResult";
    }

    public void validateGetAttackLogTypeListWithoutXml() {
        String[] whiteList = new String[]{"deviceId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    private List<Pair<String, String>> getReportBisList4Common(String reportTypeStr) {
        ArrayList<Pair<String, String>> reuturnList = new ArrayList<Pair<String, String>>();
        Pair pairAll = new Pair();
        pairAll.setKey((Object)"0");
        pairAll.setValue((Object)this.getText("atic.analysis.common.all"));
        reuturnList.add(pairAll);
        if (this.deviceId.contains("_")) {
            String[] dev = this.deviceId.split("_");
            this.deviceId = dev[0];
        }
        List listForm = new ArrayList();
        try {
            if (ReportAnalysisUtil.processStr2Long(this.deviceId) > 0L) {
                listForm = ReportBisUtil.getZoneMgrNorthSerice().getBizByZoneId(ReportAnalysisUtil.processStr2Long(this.zoneId), ReportAnalysisUtil.processStr2Long(this.deviceId));
            } else {
                String ddosType = "";
                if (-1 == ReportAnalysisUtil.processStr2Integer(this.deviceId)) {
                    ddosType = String.valueOf(0);
                } else if (-2 == ReportAnalysisUtil.processStr2Integer(this.deviceId)) {
                    ddosType = String.valueOf(1);
                }
                listForm = ReportBisUtil.getZoneMgrNorthSerice().getBizByZoneId(ReportAnalysisUtil.processStr2Long(this.zoneId), ddosType);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("get serive or seriveGroup error," + e.getMessage()));
        }
        this.addBizListToReturnList(listForm, reuturnList, reportTypeStr);
        return reuturnList;
    }

    private void addBizListToReturnList(List<ZoneServiceForm> listForm, List<Pair<String, String>> list, String reportTypeStr) {
        for (ZoneServiceForm form : listForm) {
            if ("common".equals(reportTypeStr) && !"DEFAULT".equalsIgnoreCase(form.getProtocol())) {
                this.addBizDataToBizList(list, form);
                continue;
            }
            if ("conn".equals(reportTypeStr)) {
                if (!AnalysisConstants.getConnBizTypeList().contains(form.getProtocol())) continue;
                this.addBizDataToBizList(list, form);
                continue;
            }
            if ("dns".equals(reportTypeStr)) {
                if (!"TCP_DNS".equalsIgnoreCase(form.getProtocol()) && !"UDP_DNS".equalsIgnoreCase(form.getProtocol())) continue;
                this.addBizDataToBizList(list, form);
                continue;
            }
            if (!"udp_dns".equals(reportTypeStr) || !"UDP_DNS".equalsIgnoreCase(form.getProtocol())) continue;
            this.addBizDataToBizList(list, form);
        }
    }

    private void addBizDataToBizList(List<Pair<String, String>> list, ZoneServiceForm form) {
        AticDevice firewall;
        String deviceIpString = "";
        if (ReportAnalysisUtil.processStr2Long(this.deviceId) < 0L && null != (firewall = ReportBisUtil.getIFirewallService().getDeviceByMoid(form.getDeviceId().longValue()))) {
            deviceIpString = "(" + firewall.getIpAddress() + ")";
        }
        Pair tmp = new Pair();
        tmp.setKey((Object)(form.getPkid().toString() + "_" + "service"));
        tmp.setValue((Object)(form.getServiceName() + deviceIpString));
        list.add((Pair<String, String>)tmp);
    }

    public String getReportBisList() {
        this.validateGetReportBisListWithoutXml();
        this.checkZoneId();
        this.checkDeviceId();
        List<Pair<String, String>> list = this.getReportBisList4Common("common");
        this.getOperateResult().setData(list);
        return "jsonResult";
    }

    public void validateGetReportBisListWithoutXml() {
        String[] whiteList = new String[]{"zoneId", "deviceId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    public String getReportBisList4App() {
        this.validateGetReportBisList4AppWithoutXml();
        this.checkZoneId();
        this.checkDeviceId();
        if (this.deviceId.contains("_")) {
            String[] dev = this.deviceId.split("_");
            this.deviceId = dev[0];
        }
        DataSourceStub dataSourceStub = new DataSourceStub();
        List<Pair<String, String>> temp = dataSourceStub.getBisListForApp();
        ArrayList<Object> returnList = new ArrayList<Object>();
        if (AticUtil.isNull((String)this.zoneId)) {
            returnList.addAll(temp);
        } else {
            List bizList = ReportBisUtil.getZoneMgrNorthSerice().getBizByZoneId(ReportAnalysisUtil.processStr2Long(this.zoneId), ReportAnalysisUtil.processStr2Long(this.deviceId));
            ArrayList<Pair> bizPairList = new ArrayList<Pair>();
            for (ZoneServiceForm form : bizList) {
                if (form.getProtocol().equalsIgnoreCase("DEFAULT")) continue;
                Pair tmp = new Pair();
                tmp.setKey((Object)form.getPkid().toString());
                tmp.setValue((Object)form.getServiceName());
                bizPairList.add(tmp);
            }
            returnList.addAll(temp);
            returnList.addAll(bizPairList);
        }
        this.getOperateResult().setData(returnList);
        return "jsonResult";
    }

    public void validateGetReportBisList4AppWithoutXml() {
        String[] whiteList = new String[]{"deviceId", "zoneId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    public String getBisType() {
        this.validateGetBisTypeWithoutXml();
        this.checkBisId();
        Boolean isUdpDns = false;
        if ("key".equalsIgnoreCase(this.bisId)) {
            this.getOperateResult().setData((Object)isUdpDns);
            return "jsonResult";
        }
        if ("-4".equals(this.bisId)) {
            isUdpDns = true;
        } else {
            String bizType = ReportAnalysisUtil.processBizParam(Long.parseLong(this.bisId));
            if ("UDP_DNS".equalsIgnoreCase(bizType)) {
                isUdpDns = true;
            }
        }
        this.getOperateResult().setData((Object)isUdpDns);
        return "jsonResult";
    }

    public void validateGetBisTypeWithoutXml() {
        String[] whiteList = new String[]{"bisId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    public String checkBisTypeIsOther() {
        this.validateCheckBisTypeIsOtherWithoutXml();
        this.checkBisId();
        Boolean isOther = false;
        if ("key".equalsIgnoreCase(this.bisId)) {
            this.getOperateResult().setData((Object)isOther);
            return "jsonResult";
        }
        String bizType = ReportAnalysisUtil.processBizParam(Long.parseLong(this.bisId));
        if ("Other".equalsIgnoreCase(bizType)) {
            isOther = true;
        }
        this.getOperateResult().setData((Object)isOther);
        return "jsonResult";
    }

    public void validateCheckBisTypeIsOtherWithoutXml() {
        String[] whiteList = new String[]{"bisId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    public String getReportBisListOfConn() {
        this.validateGetReportBisListOfConnWithoutXml();
        this.checkZoneId();
        this.checkDeviceId();
        List<Pair<String, String>> list = this.getReportBisList4Common("conn");
        this.getOperateResult().setData(list);
        return "jsonResult";
    }

    public void validateGetReportBisListOfConnWithoutXml() {
        String[] whiteList = new String[]{"deviceId", "zoneId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    public String getReportBisList4DNS() {
        this.validateGetReportBisList4DNSWithoutXml();
        this.checkZoneId();
        this.checkDeviceId();
        List<Pair<String, String>> list = this.getReportBisList4Common("dns");
        this.getOperateResult().setData(list);
        return "jsonResult";
    }

    public void validateGetReportBisList4DNSWithoutXml() {
        String[] whiteList = new String[]{"deviceId", "zoneId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    public String getReportBisList4UDPDNS() {
        this.validateGetReportBisList4UDPDNSWithoutXml();
        this.checkZoneId();
        this.checkDeviceId();
        List<Pair<String, String>> list = this.getReportBisList4Common("udp_dns");
        this.getOperateResult().setData(list);
        return "jsonResult";
    }

    public void validateGetReportBisList4UDPDNSWithoutXml() {
        String[] whiteList = new String[]{"zoneId", "deviceId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    public String getReportProtocolList() {
        this.validateGetReportProtocolListWithoutXml();
        this.checkBisId();
        String serviceType = "";
        if (this.bisId.contains("_")) {
            String[] biz = this.bisId.split("_");
            this.bisId = biz[0];
            serviceType = biz[1];
        }
        List<Pair<String, String>> list = null;
        if (ReportAnalysisUtil.processStr2Long(this.bisId) == 0L) {
            list = this.processTotalBiz();
        } else if ("service".equals(serviceType)) {
            list = this.dealSingleService();
        } else {
            String[] arg = null;
            String[] key = null;
            arg = new String[1];
            key = new String[1];
            arg[0] = this.getText("atic.analysis.common.all");
            key[0] = "0";
            list = this.processBizPair(arg, key);
        }
        this.getOperateResult().setData(list);
        return "jsonResult";
    }

    public void validateGetReportProtocolListWithoutXml() {
        String[] whiteList = new String[]{"bisId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    private List<Pair<String, String>> processTotalBiz() {
        String[] arg = null;
        String[] key = null;
        arg = new String[5];
        key = new String[5];
        this.processArgKeyData(arg, key);
        List<Pair<String, String>> list = this.processBizPair(arg, key);
        return list;
    }

    private List<Pair<String, String>> dealSingleService() {
        String[] arg = null;
        String[] key = null;
        ZoneServiceForm form = ReportBisUtil.getZoneMgrNorthSerice().getBizTypeById(ReportAnalysisUtil.processStr2Long(this.bisId));
        if (null != form) {
            this.logger.info((Object)("policy return bis_type:" + form.toString()));
            if ("DEFAULT".equals(form.getProtocol())) {
                arg = new String[5];
                key = new String[5];
                this.processArgKeyData(arg, key);
            } else {
                arg = new String[1];
                key = new String[1];
                arg[0] = form.getProtocol();
                key[0] = form.getProtocol();
            }
        } else {
            arg = new String[1];
            key = new String[1];
            arg[0] = this.getText("atic.analysis.common.all");
            key[0] = "0";
        }
        List<Pair<String, String>> list = this.processBizPair(arg, key);
        return list;
    }

    private List<Pair<String, String>> processBizPair(String[] arg, String[] key) {
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            list.add((Pair<String, String>)pair);
        }
        return list;
    }

    private void processArgKeyData(String[] arg, String[] key) {
        arg[0] = this.getText("atic.analysis.common.all");
        arg[1] = this.getText("atic.analysis.common.protocol.tcp");
        arg[2] = this.getText("atic.analysis.common.protocol.udp");
        arg[3] = this.getText("atic.analysis.common.protocol.icmp");
        arg[4] = this.getText("atic.analysis.common.protocol.other");
        key[0] = "0";
        key[1] = "1";
        key[2] = "2";
        key[3] = "3";
        key[4] = "4";
    }

    public String getDeviceVersionAndTypeByCombId() {
        this.validateGetDeviceVersionAndTypeByCombIdWithoutXml();
        this.checkDeviceId();
        if ("key".equalsIgnoreCase(this.deviceId)) {
            return "jsonResult";
        }
        if (this.deviceId.contains("_")) {
            String[] dev = this.deviceId.split("_");
            this.deviceId = dev[0];
            if (this.validateDevice()) {
                if ("0".equals(dev[1])) {
                    this.getOperateResult().setData((Object)"includeV1R1Clean");
                } else {
                    this.getOperateResult().setData((Object)"includeV1R1Detect");
                }
            } else {
                IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
                AticDevice firewall = firewallService.getDeviceByMoid(ReportAnalysisUtil.processStr2Long(this.deviceId).longValue());
                if (null != firewall && (8 == firewall.getDeviceType() || 9 == firewall.getDeviceType())) {
                    this.getOperateResult().setData((Object)firewall.getDeviceType());
                } else {
                    this.getOperateResult().setData((Object)ReportAnalysisUtil.processStr2Integer(dev[1]));
                }
            }
            return "jsonResult";
        }
        if (!AticUtil.isNull((String)this.deviceId)) {
            IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
            Long deviceIdLong = ReportAnalysisUtil.processStr2Long(this.deviceId);
            if (-1L == deviceIdLong) {
                this.getOperateResult().setData((Object)0);
            } else if (-2L == deviceIdLong) {
                this.getOperateResult().setData((Object)1);
            } else {
                AticDevice firewall = firewallService.getDeviceByMoid(ReportAnalysisUtil.processStr2Long(this.deviceId).longValue());
                if (null != firewall) {
                    if (this.validateDevice()) {
                        if (0 == firewall.getDdosType()) {
                            this.getOperateResult().setData((Object)"includeV1R1Clean");
                        } else {
                            this.getOperateResult().setData((Object)"includeV1R1Detect");
                        }
                    } else {
                        this.getOperateResult().setData((Object)ReportAnalysisUtil.getDeviceDdos(firewall));
                    }
                }
            }
        }
        return "jsonResult";
    }

    public void validateGetDeviceVersionAndTypeByCombIdWithoutXml() {
        String[] whiteList = new String[]{"deviceId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    public String getDeviceTypeByCombId() {
        this.validateGetDeviceTypeByCombIdWithoutXml();
        this.checkDeviceId();
        if ("key".equalsIgnoreCase(this.deviceId)) {
            return "jsonResult";
        }
        if (this.deviceId.contains("_")) {
            String[] dev = this.deviceId.split("_");
            this.deviceId = dev[0];
            this.getOperateResult().setData((Object)ReportAnalysisUtil.processStr2Integer(dev[1]));
            return "jsonResult";
        }
        if (!AticUtil.isNull((String)this.deviceId)) {
            IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
            Long deviceIdLong = ReportAnalysisUtil.processStr2Long(this.deviceId);
            if (-1L == deviceIdLong) {
                this.getOperateResult().setData((Object)0);
            } else if (-2L == deviceIdLong) {
                this.getOperateResult().setData((Object)1);
            } else {
                AticDevice firewall = firewallService.getDeviceByMoid(ReportAnalysisUtil.processStr2Long(this.deviceId).longValue());
                if (null != firewall) {
                    this.getOperateResult().setData((Object)ReportAnalysisUtil.getDeviceDdos(firewall));
                }
            }
        }
        return "jsonResult";
    }

    public void validateGetDeviceTypeByCombIdWithoutXml() {
        String[] whiteList = new String[]{"deviceId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    private void validateWithoutXml() {
        User user = (User)this.fetchRequest().getSession().getAttribute("currentUser");
        SysOptLog optLogPo = new SysOptLog();
        optLogPo.setOperation("lego.err.error");
        optLogPo.setModule("lego.dic.module.user");
        optLogPo.setLevel(SysoplogLevel.warning.getValue());
        optLogPo.setOperator(user.getUserName().trim());
        optLogPo.setTerminalIp(user.getIpAdr());
        optLogPo.setResult(0);
        optLogPo.setTarget("lego.common.paramerror");
        optLogPo.setTargetLocal(Boolean.valueOf(true));
        optLogPo.setDetail("lego.err.dataerror");
        ISysOptLog sysOptLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
        sysOptLog.writeOptLog(optLogPo);
        this.fetchRequest().getSession().invalidate();
        throw new LegoSecurityException(206L);
    }

    private boolean validateDevice() {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(ReportAnalysisUtil.processStr2Long(this.deviceId).longValue());
        if (null != firewall && 8 == firewall.getDeviceType()) {
            return false;
        }
        ArrayList<AticDevice> deviceList = new ArrayList<AticDevice>();
        if (null != firewall) {
            deviceList.add(firewall);
        }
        return CommonUtil.includesV1R1(deviceList);
    }

    public String getV1VersionBydeviceId() {
        this.validateGetV1VersionBydeviceIdWithoutXml();
        this.checkDeviceId();
        DataSourceStub dataSourceStub = new DataSourceStub();
        String version = null;
        List<Object> deviceList = new ArrayList();
        if (!AticUtil.isNull((String)this.deviceId)) {
            if (this.deviceId.equals("-1")) {
                deviceList = dataSourceStub.getCleanDeviceList();
            } else {
                AticDevice device = null;
                if (this.deviceId.contains("_")) {
                    String[] deviceIds = this.deviceId.split("_");
                    device = ReportBisUtil.getIFirewallService().getDeviceByMoid(Long.parseLong(deviceIds[0]));
                } else {
                    device = ReportBisUtil.getIFirewallService().getDeviceByMoid(Long.parseLong(this.deviceId));
                }
                if (null != device) {
                    deviceList.add(device);
                }
            }
        }
        version = CommonUtil.includesV1R1(deviceList) ? "1" : "0";
        this.getOperateResult().setData((Object)version);
        return "jsonResult";
    }

    public void validateGetV1VersionBydeviceIdWithoutXml() {
        String[] whiteList = new String[]{"deviceId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    public String getProtocolByBisId() {
        Boolean isV1Bool = false;
        String serviceType = "";
        if (this.bisId.contains("_")) {
            String[] biz = this.bisId.split("_");
            this.bisId = biz[0];
            serviceType = biz[1];
        }
        if (AticUtil.isNull((String)this.bisId) || !this.bisId.matches("^[\\d]*$")) {
            return "jsonResult";
        }
        List<Object> result = new ArrayList();
        if (0L == ReportAnalysisUtil.processStr2Long(this.bisId)) {
            result = ReportAnalysisUtil.processDafaultBizPro(isV1Bool, this.zoneId, this.displayZoneIp);
        } else if ("service".equals(serviceType)) {
            IZoneMgrNorthSerice zoneMgrNorthSerice = ReportAnalysisUtil.getZoneMgrNorthSerice();
            String bizType = zoneMgrNorthSerice.getBizTypeById(ReportAnalysisUtil.processStr2Long(this.bisId)).getProtocol();
            if ("DEFAULT".equalsIgnoreCase(bizType)) {
                result.addAll(ReportAnalysisUtil.processDafaultBizPro(isV1Bool, this.zoneId, this.displayZoneIp));
            } else {
                result.addAll((Collection<Object>)ReportAnalysisUtil.getBizType2ProtocolTypeMap(isV1Bool).get(AnalysisConstants.getBizToId().get(bizType)));
            }
        }
        this.getOperateResult().setData(result);
        return "jsonResult";
    }

    public String getDeviceVersionByCombId() {
        this.getOperateResult().setData((Object)this.getDeviceVersionById(this.deviceId));
        return "jsonResult";
    }

    private Boolean getDeviceVersionById(String deviceID) {
        if (!AticUtil.isNull((String)deviceID)) {
            if (deviceID.contains("_")) {
                String[] dev = deviceID.split("_");
                deviceID = dev[0];
            }
            if (-1 == ReportAnalysisUtil.processStr2Integer(deviceID) || -2 == ReportAnalysisUtil.processStr2Integer(deviceID)) {
                return false;
            }
            AticDevice firewall = ReportBisUtil.getIFirewallService().getDeviceByMoid(ReportAnalysisUtil.processStr2Long(deviceID).longValue());
            return ReportAnalysisUtil.isV1(firewall);
        }
        return false;
    }

    public String getAllSelectType() {
        this.validateGetAllSelectTypeWithoutXml();
        this.checkBisId();
        this.checkZoneId();
        this.checkDeviceId();
        DataSourceStub dataSourceStub = new DataSourceStub();
        String serviceType = "";
        ArrayList<Pair<String, String>> selectTypeList = new ArrayList<Pair<String, String>>(dataSourceStub.getSelectType());
        if (this.deviceId.contains("_")) {
            String[] dev = this.deviceId.split("_");
            this.deviceId = dev[0];
        }
        if (this.bisId.contains("_")) {
            String[] biz = this.bisId.split("_");
            this.bisId = biz[0];
            serviceType = biz[1];
        }
        if (ReportAnalysisUtil.processStr2Long(this.deviceId) > 0L && ReportAnalysisUtil.processStr2Long(this.zoneId) > 0L) {
            IZoneMgrNorthSerice zoneMgrNorthSerice = ReportAnalysisUtil.getZoneMgrNorthSerice();
            Map userDefineDNS = null;
            userDefineDNS = "service".equals(serviceType) ? zoneMgrNorthSerice.getUserDefDnsTypeCode(ReportAnalysisUtil.processStr2Long(this.deviceId), Long.valueOf(this.zoneId), Long.valueOf(this.bisId)) : zoneMgrNorthSerice.getUserDefDnsTypeCode(ReportAnalysisUtil.processStr2Long(this.deviceId), Long.valueOf(this.zoneId), Long.valueOf(0L));
            if (null != userDefineDNS && !userDefineDNS.isEmpty()) {
                for (Map.Entry entry : userDefineDNS.entrySet()) {
                    Pair pair = new Pair();
                    pair.setKey((Object)((Long)entry.getKey()).toString());
                    pair.setValue(entry.getValue());
                    selectTypeList.add((Pair<String, String>)pair);
                }
            }
        }
        this.getOperateResult().setData(selectTypeList);
        return "jsonResult";
    }

    public void validateGetAllSelectTypeWithoutXml() {
        String[] whiteList = new String[]{"bisId", "zoneId", "deviceId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    public String getReportTypeList4FlowCompare() {
        this.validateGetReportTypeList4FlowCompareWithoutXml();
        this.checkDeviceId();
        ArrayList<Pair> listMaxOrAvgConn = new ArrayList<Pair>();
        String[] arg = null;
        String[] key = null;
        if (this.deviceId.contains("_")) {
            String[] dev = this.deviceId.split("_");
            this.deviceId = dev[0];
        }
        if (ReportAnalysisUtil.processStr2Long(this.deviceId) > 0L && ReportAnalysisUtil.processStr2Long(this.zoneId) > 0L) {
            arg = new String[2];
            key = new String[]{"1", "2"};
            arg[0] = this.getText("atic.analysis.common.flux.max");
            arg[1] = this.getText("atic.analysis.common.flux.avg");
        } else {
            arg = new String[1];
            key = new String[]{"2"};
            arg[0] = this.getText("atic.analysis.common.flux.avg");
        }
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listMaxOrAvgConn.add(pair);
        }
        this.getOperateResult().setData(listMaxOrAvgConn);
        return "jsonResult";
    }

    public void validateGetReportTypeList4FlowCompareWithoutXml() {
        String[] whiteList = new String[]{"deviceId", "zoneId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    public String getReportTypeListOfConn() {
        this.validateGetReportTypeListOfConnWithoutXml();
        this.checkDeviceId();
        ArrayList<Pair> listMaxOrAvgConn = new ArrayList<Pair>();
        String[] arg = null;
        String[] key = null;
        if (this.deviceId.contains("_")) {
            String[] dev = this.deviceId.split("_");
            this.deviceId = dev[0];
        }
        if (ReportAnalysisUtil.processStr2Long(this.deviceId) > 0L && ReportAnalysisUtil.processStr2Long(this.zoneId) > 0L) {
            arg = new String[2];
            key = new String[]{"1", "2"};
            arg[0] = this.getText("atic.analysis.common.flux.max");
            arg[1] = this.getText("atic.analysis.common.flux.avg");
        } else {
            arg = new String[1];
            key = new String[]{"2"};
            arg[0] = this.getText("atic.analysis.common.flux.avg");
        }
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listMaxOrAvgConn.add(pair);
        }
        this.getOperateResult().setData(listMaxOrAvgConn);
        return "jsonResult";
    }

    public void validateGetReportTypeListOfConnWithoutXml() {
        String[] whiteList = new String[]{"deviceId", "zoneId"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    public String getDeviceList() {
        String regex = "^true|false$";
        if (null == this.needNfa || !String.valueOf(this.needNfa).matches(regex)) {
            this.validateWithoutXml();
        }
        this.validateGetDeviceListWithoutXml();
        DataSourceStub dataSourceStub = new DataSourceStub();
        List<Pair<String, String>> deviList = null;
        deviList = this.needNfa != false ? dataSourceStub.getDeviceListAndNFA() : dataSourceStub.getDeviceList();
        this.getOperateResult().setData(deviList);
        return "jsonResult";
    }

    public void validateGetDeviceListWithoutXml() {
        String[] whiteList = new String[]{"needNfa", "topNReportType"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    public void checkDeviceId() {
        block11: {
            try {
                if (null == this.deviceId || this.deviceId.length() <= 0) break block11;
                if (!this.deviceId.equals("-1") && !AticUtil.validateSpecialStr((String)this.deviceId)) {
                    this.validateWithoutXml();
                }
                if ("key".equalsIgnoreCase(this.deviceId)) break block11;
                String deviceIdStr = null;
                if (this.deviceId.contains("_")) {
                    String[] dev = this.deviceId.split("_");
                    deviceIdStr = dev[0];
                }
                try {
                    if (null == deviceIdStr) {
                        if (Long.parseLong(this.deviceId) < -2000L) {
                            this.validateWithoutXml();
                        }
                    } else if (Long.parseLong(deviceIdStr) < -2000L) {
                        this.validateWithoutXml();
                    }
                }
                catch (NumberFormatException e) {
                    this.validateWithoutXml();
                }
            }
            catch (NumberFormatException e) {
                this.validateWithoutXml();
            }
            catch (RuntimeException e) {
                this.validateWithoutXml();
            }
        }
    }

    public void checkBisId() {
        try {
            if (!AticUtil.validateSpecialStr((String)this.bisId)) {
                this.validateWithoutXml();
            }
            if (!"key".equalsIgnoreCase(this.bisId)) {
                if (this.bisId.contains("_")) {
                    String[] dev = this.bisId.split("_");
                    this.bisId = dev[0];
                }
                if (Long.parseLong(this.bisId) < -2000L) {
                    this.validateWithoutXml();
                }
            }
        }
        catch (NumberFormatException e) {
            this.validateWithoutXml();
        }
        catch (RuntimeException e) {
            this.validateWithoutXml();
        }
    }

    public void checkBizId() {
        try {
            if ("key".equalsIgnoreCase(this.bizId)) {
                return;
            }
            if (Long.parseLong(this.bizId) < -2000L) {
                this.validateWithoutXml();
            }
        }
        catch (NumberFormatException e) {
            this.validateWithoutXml();
        }
        catch (RuntimeException e) {
            this.validateWithoutXml();
        }
    }

    public void checkReportType() {
        if (!this.reportType.matches("^[A-Za-z0-9_-]{1,30}$")) {
            this.validateWithoutXml();
        }
    }

    public void checkZoneId() {
        if (!this.zoneId.equals("")) {
            try {
                if (Long.parseLong(this.zoneId) < 0L) {
                    this.validateWithoutXml();
                }
            }
            catch (NumberFormatException ew) {
                this.validateWithoutXml();
            }
            catch (RuntimeException e) {
                this.validateWithoutXml();
            }
        }
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public String getType() {
        return this.type;
    }

    public String showDnsAnalysisReport() {
        this.getReportTypeResult();
        return "list";
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getBisId() {
        return this.bisId;
    }

    public void setBisId(String bisId) {
        this.bisId = bisId;
    }

    public String getAbnormalTime() {
        return this.abnormalTime;
    }

    public void setAbnormalTime(String abnormalTime) {
        this.abnormalTime = abnormalTime;
    }

    public String getEndTimeLong() {
        return this.endTimeLong;
    }

    public void setEndTimeLong(String endTimeLong) {
        this.endTimeLong = endTimeLong;
    }

    public String getDisplayZoneIp() {
        return this.displayZoneIp;
    }

    public void setDisplayZoneIp(String displayZoneIp) {
        this.displayZoneIp = displayZoneIp;
    }

    public String getSwitchOption() {
        return this.switchOption;
    }

    public void setSwitchOption(String switchOption) {
        this.switchOption = switchOption;
    }

    public String getReportSessionId() {
        return this.reportSessionId;
    }

    public void setReportSessionId(String reportSessionId) {
        this.reportSessionId = reportSessionId;
    }

    public String showFluxAnalysisReport() {
        this.getReportTypeResult();
        this.setIsSupportOutbound();
        return "list";
    }

    private void setIsSupportOutbound() {
        ILicenseOutboundService licenseOutboundService = ReportBisUtil.getLicenseOutboundService();
        this.isSupportOutbound = licenseOutboundService.isSupportOutbound();
        HttpServletRequest request = (HttpServletRequest)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        request.getSession().setAttribute("isSupportOutbound", (Object)this.isSupportOutbound);
    }

    public String showHttpAnalysisReport() {
        return "list";
    }

    private String getReportTypeResult() {
        String result = "list";
        if ("ips".equalsIgnoreCase(this.getReportType())) {
            this.setAllDisplay(false);
            if (!"ips".equalsIgnoreCase(AnalysisConstants.getInstance().getReportType())) {
                AnalysisConstants.getInstance().setReportType("ips");
            }
        } else if ("ipsReport".equalsIgnoreCase(this.getReportType())) {
            this.setAllDisplay(false);
            if (!"ips".equalsIgnoreCase(AnalysisConstants.getInstance().getReportType())) {
                AnalysisConstants.getInstance().setReportType("ips");
            }
            AnalysisConstants.getInstance().setReportTypeIpsReport(true);
            result = "ipsReport";
        } else {
            this.setAllDisplay(true);
            if (!"atic".equalsIgnoreCase(AnalysisConstants.getInstance().getReportType())) {
                AnalysisConstants.getInstance().setReportType("atic");
            }
        }
        return result;
    }

    public void validateGetReportTopNTypeListWithoutXml() {
        String[] whiteList = new String[]{"direction"};
        if (!AticUtil.validateParameterNames((HttpServletRequest)this.fetchRequest(), (String[])whiteList)) {
            this.validateWithoutXml();
        }
    }

    public String getReportTopnType() {
        this.validateGetReportTopNTypeListWithoutXml();
        String regex = "^(0|1|2)$";
        if (!String.valueOf(this.direction).matches(regex)) {
            this.validateWithoutXml();
        }
        DataSourceStub ds = new DataSourceStub();
        List<Pair<String, String>> reportTopnType = ds.getReportTopnType();
        if (2 == this.direction) {
            reportTopnType.remove(1);
        }
        this.getOperateResult().setData(reportTopnType);
        return "jsonResult";
    }

    public String showAttackAnalysisReport() {
        String returnPage = this.getReportTypeResult();
        this.setIsSupportOutbound();
        return returnPage;
    }

    public Boolean getIsV1() {
        return this.isV1;
    }

    public void setIsV1(Boolean isV1) {
        this.isV1 = isV1;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Boolean getIsV1Protocl() {
        return this.isV1Protocl;
    }

    public void setIsV1Protocl(Boolean isV1Protocl) {
        this.isV1Protocl = isV1Protocl;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void setReportType(String reportType) {
        this.reportType = reportType;
    }

    public boolean isAllDisplay() {
        return this.allDisplay;
    }

    public void setAllDisplay(boolean allDisplay) {
        this.allDisplay = allDisplay;
    }

    public String getBizId() {
        return this.bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Boolean getNeedNfa() {
        return this.needNfa;
    }

    public void setNeedNfa(Boolean needNfa) {
        this.needNfa = needNfa;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int getAttackTypeId() {
        return this.attackTypeId;
    }

    public void setAttackTypeId(int attackTypeId) {
        this.attackTypeId = attackTypeId;
    }

    public boolean validateBatchBatchDeviceId() {
        if (null == this.deviceId) {
            return false;
        }
        try {
            if (Long.parseLong(this.deviceId.trim()) < 0L) {
                return false;
            }
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public String getReportTypeListByDirection() {
        ArrayList<Pair> listFluxType = new ArrayList<Pair>();
        String[] arg = new String[2];
        String[] key = new String[]{"2", "0"};
        arg[0] = this.getText("atic.analysis.report.tab.ipAttackTopN");
        arg[1] = this.getText("atic.analysis.report.tab.zoneAttackTopN");
        for (int i = 0; i < arg.length; ++i) {
            Pair pair = new Pair();
            pair.setKey((Object)key[i]);
            pair.setValue((Object)arg[i]);
            listFluxType.add(pair);
        }
        this.getOperateResult().setData(listFluxType);
        return "jsonResult";
    }
}

