/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.action;

import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ZoneInfoQueryBean;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.sdk.bis.form.IpLocation;
import com.hs.atic.sdk.bis.service.ILibraryFileService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticConstants;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.ui.plat.common.webapp.action.BaseAction;
import com.hs.vsm.secservice.sdk.module.ddos.form.FilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.form.NPFilterForm;
import com.hs.vsm.secservice.sdk.module.ddos.service.IFilterService;
import com.hs.vsm.secservice.sdk.module.ddos.service.INpFilterService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceNfaCluster;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.secne.sdk.service.IClusterService;
import com.opensymphony.xwork2.ActionContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public class GetReportZoneAction
extends BaseAction {
    private static final long serialVersionUID = -7965301838457952454L;
    private static final String REGEX = "^acn5\\d{2}$";
    private static final String CHINA_CN = "CN";
    private static final String LOCATION_CUSTOM = "Location_Custom";
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private String sortField;
    private String sortType;
    private String deviceId;
    private String selectZoneId;
    private String source;
    private List<ZoneInfoForm> queryZoneFormList;
    private List<FilterForm> attackTypeList;
    private ZoneInfoQueryBean zoneInfoBean;
    private String combAllZoneType;
    private String zoneTypeDisplay;
    private String allQueryDisplay;
    private String listZoneSel;
    private String attackTypeName;

    private boolean needNfa() {
        return AticUtil.isNull((String)this.source) || !AnalysisConstants.getNotNeedNfaZoneReport().contains(this.source);
    }

    public String getReportZoneList() {
        ActionContext ctx = ActionContext.getContext();
        if (null == ctx) {
            return "list";
        }
        HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        User currentUser = (User)request.getSession().getAttribute("currentUser");
        Boolean isAdmin = currentUser.getIsAdmin().equalsIgnoreCase("true");
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("currentUserIsAdmin", isAdmin.toString());
        queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
        if (null != this.zoneInfoBean && !AticUtil.isNull((String)this.zoneInfoBean.getZoneName())) {
            queryMap.put("zoneName", this.zoneInfoBean.getZoneName());
        }
        this.processDeviceId();
        this.processSource();
        this.queryZoneFormList = new ArrayList<ZoneInfoForm>();
        Paging page = null;
        if (!AticUtil.isNull((String)this.deviceId) && Long.parseLong(this.deviceId) == -1L) {
            queryMap.put("deviceType", String.valueOf(0));
            page = ReportBisUtil.getZoneService().getReportZoneInfoByDeviceTypeAndInfo(queryMap, this.getStart(), this.getPageSize());
        } else if (!AticUtil.isNull((String)this.deviceId) && Long.parseLong(this.deviceId) == -2L) {
            queryMap.put("deviceType", String.valueOf(1));
            page = !this.needNfa() ? ReportBisUtil.getZoneService().getPageDeployZoneInfoNoNfa(queryMap, this.getStart(), this.getPageSize()) : ReportBisUtil.getZoneService().getReportZoneInfoByDeviceTypeAndInfo(queryMap, this.getStart(), this.getPageSize());
        } else {
            page = !AticUtil.isNull((String)this.deviceId) && "0".equals(this.deviceId) ? ReportBisUtil.getZoneService().getPageDeployZoneInfo(queryMap, this.getStart(), this.getPageSize()) : this.processSingleDev(queryMap);
        }
        this.queryZoneFormList = page.getData();
        this.setTotal(page.getCount());
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.getSession().setAttribute("zoneInfoBean", (Object)this.zoneInfoBean);
        this.initZoneTypeComb();
        this.setZoneValue();
        return "list";
    }

    private Paging processSingleDev(Map<String, String> queryMap) {
        IClusterService clusterService;
        List nfaClusterList;
        IAticDeviceService firewallService;
        AticDevice tempDev;
        Paging page = null;
        queryMap.put("deviceId", this.deviceId);
        if (this.deviceId != null && AticUtil.isNum((String)this.deviceId).booleanValue() && null != (tempDev = (firewallService = ReportBisUtil.getIFirewallService()).getDeviceByMoid(Long.parseLong(this.deviceId))) && 9 == tempDev.getDeviceType() && null != (nfaClusterList = (clusterService = ReportBisUtil.getClusterService()).getBindNfaDevice(Long.valueOf(Long.parseLong(this.deviceId)))) && !nfaClusterList.isEmpty()) {
            Long nfaId = ((AticDeviceNfaCluster)nfaClusterList.get(0)).getDeviceId();
            queryMap.put("deviceId", nfaId.toString());
        }
        page = ReportBisUtil.getZoneService().getReportZoneInfoByDeviceIdAndInfo(queryMap, this.getStart(), this.getPageSize());
        return page;
    }

    public String getIpLocaList() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        if (null != this.zoneInfoBean && !AticUtil.isNull((String)this.zoneInfoBean.getZoneName())) {
            queryMap.put("locName", this.zoneInfoBean.getZoneName());
        }
        List<ZoneInfoForm> allData = this.getLocationData(queryMap);
        this.queryZoneFormList = this.getLocationPageData(allData, this.getStart(), this.getPageSize());
        this.setTotal(allData.size());
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.getSession().setAttribute("zoneInfoBean", (Object)this.zoneInfoBean);
        this.setZoneValue();
        return "list";
    }

    private List<ZoneInfoForm> getLocationData(Map<String, String> queryMap) {
        Locale locale = LocaleUtil.getInstance().getCurrentUserLocale();
        String language = locale.getLanguage();
        ArrayList<ZoneInfoForm> list = new ArrayList<ZoneInfoForm>();
        try {
            ILibraryFileService libFileService = ReportBisUtil.getLibraryFileService();
            Map<Long, IpLocation> ipLocation = libFileService.getIpLocationMap();
            if (null == ipLocation) {
                return list;
            }
            ipLocation = this.generateNewIpLocation(this.generateCountryMap(ipLocation), this.generateCityMap(ipLocation));
            String locInputName = queryMap.get("locName");
            for (Map.Entry<Long, IpLocation> entry : ipLocation.entrySet()) {
                int ipLocationType;
                String shortName = entry.getValue().getShortName().toLowerCase(Locale.getDefault());
                if (AticUtil.isNull((String)shortName)) {
                    shortName = "location";
                }
                ZoneInfoForm zoneInfoForm = new ZoneInfoForm();
                String ipLocationName = language.equalsIgnoreCase("zh") ? entry.getValue().getLocationNameZh() : entry.getValue().getLocationNameEn();
                int n = ipLocationType = entry.getValue().getLocationType().equals("Lib_Location") ? 0 : 1;
                if (AticUtil.isNull((String)locInputName)) {
                    zoneInfoForm.setZoneId(entry.getKey());
                    zoneInfoForm.setZoneName(ipLocationName);
                    zoneInfoForm.setZoneType(Integer.valueOf(ipLocationType));
                    zoneInfoForm.setZoneDesc(shortName);
                    list.add(zoneInfoForm);
                    continue;
                }
                if (!ipLocationName.contains(locInputName)) continue;
                zoneInfoForm.setZoneId(entry.getKey());
                zoneInfoForm.setZoneName(ipLocationName);
                zoneInfoForm.setZoneType(Integer.valueOf(ipLocationType));
                zoneInfoForm.setZoneDesc(shortName);
                list.add(zoneInfoForm);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("getLocationData unkonw error." + e.getMessage()));
        }
        return list;
    }

    private Map<Long, IpLocation> generateCountryMap(Map<Long, IpLocation> ipLocation) {
        LinkedHashMap<Long, IpLocation> countryMap = new LinkedHashMap<Long, IpLocation>();
        for (Map.Entry<Long, IpLocation> entry : ipLocation.entrySet()) {
            IpLocation country = entry.getValue();
            Long locationId = entry.getValue().getLocationId();
            if (!country.isCountry() && !LOCATION_CUSTOM.equals(country.getLocationType()) || countryMap.containsKey(locationId)) continue;
            countryMap.put(locationId, country);
        }
        return countryMap;
    }

    private Map<Long, IpLocation> generateCityMap(Map<Long, IpLocation> ipLocation) {
        LinkedHashMap<Long, IpLocation> cityMap = new LinkedHashMap<Long, IpLocation>();
        for (Map.Entry<Long, IpLocation> entry : ipLocation.entrySet()) {
            Long locationId = entry.getKey();
            IpLocation city = entry.getValue();
            if (city.isCountry() || LOCATION_CUSTOM.equals(city.getLocationType())) continue;
            cityMap.put(locationId, city);
        }
        return cityMap;
    }

    private Map<Long, IpLocation> generateNewIpLocation(Map<Long, IpLocation> countrys, Map<Long, IpLocation> citys) {
        LinkedHashMap<Long, IpLocation> result = new LinkedHashMap<Long, IpLocation>();
        String shortNameCity = "";
        Pattern p = Pattern.compile(REGEX);
        for (Map.Entry<Long, IpLocation> country : countrys.entrySet()) {
            IpLocation tempCountry = new IpLocation();
            BeanUtils.copyProperties((Object)country.getValue(), (Object)tempCountry);
            tempCountry.setLocationNameEn(tempCountry.getLocationNameEn().replaceFirst("/", ""));
            tempCountry.setLocationNameZh(tempCountry.getLocationNameZh().replaceFirst("/", ""));
            result.put(tempCountry.getLocationId(), tempCountry);
            String shortNameCountry = country.getValue().getShortName();
            if (shortNameCountry.equals("aaother")) {
                tempCountry.setShortName("aother");
            }
            for (Map.Entry<Long, IpLocation> city : citys.entrySet()) {
                IpLocation temp = new IpLocation();
                BeanUtils.copyProperties((Object)city.getValue(), (Object)temp);
                shortNameCity = temp.getShortName();
                if (p.matcher(shortNameCity).find()) {
                    shortNameCity = CHINA_CN;
                    temp.setShortName(shortNameCity);
                }
                if (!shortNameCity.equals(shortNameCountry)) continue;
                temp.setLocationNameEn(city.getValue().getLocationNameEn().replaceFirst("/", ""));
                temp.setLocationNameZh(city.getValue().getLocationNameZh().replaceFirst("/", ""));
                result.put(temp.getLocationId(), temp);
            }
        }
        return result;
    }

    private List<ZoneInfoForm> getLocationPageData(List<ZoneInfoForm> allData, int start, int pageSize) {
        int endIndex;
        if (start == 0 && pageSize == 0) {
            return allData;
        }
        ArrayList<ZoneInfoForm> list = new ArrayList<ZoneInfoForm>();
        int startIndex = start;
        if (startIndex < 0 || startIndex >= allData.size()) {
            startIndex = allData.size() - 1;
        }
        if ((endIndex = start + pageSize) < 0 || endIndex >= allData.size()) {
            endIndex = allData.size();
        }
        if (allData.isEmpty()) {
            return list;
        }
        list.addAll(allData.subList(startIndex, endIndex));
        return list;
    }

    private void setZoneValue() {
        if (this.selectZoneId != null) {
            ArrayList<Long> moIdList = new ArrayList<Long>();
            String[] selZoneArr = null;
            this.listZoneSel = ",";
            selZoneArr = this.selectZoneId.equals("") ? new String[]{} : this.selectZoneId.split(";");
            int gridIndex = 0;
            for (ZoneInfoForm zoneInfoForm : this.queryZoneFormList) {
                for (String role1 : selZoneArr) {
                    if (role1.equals(zoneInfoForm.getZoneId().toString())) {
                        this.listZoneSel = this.listZoneSel + gridIndex + ",";
                        break;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)role1) || Long.parseLong(role1) <= 0L) continue;
                    Long moId = ReportBisUtil.getMoidByZoneid(Long.valueOf(role1));
                    moIdList.add(moId);
                    ReportBisUtil.checkUserSecurity(moIdList);
                }
                ++gridIndex;
            }
        }
    }

    private void initZoneTypeComb() {
        if (null != this.zoneInfoBean && !AticUtil.isNull((String)this.zoneInfoBean.getZoneType())) {
            this.zoneTypeDisplay = this.getText((String)AticConstants.getMapZoneTypeI18n().get(Integer.parseInt(this.zoneInfoBean.getZoneType())));
        }
        this.allQueryDisplay = this.getText("atic.public.query.all");
        StringBuffer temp = new StringBuffer();
        temp.append("[['").append("").append("','").append(this.getText("atic.public.query.all")).append("'],");
        temp.append("['").append(1).append("','").append(this.getText("atic.user.type.default")).append("'],");
        temp.append("['").append(AticConstants.ZONE_TYPE_CUSTOME).append("','").append(this.getText("atic.user.type.custome")).append("'],");
        temp.append("['").append(AticConstants.ZONE_TYPE_SIG).append("','").append(this.getText("atic.user.type.sig")).append("']]");
        this.combAllZoneType = temp.toString();
    }

    private void processDeviceId() {
        ArrayList<Long> moIdList = new ArrayList<Long>();
        if (!AticUtil.isNull((String)this.deviceId)) {
            if (this.deviceId.contains("_")) {
                String[] dev = this.deviceId.split("_");
                this.deviceId = dev[0];
            }
            this.deviceId = this.deviceId.split(",")[0];
            if (Long.parseLong(this.deviceId) > 0L) {
                moIdList.add(Long.valueOf(this.deviceId));
                ReportBisUtil.checkUserSecurity(moIdList);
            }
        }
    }

    public boolean validateDeviceId() {
        if (!AticUtil.isNullForVpn((String)this.deviceId)) {
            if (this.deviceId.length() > 64) {
                return false;
            }
            if (this.deviceId.contains("_")) {
                this.deviceId = this.deviceId.split("_")[0];
            }
            this.deviceId = this.deviceId.split(",")[0];
            try {
                if (Long.parseLong(this.deviceId) < -2L) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                this.logger.error((Object)"validateDeviceId is NumberFormatException");
                return false;
            }
        }
        return true;
    }

    private void processSource() {
        if (!AticUtil.isNull((String)this.source)) {
            this.source = this.source.split(",")[0];
        }
    }

    public boolean checkParams() {
        if (!(null == this.zoneInfoBean || null == this.zoneInfoBean.getZoneName() || this.zoneInfoBean.getZoneName().length() <= 64 && this.zoneInfoBean.getZoneName().matches("^(?!(?i)null$)[\\w|\u4e00-\u9fa5|\\-|!|@|#|$|\\^|\\.|\\+|\\}|\\{]*$"))) {
            return false;
        }
        if (this.selectZoneId != null && !"".equals(this.selectZoneId)) {
            try {
                String[] selArr = this.selectZoneId.split(";");
                if (selArr.length > 100) {
                    return false;
                }
                for (String rol : selArr) {
                    if (!StringUtils.isNotBlank((CharSequence)rol) || Long.parseLong(rol) >= 0L) continue;
                    return false;
                }
            }
            catch (RuntimeException e) {
                return false;
            }
        }
        return true;
    }

    public String getAllAttackType() {
        this.attackTypeList = new ArrayList<FilterForm>();
        List<FilterForm> filterForms = this.queryPageData();
        ArrayList<FilterForm> allData = new ArrayList();
        if (null != this.attackTypeName && !AticUtil.isNull((String)this.attackTypeName)) {
            for (FilterForm form : filterForms) {
                if (!form.getFilterName().toLowerCase(Locale.US).contains(this.attackTypeName.toLowerCase(Locale.US))) continue;
                allData.add(form);
            }
        } else {
            allData = filterForms;
        }
        this.attackTypeList = this.getAttackTypePageData(allData, this.getStart(), this.getPageSize());
        this.setTotal(allData.size());
        this.getSession().setAttribute("pageSize", (Object)this.getPageSize());
        this.getSession().setAttribute("start", (Object)this.getStart());
        this.getSession().setAttribute("attackTypeName", (Object)this.attackTypeName);
        return "list";
    }

    private List<FilterForm> queryPageData() {
        FilterForm filterForm;
        ArrayList<FilterForm> tempAttackType = new ArrayList<FilterForm>();
        for (int i = 10; i < 99; ++i) {
            if (i == 41 || i == 54 || i == 55 || i == 60 || i == 61 || i == 63) continue;
            String attackTypeStr = this.getText("atic.attack.type." + i);
            if (("atic.attack.type." + i).equals(attackTypeStr)) continue;
            filterForm = new FilterForm();
            filterForm.setFilterId(Integer.valueOf(i));
            filterForm.setFilterName(attackTypeStr);
            tempAttackType.add(filterForm);
        }
        filterForm = new FilterForm();
        filterForm.setFilterName(this.getText("atic.attack.type.2000"));
        filterForm.setFilterId(Integer.valueOf(2000));
        tempAttackType.add(filterForm);
        IFilterService filterService = ReportBisUtil.getFilterService();
        List filterForms = filterService.findAll();
        if (!filterForms.isEmpty()) {
            for (FilterForm form : filterForms) {
                if (form.getFilterId() > 20 || form.getFilterId() < 1) continue;
                form.setFilterId(Integer.valueOf(form.getFilterId() + 2000));
                tempAttackType.add(form);
            }
        }
        filterForm = new FilterForm();
        filterForm.setFilterName(this.getText("atic.attack.type.80000"));
        filterForm.setFilterId(Integer.valueOf(80000));
        tempAttackType.add(filterForm);
        INpFilterService npFilterService = ReportBisUtil.getNpFilterService();
        List npFilterForms = npFilterService.getAllNpFilter();
        for (NPFilterForm npFilterForm : npFilterForms) {
            if (npFilterForm.getFilterIndex() > 21 || npFilterForm.getFilterIndex() < 1) continue;
            filterForm = new FilterForm();
            filterForm.setFilterName(npFilterForm.getFilterName());
            filterForm.setFilterId(Integer.valueOf(npFilterForm.getFilterIndex() + 80000));
            tempAttackType.add(filterForm);
        }
        return tempAttackType;
    }

    private List<FilterForm> getAttackTypePageData(List<FilterForm> allData, int start, int pageSize) {
        int endIndex;
        if (start == 0 && pageSize == 0) {
            return allData;
        }
        ArrayList<FilterForm> list = new ArrayList<FilterForm>();
        int startIndex = start;
        if (startIndex < 0 || startIndex >= allData.size()) {
            startIndex = allData.size() - 1;
        }
        if ((endIndex = start + pageSize) < 0 || endIndex >= allData.size()) {
            endIndex = allData.size();
        }
        if (allData.isEmpty()) {
            return list;
        }
        list.addAll(allData.subList(startIndex, endIndex));
        return list;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public List<ZoneInfoForm> getQueryZoneFormList() {
        return this.queryZoneFormList;
    }

    public void setQueryZoneFormList(List<ZoneInfoForm> queryZoneFormList) {
        this.queryZoneFormList = queryZoneFormList;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getCombAllZoneType() {
        return this.combAllZoneType;
    }

    public void setCombAllZoneType(String combAllZoneType) {
        this.combAllZoneType = combAllZoneType;
    }

    public ZoneInfoQueryBean getZoneInfoBean() {
        return this.zoneInfoBean;
    }

    public void setZoneInfoBean(ZoneInfoQueryBean zoneInfoBean) {
        this.zoneInfoBean = zoneInfoBean;
    }

    public String getZoneTypeDisplay() {
        return this.zoneTypeDisplay;
    }

    public void setZoneTypeDisplay(String zoneTypeDisplay) {
        this.zoneTypeDisplay = zoneTypeDisplay;
    }

    public String getAllQueryDisplay() {
        return this.allQueryDisplay;
    }

    public void setAllQueryDisplay(String allQueryDisplay) {
        this.allQueryDisplay = allQueryDisplay;
    }

    public String getSelectZoneId() {
        return this.selectZoneId;
    }

    public void setSelectZoneId(String selectZoneId) {
        this.selectZoneId = selectZoneId;
    }

    public String getListZoneSel() {
        return this.listZoneSel;
    }

    public void setListZoneSel(String listZoneSel) {
        this.listZoneSel = listZoneSel;
    }

    public String getAttackTypeName() {
        return this.attackTypeName;
    }

    public void setAttackTypeName(String attackTypeName) {
        this.attackTypeName = attackTypeName;
    }

    public List<FilterForm> getAttackTypeList() {
        return this.attackTypeList;
    }

    public void setAttackTypeList(List<FilterForm> attackTypeList) {
        this.attackTypeList = attackTypeList;
    }
}

