/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.attacktrend;

import com.hs.atic.analysis.report.attack.attacktrend.AttackTrend;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.AttackExactLogForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AttackCountChartDataSet
extends IJavaDataSource {
    private static final Long NUM_THREE_HUNDRED = 300L;
    private static final Long NUM_THREE_THOUSAND_SIX_HUNDRED = 3600L;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<AttackTrend> dataList = new ArrayList<AttackTrend>();
    private IDataStatService dataStatService;

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        return this.dataList;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        Map<String, List<String>> prepareParasMap = ReportAnalysisUtil.getPrepareParasMap(queryCond);
        ArrayList<String> unit = new ArrayList<String>();
        String unitValue = "0";
        if (!AticUtil.isNull((String)ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit").get(0).getValue())) {
            unitValue = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit").get(0).getValue();
        }
        if (unitValue.equals("1")) {
            unit.add("pps");
        } else if (unitValue.equals("0")) {
            unit.add("kbps");
        } else {
            unit.add("qps");
        }
        prepareParasMap.put("unit", unit);
        return prepareParasMap;
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start AttackTrafficTimeChartDataSet prepareData()");
        try {
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            List<AttackExactLogForm> attackTrendFormList = this.getSingleDeviceData(datastatConditionForm);
            attackTrendFormList = this.getAllTimeData(attackTrendFormList, datastatConditionForm);
            this.getAttackExactLogFormData(attackTrendFormList, datastatConditionForm);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            this.logger.error((Object)("AttackTrafficTimeChartDataSet prepareData() exception" + legoException.getErrorCode() + ". " + legoException.getMessage()));
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)("AttackTrafficTimeChartDataSet prepareData() unknow exception!" + e.getMessage()));
        }
        this.logger.info((Object)"end AttackTrafficTimeChartDataSet prepareData()");
        return 0;
    }

    private List<AttackExactLogForm> getAllTimeData(List<AttackExactLogForm> attackTrendFormList, DataStatConditionForm datastatConditionForm) {
        Object form;
        for (AttackExactLogForm form2 : attackTrendFormList) {
            if (2 == datastatConditionForm.getAbnormalType()) {
                form2.setEndTime(form2.getStartTimeAttack());
                continue;
            }
            form2.setEndTime(form2.getStartTimeAlert());
        }
        Long startTime = ReportAnalysisUtil.getRealStartTime(datastatConditionForm.getStartTime(), datastatConditionForm.getEndTime());
        long timeSlot = this.getTimeSlot(startTime, datastatConditionForm.getEndTime());
        Long minTime = 0L;
        Long maxTime = 0L;
        for (int i = 0; i < attackTrendFormList.size(); ++i) {
            form = attackTrendFormList.get(i);
            if (i == 0) {
                minTime = ((AttackExactLogForm)form).getEndTime();
                maxTime = ((AttackExactLogForm)form).getEndTime();
                continue;
            }
            if (((AttackExactLogForm)form).getEndTime() < minTime) {
                minTime = ((AttackExactLogForm)form).getEndTime();
            }
            if (((AttackExactLogForm)form).getEndTime() <= maxTime) continue;
            maxTime = ((AttackExactLogForm)form).getEndTime();
        }
        while (minTime <= maxTime) {
            boolean hasData = false;
            for (AttackExactLogForm form3 : attackTrendFormList) {
                if (!form3.getEndTime().equals(minTime)) continue;
                hasData = true;
                break;
            }
            if (!hasData) {
                form = new AttackExactLogForm();
                ((AttackExactLogForm)form).setEndTime(minTime);
                ((AttackExactLogForm)form).setAttackCount(0);
                attackTrendFormList.add((AttackExactLogForm)form);
            }
            minTime = minTime + timeSlot;
        }
        return attackTrendFormList;
    }

    private long getTimeSlot(Long startTime, Long endTime) {
        long timeSlot = 0L;
        int type = ReportAnalysisUtil.getTimeSpanType(endTime, startTime);
        timeSlot = type == AnalysisConstants.LESS_THAN_SEVEN_DAYS ? NUM_THREE_THOUSAND_SIX_HUNDRED : (type == AnalysisConstants.MORE_THAN_SEVEN_DAYS ? 24L * NUM_THREE_THOUSAND_SIX_HUNDRED : NUM_THREE_HUNDRED);
        return timeSlot;
    }

    private void getAttackExactLogFormData(List<AttackExactLogForm> attackTrendFormList, DataStatConditionForm datastatConditionForm) {
        for (AttackExactLogForm aExactLogForm : attackTrendFormList) {
            AttackTrend atTrend = new AttackTrend();
            atTrend.setDateTime(aExactLogForm.getEndTime() * 1000L);
            atTrend.setCount(aExactLogForm.getAttackCount().longValue());
            atTrend.setAttackTypeName(datastatConditionForm.getAttackTypeName());
            this.dataList.add(atTrend);
        }
    }

    private List<AttackExactLogForm> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        ArrayList<AttackExactLogForm> allCollectorAttackTypeForm = new ArrayList();
        try {
            allCollectorAttackTypeForm = this.dataStatService.getAbnormalOrAttackCount(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId + ". " + e.getMessage()));
        }
        return allCollectorAttackTypeForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        Long endTime;
        String startTimeStr;
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItem.get(0).getValue());
        if (direction.matches("^[\\d]*$")) {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        } else {
            datastatConditionForm.setDirection(1);
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        String zoneId = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        if (!"0".equals(zoneId)) {
            datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        } else if (!AnalysisConstants.getInstance().getReportType().equalsIgnoreCase("ips") || !AnalysisConstants.getInstance().getReportTypeIpsReport().booleanValue()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        String bisId = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox");
        bisId = String.valueOf(jsonValueItem.get(0).getValue());
        if (AticUtil.isNull((String)bisId)) {
            bisId = "0";
        }
        ReportAnalysisUtil.processServiceCond(datastatConditionForm, bisId);
        String zoneIp = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip");
        zoneIp = String.valueOf(jsonValueItem.get(0).getValue());
        if (!AticUtil.isNull((String)zoneIp)) {
            datastatConditionForm.setZoneIp(zoneIp);
        }
        Long startTime = (startTimeStr = (jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "startTime")).get(0).getText()) == null ? null : Long.valueOf(Long.parseLong(startTimeStr));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "endTime");
        String endTimeStr = jsonValueItem.get(0).getText();
        Long l = endTime = endTimeStr == null ? null : Long.valueOf(Long.parseLong(endTimeStr));
        if (null != startTime && null != endTime && queryCond.containsKey("dateRange")) {
            JsonValueObj dateObj = (JsonValueObj)queryCond.get("dateRange");
            ((JsonValueItem)dateObj.getValueList().get(0)).setValue(String.valueOf(startTime));
            ((JsonValueItem)dateObj.getValueList().get(0)).setText(AticUtil.convertTimeLong((Long)startTime));
            ((JsonValueItem)dateObj.getValueList().get(1)).setValue(String.valueOf(endTime));
            ((JsonValueItem)dateObj.getValueList().get(1)).setText(AticUtil.convertTimeLong((Long)endTime));
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "logType");
        String logType = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setAbnormalType(Integer.parseInt(logType));
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "attackType_combobox");
        String attackType = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setAttackType(Integer.parseInt(attackType));
        String attackTypeName = String.valueOf(jsonValueItem.get(0).getText());
        if (!AticUtil.isNull((String)attackTypeName)) {
            datastatConditionForm.setAttackTypeName(attackTypeName);
        } else {
            datastatConditionForm.setAttackTypeName("-");
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "minInFlow");
        String minInFlow = String.valueOf(jsonValueItem.get(0).getValue());
        if (!AticUtil.isNull((String)minInFlow)) {
            datastatConditionForm.setMinInFlow(Long.parseLong(minInFlow));
        } else {
            datastatConditionForm.setMinInFlow(0L);
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "minAttackFlowPeak");
        String minAttackFlowPeak = String.valueOf(jsonValueItem.get(0).getValue());
        if (!AticUtil.isNull((String)minAttackFlowPeak)) {
            datastatConditionForm.setMinAttackFlowPeak(Long.parseLong(minAttackFlowPeak));
        } else {
            datastatConditionForm.setMinAttackFlowPeak(0L);
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit");
        String unit = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setUnit(Integer.parseInt(unit));
    }
}

