/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.attacktrend;

import com.hs.atic.analysis.report.attack.attacktrend.AttackTrend;
import com.hs.atic.analysis.report.attack.attacktrend.AttackTrendTable;
import com.hs.atic.analysis.report.attack.attacktrend.TransmitAttackTrendData;
import com.hs.atic.analysis.report.dns.cache.TableHeader;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.security.ireport.engine.dataset.IFlexTableData;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class AttackTrendTableDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<IFlexTableData> headList = new ArrayList<IFlexTableData>();
    private List<List<AttackTrendTable>> tableData = new ArrayList<List<AttackTrendTable>>();

    public List<AttackTrend> sortListByField(List<AttackTrend> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        if (pageIndex == 0L && pageSize == 0L) {
            return this.tableData;
        }
        ArrayList<List<AttackTrendTable>> list = new ArrayList<List<AttackTrendTable>>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= this.tableData.size()) {
            startIndex = this.tableData.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= this.tableData.size()) {
            endIndex = this.tableData.size();
        }
        if (this.tableData.isEmpty()) {
            return list;
        }
        list.addAll(this.tableData.subList(startIndex, endIndex));
        return list;
    }

    public List<IFlexTableData> getFlexTableHeader() {
        return this.headList;
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start AttackTrendTableDataSet prepareData");
        try {
            ArrayList<String> attackTypeNameList = new ArrayList<String>();
            TableHeader item = new TableHeader();
            item.setDisplayTxt(AticUtil.getText((String)"atic.analysis.report.attack.table.first"));
            this.headList.add(item);
            List<AttackTrend> dataList = TransmitAttackTrendData.getInstance().getDataList(sessionId);
            TransmitAttackTrendData.getInstance().removeData(sessionId);
            this.logger.info((Object)"removeDate from TransmitAttackTrendData");
            if (null == dataList || dataList.isEmpty()) {
                this.logger.info((Object)"dataList is null or empty");
                return 0;
            }
            this.processHeadList(dataList, attackTypeNameList);
            HashMap<Long, List<AttackTrend>> sourceDataMap = new HashMap<Long, List<AttackTrend>>();
            for (int i = 0; i < dataList.size(); ++i) {
                Long time = dataList.get(i).getDateTime();
                ArrayList<AttackTrend> tmpList = new ArrayList<AttackTrend>();
                tmpList.add(dataList.get(i));
                for (int j = dataList.size() - 1; j > i; --j) {
                    if (!time.equals(dataList.get(j).getDateTime())) continue;
                    tmpList.add(dataList.get(j));
                    dataList.remove(j);
                }
                sourceDataMap.put(time, tmpList);
            }
            Object[] times = sourceDataMap.keySet().toArray();
            Arrays.sort(times);
            this.getTableData(times, sourceDataMap, attackTypeNameList);
            this.logger.info((Object)"end AttackTrendTableDataSet prepareData");
            return 0;
        }
        catch (LegoCheckedException legoException) {
            this.tableData.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.tableData.clear();
            this.logger.error((Object)("AttackTrendTableDataSet prepareData() unknow exception!" + e.getMessage()));
            return 0;
        }
    }

    private void processHeadList(List<AttackTrend> dataList, List<String> attackTypeNameList) {
        for (int i = 0; i < dataList.size(); ++i) {
            AttackTrend attackTrend = dataList.get(i);
            if (i == 0) {
                String attackTypeName = attackTrend.getAttackTypeName();
                attackTypeNameList.add(attackTypeName);
                TableHeader item = new TableHeader();
                item.setDisplayTxt(attackTypeName);
                this.headList.add(item);
                continue;
            }
            boolean hasName = false;
            for (int j = 0; j < this.headList.size(); ++j) {
                if (!attackTrend.getAttackTypeName().equals(this.headList.get(j).getDisplayTxt())) continue;
                hasName = true;
                break;
            }
            if (hasName) continue;
            String attackTypeName = attackTrend.getAttackTypeName();
            attackTypeNameList.add(attackTypeName);
            TableHeader item = new TableHeader();
            item.setDisplayTxt(attackTypeName);
            this.headList.add(item);
        }
    }

    private void getTableData(Object[] times, Map<Long, List<AttackTrend>> sourceDataMap, List<String> attackTypeNameList) {
        for (Object time : times) {
            ArrayList<AttackTrendTable> rowData = new ArrayList<AttackTrendTable>();
            AttackTrendTable data = new AttackTrendTable(AticUtil.convertTimeLong((Long)((Long)time / 1000L)));
            rowData.add(data);
            int checkZeroNum = 0;
            for (String name : attackTypeNameList) {
                checkZeroNum += this.getTableData0(sourceDataMap, name, time, rowData);
            }
            if (checkZeroNum >= attackTypeNameList.size()) continue;
            this.tableData.add(rowData);
        }
    }

    private int getTableData0(Map<Long, List<AttackTrend>> sourceDataMap, String name, Object time, List<AttackTrendTable> rowData) {
        int checkZeroNum = 0;
        String pps = "-";
        for (AttackTrend attackTrend : sourceDataMap.get(time)) {
            if (!name.equals(attackTrend.getAttackTypeName())) continue;
            pps = String.valueOf(attackTrend.getAttackTypePackagePps());
            if (0L != attackTrend.getAttackTypePackagePps()) continue;
            ++checkZeroNum;
        }
        rowData.add(new AttackTrendTable(pps));
        return checkZeroNum;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.tableData.size();
    }
}

