/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.attacktype;

import com.hs.atic.analysis.report.attack.attacktype.AtackTypeDistribute;
import com.hs.atic.analysis.report.attack.attacktype.AttackTypeComparator;
import com.hs.atic.analysis.report.integration.datasource.TransmitAttackDurationData;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.AttackTypeDistributeForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IFlexTableData;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class AttackDurationCountDataSet
extends IJavaDataSource {
    private static final int DURATION_SEGMENTATION_30_MINUTES = 1800;
    private static final int DURATION_SEGMENTATION_60_MINUTES = 3600;
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<AtackTypeDistribute> dataList = new ArrayList<AtackTypeDistribute>();
    private IDataStatService dataStatService;

    public List<IFlexTableData> getFlexTableHeader() {
        return null;
    }

    public List<AtackTypeDistribute> sortListByField(List<AtackTypeDistribute> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<AtackTypeDistribute> orderedList = null;
        if (null != sortList) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<AtackTypeDistribute> list = new ArrayList<AtackTypeDistribute>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getLogoAndNameMap(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        try {
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            List<AttackTypeDistributeForm> attackTypeDisFormList = null;
            if (datastatConditionForm.getDeviceId() <= 0L) {
                return 0;
            }
            attackTypeDisFormList = this.getSingleDeviceCounts(datastatConditionForm);
            this.logger.info((Object)("prepareData Duration attackTypeDisFormList.size = " + attackTypeDisFormList.size()));
            this.dataList = this.getAttackDurationDisListStatistic(attackTypeDisFormList, queryCond);
            String isNeedTransmitChartData = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isNeedTransmitChartData").get(0).getValue());
            if (!AticUtil.isNull((String)isNeedTransmitChartData) && isNeedTransmitChartData.equalsIgnoreCase("true")) {
                TransmitAttackDurationData.getInstance().addDataList(new ArrayList<AtackTypeDistribute>(this.dataList), sessionId);
            }
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)("AttackPacketTopnDataSet prepareData happened exception !" + e.getMessage()));
        }
        return 0;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        List<JsonValueItem> jsonValueItemList = null;
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "switchOption");
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItemList.get(0).getValue());
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItemList.get(0).getValue());
        if (direction.matches("^[\\d]*$")) {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        } else {
            datastatConditionForm.setDirection(1);
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "logType");
        String logType = String.valueOf(jsonValueItemList.get(0).getValue());
        if (AticUtil.isNull((String)logType)) {
            logType = 0 == datastatConditionForm.getDevSerType() ? "2" : "1";
        }
        datastatConditionForm.setAbnormalType(Integer.parseInt(logType));
        String zoneId = null;
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        if (null != jsonValueItemList && !jsonValueItemList.isEmpty() && !"0".equals(zoneId = String.valueOf(jsonValueItemList.get(0).getValue()))) {
            datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        }
        if (!(null != datastatConditionForm.getZoneId() || AnalysisConstants.getInstance().getReportType().equalsIgnoreCase("ips") && AnalysisConstants.getInstance().getReportTypeIpsReport().booleanValue())) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox");
        String bisId = String.valueOf(jsonValueItemList.get(0).getValue());
        ReportAnalysisUtil.processServiceCond(datastatConditionForm, bisId);
        jsonValueItemList = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip");
        String zoneIp = String.valueOf(jsonValueItemList.get(0).getValue());
        if (!AticUtil.isNull((String)zoneIp)) {
            datastatConditionForm.setZoneIp(zoneIp);
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
    }

    private List<AttackTypeDistributeForm> getSingleDeviceCounts(DataStatConditionForm datastatConditionForm) {
        List<AttackTypeDistributeForm> formList = new ArrayList<AttackTypeDistributeForm>();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist, deviceId = " + datastatConditionForm.getDeviceId()));
            return formList;
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            formList = this.dataStatService.getAttackDurationAndTrafficPeakCountsDisStatisticCountPercent(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorIp = " + this.getcleanedMessage(collectorInfo.getIpAddress()) + ". " + e.getMessage()));
        }
        return formList;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private List<AtackTypeDistribute> getAttackDurationDisList(List<AttackTypeDistributeForm> attackDurationDisFormList, Map<?, ?> queryCond) {
        Locale locale = ReportAnalysisUtil.getCurrentUserLocale4Report(queryCond);
        String lessThan30Minutes = AttackDurationCountDataSet.getText("atic.attack.duration1", locale);
        String between30MinutesAnd1Hours = AttackDurationCountDataSet.getText("atic.attack.duration2", locale);
        String moreThan1Hours = AttackDurationCountDataSet.getText("atic.attack.duration3", locale);
        List<AtackTypeDistribute> attackDurationDisList = new ArrayList<AtackTypeDistribute>();
        if (null == attackDurationDisFormList) {
            return attackDurationDisList;
        }
        HashMap<String, AttackTypeDistributeForm> attackTypeDisTempMap = new HashMap<String, AttackTypeDistributeForm>();
        float totalCount = attackDurationDisFormList.size();
        for (AttackTypeDistributeForm durationForm : attackDurationDisFormList) {
            AttackTypeDistributeForm tempForm = new AttackTypeDistributeForm();
            int duration = durationForm.getDuration();
            this.logger.info((Object)("durationForm DeviceIp =" + durationForm.getDeviceIp() + " duration=" + durationForm.getDuration()));
            if (duration <= 0) continue;
            if (duration < 1800) {
                if (attackTypeDisTempMap.containsKey(lessThan30Minutes)) {
                    tempForm.setCount(((AttackTypeDistributeForm)attackTypeDisTempMap.get(lessThan30Minutes)).getCount() + 1L);
                } else {
                    tempForm.setCount(1L);
                }
                tempForm.setDurationTypeNameStr(lessThan30Minutes);
                attackTypeDisTempMap.put(lessThan30Minutes, tempForm);
                continue;
            }
            if (duration < 3600) {
                if (attackTypeDisTempMap.containsKey(between30MinutesAnd1Hours)) {
                    tempForm.setCount(((AttackTypeDistributeForm)attackTypeDisTempMap.get(between30MinutesAnd1Hours)).getCount() + 1L);
                } else {
                    tempForm.setCount(1L);
                }
                tempForm.setDurationTypeNameStr(between30MinutesAnd1Hours);
                attackTypeDisTempMap.put(between30MinutesAnd1Hours, tempForm);
                continue;
            }
            if (attackTypeDisTempMap.containsKey(moreThan1Hours)) {
                tempForm.setCount(((AttackTypeDistributeForm)attackTypeDisTempMap.get(moreThan1Hours)).getCount() + 1L);
            } else {
                tempForm.setCount(1L);
            }
            tempForm.setDurationTypeNameStr(moreThan1Hours);
            attackTypeDisTempMap.put(moreThan1Hours, tempForm);
        }
        if (totalCount == 0.0f) {
            return attackDurationDisList;
        }
        attackDurationDisList.addAll(this.getCommonAtackTypeList(attackTypeDisTempMap, totalCount));
        Collections.sort(attackDurationDisList, new AttackTypeComparator());
        attackDurationDisList = this.processPercent(attackDurationDisList);
        return attackDurationDisList;
    }

    private List<AtackTypeDistribute> getAttackDurationDisListStatistic(List<AttackTypeDistributeForm> attackDurationDisFormList, Map<?, ?> queryCond) {
        Locale locale = ReportAnalysisUtil.getCurrentUserLocale4Report(queryCond);
        String lessThan30Minutes = AttackDurationCountDataSet.getText("atic.attack.duration1", locale);
        String between30MinutesAnd1Hours = AttackDurationCountDataSet.getText("atic.attack.duration2", locale);
        String moreThan1Hours = AttackDurationCountDataSet.getText("atic.attack.duration3", locale);
        List<AtackTypeDistribute> attackDurationDisList = new ArrayList<AtackTypeDistribute>();
        if (null == attackDurationDisFormList) {
            return attackDurationDisList;
        }
        HashMap<String, AttackTypeDistributeForm> attackTypeDisTempMap = new HashMap<String, AttackTypeDistributeForm>();
        float totalCount = 0.0f;
        for (AttackTypeDistributeForm durationForm : attackDurationDisFormList) {
            AttackTypeDistributeForm tempForm = new AttackTypeDistributeForm();
            int duration = durationForm.getDuration();
            this.logger.info((Object)("durationForm DeviceIp =" + durationForm.getDeviceIp() + " duration=" + durationForm.getDuration()));
            if (duration == 1) {
                tempForm.setCount(durationForm.getCount());
                tempForm.setDurationTypeNameStr(lessThan30Minutes);
                attackTypeDisTempMap.put(lessThan30Minutes, tempForm);
            } else if (duration == 2) {
                tempForm.setCount(durationForm.getCount());
                tempForm.setDurationTypeNameStr(between30MinutesAnd1Hours);
                attackTypeDisTempMap.put(between30MinutesAnd1Hours, tempForm);
            } else {
                tempForm.setCount(durationForm.getCount());
                tempForm.setDurationTypeNameStr(moreThan1Hours);
                attackTypeDisTempMap.put(moreThan1Hours, tempForm);
            }
            totalCount += (float)durationForm.getCount().longValue();
        }
        if (totalCount == 0.0f) {
            return attackDurationDisList;
        }
        attackDurationDisList.addAll(this.getCommonAtackTypeList(attackTypeDisTempMap, totalCount));
        Collections.sort(attackDurationDisList, new AttackTypeComparator());
        attackDurationDisList = this.processPercent(attackDurationDisList);
        return attackDurationDisList;
    }

    private List<AtackTypeDistribute> getCommonAtackTypeList(Map<String, AttackTypeDistributeForm> attackTypeDisMap, float totalCount) {
        ArrayList<AtackTypeDistribute> attackTypeDisList = new ArrayList<AtackTypeDistribute>();
        if (null != attackTypeDisMap) {
            for (Map.Entry<String, AttackTypeDistributeForm> attackTypeSet : attackTypeDisMap.entrySet()) {
                AtackTypeDistribute distribute = new AtackTypeDistribute();
                long counts = attackTypeSet.getValue().getCount();
                float percent = (float)counts / totalCount;
                distribute.setCount(counts);
                distribute.setCountStr(this.formatCount(counts));
                distribute.setPercent(percent);
                distribute.setDurationTypeNameStr(attackTypeSet.getValue().getDurationTypeNameStr());
                attackTypeDisList.add(distribute);
            }
        }
        return attackTypeDisList;
    }

    private List<AtackTypeDistribute> processPercent(List<AtackTypeDistribute> attackTypeDisList) {
        float totalPercent = 0.0f;
        if (null != attackTypeDisList && !attackTypeDisList.isEmpty()) {
            for (AtackTypeDistribute attackTypeDis : attackTypeDisList) {
                float percent = this.formatPercent(attackTypeDis.getPercent());
                totalPercent += percent;
                attackTypeDis.setPercent(percent);
                attackTypeDis.setPercentStr(percent + "%");
            }
            AtackTypeDistribute tempAttackType = attackTypeDisList.get(attackTypeDisList.size() - 1);
            if (tempAttackType.getPercent() > 0.0f) {
                float lastPercent = this.formatPercent((tempAttackType.getPercent() + 100.0f - totalPercent) / 100.0f);
                tempAttackType.setPercent(lastPercent);
                tempAttackType.setPercentStr(lastPercent + "%");
            }
        }
        return attackTypeDisList;
    }

    private float formatPercent(float percent) {
        int tmp = Math.round(percent * 1000.0f);
        float base = 10.0f;
        return (float)tmp / base;
    }

    private String formatCount(long count) {
        int comma = 0;
        String countStr = null;
        try {
            countStr = String.valueOf(count);
        }
        catch (Exception e) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int length = countStr.length();
        comma = length % 3 == 0 ? length / 3 - 1 : length / 3;
        int len = length - comma * 3;
        for (int i = 0; i <= comma; ++i) {
            if (i == 0) {
                buffer.append(countStr.substring(0, len));
                buffer.append(',');
                continue;
            }
            buffer.append(countStr.substring(len + (i - 1) * 3, len + i * 3));
            buffer.append(',');
        }
        countStr = buffer.substring(0, buffer.length() - 1);
        return countStr;
    }

    public static String getText(String aTextName, Locale locale) {
        return LocaleUtil.getInstance().getText(aTextName, locale);
    }
}

