/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.bisattack;

import com.hs.atic.analysis.report.attack.bisattack.BisAttackCountTopN;
import com.hs.atic.analysis.util.RedunDeviceForm;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.BisAttackCountTopNForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.DeviceWorkTimeForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.sdk.module.ddos.form.ZoneServiceForm;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class BisAttackCountTopNDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<BisAttackCountTopN> dataList = new ArrayList<BisAttackCountTopN>();
    private IDataStatService dataStatService;

    public List<BisAttackCountTopN> sortListByField(List<BisAttackCountTopN> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<BisAttackCountTopN> orderedList = null;
        if (sortList != null) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<BisAttackCountTopN> list = new ArrayList<BisAttackCountTopN>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getLogoAndNameMap(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start BisAttackCountTopNDataSet prepareData");
        List<BisAttackCountTopNForm> bisTopNFormList = null;
        Map<String, List<BisAttackCountTopNForm>> allCollectorForm = null;
        try {
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            if (datastatConditionForm.getDeviceId() > 0L) {
                allCollectorForm = this.getSingleDeviceData(datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
                allCollectorForm = -2L == datastatConditionForm.getDeviceId() ? this.getAllDetectDeviceDate(firewallList, datastatConditionForm) : this.getAllCollectorIpTopNForm(firewallList, datastatConditionForm);
            }
            bisTopNFormList = this.getTopNForm(allCollectorForm, datastatConditionForm.getTopn());
            this.dataList = this.getAttackCountFormDate(bisTopNFormList);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)("BisAttackCountTopNDataSet prepareData() unknow exception!" + e.getMessage()));
        }
        this.logger.info((Object)"end BisAttackCountTopNDataSet prepareData");
        return 0;
    }

    private List<BisAttackCountTopN> getAttackCountFormDate(List<BisAttackCountTopNForm> bisTopNFormList) {
        HashMap<String, Integer> sameBizNameNum = new HashMap<String, Integer>();
        IZoneService zoneService = ReportBisUtil.getZoneService();
        for (BisAttackCountTopNForm form : bisTopNFormList) {
            ZoneInfoForm zoneForm = zoneService.getById(form.getZoneId());
            if (null == zoneForm || "".equals(zoneForm.getZoneDesc())) {
                this.logger.info((Object)("the zone not exist,zoneId = " + form.getZoneId()));
                form.setZoneName(AticUtil.getText((String)"atic.analysis.common.unknownZone") + form.getZoneId());
            } else {
                form.setZoneName(zoneForm.getZoneDesc());
            }
            ZoneServiceForm serviceForm = ReportBisUtil.getZoneMgrNorthSerice().getBizTypeById(form.getBisId());
            String bisNameTemp = "";
            if (null != serviceForm) {
                bisNameTemp = serviceForm.getServiceName();
            } else {
                this.logger.info((Object)("the biz id=" + form.getBisId() + " exist"));
                bisNameTemp = AticUtil.getText((String)"atic.analysis.common.unknownBiz") + form.getBisId();
            }
            form.setBisName(bisNameTemp);
            if (sameBizNameNum.containsKey(form.getBisName())) {
                int newNum = (Integer)sameBizNameNum.get(form.getBisName()) + 1;
                sameBizNameNum.put(form.getBisName(), newNum);
                continue;
            }
            sameBizNameNum.put(form.getBisName(), 1);
        }
        Set set = sameBizNameNum.entrySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Integer num = (Integer)entry.getValue();
            if (num > 1) continue;
            iter.remove();
        }
        ArrayList<BisAttackCountTopN> returnDataList = new ArrayList<BisAttackCountTopN>();
        for (int i = 0; i < bisTopNFormList.size(); ++i) {
            BisAttackCountTopN data = new BisAttackCountTopN();
            data.setAttackTimes(bisTopNFormList.get(i).getAttackTimes());
            data.setZoneName(bisTopNFormList.get(i).getZoneName());
            String key = bisTopNFormList.get(i).getBisName();
            if (sameBizNameNum.containsKey(key) && (Integer)sameBizNameNum.get(key) > 0) {
                int tempNum = (Integer)sameBizNameNum.get(key);
                data.setBisName(key + "(" + tempNum + ")");
                sameBizNameNum.put(key, tempNum - 1);
            } else {
                data.setBisName(key);
            }
            returnDataList.add(data);
        }
        return returnDataList;
    }

    private Map<String, List<BisAttackCountTopNForm>> getAllDetectDeviceDate(List<AticDevice> firewallList, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<BisAttackCountTopNForm>> allCollectorForm = new HashMap<String, List<BisAttackCountTopNForm>>();
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        Map<Long, List<RedunDeviceForm>> redunMap = ReportAnalysisUtil.getRedunFirewallInfoList(firewallList);
        for (Map.Entry<Long, List<RedunDeviceForm>> redun : redunMap.entrySet()) {
            List<DeviceWorkTimeForm> workTimeList = ReportAnalysisUtil.getWorkTimeList(datastatConditionForm, redun);
            for (DeviceWorkTimeForm form : workTimeList) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(form.getDeviceIp());
                datastatConditionForm.setDeviceIpList(list);
                datastatConditionForm.setStartTime(form.getStartTime());
                datastatConditionForm.setEndTime(form.getEndTime());
                Map<Object, Object> tempFormMap = new HashMap();
                try {
                    tempFormMap = this.dataStatService.getBisAttackCountTopN(datastatConditionForm, form.getCollectorIp());
                }
                catch (Exception e) {
                    this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorIp = " + form.getCollectorIp() + ". " + e.getMessage()));
                }
                if (null == tempFormMap || tempFormMap.isEmpty()) continue;
                if (allCollectorForm.containsKey(form.getDeviceIp())) {
                    ((List)allCollectorForm.get(form.getDeviceIp())).addAll((Collection)tempFormMap.get(form.getDeviceIp()));
                    continue;
                }
                allCollectorForm.putAll(tempFormMap);
            }
        }
        List<AticDevice> redunFirewallList = ReportAnalysisUtil.getRedunFirewallList(redunMap);
        if (!redunFirewallList.isEmpty()) {
            firewallList.removeAll(redunFirewallList);
        }
        if (!firewallList.isEmpty()) {
            allCollectorForm.putAll(this.getAllCollectorIpTopNForm(firewallList, datastatConditionForm));
        }
        return allCollectorForm;
    }

    private Map<String, List<BisAttackCountTopNForm>> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        HashMap<String, List<BisAttackCountTopNForm>> allCollectorForm = new HashMap();
        try {
            allCollectorForm = this.dataStatService.getBisAttackCountTopN(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId + ". " + e.getMessage()));
        }
        return allCollectorForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        String direction;
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        String zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        if (0L == datastatConditionForm.getZoneId()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        if ((direction = String.valueOf((jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox")).get(0).getValue())).matches("^[\\d]*$")) {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        } else {
            datastatConditionForm.setDirection(1);
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
        String topn = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setTopn(Integer.parseInt(topn));
    }

    private Map<String, List<BisAttackCountTopNForm>> getAllCollectorIpTopNForm(List<AticDevice> firewallList, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<BisAttackCountTopNForm>> allCollectorIpTopNForm = new HashMap<String, List<BisAttackCountTopNForm>>();
        if (!firewallList.isEmpty()) {
            Map<Long, List<AticDevice>> collectDevMap = ReportAnalysisUtil.getCollectDevMap(firewallList);
            for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
                String collectorIp = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue()).getIpAddress();
                datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                for (AticDevice firewall : entry.getValue()) {
                    if (null == datastatConditionForm.getDeviceIpList()) {
                        datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                    }
                    datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
                }
                this.dataStatService = ReportAnalysisUtil.getDataStatService();
                try {
                    allCollectorIpTopNForm.putAll(this.dataStatService.getBisAttackCountTopN(datastatConditionForm, collectorIp));
                }
                catch (Exception e) {
                    this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey() + ". " + e.getMessage()));
                }
            }
        }
        return allCollectorIpTopNForm;
    }

    private List<BisAttackCountTopNForm> getTopNForm(Map<String, List<BisAttackCountTopNForm>> allCollectorForm, int topn) {
        int i;
        List<BisAttackCountTopNForm> allForm = new ArrayList<BisAttackCountTopNForm>();
        for (Map.Entry<String, List<BisAttackCountTopNForm>> entry : allCollectorForm.entrySet()) {
            allForm.addAll((Collection)entry.getValue());
        }
        for (i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (!allForm.get(i).getBisId().equals(allForm.get(j).getBisId())) continue;
                allForm.get(i).setAttackTimes(allForm.get(i).getAttackTimes() + allForm.get(j).getAttackTimes());
                allForm.remove(j);
            }
        }
        allForm = this.sortZoneAttackTimeTopNFormListByField(allForm, "attackTimes", "DESC");
        this.processData4Order(allForm);
        if (allForm.size() > topn) {
            for (i = allForm.size() - 1; i >= topn; --i) {
                allForm.remove(i);
            }
        }
        return allForm;
    }

    private void processData4Order(List<BisAttackCountTopNForm> orderformList) {
        for (int i = 0; i < orderformList.size(); ++i) {
            for (int j = i + 1; j < orderformList.size(); ++j) {
                if (!orderformList.get(i).getAttackTimes().equals(orderformList.get(j).getAttackTimes())) continue;
                this.processItemOrder(orderformList, i, j);
            }
        }
    }

    private void processItemOrder(List<BisAttackCountTopNForm> orderformList, int i, int j) {
        if (orderformList.get(i).getBisId() > orderformList.get(j).getBisId()) {
            BisAttackCountTopNForm temp = orderformList.get(i);
            orderformList.set(i, orderformList.get(j));
            orderformList.set(j, temp);
        } else if (orderformList.get(i).getBisId().equals(orderformList.get(j).getBisId()) && orderformList.get(i).getZoneId() > orderformList.get(j).getZoneId()) {
            BisAttackCountTopNForm temp = orderformList.get(i);
            orderformList.set(i, orderformList.get(j));
            orderformList.set(j, temp);
        }
    }

    private List<BisAttackCountTopNForm> sortZoneAttackTimeTopNFormListByField(List<BisAttackCountTopNForm> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }
}

