/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.droptrend;

import com.hs.atic.analysis.report.attack.droptrend.DropTrend;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.DropTrendForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.secservice.ddos.policy.util.PolicyUtil;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DropTrendChartDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<DropTrend> dataList = new ArrayList<DropTrend>();
    private IDataStatService dataStatService;

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        return this.dataList;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getPrepareParasMap(queryCond);
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start DropTrendChartDataSet prepareData()");
        List<DropTrendForm> attackTrendFormList = null;
        Map<String, List<DropTrendForm>> allCollectorAttackTypeForm = null;
        try {
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            if (datastatConditionForm.getDeviceId() > 0L) {
                allCollectorAttackTypeForm = this.getSingleDeviceData(datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
                Map<Long, List<AticDevice>> collectDevMap = null;
                collectDevMap = ReportAnalysisUtil.getCollectDevMap(firewallList);
                allCollectorAttackTypeForm = this.getAllCollectorIpTopNForm(collectDevMap, datastatConditionForm);
            }
            if (-2L == datastatConditionForm.getDeviceId()) {
                attackTrendFormList = this.getAllDetectTopNForm(allCollectorAttackTypeForm);
            } else {
                ArrayList<DropTrendForm> allForm = new ArrayList<DropTrendForm>();
                for (Map.Entry<String, List<DropTrendForm>> entry : allCollectorAttackTypeForm.entrySet()) {
                    allForm.addAll((Collection<DropTrendForm>)entry.getValue());
                }
                attackTrendFormList = this.getTopNForm(allForm, 1);
            }
            attackTrendFormList = this.getAllTimeData(attackTrendFormList, datastatConditionForm.getStartTime(), datastatConditionForm.getEndTime());
            this.getAttackTrendFormData(attackTrendFormList);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            this.logger.error((Object)("AttackTrendChartDataSet prepareData() exception" + legoException.getErrorCode() + ". " + legoException.getMessage()));
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)("AttackTrendChartDataSet prepareData() unknow exception!" + e.getMessage()));
        }
        this.logger.info((Object)"end DropTrendChartDataSet  prepareData()");
        return 0;
    }

    private void getAttackTrendFormData(List<DropTrendForm> attackTrendFormList) {
        for (DropTrendForm form : attackTrendFormList) {
            DropTrend data = new DropTrend();
            data.setDateTime(form.getDateTime() * 1000L);
            data.setDropTypePackagePps(form.getDropPackagePps());
            data.setDropTypeName(form.getDropTypeName());
            this.dataList.add(data);
        }
    }

    private Map<String, List<DropTrendForm>> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        HashMap<String, List<DropTrendForm>> allCollectorAttackTypeForm = new HashMap();
        try {
            allCollectorAttackTypeForm = this.dataStatService.getDropTrend(datastatConditionForm, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId + ". " + e.getMessage()));
        }
        return allCollectorAttackTypeForm;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        String zoneId = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        if (!"0".equals(zoneId)) {
            datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        } else {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        String bisId = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox");
        bisId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processServiceCond(datastatConditionForm, bisId);
        String zoneIp = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip");
        zoneIp = String.valueOf(jsonValueItem.get(0).getValue());
        if (!AticUtil.isNull((String)zoneIp)) {
            datastatConditionForm.setZoneIp(zoneIp);
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
    }

    private List<DropTrendForm> getAllDetectTopNForm(Map<String, List<DropTrendForm>> inputMap) {
        List<DropTrendForm> distinctForm = new ArrayList<DropTrendForm>();
        List listDefendGroupForm = ReportBisUtil.getDefendGroupService().getAll();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        for (DefendGroupForm defendGroupForm : listDefendGroupForm) {
            String[] devIds;
            ArrayList<DropTrendForm> listForm = new ArrayList<DropTrendForm>();
            if (null == defendGroupForm.getDevices() || "".equals(defendGroupForm.getDevices())) continue;
            for (String devId : devIds = defendGroupForm.getDevices().split(",")) {
                AticDevice firewall = firewallService.getDeviceByMoid(Long.parseLong(devId));
                if (null == firewall) continue;
                String devIp = firewall.getIpAddress();
                if (!inputMap.containsKey(devIp = AticUtil.formatIpAddress((String)devIp))) continue;
                listForm.addAll((Collection<DropTrendForm>)inputMap.get(devIp));
                inputMap.remove(devIp);
            }
            if (listForm.isEmpty()) continue;
            distinctForm.addAll(this.getTopNForm(listForm, defendGroupForm.getDetectMode()));
        }
        for (Map.Entry entry : inputMap.entrySet()) {
            distinctForm.addAll((Collection)entry.getValue());
        }
        distinctForm = this.getTopNForm(distinctForm, 1);
        return distinctForm;
    }

    private List<DropTrendForm> getAllTimeData(List<DropTrendForm> attackTrendFormList, long startTime, long endTime) {
        startTime = ReportAnalysisUtil.getRealStartTime(startTime, endTime);
        long timeSlot = this.getTimeSlot(startTime, endTime);
        ArrayList<String> attackTypeNameList = new ArrayList<String>();
        Long minTime = 0L;
        Long maxTime = 0L;
        for (int i = 0; i < attackTrendFormList.size(); ++i) {
            DropTrendForm form = attackTrendFormList.get(i);
            if (i == 0) {
                minTime = form.getDateTime();
                maxTime = form.getDateTime();
            } else {
                if (form.getDateTime() < minTime) {
                    minTime = form.getDateTime();
                }
                if (form.getDateTime() > maxTime) {
                    maxTime = form.getDateTime();
                }
            }
            this.getAttackTypeNameList(form, attackTypeNameList);
        }
        HashMap<Long, List<DropTrendForm>> map = new HashMap<Long, List<DropTrendForm>>();
        while (minTime <= maxTime) {
            ArrayList<DropTrendForm> tmpList = new ArrayList<DropTrendForm>();
            for (DropTrendForm form : attackTrendFormList) {
                if (!form.getDateTime().equals(minTime)) continue;
                tmpList.add(form);
            }
            map.put(minTime, tmpList);
            minTime = minTime + timeSlot;
        }
        this.getAttackTrendFormList(map, attackTypeNameList, attackTrendFormList);
        return attackTrendFormList;
    }

    private void getAttackTrendFormList(Map<Long, List<DropTrendForm>> map, List<String> attackTypeNameList, List<DropTrendForm> attackTrendFormList) {
        for (Map.Entry<Long, List<DropTrendForm>> entry : map.entrySet()) {
            for (int i = 0; i < attackTypeNameList.size(); ++i) {
                boolean hasData = false;
                for (DropTrendForm form : entry.getValue()) {
                    if (!form.getDropTypeName().equals(attackTypeNameList.get(i))) continue;
                    hasData = true;
                    break;
                }
                if (hasData) continue;
                DropTrendForm form = new DropTrendForm();
                form.setDateTime(entry.getKey());
                form.setDropPackagePps(0L);
                form.setDropTypeName(attackTypeNameList.get(i));
                attackTrendFormList.add(form);
            }
        }
    }

    private void getAttackTypeNameList(DropTrendForm form, List<String> attackTypeNameList) {
        boolean hasData = false;
        for (int j = 0; j < attackTypeNameList.size(); ++j) {
            if (!form.getDropTypeName().equals(attackTypeNameList.get(j))) continue;
            hasData = true;
            break;
        }
        if (!hasData) {
            attackTypeNameList.add(form.getDropTypeName());
        }
    }

    private long getTimeSlot(long startTime, long endTime) {
        long timeSlot = 0L;
        int type = ReportAnalysisUtil.getTimeSpanType(endTime, startTime);
        timeSlot = type == AnalysisConstants.LESS_THAN_SEVEN_DAYS ? PolicyUtil.NUM_THREE_THOUSAND_SIX_HUNDRED : (type == AnalysisConstants.MORE_THAN_SEVEN_DAYS ? 24L * PolicyUtil.NUM_THREE_THOUSAND_SIX_HUNDRED : PolicyUtil.NUM_THREE_HUNDRED);
        return timeSlot;
    }

    private Map<String, List<DropTrendForm>> getAllCollectorIpTopNForm(Map<Long, List<AticDevice>> collectDevMap, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<DropTrendForm>> allCollectorRequestTrendForm = new HashMap<String, List<DropTrendForm>>();
        for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
            String collectorIp = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue()).getIpAddress();
            datastatConditionForm.setDeviceIpList(new ArrayList<String>());
            for (AticDevice firewall : entry.getValue()) {
                if (null == datastatConditionForm.getDeviceIpList()) {
                    datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                }
                datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
            }
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            Map<Object, Object> tempMap = new HashMap();
            try {
                tempMap = this.dataStatService.getDropTrend(datastatConditionForm, collectorIp);
            }
            catch (Exception e) {
                this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey() + ". " + e.getMessage()));
            }
            allCollectorRequestTrendForm.putAll(tempMap);
        }
        return allCollectorRequestTrendForm;
    }

    private List<DropTrendForm> getTopNForm(List<DropTrendForm> allForm, int netMode) {
        for (int i = 0; i < allForm.size(); ++i) {
            for (int j = allForm.size() - 1; j > i; --j) {
                if (!allForm.get(i).getDateTime().equals(allForm.get(j).getDateTime()) || !allForm.get(i).getDropTypeName().equals(allForm.get(j).getDropTypeName())) continue;
                this.dealWithSame(allForm, netMode, i, j);
            }
        }
        return allForm;
    }

    private void dealWithSame(List<DropTrendForm> allForm, int netMode, int i, int j) {
        if (netMode == 0) {
            if (allForm.get(i).getDropPackagePps() > allForm.get(j).getDropPackagePps()) {
                allForm.get(i).setDropPackagePps(allForm.get(i).getDropPackagePps());
            } else {
                allForm.get(i).setDropPackagePps(allForm.get(j).getDropPackagePps());
            }
            allForm.remove(j);
        } else if (netMode == 1) {
            allForm.get(i).setDropPackagePps(allForm.get(i).getDropPackagePps() + allForm.get(j).getDropPackagePps());
            allForm.remove(j);
        }
    }
}

