/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.ipattack;

import com.hs.atic.analysis.report.attack.ipattack.IpAttackTimeTopN;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.RedunDeviceForm;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.res.util.ResActionUtil;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.form.DeviceWorkTimeForm;
import com.hs.atic.sdk.analysis.form.IpAttackTimeTopNForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class IpAttackTimeTopNDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<IpAttackTimeTopN> dataList = new ArrayList<IpAttackTimeTopN>();
    private Long queryStartData;
    private Long queryEndData;
    private IDataStatService dataStatService;
    private String zoneIp;

    public List<IpAttackTimeTopN> sortListByField(List<IpAttackTimeTopN> beSortedList, String sortField, String sortType) {
        if (sortField.equalsIgnoreCase("disIp")) {
            sortField = "zoneIp";
        }
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public List<IpAttackTimeTopNForm> sortZoneAttackTimeTopNFormListByField(List<IpAttackTimeTopNForm> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getLogoAndNameMap(queryCond);
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        List<IpAttackTimeTopN> orderedList = null;
        if (sortList != null) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<IpAttackTimeTopN> list = new ArrayList<IpAttackTimeTopN>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String dataSourceId, long sessionId) {
        return this.dataList.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start IpAttackTimeTopNDataSet prepareData");
        List<IpAttackTimeTopNForm> ipTopNFormList = null;
        Map<String, List<IpAttackTimeTopNForm>> allCollectorForm = null;
        try {
            DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
            this.getConditionForm(queryCond, datastatConditionForm, sessionId);
            if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
                return 0;
            }
            if (null != datastatConditionForm.getSessionId() && datastatConditionForm.getZoneIdList().isEmpty()) {
                return 0;
            }
            List<IpAttackTimeTopNForm> formDataList = null;
            if (datastatConditionForm.getDeviceId() > 0L) {
                formDataList = this.getSingleDeviceData(datastatConditionForm);
            } else {
                Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
                List<AticDevice> firewallList = ReportAnalysisUtil.getFireWallOfCleanOrDetect(datastatConditionForm, currentLogUserId);
                allCollectorForm = -2L == datastatConditionForm.getDeviceId() ? this.getAllDetectDeviceDate(firewallList, datastatConditionForm) : this.getAllCollectorIpTopNForm(firewallList, datastatConditionForm);
                formDataList = this.processMultZoneNE(allCollectorForm);
            }
            ipTopNFormList = this.getTopNForm(formDataList, datastatConditionForm.getTopn());
            this.dataList = this.getAttackTimeFormDate(ipTopNFormList, queryCond);
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)("IpAttackTimeTopNDataSet prepareData() unknow exception!" + e.getMessage()));
        }
        this.logger.info((Object)"end IpAttackTimeTopNDataSet prepareData");
        return 0;
    }

    private List<IpAttackTimeTopN> getAttackTimeFormDate(List<IpAttackTimeTopNForm> ipTopNFormList, Map<?, ?> queryCond) {
        HashMap<String, Integer> sameIpNameNum = new HashMap<String, Integer>();
        for (IpAttackTimeTopNForm form : ipTopNFormList) {
            if (sameIpNameNum.containsKey(form.getDisIp())) {
                int newNum = (Integer)sameIpNameNum.get(form.getDisIp()) + 1;
                sameIpNameNum.put(form.getDisIp(), newNum);
                continue;
            }
            sameIpNameNum.put(form.getDisIp(), 1);
        }
        Set set = sameIpNameNum.entrySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Integer num = (Integer)entry.getValue();
            if (num > 1) continue;
            iter.remove();
        }
        List<IpAttackTimeTopN> returnDataList = this.processFinalData(queryCond, ipTopNFormList, sameIpNameNum);
        return returnDataList;
    }

    private List<IpAttackTimeTopN> processFinalData(Map<?, ?> queryCond, List<IpAttackTimeTopNForm> ipTopNFormList, Map<String, Integer> sameIpNameNum) {
        ArrayList<IpAttackTimeTopN> returnDataList = new ArrayList<IpAttackTimeTopN>();
        IZoneService zoneService = ReportBisUtil.getZoneService();
        Locale locale = ReportAnalysisUtil.getCurrentUserLocale4Report(queryCond);
        for (int i = 0; i < ipTopNFormList.size(); ++i) {
            IpAttackTimeTopN data = new IpAttackTimeTopN();
            data.setTotalDate(ipTopNFormList.get(i).getTotalDate());
            data.setDisTotalDate(ReportAnalysisUtil.longTimeToTotalHMS(ipTopNFormList.get(i).getTotalDate(), locale));
            ZoneInfoForm zoneForm = zoneService.getById(ipTopNFormList.get(i).getZoneId());
            if (null == zoneForm || "".equals(zoneForm.getZoneDesc())) {
                this.logger.info((Object)("the zone not exist,zoneId = " + ipTopNFormList.get(i).getZoneId()));
                data.setZoneName(AticUtil.getText((String)"atic.analysis.common.unknownZone") + ipTopNFormList.get(i).getZoneId());
            } else {
                data.setZoneName(zoneForm.getZoneDesc());
            }
            String key = ipTopNFormList.get(i).getDisIp();
            if (sameIpNameNum.containsKey(key) && sameIpNameNum.get(key) > 0) {
                int tempNum = sameIpNameNum.get(key);
                data.setDisIp(IPUtil4Atic.compressIP((String)key) + "(" + tempNum + ")");
                sameIpNameNum.put(key, tempNum - 1);
            } else {
                data.setDisIp(IPUtil4Atic.compressIP((String)ipTopNFormList.get(i).getDisIp()));
            }
            data.setZoneIp(ipTopNFormList.get(i).getZoneIp());
            returnDataList.add(data);
        }
        return returnDataList;
    }

    /*
     * WARNING - void declaration
     */
    private List<IpAttackTimeTopNForm> processMultZoneNE(Map<String, List<IpAttackTimeTopNForm>> allCollectorForm) {
        ArrayList<IpAttackTimeTopNForm> returnData = new ArrayList<IpAttackTimeTopNForm>();
        Map<String, Map<String, List<IpAttackTimeTopNForm>>> ipDeviceData = this.processMultNEIpData(allCollectorForm);
        for (Map.Entry<String, Map<String, List<IpAttackTimeTopNForm>>> entry : ipDeviceData.entrySet()) {
            if (1 == entry.getValue().size()) {
                void var8_10;
                Long totalDate = 0L;
                Object zoneId = 0L;
                String string = "";
                String disIp = "";
                for (Map.Entry<String, List<IpAttackTimeTopNForm>> bizData : entry.getValue().entrySet()) {
                    for (IpAttackTimeTopNForm form : bizData.getValue()) {
                        totalDate = totalDate + form.getTotalDate();
                        zoneId = form.getZoneId();
                        String string2 = form.getZoneIp();
                        disIp = form.getDisIp();
                    }
                }
                IpAttackTimeTopNForm temp = new IpAttackTimeTopNForm();
                temp.setZoneIp((String)var8_10);
                temp.setZoneId((Long)zoneId);
                temp.setDisIp(disIp);
                temp.setTotalDate(totalDate);
                returnData.add(temp);
                continue;
            }
            ArrayList<IpAttackTimeTopNForm> bizData = new ArrayList<IpAttackTimeTopNForm>();
            for (Map.Entry entry2 : entry.getValue().entrySet()) {
                bizData.addAll((Collection)entry2.getValue());
            }
            IpAttackTimeTopNForm temp = this.processBizTotalData(bizData);
            if (null == temp) continue;
            returnData.add(temp);
        }
        return returnData;
    }

    private Map<String, Map<String, List<IpAttackTimeTopNForm>>> processMultNEIpData(Map<String, List<IpAttackTimeTopNForm>> allCollectorForm) {
        HashMap<String, Map<String, List<IpAttackTimeTopNForm>>> ipDeviceData = new HashMap<String, Map<String, List<IpAttackTimeTopNForm>>>();
        for (Map.Entry<String, List<IpAttackTimeTopNForm>> entry : allCollectorForm.entrySet()) {
            for (IpAttackTimeTopNForm ipData : entry.getValue()) {
                List<IpAttackTimeTopNForm> list;
                Map deviceData;
                String mapKey = ipData.getZoneIp() + "-" + ipData.getZoneId();
                if (ipDeviceData.containsKey(mapKey)) {
                    deviceData = (Map)ipDeviceData.get(mapKey);
                    list = deviceData.containsKey(ipData.getDeviceIp()) ? (List)deviceData.get(ipData.getDeviceIp()) : new ArrayList();
                } else {
                    deviceData = new HashMap();
                    list = new ArrayList<IpAttackTimeTopNForm>();
                }
                list.add(ipData);
                deviceData.put(ipData.getDeviceIp(), list);
                ipDeviceData.put(mapKey, deviceData);
            }
        }
        return ipDeviceData;
    }

    private IpAttackTimeTopNForm processBizTotalData(List<IpAttackTimeTopNForm> zoneDataList) {
        if (null == zoneDataList || zoneDataList.isEmpty()) {
            return null;
        }
        List<IpAttackTimeTopNForm> orderForm = this.sortZoneAttackTimeTopNFormListByField(zoneDataList, "startDate", "ASC");
        ArrayList<IpAttackTimeTopNForm> unionList = new ArrayList<IpAttackTimeTopNForm>();
        unionList.add(orderForm.get(0));
        for (int i = 1; i < orderForm.size(); ++i) {
            IpAttackTimeTopNForm check = (IpAttackTimeTopNForm)unionList.get(unionList.size() - 1);
            if (orderForm.get(i).getEndData() <= check.getEndData()) continue;
            if (orderForm.get(i).getStartDate() > check.getEndData()) {
                unionList.add(orderForm.get(i));
                continue;
            }
            if (orderForm.get(i).getStartDate() > check.getEndData()) continue;
            ((IpAttackTimeTopNForm)unionList.get(unionList.size() - 1)).setEndData(orderForm.get(i).getEndData());
        }
        Long startTime = ((IpAttackTimeTopNForm)unionList.get(0)).getStartDate();
        Long endTime = ((IpAttackTimeTopNForm)unionList.get(unionList.size() - 1)).getEndData();
        if (this.queryStartData > startTime) {
            ((IpAttackTimeTopNForm)unionList.get(0)).setStartDate(this.queryStartData);
        }
        if (this.queryEndData < endTime) {
            ((IpAttackTimeTopNForm)unionList.get(unionList.size() - 1)).setEndData(this.queryEndData);
        }
        Long totalDate = 0L;
        for (IpAttackTimeTopNForm form : unionList) {
            totalDate = totalDate + (form.getEndData() - form.getStartDate());
        }
        IpAttackTimeTopNForm returnData = new IpAttackTimeTopNForm();
        returnData.setTotalDate(totalDate);
        returnData.setZoneId(((IpAttackTimeTopNForm)unionList.get(0)).getZoneId());
        returnData.setZoneIp(((IpAttackTimeTopNForm)unionList.get(0)).getZoneIp());
        returnData.setDisIp(((IpAttackTimeTopNForm)unionList.get(0)).getDisIp());
        return returnData;
    }

    private Map<String, List<IpAttackTimeTopNForm>> getAllDetectDeviceDate(List<AticDevice> firewallList, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<IpAttackTimeTopNForm>> allCollectorForm = new HashMap<String, List<IpAttackTimeTopNForm>>();
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        Map<Long, List<RedunDeviceForm>> redunMap = ReportAnalysisUtil.getRedunFirewallInfoList(firewallList);
        for (Map.Entry<Long, List<RedunDeviceForm>> redun : redunMap.entrySet()) {
            List<DeviceWorkTimeForm> workTimeList = ReportAnalysisUtil.getWorkTimeList(datastatConditionForm, redun);
            for (DeviceWorkTimeForm form : workTimeList) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(form.getDeviceIp());
                datastatConditionForm.setDeviceIpList(list);
                datastatConditionForm.setStartTime(form.getStartTime());
                datastatConditionForm.setEndTime(form.getEndTime());
                Map<Object, Object> tempFormMap = new HashMap();
                try {
                    tempFormMap = this.dataStatService.getIpAttackTimeTopN(datastatConditionForm, form.getCollectorIp());
                }
                catch (Exception e) {
                    this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorIp = " + form.getCollectorIp() + ". " + e.getMessage()));
                }
                if (null == tempFormMap || tempFormMap.isEmpty()) continue;
                if (allCollectorForm.containsKey(form.getDeviceIp())) {
                    ((List)allCollectorForm.get(form.getDeviceIp())).addAll((Collection)tempFormMap.get(form.getDeviceIp()));
                    continue;
                }
                allCollectorForm.putAll(tempFormMap);
            }
        }
        List<AticDevice> redunFirewallList = ReportAnalysisUtil.getRedunFirewallList(redunMap);
        if (!redunFirewallList.isEmpty()) {
            firewallList.removeAll(redunFirewallList);
        }
        if (!firewallList.isEmpty()) {
            allCollectorForm.putAll(this.getAllCollectorIpTopNForm(firewallList, datastatConditionForm));
        }
        return allCollectorForm;
    }

    private List<IpAttackTimeTopNForm> getSingleDeviceData(DataStatConditionForm datastatConditionForm) {
        ArrayList<IpAttackTimeTopNForm> returnData = new ArrayList<IpAttackTimeTopNForm>();
        IAticDeviceService firewallService = ReportBisUtil.getIFirewallService();
        AticDevice firewall = firewallService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = ResActionUtil.getCollectorService();
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            Map<String, List<IpAttackTimeTopNForm>> allCollectorForm = this.dataStatService.getIpAttackTimeTopN(datastatConditionForm, collectorInfo.getIpAddress());
            for (Map.Entry<String, List<IpAttackTimeTopNForm>> entry : allCollectorForm.entrySet()) {
                returnData.addAll((Collection<IpAttackTimeTopNForm>)entry.getValue());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId + ". " + e.getMessage()));
        }
        return returnData;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private void getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm, Long sessionId) {
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        String direction = String.valueOf(jsonValueItem.get(0).getValue());
        if (direction.matches("^[\\d]*$")) {
            datastatConditionForm.setDirection(Integer.parseInt(direction));
        } else {
            datastatConditionForm.setDirection(1);
        }
        ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        String zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        if (!(0L != datastatConditionForm.getZoneId() || AnalysisConstants.getInstance().getReportType().equalsIgnoreCase("ips") && AnalysisConstants.getInstance().getReportTypeIpsReport().booleanValue())) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, datastatConditionForm, sessionId);
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox");
        String bisId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processServiceCond(datastatConditionForm, bisId);
        if (!AticUtil.isNull((String)this.zoneIp)) {
            datastatConditionForm.setZoneIp(AticUtil.htmlEncodeCore((String)this.zoneIp));
        }
        ReportAnalysisUtil.setDateRange(queryCond, datastatConditionForm);
        this.queryStartData = datastatConditionForm.getStartTime();
        this.queryEndData = datastatConditionForm.getEndTime();
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN");
        String topn = String.valueOf(jsonValueItem.get(0).getValue());
        datastatConditionForm.setTopn(Integer.parseInt(topn));
        String isInteReport = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isInteReport").get(0).getValue());
        if (!AticUtil.isNull((String)isInteReport) && isInteReport.equalsIgnoreCase("true")) {
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "AbnormalOrAttackTopNTOPN");
            String topn4Inte = String.valueOf(jsonValueItem.get(0).getValue());
            Integer topn4InteValue = Integer.parseInt(topn4Inte);
            datastatConditionForm.setTopn(topn4InteValue);
        }
    }

    private Map<String, List<IpAttackTimeTopNForm>> getAllCollectorIpTopNForm(List<AticDevice> firewallList, DataStatConditionForm datastatConditionForm) {
        HashMap<String, List<IpAttackTimeTopNForm>> allCollectorIpTopNForm = new HashMap<String, List<IpAttackTimeTopNForm>>();
        if (!firewallList.isEmpty()) {
            Map<Long, List<AticDevice>> collectDevMap = ReportAnalysisUtil.getCollectDevMap(firewallList);
            for (Map.Entry<Long, List<AticDevice>> entry : collectDevMap.entrySet()) {
                String collectorIp = ResActionUtil.getCollectorService().getCollectorInfo(entry.getKey().longValue()).getIpAddress();
                datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                for (AticDevice firewall : entry.getValue()) {
                    if (null == datastatConditionForm.getDeviceIpList()) {
                        datastatConditionForm.setDeviceIpList(new ArrayList<String>());
                    }
                    datastatConditionForm.getDeviceIpList().add(firewall.getIpAddress());
                }
                this.dataStatService = ReportAnalysisUtil.getDataStatService();
                try {
                    allCollectorIpTopNForm.putAll(this.dataStatService.getIpAttackTimeTopN(datastatConditionForm, collectorIp));
                }
                catch (Exception e) {
                    this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey() + ". " + e.getMessage()));
                }
            }
        }
        return allCollectorIpTopNForm;
    }

    private List<IpAttackTimeTopNForm> getTopNForm(List<IpAttackTimeTopNForm> allCollectorForm, int topn) {
        List<IpAttackTimeTopNForm> allForm = this.sortZoneAttackTimeTopNFormListByField(allCollectorForm, "totalDate", "DESC");
        this.processData4Order(allForm);
        if (allForm.size() > topn) {
            for (int i = allForm.size() - 1; i >= topn; --i) {
                allForm.remove(i);
            }
        }
        return allForm;
    }

    private void processData4Order(List<IpAttackTimeTopNForm> orderformList) {
        for (int i = 0; i < orderformList.size(); ++i) {
            for (int j = i + 1; j < orderformList.size(); ++j) {
                if (!orderformList.get(i).getTotalDate().equals(orderformList.get(j).getTotalDate())) continue;
                this.processItemOrder(orderformList, i, j);
            }
        }
    }

    private void processItemOrder(List<IpAttackTimeTopNForm> orderformList, int i, int j) {
        if (orderformList.get(i).getZoneIp().compareTo(orderformList.get(j).getZoneIp()) > 0) {
            IpAttackTimeTopNForm temp = orderformList.get(i);
            orderformList.set(i, orderformList.get(j));
            orderformList.set(j, temp);
        } else if (orderformList.get(i).getZoneIp().equals(orderformList.get(j).getZoneIp()) && orderformList.get(i).getZoneId() > orderformList.get(j).getZoneId()) {
            IpAttackTimeTopNForm temp = orderformList.get(i);
            orderformList.set(i, orderformList.get(j));
            orderformList.set(j, temp);
        }
    }

    public String getZoneIp() {
        return this.zoneIp;
    }

    public void setZoneIp(String zoneIp) {
        this.zoneIp = zoneIp;
    }

    public List<IpAttackTimeTopN> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<IpAttackTimeTopN> dataList) {
        this.dataList = dataList;
    }
}

