/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.log;

import com.hs.atic.analysis.report.attack.log.AttackExactLog;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.analysis.util.ReportAticUtil;
import com.hs.atic.analysis.util.ReportCommonUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.report.util.SystemUtil;
import com.hs.atic.sdk.analysis.form.AttackExactLogForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.sdk.util.MathUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.CommonUtil;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class AttackExactLogDataSet4AttackEvent
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<AttackExactLog> dataList = new ArrayList<AttackExactLog>();
    private boolean isIncludeV1R1 = false;
    private IDataStatService dataStatService;
    private String nextLineStr = "<br>";

    public List<AttackExactLog> sortListByField(List<AttackExactLog> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    private void setIsIncludeV1R1(List<AttackExactLogForm> attackExactLogFormList) {
        ArrayList<AticDevice> deviceList = new ArrayList<AticDevice>();
        IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        AticDevice device = null;
        for (AttackExactLogForm logForm : attackExactLogFormList) {
            device = aticDeviceService.getDeviceByIp(logForm.getDeviceIp());
            if (null == device) continue;
            deviceList.add(device);
        }
        this.isIncludeV1R1 = ReportCommonUtil.includesV1R1(deviceList);
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        int endIndex;
        this.nextLineStr = pageSize > 100L ? "\n" : "<br>";
        for (AttackExactLog log : this.dataList) {
            double avgPackLength;
            log.setAttackLogInfo(ReportAticUtil.getText("atic.analysis.common.ip.address") + AticUtil.htmlEncodeCore((String)log.getDisZoneIp()) + this.nextLineStr + ReportAticUtil.getText("atic.analysis.common.ip.protocol") + AticUtil.transformProtocol((int)log.getProtocol()) + this.nextLineStr + ReportAticUtil.getText("atic.analysis.common.ip.port") + AticUtil.htmlEncodeCore((String)log.getDestinationPort()) + this.nextLineStr + ReportAticUtil.getText("atic.analysis.common.zone") + AticUtil.htmlEncodeCore((String)log.getZoneDesc()));
            String endTime = log.getDisEndTime().length() > 5 ? log.getDisEndTime().substring(5) : log.getDisEndTime();
            log.setAttackLogTimes(ReportAticUtil.getText("atic.analysis.report.time.start") + log.getDisStartTimeAlert().substring(5) + this.nextLineStr + ReportAticUtil.getText("atic.analysis.report.time.end") + endTime);
            log.setAttackTypeAndPacket(ReportAticUtil.getText("atic.analysis.common.type") + log.getAttackType() + this.nextLineStr + ReportAticUtil.getText("atic.analysis.report.attack.dropPacket") + log.getDropPackets());
            String avgPackLengthStr = "-";
            if (log.getDropBytes() > 0L && log.getDropPackets() > 0L && (avgPackLength = MathUtil.getDoubleValue((double)((double)(log.getDropBytes() * 1024L) / (double)(log.getDropPackets() * 8L)))) > 24.0) {
                avgPackLengthStr = CommonUtil.transformNumber((String)String.valueOf(avgPackLength - 24.0), (String)"");
            }
            String curAndLimit = "";
            if (1 == log.getDeviceType() || log.getStartTimeAttack() <= 0L) {
                curAndLimit = 3 != log.getPpsOrKbps() ? curAndLimit + ReportAticUtil.getText("atic.analysis.report.attack.attackFlow") + log.getCurrentDis() + this.nextLineStr : curAndLimit + ReportAnalysisUtil.getMaxPeakStr(log) + this.nextLineStr;
                curAndLimit = curAndLimit + ReportAticUtil.getText("atic.report.integration.limitValue") + log.getLimitDis();
            } else {
                curAndLimit = curAndLimit + ReportAticUtil.getText("atic.analysis.report.attack.dropKbits") + CommonUtil.transformNumber((String)String.valueOf(log.getDropBytes() / 8L), (String)"") + this.nextLineStr + ReportAticUtil.getText("atic.analysis.report.average.pack.length") + avgPackLengthStr + this.nextLineStr;
                if (3 != log.getPpsOrKbps()) {
                    curAndLimit = curAndLimit + ReportAticUtil.getText("atic.analysis.report.attack.attackFlow") + log.getCurrentDis() + this.nextLineStr;
                }
                curAndLimit = curAndLimit + ReportAnalysisUtil.getMaxPeakStr(log) + this.nextLineStr + ReportAticUtil.getText("atic.report.integration.limitValue") + log.getLimitDis();
            }
            log.setAttackCurAndLimit(curAndLimit);
        }
        List<AttackExactLog> orderedList = null;
        if (sortList != null) {
            OrderInfo order = sortList;
            orderedList = this.sortListByField(this.dataList, order.getOrderField(), order.getOrderType());
        } else {
            orderedList = this.dataList;
        }
        if (pageIndex == 0L && pageSize == 0L) {
            return orderedList;
        }
        ArrayList<AttackExactLog> list = new ArrayList<AttackExactLog>();
        int startIndex = (int)((pageIndex - 1L) * pageSize);
        if (startIndex < 0 || startIndex >= orderedList.size()) {
            startIndex = orderedList.size() - 1;
        }
        if ((endIndex = (int)(pageIndex * pageSize)) < 0 || endIndex >= orderedList.size()) {
            endIndex = orderedList.size();
        }
        if (orderedList.isEmpty()) {
            return list;
        }
        list.addAll(orderedList.subList(startIndex, endIndex));
        return list;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.dataList.size();
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        this.logger.info((Object)"start AttackExactLogDataSet4AttackEvent prepareData");
        DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
        String collectorIp = this.getConditionForm(queryCond, datastatConditionForm);
        if (!ReportAnalysisUtil.checkDeviceAuthority(queryCond, datastatConditionForm)) {
            return 0;
        }
        if (!ReportAnalysisUtil.checkZoneAuthority(queryCond, datastatConditionForm)) {
            return 0;
        }
        List<AttackExactLogForm> attackExactLogFormList = null;
        try {
            this.dataStatService = ReportAnalysisUtil.getDataStatService();
            Locale locale = LocaleUtil.getInstance().getCurrentUserLocale();
            String language = locale.getLanguage();
            attackExactLogFormList = this.dataStatService.getAttackExactLog4AttackEvent(datastatConditionForm, collectorIp, language);
            if (null == attackExactLogFormList) {
                this.logger.info((Object)"AttackExactLogFormList is null !");
                return 0;
            }
            this.setIsIncludeV1R1(attackExactLogFormList);
            for (AttackExactLogForm form : attackExactLogFormList) {
                this.processExactLogItem(form, collectorIp, sessionId);
            }
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            throw legoException;
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)("AttackExactLogDataSet4AttackEvent prepareData happened exception !" + e.getMessage()));
        }
        this.logger.info((Object)"end AttackExactLogDataSet4AttackEvent prepareData");
        return 0;
    }

    private String getConditionForm(Map<?, ?> queryCond, DataStatConditionForm datastatConditionForm) {
        List<JsonValueItem> jsonValueItem = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
        String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
        ReportAnalysisUtil.processDeviceInfo(datastatConditionForm, deviceId);
        IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        AticDevice firewall = aticDeviceService.getDeviceByMoid(datastatConditionForm.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForm.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForm.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = (ICollectorService)ServiceContext.getInstance().getService("collectorService", ICollectorService.class);
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(Long.valueOf(firewall.getMoId()));
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "collectorIp");
        String collectorIp = collectorInfo.getIpAddress();
        String zoneId = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
        zoneId = String.valueOf(jsonValueItem.get(0).getValue());
        if (!"0".equals(zoneId)) {
            datastatConditionForm.setZoneId(Long.parseLong(zoneId));
        }
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
        int direction = Integer.parseInt(jsonValueItem.get(0).getValue());
        datastatConditionForm.setDirection(direction);
        String bisId = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox");
        bisId = String.valueOf(jsonValueItem.get(0).getValue());
        if (AticUtil.isNull((String)bisId)) {
            bisId = "0";
        }
        ReportAnalysisUtil.processServiceCond(datastatConditionForm, bisId);
        String zoneIp = null;
        jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip");
        zoneIp = String.valueOf(jsonValueItem.get(0).getValue());
        if (!AticUtil.isNull((String)zoneIp)) {
            datastatConditionForm.setZoneIp(zoneIp);
        }
        long startTime = Long.parseLong(ReportAnalysisUtil.getJsonValueItemList(queryCond, "startTime").get(0).getText());
        datastatConditionForm.setStartTime(startTime);
        long endTime = Long.parseLong(ReportAnalysisUtil.getJsonValueItemList(queryCond, "endTime").get(0).getText());
        datastatConditionForm.setEndTime(endTime);
        return collectorIp;
    }

    private void processExactLogItem(AttackExactLogForm form, String collectorIp, long sessionId) {
        AttackExactLog log = new AttackExactLog();
        AticUtil.copyProperties((Object)form, (Object)log);
        this.processSrcIpAndZoneIp(form, log, sessionId, collectorIp);
        this.processZoneName(form, log);
        log.setDisplayDuration(ReportAnalysisUtil.longTimeToHMS(log.getDuration()));
        if (0 != form.getAttackStatus()) {
            log.setDisEndTime("-");
        }
        this.processAttackType(form, log);
        this.processUnit(form, log);
        String contextPath = SystemUtil.getContextPath();
        String checkPcapFile = this.processPcapFile(contextPath, form, collectorIp, log);
        log.setCheckPcapFile(checkPcapFile);
        String checkFlowGraph = this.processFlowGraph(contextPath, collectorIp, form, sessionId);
        log.setCheckFlowGraph(checkFlowGraph);
        Map<String, JsonValueObj> reportQueryCond = this.processSingleAttackSnap(form, collectorIp, log);
        log.setQueryCondtion(reportQueryCond);
        log.setSrcIp(AticUtil.htmlEncodeCore((String)log.getSrcIp()));
        this.dataList.add(log);
    }

    private void processZoneName(AttackExactLogForm form, AttackExactLog log) {
        ZoneInfoForm zoneForm = ReportBisUtil.getZoneService().getById(form.getZoneId());
        if (null != zoneForm) {
            log.setZoneDesc(AticUtil.htmlEncodeCore((String)zoneForm.getZoneDesc()));
        } else {
            this.logger.info((Object)("the zone not exist,zoneId = " + form.getZoneId()));
            log.setZoneDesc(ReportAticUtil.getText("atic.analysis.common.unknownZone") + form.getZoneId());
        }
    }

    private void processAttackType(AttackExactLogForm form, AttackExactLog log) {
        log.setAttackStatuStr(ReportAnalysisUtil.getExactLogAttackStatus().get(String.valueOf(form.getAttackStatus())));
        if (log.getAttackTypeValue() >= 10) {
            log.setAttackType(ReportAnalysisUtil.getDisplayAttackType(String.valueOf(log.getAttackTypeValue())));
        } else {
            log.setAttackType(ReportAnalysisUtil.getCustomAttackTypeStr(form.getZoneId(), form.getDeviceIp(), form.getProtocol(), form.getPort()));
        }
    }

    private void processUnit(AttackExactLogForm form, AttackExactLog log) {
        String currentDis = ReportAnalysisUtil.getCurrentDis(form);
        String limitDis = ReportAnalysisUtil.getLimitDis(form);
        log.setCurrentDis(currentDis);
        log.setLimitDis(limitDis);
    }

    private Map<String, JsonValueObj> processSingleAttackSnap(AttackExactLogForm form, String collectorIp, AttackExactLog log) {
        HashMap<String, JsonValueObj> reportQueryCond = new HashMap<String, JsonValueObj>();
        JsonValueObj deviceIpObj = new JsonValueObj(form.getDeviceIp(), form.getDeviceIp(), form.getDeviceIp());
        reportQueryCond.put("deviceIp", deviceIpObj);
        int deviceType = 0;
        if (0L == log.getStartTimeAttack()) {
            deviceType = 1;
        }
        JsonValueObj deviceTypeObj = new JsonValueObj(String.valueOf(deviceType), String.valueOf(deviceType), String.valueOf(deviceType));
        reportQueryCond.put("deviceType", deviceTypeObj);
        JsonValueObj zoneComboboxObj = new JsonValueObj(form.getZoneId().toString(), form.getZoneId().toString(), form.getZoneId().toString());
        reportQueryCond.put("zone_combobox", zoneComboboxObj);
        JsonValueObj bisObj = new JsonValueObj(form.getBizId().toString(), form.getBizId().toString(), form.getBizId().toString());
        reportQueryCond.put("bis_combobox", bisObj);
        JsonValueObj zoneIpObj = new JsonValueObj(form.getZoneIp(), form.getZoneIp(), form.getZoneIp());
        reportQueryCond.put("zone_ip", zoneIpObj);
        JsonValueObj attackTypeObj = new JsonValueObj(form.getAttackTypeValue().toString(), form.getAttackTypeValue().toString(), form.getAttackTypeValue().toString());
        reportQueryCond.put("attackType", attackTypeObj);
        JsonValueObj protocolObj = new JsonValueObj(form.getProtocol().toString(), form.getProtocol().toString(), form.getProtocol().toString());
        reportQueryCond.put("protocol", protocolObj);
        JsonValueObj portObj = new JsonValueObj(form.getPort().toString(), form.getPort().toString(), form.getPort().toString());
        reportQueryCond.put("port", portObj);
        JsonValueObj collectorIpObj = new JsonValueObj(collectorIp, collectorIp, collectorIp);
        reportQueryCond.put("collectorIp", collectorIpObj);
        JsonValueObj startTimeObj = new JsonValueObj(log.getStartTimeAttack().toString(), log.getStartTimeAttack().toString(), AticUtil.convertTimeLong((Long)log.getStartTimeAttack()));
        JsonValueObj endTimeObj = new JsonValueObj(log.getEndTime().toString(), log.getEndTime().toString(), AticUtil.convertTimeLong((Long)log.getEndTime()));
        reportQueryCond.put("startTime", startTimeObj);
        reportQueryCond.put("endTime", endTimeObj);
        JsonValueObj switchOptionObj = new JsonValueObj("1", "1", "1");
        reportQueryCond.put("switchOption", switchOptionObj);
        return reportQueryCond;
    }

    private void processSrcIpAndZoneIp(AttackExactLogForm form, AttackExactLog log, long sessionId, String collectorIp) {
        String contextPath = SystemUtil.getContextPath();
        String checkAttackSrcTopn = "<img src=\"" + contextPath + "/vsm/atic/resource/skins/images/event_down.gif\" />";
        if (!AticUtil.isNull((String)log.getSrcIp())) {
            String[] srcIpStr = log.getSrcIp().split(",");
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < srcIpStr.length; ++i) {
                buf.append(IPUtil4Atic.compressIP((String)srcIpStr[i]));
                buf.append(';');
            }
            String srcIpCompress = buf.toString();
            srcIpCompress = srcIpCompress.substring(0, srcIpCompress.length() - 1);
            log.setSrcIp(srcIpCompress);
            if (!AticUtil.isNull((String)log.getAttackSrcIpFlow())) {
                checkAttackSrcTopn = "<a style='cursor:pointer' title=\"" + ReportAticUtil.getText("atic.analysis.exact.log.attackSrc.flowTopn") + "\" href=\"javascript:window.open('" + contextPath + "/atic/ireport/dataDrill.do?reportId=attackSrcTopN&attackExactLogPkid=" + log.getId() + "&reportSessionId=" + sessionId + "&collectorIp=" + collectorIp + "&dataDrillTitle=&IREPORT_WOS_CODE=','_blank');void(0);\" > <img src=\"" + contextPath + "/vsm/atic/resource/skins/images/event.gif\" /> </a>";
            }
        }
        log.setCheckAttackSrcTopn(checkAttackSrcTopn);
        if (form.getZoneIp().equals("0") && form.getBizId() == 0L) {
            log.setDisZoneIp("-");
        } else {
            log.setDisZoneIp(IPUtil4Atic.compressIP((String)form.getZoneIp()));
        }
    }

    private String processPcapFile(String contextPath, AttackExactLogForm form, String collectorIp, AttackExactLog log) {
        String checkPcapFile = "";
        AticDevice ne = ((IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class)).getDeviceByIp(form.getDeviceIp());
        if (ne instanceof AticDevice) {
            if (AnalysisConstants.getAllDiscardRelateAttackType().contains(log.getAttackTypeValue())) {
                checkPcapFile = "<img src=\"" + contextPath + "/vsm/atic/resource/skins/images/pcapfile_down.gif\" />";
            } else {
                AticDevice firewall = ne;
                Long devId = firewall.getMoId();
                String zoneIpTemp = log.getZoneIp();
                if (IPUtil.isIpv6((String)zoneIpTemp)) {
                    zoneIpTemp = IPUtil4Atic.convert2CompleteIpV6((String)zoneIpTemp);
                }
                checkPcapFile = "<a style='cursor:pointer' title=\"" + ReportAticUtil.getText("atic.analysis.exact.log.pcapfile") + "\" href=\"javascript:window.open('" + contextPath + "/atic/business/listPcapFileFromReport.do?startTime=" + log.getStartTimeAlert() + "&collectorIp=" + collectorIp + "&endTime=" + log.getEndTime() + "&deviceId=" + devId + "&attackType=" + log.getAttackTypeValue() + "&deviceType=" + log.getDeviceType() + "&zoneId=" + log.getZoneId() + "&protocolValue=" + log.getProtocol() + "&zoneIp4Report=" + zoneIpTemp + "&portValue=" + log.getPort() + "&IREPORT_WOS_CODE=','_blank');void(0);\" > <img src=\"" + contextPath + "/vsm/atic/resource/skins/images/pcapfile.gif\" /> </a>";
            }
        } else {
            checkPcapFile = "<img src=\"" + contextPath + "/vsm/atic/resource/skins/images/pcapfile_down.gif\" />";
        }
        return checkPcapFile;
    }

    private String processFlowGraph(String contextPath, String collectorIp, AttackExactLogForm log, long sessionId) {
        String checkFlowGraph = "";
        String reportIdURL = "singleAttackExactFlow";
        if ("ips".equalsIgnoreCase(AnalysisConstants.getInstance().getReportType()) && AnalysisConstants.getInstance().getReportTypeIpsReport().booleanValue()) {
            reportIdURL = "singleAttackExactFlowIpsReport";
        }
        if (null != log.getStartTimeAttack() && log.getStartTimeAttack() > 0L) {
            String zoneIpTemp = log.getZoneIp();
            if (IPUtil.isIpv6((String)zoneIpTemp)) {
                zoneIpTemp = IPUtil4Atic.convert2CompleteIpV6((String)zoneIpTemp);
            }
            int switchOption = 1;
            if (this.isIncludeV1R1 && "singleAttackExactFlow".equals(reportIdURL)) {
                switchOption = 2;
            }
            checkFlowGraph = "<a style='cursor:pointer' title=\"" + ReportAticUtil.getText("atic.analysis.exact.log.attack.detail") + "\" href=\"javascript:window.open('" + contextPath + "/atic/ireport/dataDrill.do?reportId=" + reportIdURL + "&switchOption=" + switchOption + "&deviceIp=" + log.getDeviceIp() + "&deviceType=" + log.getDeviceType() + "&zone_combobox=" + log.getZoneId() + "&bis_combobox=" + log.getBizId() + "&zone_ip=" + zoneIpTemp + "&startTime=" + log.getStartTimeAttack() + "&endTime=" + log.getEndTime() + "&collectorIp=" + collectorIp + "&attackType=" + log.getAttackTypeValue() + "&protocol=" + log.getProtocol() + "&port=" + log.getPort() + "&reportSessionId=" + sessionId + "&dataDrillTitle=&IREPORT_WOS_CODE=','_blank');void(0);\" > <img src=\"" + contextPath + "/vsm/atic/resource/skins/images/event.gif\" /> </a>";
        } else {
            checkFlowGraph = "<img src=\"" + contextPath + "/vsm/atic/resource/skins/images/event_down.gif\" />";
        }
        return checkFlowGraph;
    }
}

