/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.log;

import com.hs.atic.analysis.report.attack.log.AttackLog;
import com.hs.atic.analysis.report.attack.log.AttackLogComparator;
import com.hs.atic.analysis.util.AnalysisConstants;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.analysis.util.ReportAticUtil;
import com.hs.atic.analysis.util.ReportCommonUtil;
import com.hs.atic.bis.util.ReportBisUtil;
import com.hs.atic.report.util.SystemUtil;
import com.hs.atic.sdk.analysis.form.AttackLogForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.sdk.zone.form.IpDomainForm;
import com.hs.atic.sdk.zone.form.ZoneInfoForm;
import com.hs.atic.sdk.zone.service.IIpDomainService;
import com.hs.atic.sdk.zone.service.IZoneService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.vsm.common.sdk.util.IPUtil4Atic;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ReverseComparator;

public class AttackLogDataSet
extends IJavaDataSource {
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private List<AttackLog> dataList = null;
    private Integer total = 0;
    private int unitKB = 8;
    private Map<String, String> resMap = new HashMap<String, String>();
    private Map<Long, String> zoneInfoMap = new HashMap<Long, String>();
    private IDataStatService dataStatService;
    private IZoneService zoneService;
    private DataStatConditionForm datastatConditionForm = new DataStatConditionForm();
    private Map<?, ?> queryCond4Security;
    private Long currentLogUserId;
    private String nextLineStr = "<br>";

    public List<AttackLog> sortListByField(List<AttackLog> beSortedList, String sortField, String sortType) {
        BeanComparator comparator = new BeanComparator(sortField);
        if (sortType.equals("DESC")) {
            comparator = new ReverseComparator((Comparator)comparator);
        }
        Collections.sort(beSortedList, comparator);
        return beSortedList;
    }

    private String processZoneName(Long zoneId) {
        String res = "";
        Locale locale = this.getLocaleByCondition(this.queryCond4Security);
        if (!this.zoneInfoMap.containsKey(zoneId)) {
            ZoneInfoForm zoneForm = this.zoneService.getById(zoneId);
            if (null == zoneForm) {
                if (!this.resMap.containsKey("atic.analysis.common.unknownZone")) {
                    this.resMap.put("atic.analysis.common.unknownZone", ReportAticUtil.getText("atic.analysis.common.unknownZone", locale));
                }
                res = this.resMap.get("atic.analysis.common.unknownZone") + zoneId;
            } else {
                res = zoneForm.getZoneDesc();
            }
            this.zoneInfoMap.put(zoneId, res);
        } else {
            res = this.zoneInfoMap.get(zoneId);
        }
        return res;
    }

    private String processStatus(String status) {
        Locale locale = this.getLocaleByCondition(this.queryCond4Security);
        String statusKey = ReportAnalysisUtil.getLogAttackStatus().get(status);
        if (!this.resMap.containsKey(statusKey)) {
            this.resMap.put(statusKey, ReportAticUtil.getText(statusKey, locale));
        }
        return this.resMap.get(statusKey);
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        this.logger.info((Object)("fetch----DeviceData :" + new SimpleDateFormat("yyyyMMdd-HH-mm-ss").format(new Date())));
        this.nextLineStr = pageSize > 100L ? "\n" : "<br>";
        List<AttackLogForm> attackLogFormList = null;
        if (!ReportAnalysisUtil.checkDeviceAuthority(this.queryCond4Security, this.datastatConditionForm)) {
            return new ArrayList();
        }
        if (!ReportAnalysisUtil.checkZoneAuthority(this.queryCond4Security, this.datastatConditionForm)) {
            return new ArrayList();
        }
        if (0L == pageIndex && 0L == pageSize) {
            pageSize = Integer.MAX_VALUE;
        }
        if (pageIndex < 1L) {
            pageIndex = 1L;
        }
        this.datastatConditionForm.setStartRow((int)((pageIndex - 1L) * pageSize));
        this.datastatConditionForm.setLimit((int)pageSize);
        this.dataList = new ArrayList<AttackLog>();
        try {
            attackLogFormList = this.getSingleDeviceData(this.datastatConditionForm, sortList);
            this.logger.info((Object)("getSingleDeviceData :" + new SimpleDateFormat("yyyyMMdd-HH-mm-ss").format(new Date())));
            this.processAttackLogList(attackLogFormList, sessionId);
            this.logger.info((Object)("pocessAttDeviceData :" + new SimpleDateFormat("yyyyMMdd-HH-mm-ss").format(new Date())));
            if (null != this.datastatConditionForm.getTopn()) {
                this.getTopnData();
            }
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            this.logger.error((Object)("AttackLogDataSet fetchData() LegoCheckedException:" + legoException.getErrorCode()));
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)("AttackLogDataSet fetchData() unknow exception!" + e.getMessage()));
        }
        this.logger.info((Object)("getSingleDeviceData :" + new SimpleDateFormat("yyyyMMdd-HH-mm-ss").format(new Date()) + ".data size:" + this.dataList.size()));
        return this.dataList;
    }

    public List<?> fetchDataTotal(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        this.logger.info((Object)("fetchDataTotal----DeviceData :" + new SimpleDateFormat("yyyyMMdd-HH-mm-ss").format(new Date())));
        this.nextLineStr = pageSize > 100L ? "\n" : "<br>";
        List<AttackLogForm> attackLogFormList = null;
        if (!ReportAnalysisUtil.checkDeviceAuthority(this.queryCond4Security, this.datastatConditionForm)) {
            return new ArrayList();
        }
        if (!ReportAnalysisUtil.checkZoneAuthority(this.queryCond4Security, this.datastatConditionForm)) {
            return new ArrayList();
        }
        if (0L == pageIndex && 0L == pageSize) {
            pageSize = Integer.MAX_VALUE;
        }
        if (pageIndex < 1L) {
            pageIndex = 1L;
        }
        this.datastatConditionForm.setStartRow((int)((pageIndex - 1L) * pageSize));
        this.datastatConditionForm.setLimit((int)pageSize);
        this.dataList = new ArrayList<AttackLog>();
        try {
            attackLogFormList = this.getSingleDeviceDataTotal(this.datastatConditionForm, sortList);
            this.logger.info((Object)("getSingleDeviceDataTotal :" + new SimpleDateFormat("yyyyMMdd-HH-mm-ss").format(new Date())));
            if (null != attackLogFormList) {
                for (AttackLogForm form : attackLogFormList) {
                    AttackLog log = new AttackLog();
                    AticUtil.copyProperties((Object)form, (Object)log);
                    this.dataList.add(log);
                }
            }
            this.logger.info((Object)("getSingleDeviceDataTotal :" + new SimpleDateFormat("yyyyMMdd-HH-mm-ss").format(new Date())));
            if (null != this.datastatConditionForm.getTopn()) {
                if (1 == this.datastatConditionForm.getDevSerType()) {
                    sortList = new OrderInfo();
                    sortList.setOrderField("duration");
                    sortList.setOrderType("desc");
                } else {
                    sortList.setOrderField("dropPackets");
                    sortList.setOrderType("desc");
                }
                int length = this.dataList.size();
                if (length > this.datastatConditionForm.getTopn()) {
                    length = this.datastatConditionForm.getTopn();
                }
                this.datastatConditionForm.setStartRow(0);
                this.datastatConditionForm.setLimit(length);
                attackLogFormList = this.getSingleDeviceDataTopN(this.datastatConditionForm, sortList);
                this.processAttackLogList(attackLogFormList, sessionId);
                for (AttackLog attackLog : this.dataList) {
                    attackLog.setCheckExactLog("-");
                    attackLog.setCheckGraph("-");
                }
            }
        }
        catch (LegoCheckedException legoException) {
            this.dataList.clear();
            this.logger.error((Object)("AttackLogDataSet fetchDataTotal() LegoCheckedException:" + legoException.getErrorCode()));
        }
        catch (Exception e) {
            this.dataList.clear();
            this.logger.error((Object)("AttackLogDataSet fetchDataTotal() unknow exception!" + e.getMessage()));
        }
        this.logger.info((Object)("getSingleDeviceDataTotal :" + new SimpleDateFormat("yyyyMMdd-HH-mm-ss").format(new Date()) + ".data size:" + this.dataList.size()));
        return this.dataList;
    }

    private void processAttackLogList(List<AttackLogForm> attackLogFormList, long sessionId) {
        if (null == attackLogFormList) {
            return;
        }
        String contextPath = SystemUtil.getContextPath();
        int ddosType = this.datastatConditionForm.getDevSerType();
        long deviceId = this.datastatConditionForm.getDeviceId();
        int direction = this.datastatConditionForm.getDirection();
        int unit = this.datastatConditionForm.getUnit();
        this.zoneService = ReportBisUtil.getZoneService();
        AttackLog log = null;
        StringBuffer allZoneIp = new StringBuffer();
        for (AttackLogForm form : attackLogFormList) {
            log = new AttackLog();
            AticUtil.copyProperties((Object)form, (Object)log);
            log.setDropBytes(log.getDropBytes() / (long)this.unitKB);
            this.processZoneNameAndIp(form, log);
            String statusStr = this.processStatus(form.getStatus());
            log.setStatus(statusStr);
            if (!"0".equals(form.getStatus())) {
                log.setEndTime("-");
            }
            if (unit == 1) {
                log.setIpAttackFlowPeak(form.getIpAttackPeakPps());
                log.setIpInFlowPeak(form.getIpInPeakPps());
            } else {
                log.setIpAttackFlowPeak(form.getIpAttackPeakKbps());
                log.setIpInFlowPeak(form.getIpInPeakKbps());
            }
            log.setDevDdosType(ddosType);
            log.setDeviceId(deviceId);
            String abnormalType = ReportAticUtil.processAttackTypeNum2Str(log.getAbnormalType());
            String attackType = ReportAticUtil.processAttackTypeNum2Str(log.getAttackType());
            log.setAbnormalType(abnormalType);
            log.setAttackType(attackType);
            log.setDisplayDuration(ReportAnalysisUtil.longTimeToHMS(Long.parseLong(log.getDuration())));
            Locale locale = this.getLocaleByCondition(this.queryCond4Security);
            if (!this.resMap.containsKey("atic.analysis.exact.log.detail")) {
                this.resMap.put("atic.analysis.exact.log.detail", ReportAticUtil.getText("atic.analysis.exact.log.detail", locale));
            }
            String bisObjValue = "0";
            String checkExactLog = this.processExactLogLink(bisObjValue, log, ddosType, sessionId, direction, contextPath);
            log.setCheckExactLog(checkExactLog);
            if (!AticUtil.isNull((String)log.getZoneIp())) {
                allZoneIp.append(log.getZoneIp()).append(',');
            }
            this.dataList.add(log);
        }
        this.processDomainCompare(allZoneIp.toString());
    }

    private void processDomainCompare(String zoneIp) {
        if (!AticUtil.isNull((String)zoneIp) && zoneIp.endsWith(",")) {
            zoneIp = zoneIp.substring(0, zoneIp.length() - 1);
        }
        ServiceContext serviceContext = ServiceContext.getInstance();
        IIpDomainService service = (IIpDomainService)serviceContext.getService("ipDomainService", IIpDomainService.class);
        List ipDomainForms = service.getByIps(zoneIp);
        for (AttackLog log : this.dataList) {
            for (IpDomainForm form : ipDomainForms) {
                if (!IPUtil4Atic.convert2CompleteIp((String)log.getZoneIp()).equals(IPUtil4Atic.convert2CompleteIp((String)form.getDestIp()))) continue;
                log.setIpDomain(form.getDomain());
                break;
            }
            String ipDomain = "";
            if (!AticUtil.isNull((String)log.getIpDomain())) {
                ipDomain = "(" + AticUtil.htmlEncodeCore((String)log.getIpDomain()) + ")";
            }
            Locale locale = this.getLocaleByCondition(this.queryCond4Security);
            log.setAttackLogInfo(ReportAticUtil.getText("atic.analysis.common.ip.address", locale) + AticUtil.htmlEncodeCore((String)log.getDisplayZoneIp()) + ipDomain + this.nextLineStr + ReportAticUtil.getText("atic.analysis.common.zone", locale) + AticUtil.htmlEncodeCore((String)log.getZoneName()));
            String endTime = log.getEndTime().length() > 5 ? log.getEndTime().substring(5) : log.getEndTime();
            log.setAttackLogTimes(ReportAticUtil.getText("atic.analysis.report.time.start", locale) + log.getAbnormalStartTime().substring(5) + this.nextLineStr + ReportAticUtil.getText("atic.analysis.report.time.end", locale) + endTime);
            String abnormalAndAttackTypes = this.processAbnormalAndAttackType(log.getAbnormalType(), log.getAttackType());
            log.setAbnormalAndAttackTypes(abnormalAndAttackTypes);
        }
    }

    private String processAbnormalAndAttackType(String abnormalType, String attackType) {
        Locale locale = this.getLocaleByCondition(this.queryCond4Security);
        if ("-".equals(attackType)) {
            return ReportAticUtil.getText("atic.analysis.report.time.abnormal", locale) + abnormalType;
        }
        List<String> attackTypes = Arrays.asList(attackType.split("; "));
        String abnormalStr = "";
        String[] abnormalTypes = abnormalType.split("; ");
        StringBuffer buf = new StringBuffer();
        for (String abnormalTemp : abnormalTypes) {
            if (attackTypes.contains(abnormalTemp)) continue;
            buf.append(abnormalTemp);
            buf.append("; ");
        }
        abnormalStr = buf.toString();
        abnormalStr = abnormalStr.trim();
        String returnStr = ReportAticUtil.getText("atic.analysis.report.time.attack", locale) + attackType;
        if (!AticUtil.isNull((String)abnormalStr)) {
            returnStr = returnStr + this.nextLineStr + ReportAticUtil.getText("atic.analysis.report.time.abnormal", locale) + abnormalStr.substring(0, abnormalStr.length() - 1);
        }
        return returnStr;
    }

    private String processExactLogLink(String bisObjValue, AttackLog log, int ddosType, long sessionId, int direction, String contextPath) {
        String checkExactLog = null;
        String reportId = "attackLogDetailAnalysis";
        int unit = this.datastatConditionForm.getUnit();
        String switchOption = "detect_less1day_pps";
        if (0 == ddosType) {
            switchOption = 0 == unit ? "clean_less1day_pps" : "clean_less2day_pps";
        } else if (1 == ddosType) {
            switchOption = 0 == unit ? "detect_less1day_pps" : "detect_less2day_pps";
        }
        String zoneIpTemp = log.getDisplayZoneIp();
        if (IPUtil.isIpv6((String)zoneIpTemp)) {
            zoneIpTemp = IPUtil4Atic.convert2CompleteIpV6((String)zoneIpTemp);
        }
        checkExactLog = "<a style='cursor:pointer' title=\"" + this.resMap.get("atic.analysis.exact.log.detail") + "\" href=\"javascript:window.open('" + contextPath + "/atic/ireport/dataDrill.do?reportId=" + reportId + "&switchOption=" + switchOption + "&attackLogPkid=" + log.getPkid() + "&collectorIp=" + log.getCollectorIp() + "&reportSessionId=" + sessionId + "&netDevice_combobox=" + log.getDeviceId() + "_" + log.getDevDdosType() + "&zone_ip=" + zoneIpTemp + "&zone_combobox=" + log.getZoneId() + "&bis_combobox=" + bisObjValue + "&startTime=" + log.getAbnormalTime() + "&endTime=" + log.getEndTimeLong() + "&direction_combobox=" + direction + "&unit=" + unit + "&dataDrillTitle=&IREPORT_WOS_CODE=','_blank');void(0);\" > <img src=\"" + contextPath + "/vsm/atic/resource/skins/images/attacklog.gif\" /> </a>";
        return checkExactLog;
    }

    private void processZoneNameAndIp(AttackLogForm form, AttackLog log) {
        if (form.getZoneIp().equals("0") && form.getBizId() == 0L) {
            log.setDisplayZoneIp("-");
        } else {
            log.setDisplayZoneIp(IPUtil4Atic.compressIP((String)form.getZoneIp()));
        }
        String zoneName = this.processZoneName(log.getZoneId());
        log.setZoneName(zoneName);
    }

    private void getTopnData() {
        if (1 == this.datastatConditionForm.getDevSerType()) {
            Collections.sort(this.dataList, new AttackLogComparator("duration", "desc"));
        } else {
            Collections.sort(this.dataList, new AttackLogComparator("dropPackets", "desc"));
        }
        int length = this.dataList.size();
        if (length > this.datastatConditionForm.getTopn()) {
            length = this.datastatConditionForm.getTopn();
        }
        this.dataList = new ArrayList<AttackLog>(this.dataList.subList(0, length));
        for (AttackLog attackLog : this.dataList) {
            attackLog.setCheckExactLog("-");
            attackLog.setCheckGraph("-");
        }
    }

    private List<AttackLogForm> getSingleDeviceData(DataStatConditionForm datastatConditionForms, OrderInfo sortList) {
        List<Object> attackLogFormList = new ArrayList();
        IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        AticDevice firewall = aticDeviceService.getDeviceByMoid(datastatConditionForms.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForms.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForms.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = (ICollectorService)ServiceContext.getInstance().getService("collectorService", ICollectorService.class);
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(datastatConditionForms.getDeviceId());
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            attackLogFormList = null != sortList ? this.dataStatService.getAttackLog(datastatConditionForms, collectorInfo.getIpAddress(), sortList.getOrderField(), sortList.getOrderType()) : this.dataStatService.getAttackLog(datastatConditionForms, collectorInfo.getIpAddress(), null, null);
            this.total = this.dataStatService.getAttackLogNum(datastatConditionForms, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + collectorId + ". " + e.getMessage()));
        }
        return attackLogFormList;
    }

    private List<AttackLogForm> getSingleDeviceDataTotal(DataStatConditionForm datastatConditionForms, OrderInfo sortList) {
        List<Object> attackLogFormList = new ArrayList();
        IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        AticDevice firewall = aticDeviceService.getDeviceByMoid(datastatConditionForms.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForms.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForms.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = (ICollectorService)ServiceContext.getInstance().getService("collectorService", ICollectorService.class);
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(datastatConditionForms.getDeviceId());
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            attackLogFormList = null != sortList ? this.dataStatService.getAttackLogTotal(datastatConditionForms, collectorInfo.getIpAddress(), sortList.getOrderField(), sortList.getOrderType()) : this.dataStatService.getAttackLogTotal(datastatConditionForms, collectorInfo.getIpAddress(), null, null);
            this.total = this.dataStatService.getAttackLogNum(datastatConditionForms, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("getAttackLogTotal rmi service error, Failed to connect to the collector,collectorId = " + collectorId + ". " + e.getMessage()));
        }
        return attackLogFormList;
    }

    private List<AttackLogForm> getSingleDeviceDataTopN(DataStatConditionForm datastatConditionForms, OrderInfo sortList) {
        List<Object> attackLogFormList = new ArrayList();
        IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        AticDevice firewall = aticDeviceService.getDeviceByMoid(datastatConditionForms.getDeviceId().longValue());
        if (null == firewall || null == firewall.getIpAddress()) {
            this.logger.error((Object)("no device exist,deviceId = " + datastatConditionForms.getDeviceId()));
            throw new LegoCheckedException(570502L);
        }
        datastatConditionForms.setDeviceIp(firewall.getIpAddress());
        ICollectorService collectorService = (ICollectorService)ServiceContext.getInstance().getService("collectorService", ICollectorService.class);
        Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(datastatConditionForms.getDeviceId());
        if (null == collectorId) {
            this.logger.error((Object)("no collector exist,firewall.getMoId() = " + firewall.getMoId()));
            throw new LegoCheckedException(570512L);
        }
        CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
        if (null == collectorInfo) {
            this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
            throw new LegoCheckedException(570512L);
        }
        if (2 == collectorInfo.getStatus()) {
            this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + this.getcleanedMessage(collectorInfo.getIpAddress())));
            throw new LegoCheckedException(570504L);
        }
        this.dataStatService = ReportAnalysisUtil.getDataStatService();
        try {
            attackLogFormList = null != sortList ? this.dataStatService.getAttackLogTopN(datastatConditionForms, collectorInfo.getIpAddress(), sortList.getOrderField(), sortList.getOrderType()) : this.dataStatService.getAttackLogTopN(datastatConditionForms, collectorInfo.getIpAddress(), null, null);
            this.total = this.dataStatService.getAttackLogNum(datastatConditionForms, collectorInfo.getIpAddress());
        }
        catch (Exception e) {
            this.logger.error((Object)("getAttackLogTotal rmi service error, Failed to connect to the collector,collectorId = " + collectorId + ". " + e.getMessage()));
        }
        return attackLogFormList;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public long getAllCount(String arg0, long arg1) {
        return this.total.intValue();
    }

    private void processQueryCondition(Map<?, ?> queryCond, boolean showDropPacket, String logType) {
        JsonValueObj objDropPacket = (JsonValueObj)queryCond.get("dropPacket");
        JsonValueObj objMinAttackFlowPeak = (JsonValueObj)queryCond.get("minAttackFlowPeak");
        if (null != objDropPacket && ("1".equals(logType) || !showDropPacket)) {
            objDropPacket.setShowInfo("false");
        }
        if (null != objMinAttackFlowPeak && ("1".equals(logType) || showDropPacket)) {
            objMinAttackFlowPeak.setShowInfo("false");
        }
    }

    public int prepareData(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        try {
            String minInFlow;
            String topn;
            this.queryCond4Security = queryCond;
            List<JsonValueItem> jsonValueItem = null;
            this.datastatConditionForm = new DataStatConditionForm();
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "direction_combobox");
            String direction = String.valueOf(jsonValueItem.get(0).getValue());
            if (direction.matches("^[\\d]*$")) {
                this.datastatConditionForm.setDirection(Integer.parseInt(direction));
            } else {
                this.datastatConditionForm.setDirection(1);
            }
            ReportAnalysisUtil.processDirectionQueryCondition(queryCond);
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox");
            String deviceId = String.valueOf(jsonValueItem.get(0).getValue());
            ReportAnalysisUtil.processDeviceInfo(this.datastatConditionForm, deviceId);
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox");
            String zoneId = String.valueOf(jsonValueItem.get(0).getValue());
            this.datastatConditionForm.setZoneId(Long.parseLong(zoneId));
            if (!(AnalysisConstants.getInstance().getReportType().equalsIgnoreCase("ips") && AnalysisConstants.getInstance().getReportTypeIpsReport().booleanValue() || 0L != this.datastatConditionForm.getZoneId())) {
                ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, this.datastatConditionForm, sessionId);
            }
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "bis_combobox");
            String bisId = String.valueOf(jsonValueItem.get(0).getValue());
            ReportAnalysisUtil.processServiceCond(this.datastatConditionForm, bisId);
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip");
            String zoneIp = String.valueOf(jsonValueItem.get(0).getValue());
            this.datastatConditionForm.setZoneIp(zoneIp);
            ReportAnalysisUtil.setDateRange(queryCond, this.datastatConditionForm);
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "logType");
            String logType = String.valueOf(jsonValueItem.get(0).getValue());
            if (!AticUtil.isNull((String)logType)) {
                this.datastatConditionForm.setAbnormalType(Integer.parseInt(logType));
            } else {
                this.datastatConditionForm.setAbnormalType(0);
            }
            this.currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit");
            String unit = String.valueOf(jsonValueItem.get(0).getValue());
            if (!AticUtil.isNull((String)unit)) {
                this.datastatConditionForm.setUnit(Integer.parseInt(unit));
            } else {
                this.datastatConditionForm.setUnit(0);
            }
            String isBPSStr = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "isBPS").get(0).getValue());
            if (AticUtil.isNull((String)isBPSStr) && !AticUtil.isNull((String)(topn = String.valueOf((jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN")).get(0).getValue())))) {
                this.datastatConditionForm.setTopn(Integer.parseInt(topn));
            }
            boolean showDropPacket = this.validateDevice();
            this.datastatConditionForm.setShowDropPacket(showDropPacket);
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "dropPacket");
            String dropPacket = String.valueOf(jsonValueItem.get(0).getValue());
            if (showDropPacket && !AticUtil.isNull((String)dropPacket)) {
                this.datastatConditionForm.setDropPacket(Long.parseLong(dropPacket));
            }
            if (!AticUtil.isNull((String)(minInFlow = String.valueOf((jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "minInFlow")).get(0).getValue())))) {
                this.datastatConditionForm.setMinInFlow(Long.parseLong(minInFlow));
            } else {
                this.datastatConditionForm.setMinInFlow(0L);
            }
            jsonValueItem = ReportAnalysisUtil.getJsonValueItemList(queryCond, "minAttackFlowPeak");
            String minAttackFlowPeak = String.valueOf(jsonValueItem.get(0).getValue());
            if (!AticUtil.isNull((String)minAttackFlowPeak)) {
                this.datastatConditionForm.setMinAttackFlowPeak(Long.parseLong(minAttackFlowPeak));
            } else {
                this.datastatConditionForm.setMinAttackFlowPeak(0L);
            }
            this.processQueryCondition(queryCond, showDropPacket, logType);
            ICollectorService collectorService = (ICollectorService)ServiceContext.getInstance().getService("collectorService", ICollectorService.class);
            Long collectorId = ReportBisUtil.getICollectorDeviceService().getCollectorIdByDevId(this.datastatConditionForm.getDeviceId());
            if (null == collectorId) {
                this.logger.error((Object)("no collector exist,firewallId = " + this.datastatConditionForm.getDeviceId()));
                throw new LegoCheckedException(570512L);
            }
            CollectorInfo collectorInfo = collectorService.getCollectorInfo(collectorId.longValue());
            if (null == collectorInfo) {
                this.logger.error((Object)("no collector exist,collectorId = " + collectorId));
                throw new LegoCheckedException(570512L);
            }
            if (2 == collectorInfo.getStatus()) {
                this.logger.error((Object)("collector Status is offLine, collectorId: " + collectorId + ",collectorIp: " + collectorInfo.getIpAddress()));
                throw new LegoCheckedException(570504L);
            }
        }
        catch (LegoCheckedException legoException) {
            this.logger.error((Object)("AttackLogDataSet prepareData happened unknow exception :" + legoException.getErrorCode() + ". " + legoException.getMessage()));
            throw legoException;
        }
        return 0;
    }

    private boolean validateDevice() {
        IAticDeviceService aticDeviceService = (IAticDeviceService)ServiceContext.getInstance().getService("aticDeviceService", IAticDeviceService.class);
        AticDevice firewall = aticDeviceService.getDeviceByMoid(this.datastatConditionForm.getDeviceId().longValue());
        ArrayList<AticDevice> deviceList = new ArrayList<AticDevice>();
        if (null != firewall) {
            if (5 == firewall.getDeviceType()) {
                return false;
            }
            deviceList.add(firewall);
        }
        return ReportCommonUtil.includesV1R1(deviceList);
    }

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        String unitValue = "0";
        if (!AticUtil.isNull((String)ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit").get(0).getValue())) {
            unitValue = ReportAnalysisUtil.getJsonValueItemList(queryCond, "unit").get(0).getValue();
        }
        String ipInFlowPeakName = "";
        String ipAttackFlowPeakName = "";
        Locale locale = this.getLocaleByCondition(queryCond);
        if (unitValue.equals("1")) {
            ipInFlowPeakName = ReportAticUtil.getText("atic.analysis.report.tab.inFlowfeak.pps", locale);
            ipAttackFlowPeakName = ReportAticUtil.getText("atic.analysis.report.tab.column.feak.attack.pps", locale);
        } else {
            ipInFlowPeakName = ReportAticUtil.getText("atic.analysis.report.tab.inFlowfeak.bps", locale);
            ipAttackFlowPeakName = ReportAticUtil.getText("atic.analysis.report.tab.column.feak.attack.bps", locale);
        }
        Map<String, List<String>> prepareParasMap = ReportAnalysisUtil.getPrepareParasMap(queryCond);
        ArrayList<String> ipInFlowPeak = new ArrayList<String>();
        ipInFlowPeak.add(ipInFlowPeakName);
        ArrayList<String> ipAttackFlowPeak = new ArrayList<String>();
        ipAttackFlowPeak.add(ipAttackFlowPeakName);
        prepareParasMap.put("ipInFlowPeak", ipInFlowPeak);
        prepareParasMap.put("ipAttackFlowPeak", ipAttackFlowPeak);
        return prepareParasMap;
    }

    private Locale getLocaleByCondition(Map<?, ?> queryCond) {
        if (null == queryCond) {
            return null;
        }
        Locale locale = null;
        try {
            Object byInterfaceObj = queryCond.get("byInterface");
            if (null != byInterfaceObj) {
                JsonValueObj jvo = (JsonValueObj)byInterfaceObj;
                String localeStr = ((JsonValueItem)jvo.getValueList().get(0)).getValue();
                locale = new Locale(localeStr);
                return locale;
            }
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public Long getCurrentLogUserId() {
        return this.currentLogUserId;
    }

    public void setCurrentLogUserId(Long currentLogUserId) {
        this.currentLogUserId = currentLogUserId;
    }
}

