/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.attack.log;

import com.hs.atic.analysis.report.ReportConditionValidateUtils;
import com.security.ireport.model.vo.JsonValueItem;
import com.security.ireport.model.vo.JsonValueObj;
import com.security.ireport.validator.AbstractValidator;
import java.util.List;
import java.util.Map;

public class AttackLogDetailAnalysisValidator
extends AbstractValidator {
    public boolean validate(Map<String, JsonValueObj> reportCon) {
        for (Map.Entry<String, JsonValueObj> entry : reportCon.entrySet()) {
            String checkKey = entry.getKey();
            if ("reportId".equals(entry.getKey())) {
                JsonValueObj jsonValueObj = reportCon.get("reportId");
                if (null == jsonValueObj) {
                    return false;
                }
                List list = jsonValueObj.getValueList();
                if (!((JsonValueItem)list.get(0)).getValue().equals("attackLogDetailAnalysis")) {
                    return false;
                }
            } else {
                if ("direction_combobox".equals(checkKey) && !ReportConditionValidateUtils.isValidateDirectionCombobox(reportCon)) {
                    return false;
                }
                if ("switchOption".equals(checkKey) && !ReportConditionValidateUtils.isValidateSwitchOption(reportCon)) {
                    return false;
                }
                if ("attackLogPkid".equals(checkKey) && !ReportConditionValidateUtils.checkIsNum("attackLogPkid", reportCon)) {
                    return false;
                }
                if ("collectorIp".equals(checkKey) && !ReportConditionValidateUtils.checkIsCollectorIp(reportCon)) {
                    return false;
                }
            }
            if (!this.checkF(checkKey, reportCon)) {
                return false;
            }
            if (this.checkS(checkKey, reportCon)) continue;
            return false;
        }
        return true;
    }

    private boolean checkF(String checkKey, Map<String, JsonValueObj> reportCon) {
        if ("reportSessionId".equals(checkKey) && !ReportConditionValidateUtils.checkIsNum("reportSessionId", reportCon)) {
            return false;
        }
        if ("netDevice_combobox".equals(checkKey) && !ReportConditionValidateUtils.isValidateNetDeviceCombobox(reportCon)) {
            return false;
        }
        if ("zone_ip".equals(checkKey) && !ReportConditionValidateUtils.isValidateZoneIp(reportCon)) {
            return false;
        }
        if ("zone_combobox".equals(checkKey) && !ReportConditionValidateUtils.isValidateZoneCombobox(reportCon)) {
            return false;
        }
        return !"bis_combobox".equals(checkKey) || ReportConditionValidateUtils.isValidateBisCombobox(reportCon);
    }

    private boolean checkS(String checkKey, Map<String, JsonValueObj> reportCon) {
        if ("startTime".equals(checkKey) && !ReportConditionValidateUtils.isValidateStartTime(reportCon)) {
            return false;
        }
        if ("endTime".equals(checkKey) && !ReportConditionValidateUtils.isValidateEndTime(reportCon)) {
            return false;
        }
        if ("unit".equals(checkKey) && !ReportConditionValidateUtils.isValidateUnit(reportCon)) {
            return false;
        }
        if ("dataDrillTitle".equals(checkKey) && !ReportConditionValidateUtils.checkDataDrillTitle(reportCon)) {
            return false;
        }
        return !"IREPORT_WOS_CODE".equals(checkKey) || ReportConditionValidateUtils.checkIreportWosCode(reportCon);
    }
}

