/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.analysis.report.dns.analyzesuccessrate;

import com.hs.atic.analysis.report.dns.analyzesuccessrate.AnalyzeSuccessRateComparator;
import com.hs.atic.analysis.report.dns.analyzesuccessrate.AnalyzeSuccessRateView;
import com.hs.atic.analysis.report.dns.analyzesuccessrate.TransmitAnalyzeSuccessRateData;
import com.hs.atic.analysis.util.ReportAnalysisUtil;
import com.hs.atic.sdk.analysis.form.AnalyzeSuccessRateConditionForm;
import com.hs.atic.sdk.analysis.form.AnalyzeSuccessRateForm;
import com.hs.atic.sdk.analysis.form.DataStatConditionForm;
import com.hs.atic.sdk.analysis.service.IDataStatService;
import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import com.security.ireport.engine.dataset.IJavaDataSource;
import com.security.ireport.engine.dataset.OrderInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class AnalyzeSuccessRateChartDataSet
extends IJavaDataSource {
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_REPORT);
    private AnalyzeSuccessRateConditionForm analyzeSuccessRateConditionForm;
    private List<AticDevice> firewallList;
    private Map<String, List<String>> collectorDeviceMap = new HashMap<String, List<String>>();
    private boolean isAllDetect;
    private Map<?, ?> queryCond4Security;
    private DataStatConditionForm datastatConditionForm = new DataStatConditionForm();

    public Map<String, List<String>> getPrepareParasMap(String reportId, String dataSourceId, Map<?, ?> queryCond, long sessionId) {
        return ReportAnalysisUtil.getPrepareParasMap(queryCond);
    }

    public int prepareData(String arg0, String arg1, Map<?, ?> queryCond, long sessionId) {
        try {
            this.queryCond4Security = queryCond;
            this.analyzeSuccessRateConditionForm = this.beforeQuery(queryCond, sessionId);
        }
        catch (LegoCheckedException legoException) {
            logger.error((Object)("FlowCompareChartDataSet prepareData() unknow exception!" + legoException.getMessage()));
            throw legoException;
        }
        catch (Exception e) {
            logger.error((Object)("FlowCompareChartDataSet prepareData() unknow exception!" + e.getMessage()));
        }
        return 0;
    }

    public List<?> fetchData(long pageIndex, long pageSize, OrderInfo sortList, String dataSourceId, long sessionId) {
        logger.info((Object)"start AnalyzeSuccessRateChartDataSet fetchData");
        ArrayList<AnalyzeSuccessRateView> resultList = new ArrayList<AnalyzeSuccessRateView>();
        try {
            List<AnalyzeSuccessRateForm> allList = this.queryAnalyzeSuccessRate(this.analyzeSuccessRateConditionForm, sessionId);
            for (AnalyzeSuccessRateForm analyzeSuccessRateForm : allList) {
                if (analyzeSuccessRateForm.getSuccessRate() > 1.0) {
                    analyzeSuccessRateForm.setSuccessRate(1.0);
                }
                resultList.add((AnalyzeSuccessRateView)ReportAnalysisUtil.copyProperties(analyzeSuccessRateForm, new AnalyzeSuccessRateView()));
            }
        }
        catch (LegoCheckedException legoException) {
            resultList.clear();
            logger.error((Object)("AnalyzeSuccessRateChartDataSet fetchData() LegoCheckedException :" + legoException.getErrorCode()));
        }
        catch (Exception e) {
            resultList.clear();
            logger.error((Object)("AnalyzeSuccessRateChartDataSet fetchData() unknow exception!" + e.getMessage()));
        }
        logger.info((Object)"end AnalyzeSuccessRateChartDataSet fetchData");
        return resultList;
    }

    private List<AnalyzeSuccessRateForm> queryAnalyzeSuccessRate(AnalyzeSuccessRateConditionForm analyzeSuccessRateConditionForms, long sessionId) {
        IDataStatService dataStatService = ReportAnalysisUtil.getDataStatService();
        List<Object> analyzeSuccessRateList = new ArrayList();
        ArrayList<AnalyzeSuccessRateForm> allList = new ArrayList<AnalyzeSuccessRateForm>();
        if (!ReportAnalysisUtil.checkDeviceAuthority(this.queryCond4Security, this.datastatConditionForm)) {
            return this.processResult(ReportAnalysisUtil.getRedunFirewallIpList(this.firewallList), allList, analyzeSuccessRateConditionForms.getTimeSpanType(), sessionId);
        }
        if (!ReportAnalysisUtil.checkZoneAuthority(this.queryCond4Security, this.datastatConditionForm)) {
            return this.processResult(ReportAnalysisUtil.getRedunFirewallIpList(this.firewallList), allList, analyzeSuccessRateConditionForms.getTimeSpanType(), sessionId);
        }
        if (null != analyzeSuccessRateConditionForms.getSessionId() && analyzeSuccessRateConditionForms.getZoneIdList().isEmpty()) {
            return this.processResult(ReportAnalysisUtil.getRedunFirewallIpList(this.firewallList), allList, analyzeSuccessRateConditionForms.getTimeSpanType(), sessionId);
        }
        for (Map.Entry<String, List<String>> entry : this.collectorDeviceMap.entrySet()) {
            analyzeSuccessRateConditionForms.setDeviceIpList(entry.getValue());
            try {
                analyzeSuccessRateList = dataStatService.queryAnalyzeSuccessRate(analyzeSuccessRateConditionForms, entry.getKey());
            }
            catch (Exception e) {
                logger.error((Object)("rmi service error, Failed to connect to the collector,collectorId = " + entry.getKey() + ". " + e.getMessage()));
            }
            allList.addAll(analyzeSuccessRateList);
        }
        return this.processResult(ReportAnalysisUtil.getRedunFirewallIpList(this.firewallList), allList, analyzeSuccessRateConditionForms.getTimeSpanType(), sessionId);
    }

    private List<AnalyzeSuccessRateForm> processResult(List<List<String>> firewallIpList, List<AnalyzeSuccessRateForm> allList, int timeType, long sessionId) {
        List<AnalyzeSuccessRateForm> result = this.isAllDetect ? this.processRedundancyAndAdd(firewallIpList, allList) : this.processAdd(allList);
        List<AnalyzeSuccessRateForm> resultForTable = null;
        if (null != this.analyzeSuccessRateConditionForm) {
            if (null == this.analyzeSuccessRateConditionForm.getTopn()) {
                resultForTable = result;
            } else {
                ArrayList<AnalyzeSuccessRateForm> tempList = new ArrayList<AnalyzeSuccessRateForm>(result);
                Collections.sort(tempList, AnalyzeSuccessRateComparator.getComparatorByFieldName("successRatePercent", "desc"));
                int length = this.analyzeSuccessRateConditionForm.getTopn();
                if (tempList.size() <= this.analyzeSuccessRateConditionForm.getTopn()) {
                    length = tempList.size();
                }
                resultForTable = tempList.subList(0, length);
            }
        }
        if (null == resultForTable) {
            resultForTable = new ArrayList<AnalyzeSuccessRateForm>();
        }
        TransmitAnalyzeSuccessRateData.getInstance().addDataList(new ArrayList<AnalyzeSuccessRateForm>(resultForTable), sessionId);
        this.fillContinuousTime(result, 0, 1, ReportAnalysisUtil.getGapTime(timeType));
        return result;
    }

    public List<AnalyzeSuccessRateForm> processRedundancyAndAdd(List<List<String>> ipList, List<AnalyzeSuccessRateForm> analyzeSuccessRateFormList) {
        ArrayList<AnalyzeSuccessRateForm> result = new ArrayList<AnalyzeSuccessRateForm>();
        for (List<String> ips : ipList) {
            ArrayList<AnalyzeSuccessRateForm> allList = new ArrayList<AnalyzeSuccessRateForm>(analyzeSuccessRateFormList);
            allList.retainAll(ips);
            analyzeSuccessRateFormList.removeAll(allList);
            result.addAll(this.processRedundancy0(allList));
        }
        result.addAll(analyzeSuccessRateFormList);
        return this.processAdd(result);
    }

    private List<AnalyzeSuccessRateForm> processRedundancy0(List<AnalyzeSuccessRateForm> allList) {
        ArrayList<AnalyzeSuccessRateForm> result = new ArrayList<AnalyzeSuccessRateForm>();
        Collections.sort(allList, AnalyzeSuccessRateComparator.getComparatorByFieldName("logTime", "asc"));
        ListIterator<AnalyzeSuccessRateForm> iter = allList.listIterator();
        int endIndex = 0;
        block0: while (iter.hasNext()) {
            AnalyzeSuccessRateForm first = iter.next();
            int startIndex = endIndex;
            if (!iter.hasNext()) {
                result.add(first);
            }
            while (iter.hasNext()) {
                boolean isEqual = iter.next().getLogTime().equals(first.getLogTime());
                if (isEqual) {
                    ++endIndex;
                    if (iter.hasNext()) continue;
                }
                List<AnalyzeSuccessRateForm> subList = allList.subList(startIndex, endIndex + 1);
                Collections.sort(subList, AnalyzeSuccessRateComparator.getComparatorByFieldName("requestPps", "desc"));
                result.add(subList.get(0));
                if (isEqual) continue block0;
                ++endIndex;
                iter = allList.listIterator(iter.previousIndex());
                continue block0;
            }
        }
        return result;
    }

    private AnalyzeSuccessRateConditionForm beforeQuery(Map<?, ?> queryCond, Long sessionId) {
        this.valiateParams(queryCond);
        return this.processQueryCondition(queryCond, sessionId);
    }

    private void valiateParams(Map<?, ?> queryCond) {
        if (null == queryCond) {
            logger.error((Object)"map is empty !");
        }
    }

    private void fillContinuousTime(List<AnalyzeSuccessRateForm> analyzeSuccessRateFormList, int first, int next, int timeSpan) {
        if (next < analyzeSuccessRateFormList.size()) {
            AnalyzeSuccessRateForm firstForm = analyzeSuccessRateFormList.get(first);
            AnalyzeSuccessRateForm nextForm = analyzeSuccessRateFormList.get(next);
            long timeGap = nextForm.getLogTime() - firstForm.getLogTime();
            if (timeGap > (long)timeSpan) {
                ArrayList<AnalyzeSuccessRateForm> analyzeSuccessRateFormListGap = new ArrayList<AnalyzeSuccessRateForm>();
                int i = 1;
                while ((long)i < timeGap / (long)timeSpan) {
                    AnalyzeSuccessRateForm analyzeSuccessRateFormGap = new AnalyzeSuccessRateForm();
                    analyzeSuccessRateFormGap.setLogTime(firstForm.getLogTime() + (long)timeSpan);
                    analyzeSuccessRateFormGap.setSuccessRate(0.0);
                    firstForm = analyzeSuccessRateFormGap;
                    analyzeSuccessRateFormListGap.add(analyzeSuccessRateFormGap);
                    ++i;
                }
                analyzeSuccessRateFormList.addAll(next, analyzeSuccessRateFormListGap);
                int nextIndex = ++first + analyzeSuccessRateFormListGap.size();
                this.fillContinuousTime(analyzeSuccessRateFormList, nextIndex, nextIndex + 1, timeSpan);
            } else {
                this.fillContinuousTime(analyzeSuccessRateFormList, ++first, ++next, timeSpan);
            }
        }
    }

    private List<AnalyzeSuccessRateForm> processAdd(List<AnalyzeSuccessRateForm> flowCompareList) {
        Collections.sort(flowCompareList, AnalyzeSuccessRateComparator.getComparatorByFieldName("logTime", "asc"));
        ListIterator<AnalyzeSuccessRateForm> iter = flowCompareList.listIterator();
        block0: while (iter.hasNext()) {
            AnalyzeSuccessRateForm first = iter.next();
            if (!iter.hasNext()) {
                first.processRateAndPercent();
            }
            while (iter.hasNext()) {
                AnalyzeSuccessRateForm next = iter.next();
                if (next.getLogTime().equals(first.getLogTime())) {
                    first.setRequestPps(first.getRequestPps() + next.getRequestPps());
                    first.setReplyPps(first.getReplyPps() + next.getReplyPps());
                    if (!iter.hasNext()) {
                        first.processRateAndPercent();
                    }
                    iter.remove();
                    continue;
                }
                first.processRateAndPercent();
                iter = flowCompareList.listIterator(iter.previousIndex());
                continue block0;
            }
        }
        return flowCompareList;
    }

    private AnalyzeSuccessRateConditionForm processQueryCondition(Map<?, ?> queryCond, Long sessionId) {
        String zoneIp;
        AnalyzeSuccessRateConditionForm analyzeSuccessRateConditionForms = new AnalyzeSuccessRateConditionForm();
        String deviceId = ReportAnalysisUtil.getJsonValueItemList(queryCond, "netDevice_combobox").get(0).getValue();
        Long currentLogUserId = ReportAnalysisUtil.getCurrentLogUserId(queryCond);
        this.processDeviceParam(currentLogUserId, deviceId, analyzeSuccessRateConditionForms);
        Long zoneId = Long.parseLong(ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_combobox").get(0).getValue());
        analyzeSuccessRateConditionForms.setZoneId(zoneId);
        ReportAnalysisUtil.processDeviceInfo(this.datastatConditionForm, deviceId);
        this.datastatConditionForm.setZoneId(zoneId);
        if (0L == analyzeSuccessRateConditionForms.getZoneId()) {
            ReportAnalysisUtil.addZoneSecurityToQueryCondition(queryCond, deviceId, analyzeSuccessRateConditionForms, sessionId);
        }
        analyzeSuccessRateConditionForms.setZoneIp(AticUtil.isNull((String)(zoneIp = ReportAnalysisUtil.getJsonValueItemList(queryCond, "zone_ip").get(0).getValue())) ? null : zoneIp);
        ReportAnalysisUtil.processTimeParams(queryCond, analyzeSuccessRateConditionForms);
        String topn = String.valueOf(ReportAnalysisUtil.getJsonValueItemList(queryCond, "TOPN").get(0).getValue());
        if (!AticUtil.isNull((String)topn)) {
            analyzeSuccessRateConditionForms.setTopn(Integer.parseInt(topn));
        }
        return analyzeSuccessRateConditionForms;
    }

    public void processDeviceParam(Long currentLogUserId, String deviceId, AnalyzeSuccessRateConditionForm analyzeSuccessRateConditionForms) {
        this.firewallList = ReportAnalysisUtil.processDeviceParam4DnsAnalysis(deviceId, analyzeSuccessRateConditionForms, currentLogUserId);
        this.isAllDetect = ReportAnalysisUtil.isAllDetect(deviceId);
        if (this.firewallList.isEmpty()) {
            logger.warn((Object)"query AnalyzeSuccessRate error, no devices exist!");
        } else {
            ReportAnalysisUtil.generateCollectorDeviceMap(deviceId, this.firewallList, this.collectorDeviceMap);
        }
    }

    public long getAllCount(String arg0, long arg1) {
        return 0L;
    }
}

